/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.ContentSelectionChangedListener;
import org.apache.batik.bridge.svg12.DefaultXBLManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg12.XBLOMContentElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBLContentElementBridge
extends AbstractGraphicsNodeBridge {
    protected ContentChangedListener contentChangedListener;
    protected ContentManager contentManager;

    public String getLocalName() {
        return "content";
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    public Bridge getInstance() {
        return new XBLContentElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        XBLOMContentElement xBLOMContentElement = (XBLOMContentElement)element;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        DefaultXBLManager defaultXBLManager = (DefaultXBLManager)abstractDocument.getXBLManager();
        this.contentManager = defaultXBLManager.getContentManager(element);
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
        } else {
            int n = compositeGraphicsNode.size();
            for (int i = 0; i < n; ++i) {
                compositeGraphicsNode.remove(0);
            }
        }
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        NodeList nodeList = this.contentManager.getSelectedContent(xBLOMContentElement);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GraphicsNode graphicsNode;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
                compositeGraphicsNode.add((Object)graphicsNode);
            }
        }
        if (bridgeContext.isDynamic() && this.contentChangedListener == null) {
            this.contentChangedListener = new ContentChangedListener();
            this.contentManager.addContentSelectionChangedListener(xBLOMContentElement, this.contentChangedListener);
        }
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    public boolean getDisplay(Element element) {
        return true;
    }

    public boolean isComposite() {
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.contentChangedListener != null) {
            this.contentManager.removeContentSelectionChangedListener((XBLOMContentElement)this.e, this.contentChangedListener);
        }
    }

    protected class ContentChangedListener
    implements ContentSelectionChangedListener {
        protected ContentChangedListener() {
        }

        public void contentSelectionChanged(ContentSelectionChangedEvent contentSelectionChangedEvent) {
            XBLContentElementBridge.this.buildCompositeGraphicsNode(XBLContentElementBridge.this.ctx, XBLContentElementBridge.this.e, (CompositeGraphicsNode)XBLContentElementBridge.this.node);
        }
    }
}

