\documentclass{article}
\usepackage{../../../../../src/scripts/tex/axiom}
\begin{document}
\title{\$SPAD/lsp/ccl/src/axbase runtime.lsp}
\author{Arthur Norman}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{License}
<<license>>=
; Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are
; met:
;
;     - Redistributions of source code must retain the above copyright
;       notice, this list of conditions and the following disclaimer.
;
;     - Redistributions in binary form must reproduce the above copyright
;       notice, this list of conditions and the following disclaimer in
;       the documentation and/or other materials provided with the
;       distribution.
;
;     - Neither the name of The Numerical ALgorithms Group Ltd. nor the
;       names of its contributors may be used to endorse or promote products
;       derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
; IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
; TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
; PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
; OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
; EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
; PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
; LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

@
<<*>>=
<<license>>
 

;;;
;;; Lisp code generated by Aldor from file "runtime.as".
;;;

(in-package "FOAM-USER" :use '("FOAM" "LISP"))

(declare-prog (|C0-runtime-runtime|) ((|e1| |Env|)))

(declare-prog
  (|C1-runtime-filePutc| |Clos|)
  ((|P0-ofile| |Word|) (|e1| |Env|)))

(declare-prog (|C2-runtime-filePutc|) ((|P0-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C3-runtime-filePuts| |Clos|)
  ((|P0-ofile| |Word|) (|e1| |Env|)))

(declare-prog
  (|C4-runtime-filePuts|)
  ((|P0-s| |Word|) (|P1-start| |Word|) (|P2-limit| |Word|) (|e1| |Env|)))

(declare-prog (|C5-runtime-PRINT| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C6-runtime-PRINT| |Clos| |Clos| |Clos|)
  ((|e1| |Env|)))

(declare-prog (|C7-runtime-PRINT| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C8-runtime-printDomain| |Word|)
  ((|P0-out| |Word|) (|P1-nm| |Word|) (|e1| |Env|)))

(declare-prog
  (|C9-runtime-getExport!| |Word|)
  ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))

(declare-prog
  (|C10-runtime-failmsg|)
  ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))

(declare-prog (|C11-runtime-domainStdName| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C12-runtime-get| |Word|)
  ((|P0-dom| |Word|)
    (|P1-pcent| |Word|)
    (|P2-nameCode| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|P5-skip| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C13-runtime-hash| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C14-runtime-name| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C15-runtime-inheritTo| |Word|)
  ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))

(declare-prog
  (|C16-runtime-fn1| |Clos|)
  ((|P0-self| |Word|) (|e1| |Env|)))

(declare-prog
  (|C17-runtime-getExtend| |Word|)
  ((|P0-dom| |Word|)
    (|P1-pcent| |Word|)
    (|P2-name| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|P5-skip| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C18-runtime-hashExtend| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C19-runtime-nameExtend| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C20-runtime-inheritToExtend| |Word|)
  ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))

(declare-prog
  (|C21-runtime-fn1| |Clos|)
  ((|P0-self| |Word|) (|e1| |Env|)))

(declare-prog
  (|C22-runtime-fn1|)
  ((|P0-x| |Word|) (|P1-h| |Word|) (|e1| |Env|)))

(declare-prog
  (|C23-runtime-nameDummy| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C24-runtime-getDummy| |Word|)
  ((|P0-dom| |Word|)
    (|P1-pcent| |Word|)
    (|P2-name| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|P5-skip| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C25-runtime-hashDummy| |Word|)
  ((|P0-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C26-runtime-inheritToDummy| |Word|)
  ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))

(declare-prog
  (|C27-runtime-name| |Word|)
  ((|P0-d| |Word|) (|e1| |Env|)))

(declare-prog
  (|C28-runtime-domHash| |Word|)
  ((|P0-d| |Word|) (|e1| |Env|)))

(declare-prog
  (|C29-runtime-get| |Word|)
  ((|P0-d| |Word|)
    (|P1-pc| |Word|)
    (|P2-n1| |Word|)
    (|P3-n2| |Word|)
    (|P4-box| |Word|)
    (|P5-skip| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C30-runtime-inheritTo| |Word|)
  ((|P0-d| |Word|) (|P1-d2| |Word|) (|e1| |Env|)))

(declare-prog (|C31-runtime-fn| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C32-runtime-getDefault!| |Word|)
  ((|P0-cat| |Word|)
    (|P1-pcent| |Word|)
    (|P2-nm| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C33-runtime-name0| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C34-runtime-build0| |Word|)
  ((|P0-cat| |Word|) (|P1-d| |Word|) (|e1| |Env|)))

(declare-prog
  (|C35-runtime-get0| |Word|)
  ((|P0-cat| |Word|)
    (|P1-pcent| |Word|)
    (|P2-name| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C36-runtime-hash0| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C37-runtime-parentCount0| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C38-runtime-parentGet| |Word|)
  ((|P0-cat| |Word|) (|P1-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C39-runtime-nameDummy| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C40-runtime-buildDummy| |Word|)
  ((|P0-cat| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C41-runtime-getDummy| |Word|)
  ((|P0-cat| |Word|)
    (|P1-pcent| |Word|)
    (|P2-name| |Word|)
    (|P3-type| |Word|)
    (|P4-box| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C42-runtime-hashDummy| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C43-runtime-parentGetDummy| |Word|)
  ((|P0-cat| |Word|) (|P1-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C44-runtime-parentCountDummy| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog
  (|C45-runtime-name0| |Word|)
  ((|P0-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C46-runtime-build0| |Word|)
  ((|P0-c| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C47-runtime-get0| |Word|)
  ((|P0-c| |Word|)
    (|P1-pc| |Word|)
    (|P2-n1| |Word|)
    (|P3-n2| |Word|)
    (|P4-box| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C48-runtime-hash0| |Word|)
  ((|P0-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C49-runtime-parentCount0| |Word|)
  ((|P0-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C50-runtime-parentGet| |Word|)
  ((|P0-c| |Word|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C51-runtime-force| |Word|)
  ((|P0-lv| |Word|) (|e1| |Env|)))

(declare-prog (|C52-runtime-table| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C53-runtime-domainMake| |Word|)
  ((|P0-df| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C54-runtime-domainMakeDispatch| |Word|)
  ((|P0-dr| |Word|) (|e1| |Env|)))

(declare-prog
  (|C55-runtime-extendMakeDispatch| |Word|)
  ((|P0-dr| |Word|) (|e1| |Env|)))

(declare-prog
  (|C56-runtime-domainAddExports!|)
  ((|P0-d| |Word|)
    (|P1-names| |Word|)
    (|P2-types| |Word|)
    (|P3-exports| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C57-runtime-domainAddDefaults!|)
  ((|P0-d| |Word|) (|P1-defaults| |Word|) (|P2-d2| |Word|) (|e1| |Env|)))

(declare-prog
  (|C58-runtime-domainAddParents!|)
  ((|P0-d| |Word|)
    (|P1-parents| |Word|)
    (|P2-dAsDom| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C59-runtime-domainAddHash!|)
  ((|P0-d| |Word|) (|P1-hash| |Word|) (|e1| |Env|)))

(declare-prog
  (|C60-runtime-domainAddNameFn!|)
  ((|P0-d| |Word|) (|P1-namefn| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C61-runtime-domainGetExport!| |Word|)
  ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))

(declare-prog
  (|C62-runtime-domainTestExport!| |Word|)
  ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))

(declare-prog
  (|C63-runtime-domainHash!| |Word|)
  ((|P0-td| |Word|) (|e1| |Env|)))

(declare-prog
  (|C64-runtime-domainName| |Word|)
  ((|P0-td| |Word|) (|e1| |Env|)))

(declare-prog (|C65-runtime-domainMakeDummy| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C66-runtime-domainFill!|)
  ((|P0-d| |Word|) (|P1-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C67-runtime-categoryMake| |Word|)
  ((|P0-fn| |Clos|) (|P1-hfn| |Clos|) (|P2-nameFn| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C68-runtime-categoryAddParents!|)
  ((|P0-c| |Word|)
    (|P1-parents| |Word|)
    (|P2-cAsCat| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C69-runtime-categoryAddExports!|)
  ((|P0-c| |Word|)
    (|P1-names| |Word|)
    (|P2-types| |Word|)
    (|P3-exports| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C70-runtime-categoryAddNameFn!|)
  ((|P0-cat| |Word|) (|P1-name| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C71-runtime-categoryBuild| |Word|)
  ((|P0-cat| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C72-runtime-categoryName| |Word|)
  ((|P0-cat| |Word|) (|e1| |Env|)))

(declare-prog (|C73-runtime-categoryMakeDummy| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C74-runtime-categoryFill!|)
  ((|P0-d| |Word|) (|P1-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C75-runtime-domainPrepare!|)
  ((|P0-td| |Word|) (|e1| |Env|)))

(declare-prog
  (|C76-runtime-lazyGetExport!| |Word|)
  ((|P0-dom| |Word|) (|P1-n| |Word|) (|P2-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C77-runtime-lazyForceImport| |Word|)
  ((|P0-li| |Word|) (|e1| |Env|)))

(declare-prog (|C78-runtime-noOperation|) ((|e1| |Env|)))

(declare-prog
  (|C79-runtime-extendMake| |Word|)
  ((|P0-df| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C80-runtime-extendFill!|)
  ((|P0-dom| |Word|) (|P1-pars| |Word|) (|e1| |Env|)))

(declare-prog
  (|C81-runtime-rtConstSIntFn| |Clos|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog (|C82-runtime-rtConstSIntFn| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C83-runtime-stringConcat| |Word|)
  ((|P0-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C84-runtime-rtAddStrings|)
  ((|P0-a1| |Word|) (|P1-a2| |Word|) (|e1| |Env|)))

(declare-prog (|C85-runtime-rtCacheMake| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C86-runtime-rtCacheExplicitMake| |Word|)
  ((|P0-x| |SInt|) (|e1| |Env|)))

(declare-prog
  (|C87-runtime-rtCacheCheck| |Word| |Word|)
  ((|P0-cache| |Word|) (|P1-key| |Word|) (|e1| |Env|)))

(declare-prog
  (|C88-runtime-rtCacheAdd| |Word|)
  ((|P0-cache| |Word|)
    (|P1-key| |Word|)
    (|P2-value| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C89-runtime-rtCacheDynamicMake| |Word|)
  ((|e1| |Env|)))

(declare-prog
  (|C90-runtime-rtCacheDynamicCheck| |Word| |Word|)
  ((|P0-cache| |Word|) (|P1-key| |Word|) (|e1| |Env|)))

(declare-prog
  (|C91-runtime-rtCacheDynamicAdd| |Word|)
  ((|P0-cache| |Word|)
    (|P1-key| |Word|)
    (|P2-value| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C92-runtime-rtDelayedInit!| |Clos|)
  ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog (|C93-runtime-rtDelayedInit!| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C94-runtime-rtDelayedGetExport!| |Clos|)
  ((|P0-d| |Word|) (|P1-n1| |Word|) (|P2-n2| |Word|) (|e1| |Env|)))

(declare-prog
  (|C95-runtime-rtDelayedGetExport!| |Word|)
  ((|e1| |Env|)))

(declare-prog
  (|C96-runtime-rtLazyCatFrInit| |Word|)
  ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog (|C97-runtime-ifn| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C98-runtime-rtLazyCatFrFn| |Word|)
  ((|P0-fn| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C99-runtime-rtLazyDomFrInit| |Word|)
  ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog (|C100-runtime-ifn| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C101-runtime-rtLazyDomFrFn| |Word|)
  ((|P0-fn| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C102-runtime-namePartConcat| |Word|)
  ((|P0-x| |Word|) (p1-t |Word|) (|e1| |Env|)))

(declare-prog
  (|C103-runtime-namePartFrString| |Word|)
  ((|P0-s| |Word|) (|e1| |Env|)))

(declare-prog
  (|C104-runtime-namePartFrOther| |Word|)
  ((|P0-p| |Word|) (|e1| |Env|)))

(declare-prog
  (|C105-runtime-rtConstNameFn| |Clos|)
  ((|P0-s| |Word|) (|e1| |Env|)))

(declare-prog (|C106-runtime-rtConstNameFn| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C107-runtime-rtSingleParamNameFn| |Clos|)
  ((|P0-s| |Word|) (|P1-d| |Word|) (|e1| |Env|)))

(declare-prog
  (|C108-runtime-rtSingleParamNameFn| |Word|)
  ((|e1| |Env|)))

(declare-prog
  (|C109-runtime-runtime|)
  ((|P0-a| |Word|)
    (|P1-s| |Word|)
    (|P2-i| |Word|)
    (|P3-v1| |Word|)
    (|P4-v2| |Word|)
    (|P5-v3| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C110-runtime-rtDoDebug|)
  ((|P0-a| |Word|)
    (|P1-s| |Word|)
    (|P2-i| |Word|)
    (|P3-v1| |Word|)
    (|P4-v2| |Word|)
    (|P5-v3| |Word|)
    (|e1| |Env|)))

(declare-prog (|C111-runtime-rtDebugPaused?| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C112-runtime-rtDebugPaused!| |Word|)
  ((|P0-state| |Word|) (|e1| |Env|)))

(declare-prog
  (|C113-runtime-rtDebugInit| |Word|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-e| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C114-runtime-rtDebugEnter| |Word|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-e| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C115-runtime-rtDebugInside|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C116-runtime-rtDebugReturn|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-t| |Word|)
    (|P4-v| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C117-runtime-rtDebugExit|)
  ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C118-runtime-rtDebugAssign|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-v| |Word|)
    (|P6-d| |Word|)
    (|P7-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C119-runtime-rtDebugThrow|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-e| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C120-runtime-rtDebugCatch|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-e| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C121-runtime-rtDebugCall|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-n| |Word|)
    (|P4-e| |Word|)
    (|P5-t| |Word|)
    (|P6-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C122-runtime-rtDebugStep|)
  ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C123-runtime-dInit| |Word|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-e| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C124-runtime-dEnter| |Word|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-e| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-c| |Word|)
    (|e1| |Env|)))

(declare-prog (|C125-runtime-dInside|) ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C126-runtime-dReturn|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-t| |Word|)
    (|P4-v| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C127-runtime-dExit|)
  ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C128-runtime-dAssign|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-n| |Word|)
    (|P4-t| |Word|)
    (|P5-v| |Word|)
    (|P6-d| |Word|)
    (|P7-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C129-runtime-dThrow|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-e| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C130-runtime-dCatch|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-e| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C131-runtime-dCall|)
  ((|P0-f| |Word|)
    (|P1-l| |Word|)
    (|P2-x| |Word|)
    (|P3-n| |Word|)
    (|P4-e| |Word|)
    (|P5-t| |Word|)
    (|P6-c| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C132-runtime-dStep|)
  ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C133-runtime-stringHash| |Word|)
  ((|P0-s| |Word|) (|e1| |Env|)))

(declare-prog
  (|C134-runtime-rtAssertMessage|)
  ((|P0-file| |Word|)
    (|P1-line| |Word|)
    (|P2-text| |Word|)
    (|e1| |Env|)))

(declare-prog (|C135-runtime-lazyGetter2|) ((|e1| |Env|)))

(declare-prog
  (|C136-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C137-runtime-lazyGetter| |Word| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C138-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C139-runtime-lazyGetter| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C140-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C141-runtime-lazyGetter|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C142-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C143-runtime-lazyGetter| |Clos|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))

(declare-prog
  (|C144-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C145-runtime-lazyGetter| |Word| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C146-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C147-runtime-lazyGetter| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C148-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C149-runtime-lazyGetter|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C150-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C151-runtime-lazyGetter| |Clos|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C152-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C153-runtime-lazyGetter| |Word| |Word|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C154-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C155-runtime-lazyGetter| |Word|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C156-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C157-runtime-lazyGetter|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C158-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C159-runtime-lazyGetter| |Clos|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C160-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C161-runtime-lazyGetter| |Word| |Word|)
  ((|P0-a| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C162-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C163-runtime-lazyGetter| |Word|)
  ((|P0-a| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C164-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C165-runtime-lazyGetter|)
  ((|P0-a| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C166-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C167-runtime-lazyGetter| |Clos|)
  ((|P0-a| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C168-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C169-runtime-lazyGetter| |Word| |Word|)
  ((|e1| |Env|)))

(declare-prog
  (|C170-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog (|C171-runtime-lazyGetter| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C172-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog (|C173-runtime-lazyGetter|) ((|e1| |Env|)))

(declare-prog
  (|C174-runtime-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog (|C175-runtime-lazyGetter| |Clos|) ((|e1| |Env|)))

(declare-type |G-runtime| |Clos|)

(declare-type |G-extendMakeDispatch| |Clos|)

(declare-type |G-stringConcat| |Clos|)

(declare-type |G-rtLazyCatFrFn| |Clos|)

(declare-type |G-rtLazyDomFrFn| |Clos|)

(declare-type |G-dInside| |Clos|)

(declare-type |G-stringHash| |Clos|)

(defspecials
  |G-stringHash|
  |G-dInside|
  |G-rtLazyDomFrFn|
  |G-rtLazyCatFrFn|
  |G-stringConcat|
  |G-extendMakeDispatch|)

(|DDecl| |Struct-runtime-6| (|ofile-0| |Word|))

(|DDecl| |Struct-runtime-7| (|ofile-0| |Word|))

(|DDecl| |Struct-runtime-8| (\-0 |Clos|) (\-1 |Clos|) (\-2 |Clos|))

(|DDecl| |Struct-runtime-9| (\-0 |Clos|) (\-1 |Clos|) (\-2 |Clos|))

(|DDecl|
  |Struct-runtime-11|
  (|dispatcher-0| |Word|)
  (|domainRep-1| |Word|))

(|DDecl|
  |Struct-runtime-13|
  (|f1-0| |Word|)
  (|f2-1| |Word|)
  (|hashcode-2| |Word|)
  (|parents-3| |Word|)
  (|extendees-4| |Word|)
  (|defaults-5| |Word|)
  (|names-6| |Word|)
  (|types-7| |Word|)
  (|exports-8| |Word|)
  (|ngets-9| |Word|)
  (|serial-10| |Word|)
  (|cache-11| |Word|)
  (|nameFn-12| |Clos|))

(|DDecl| |Struct-runtime-15| (|dom-0| |Word|) (|child-1| |Word|))

(|DDecl| |Struct-runtime-16| (|dom-0| |Word|) (|child-1| |Word|))

(|DDecl| |Struct-runtime-18| (|tag-0| |SInt|) (|value-1| |Word|))

(|DDecl| |Struct-runtime-19| (|d-0| |Word|) (|d2-1| |Word|))

(|DDecl|
  |Struct-runtime-20|
  (|tag-0| |Word|)
  (|namer-1| |Clos|)
  (|noname-2| |Word|)
  (|getter-3| |Clos|)
  (|hasher-4| |Clos|)
  (|inheriter-5| |Clos|))

(|DDecl| |Struct-runtime-22| (|cdv-0| |Word|) (|catRep-1| |Word|))

(|DDecl|
  |Struct-runtime-24|
  (|buildFn-0| |Word|)
  (|hashFn-1| |Clos|)
  (|dc-2| |Word|)
  (|domain-3| |Word|)
  (|parents-4| |Word|)
  (|nparents-5| |Word|)
  (|names-6| |Word|)
  (|types-7| |Word|)
  (|exports-8| |Word|)
  (|nameFn-9| |Clos|))

(|DDecl| |Struct-runtime-25| (|size-0| |SInt|) (|values-1| |Arr|))

(|DDecl| |Struct-runtime-26| (\-0 |Word|) (\-1 |Word|))

(|DDecl|
  |Struct-runtime-28|
  (|tag-0| |Word|)
  (|namer-1| |Clos|)
  (|noname-2| |Word|)
  (|getter-3| |Clos|)
  (|hasher-4| |Clos|)
  (|builder-5| |Clos|)
  (|parentCounter-6| |Clos|)
  (|parentGetter-7| |Clos|))

(|DDecl| |Struct-runtime-30| (|value-0| |Word|))

(|DDecl|
  |Struct-runtime-32|
  (|got-0| |Word|)
  (|dom-1| |Word|)
  (|name-2| |Word|)
  (|type-3| |Word|)
  (|value-4| |Word|))

(|DDecl|
  |Struct-runtime-34|
  (|posn-0| |Word|)
  (|keys-1| |Word|)
  (|values-2| |Word|)
  (|size-3| |Word|))

(|DDecl| |Struct-runtime-36| (|count-0| |Word|) (|buckv-1| |Word|))

(|DDecl|
  |Struct-runtime-37|
  (|key-0| |Word|)
  (|value-1| |Word|)
  (|hash-2| |Word|))

(|DDecl| |Struct-runtime-42| (|x-0| |Word|))

(|DDecl| |Struct-runtime-43| (|fn-0| |Clos|) (|n-1| |Word|))

(|DDecl|
  |Struct-runtime-44|
  (|d-0| |Word|)
  (|n1-1| |Word|)
  (|n2-2| |Word|))

(|DDecl| |Struct-runtime-45| (|fn-0| |Clos|) (|n-1| |Word|))

(|DDecl| |Struct-runtime-46| (|fn-0| |Clos|) (|n-1| |Word|))

(|DDecl| |Struct-runtime-47| (|s-0| |Word|))

(|DDecl| |Struct-runtime-49| (|s-0| |Word|) (|d-1| |Word|))

(|DDecl|
  |Struct-runtime-50|
  (|getter-0| |Clos|)
  (|flag-1| |Bool|)
  (|self-2| |Clos|))

(|DDecl|
  |Struct-runtime-51|
  (|rtAssertMessage-0| |Clos|)
  (|dbgPaused?-1| |Word|)
  (|rtDebugPaused!-2| |Clos|)
  (|rtDebugPaused?-3| |Clos|)
  (|rtDebugStep-4| |Clos|)
  (|rtDebugCall-5| |Clos|)
  (|rtDebugCatch-6| |Clos|)
  (|rtDebugThrow-7| |Clos|)
  (|rtDebugAssign-8| |Clos|)
  (|rtDebugExit-9| |Clos|)
  (|rtDebugReturn-10| |Clos|)
  (|rtDebugInside-11| |Clos|)
  (|rtDebugEnter-12| |Clos|)
  (|rtDebugInit-13| |Clos|)
  (|rtDoDebug-14| |Clos|)
  (|rtSingleParamNameFn-15| |Clos|)
  (|rtConstNameFn-16| |Clos|)
  (|namePartFrString-17| |Clos|)
  (|namePartFrOther-18| |Clos|)
  (|namePartConcat-19| |Clos|)
  (|rtLazyDomFrInit-20| |Clos|)
  (|rtLazyCatFrInit-21| |Clos|)
  (|rtDelayedGetExport!-22| |Clos|)
  (|rtDelayedInit!-23| |Clos|)
  (|rtCacheDynamicAdd-24| |Clos|)
  (|rtCacheDynamicCheck-25| |Clos|)
  (|rtCacheDynamicMake-26| |Clos|)
  (|rtCacheAdd-27| |Clos|)
  (|rtCacheCheck-28| |Clos|)
  (|rtCacheExplicitMake-29| |Clos|)
  (|rtCacheMake-30| |Clos|)
  (|domainPrepare!-31| |Clos|)
  (|rtAddStrings-32| |Clos|)
  (|rtConstSIntFn-33| |Clos|)
  (|lazyForceImport-34| |Clos|)
  (|lazyGetExport!-35| |Clos|)
  (|extendFill!-36| |Clos|)
  (|extendMake-37| |Clos|)
  (|noOperation-38| |Clos|)
  (|categoryFill!-39| |Clos|)
  (|categoryMakeDummy-40| |Clos|)
  (|categoryName-41| |Clos|)
  (|categoryBuild-42| |Clos|)
  (|categoryMake-43| |Clos|)
  (|categoryAddExports!-44| |Clos|)
  (|categoryAddNameFn!-45| |Clos|)
  (|categoryAddParents!-46| |Clos|)
  (|domainFill!-47| |Clos|)
  (|domainMakeDummy-48| |Clos|)
  (|domainName-49| |Clos|)
  (|domainHash!-50| |Clos|)
  (|domainTestExport!-51| |Clos|)
  (|domainGetExport!-52| |Clos|)
  (|domainAddNameFn!-53| |Clos|)
  (|domainAddHash!-54| |Clos|)
  (|domainAddParents!-55| |Clos|)
  (|domainAddDefaults!-56| |Clos|)
  (|domainAddExports!-57| |Clos|)
  (|domainMakeDispatch-58| |Clos|)
  (|domainMake-59| |Clos|)
  (print-60 |Clos|)
  (|box-61| |Word|)
  (|ddv-62| |Word|)
  (|edv-63| |Word|)
  (|adv-64| |Word|)
  (|inheritToDummy-65| |Clos|)
  (|hashDummy-66| |Clos|)
  (|getDummy-67| |Clos|)
  (|nameDummy-68| |Clos|)
  (|inheritToExtend-69| |Clos|)
  (|nameExtend-70| |Clos|)
  (|hashExtend-71| |Clos|)
  (|getExtend-72| |Clos|)
  (|inheritTo-73| |Clos|)
  (|name-74| |Clos|)
  (|hash-75| |Clos|)
  (|get-76| |Clos|)
  (|domainStdName-77| |Clos|)
  (|serialThis-78| |Word|)
  (|inheritTo-79| |Clos|)
  (|get-80| |Clos|)
  (|domHash-81| |Clos|)
  (|name-82| |Clos|)
  (|pdv-83| |Word|)
  (|ddv-84| |Word|)
  (|dv-85| |Word|)
  (|parentCountDummy-86| |Clos|)
  (|parentGetDummy-87| |Clos|)
  (|hashDummy-88| |Clos|)
  (|getDummy-89| |Clos|)
  (|buildDummy-90| |Clos|)
  (|nameDummy-91| |Clos|)
  (|parentGet-92| |Clos|)
  (|parentCount0-93| |Clos|)
  (|hash0-94| |Clos|)
  (|get0-95| |Clos|)
  (|build0-96| |Clos|)
  (|name0-97| |Clos|)
  (|parentGet-98| |Clos|)
  (|parentCount0-99| |Clos|)
  (|hash0-100| |Clos|)
  (|get0-101| |Clos|)
  (|build0-102| |Clos|)
  (|name0-103| |Clos|)
  (|pcdv-104| |Word|)
  (|codes-105| |Word|)
  (|names-106| |Word|)
  (|table-107| |Clos|)
  (|primes-108| |Word|))

(|DDecl|
  |Struct-runtime-52|
  (|size-0| |Word|)
  (|nvalues-1| |Word|)
  (|values-2| |Word|))

(|DDecl| |Struct-runtime-53| (|size-0| |SInt|) (|values-1| |Arr|))

(|DDecl| |Struct-runtime-54| (|tag-0| |Word|) (|p-1| |Word|))

(|DDecl| |Struct-runtime-55| (\-0 |Clos|) (\-1 |Clos|) (\-2 |Clos|))

(|DDecl| |Struct-runtime-56| (|first-0| |Word|) (|rest-1| |Word|))

(defprog
  ((|C0-runtime-runtime|) ((|e1| |Env|)))
  ((|T0-dStep| |Clos|)
    (|T1-dCall| |Clos|)
    (|T2-dCatch| |Clos|)
    (|T3-dThrow| |Clos|)
    (|T4-dAssign| |Clos|)
    (|T5-dExit| |Clos|)
    (|T6-dReturn| |Clos|)
    (|T7-dInit| |Clos|)
    (|T8-dEnter| |Clos|)
    (t9 |Arr|)
    (t10 |Record|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |Word|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |Arr|)
    (t17 |Word|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Word|)
    (t21 |Word|)
    (t22 |Record|)
    (t23 |SInt|)
    (t24 |Env|)
    (t25 |Arr|)
    (t26 |SInt|)
    (t27 |SInt|)
    (t28 |Word|)
    (t29 |Word|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-51| |Struct-runtime-51|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (tagbody
    (|SetLex|
      |Struct-runtime-51-PRINT-60|
      60
      |l0|
      (|Clos| |e0| |C5-runtime-PRINT|))
    (|SetLex|
      |Struct-runtime-51-domainStdName-77|
      77
      |l0|
      (|Clos| |e0| |C11-runtime-domainStdName|))
    (|SetLex|
      |Struct-runtime-51-get-76|
      76
      |l0|
      (|Clos| |e0| |C12-runtime-get|))
    (|SetLex|
      |Struct-runtime-51-hash-75|
      75
      |l0|
      (|Clos| |e0| |C13-runtime-hash|))
    (|SetLex|
      |Struct-runtime-51-name-74|
      74
      |l0|
      (|Clos| |e0| |C14-runtime-name|))
    (|SetLex|
      |Struct-runtime-51-inheritTo-73|
      73
      |l0|
      (|Clos| |e0| |C15-runtime-inheritTo|))
    (|SetLex|
      |Struct-runtime-51-getExtend-72|
      72
      |l0|
      (|Clos| |e0| |C17-runtime-getExtend|))
    (|SetLex|
      |Struct-runtime-51-hashExtend-71|
      71
      |l0|
      (|Clos| |e0| |C18-runtime-hashExtend|))
    (|SetLex|
      |Struct-runtime-51-nameExtend-70|
      70
      |l0|
      (|Clos| |e0| |C19-runtime-nameExtend|))
    (|SetLex|
      |Struct-runtime-51-inheritToExtend-69|
      69
      |l0|
      (|Clos| |e0| |C20-runtime-inheritToExtend|))
    (|SetLex|
      |Struct-runtime-51-nameDummy-68|
      68
      |l0|
      (|Clos| |e0| |C23-runtime-nameDummy|))
    (|SetLex|
      |Struct-runtime-51-getDummy-67|
      67
      |l0|
      (|Clos| |e0| |C24-runtime-getDummy|))
    (|SetLex|
      |Struct-runtime-51-hashDummy-66|
      66
      |l0|
      (|Clos| |e0| |C25-runtime-hashDummy|))
    (|SetLex|
      |Struct-runtime-51-inheritToDummy-65|
      65
      |l0|
      (|Clos| |e0| |C26-runtime-inheritToDummy|))
    (|SetLex|
      |Struct-runtime-51-name-82|
      82
      |l0|
      (|Clos| |e0| |C27-runtime-name|))
    (|SetLex|
      |Struct-runtime-51-domHash-81|
      81
      |l0|
      (|Clos| |e0| |C28-runtime-domHash|))
    (|SetLex|
      |Struct-runtime-51-get-80|
      80
      |l0|
      (|Clos| |e0| |C29-runtime-get|))
    (|SetLex|
      |Struct-runtime-51-inheritTo-79|
      79
      |l0|
      (|Clos| |e0| |C30-runtime-inheritTo|))
    (|SetLex|
      |Struct-runtime-51-name0-97|
      97
      |l0|
      (|Clos| |e0| |C33-runtime-name0|))
    (|SetLex|
      |Struct-runtime-51-build0-96|
      96
      |l0|
      (|Clos| |e0| |C34-runtime-build0|))
    (|SetLex|
      |Struct-runtime-51-get0-95|
      95
      |l0|
      (|Clos| |e0| |C35-runtime-get0|))
    (|SetLex|
      |Struct-runtime-51-hash0-94|
      94
      |l0|
      (|Clos| |e0| |C36-runtime-hash0|))
    (|SetLex|
      |Struct-runtime-51-parentCount0-93|
      93
      |l0|
      (|Clos| |e0| |C37-runtime-parentCount0|))
    (|SetLex|
      |Struct-runtime-51-parentGet-92|
      92
      |l0|
      (|Clos| |e0| |C38-runtime-parentGet|))
    (|SetLex|
      |Struct-runtime-51-nameDummy-91|
      91
      |l0|
      (|Clos| |e0| |C39-runtime-nameDummy|))
    (|SetLex|
      |Struct-runtime-51-buildDummy-90|
      90
      |l0|
      (|Clos| |e0| |C40-runtime-buildDummy|))
    (|SetLex|
      |Struct-runtime-51-getDummy-89|
      89
      |l0|
      (|Clos| |e0| |C41-runtime-getDummy|))
    (|SetLex|
      |Struct-runtime-51-hashDummy-88|
      88
      |l0|
      (|Clos| |e0| |C42-runtime-hashDummy|))
    (|SetLex|
      |Struct-runtime-51-parentGetDummy-87|
      87
      |l0|
      (|Clos| |e0| |C43-runtime-parentGetDummy|))
    (|SetLex|
      |Struct-runtime-51-parentCountDummy-86|
      86
      |l0|
      (|Clos| |e0| |C44-runtime-parentCountDummy|))
    (|SetLex|
      |Struct-runtime-51-name0-103|
      103
      |l0|
      (|Clos| |e0| |C45-runtime-name0|))
    (|SetLex|
      |Struct-runtime-51-build0-102|
      102
      |l0|
      (|Clos| |e0| |C46-runtime-build0|))
    (|SetLex|
      |Struct-runtime-51-get0-101|
      101
      |l0|
      (|Clos| |e0| |C47-runtime-get0|))
    (|SetLex|
      |Struct-runtime-51-hash0-100|
      100
      |l0|
      (|Clos| |e0| |C48-runtime-hash0|))
    (|SetLex|
      |Struct-runtime-51-parentCount0-99|
      99
      |l0|
      (|Clos| |e0| |C49-runtime-parentCount0|))
    (|SetLex|
      |Struct-runtime-51-parentGet-98|
      98
      |l0|
      (|Clos| |e0| |C50-runtime-parentGet|))
    (|SetLex|
      |Struct-runtime-51-table-107|
      107
      |l0|
      (|Clos| |e0| |C52-runtime-table|))
    (|SetLex|
      |Struct-runtime-51-domainMake-59|
      59
      |l0|
      (|Clos| |e0| |C53-runtime-domainMake|))
    (|SetLex|
      |Struct-runtime-51-domainMakeDispatch-58|
      58
      |l0|
      (|Clos| |e0| |C54-runtime-domainMakeDispatch|))
    (setq
      |G-extendMakeDispatch|
      (|Clos| |e0| |C55-runtime-extendMakeDispatch|))
    (|SetLex|
      |Struct-runtime-51-domainAddExports!-57|
      57
      |l0|
      (|Clos| |e0| |C56-runtime-domainAddExports!|))
    (|SetLex|
      |Struct-runtime-51-domainAddDefaults!-56|
      56
      |l0|
      (|Clos| |e0| |C57-runtime-domainAddDefaults!|))
    (|SetLex|
      |Struct-runtime-51-domainAddParents!-55|
      55
      |l0|
      (|Clos| |e0| |C58-runtime-domainAddParents!|))
    (|SetLex|
      |Struct-runtime-51-domainAddHash!-54|
      54
      |l0|
      (|Clos| |e0| |C59-runtime-domainAddHash!|))
    (|SetLex|
      |Struct-runtime-51-domainAddNameFn!-53|
      53
      |l0|
      (|Clos| |e0| |C60-runtime-domainAddNameFn!|))
    (|SetLex|
      |Struct-runtime-51-domainGetExport!-52|
      52
      |l0|
      (|Clos| |e0| |C61-runtime-domainGetExport!|))
    (|SetLex|
      |Struct-runtime-51-domainTestExport!-51|
      51
      |l0|
      (|Clos| |e0| |C62-runtime-domainTestExport!|))
    (|SetLex|
      |Struct-runtime-51-domainHash!-50|
      50
      |l0|
      (|Clos| |e0| |C63-runtime-domainHash!|))
    (|SetLex|
      |Struct-runtime-51-domainName-49|
      49
      |l0|
      (|Clos| |e0| |C64-runtime-domainName|))
    (|SetLex|
      |Struct-runtime-51-domainMakeDummy-48|
      48
      |l0|
      (|Clos| |e0| |C65-runtime-domainMakeDummy|))
    (|SetLex|
      |Struct-runtime-51-domainFill!-47|
      47
      |l0|
      (|Clos| |e0| |C66-runtime-domainFill!|))
    (|SetLex|
      |Struct-runtime-51-categoryMake-43|
      43
      |l0|
      (|Clos| |e0| |C67-runtime-categoryMake|))
    (|SetLex|
      |Struct-runtime-51-categoryAddParents!-46|
      46
      |l0|
      (|Clos| |e0| |C68-runtime-categoryAddParents!|))
    (|SetLex|
      |Struct-runtime-51-categoryAddExports!-44|
      44
      |l0|
      (|Clos| |e0| |C69-runtime-categoryAddExports!|))
    (|SetLex|
      |Struct-runtime-51-categoryAddNameFn!-45|
      45
      |l0|
      (|Clos| |e0| |C70-runtime-categoryAddNameFn!|))
    (|SetLex|
      |Struct-runtime-51-categoryBuild-42|
      42
      |l0|
      (|Clos| |e0| |C71-runtime-categoryBuild|))
    (|SetLex|
      |Struct-runtime-51-categoryName-41|
      41
      |l0|
      (|Clos| |e0| |C72-runtime-categoryName|))
    (|SetLex|
      |Struct-runtime-51-categoryMakeDummy-40|
      40
      |l0|
      (|Clos| |e0| |C73-runtime-categoryMakeDummy|))
    (|SetLex|
      |Struct-runtime-51-categoryFill!-39|
      39
      |l0|
      (|Clos| |e0| |C74-runtime-categoryFill!|))
    (|SetLex|
      |Struct-runtime-51-domainPrepare!-31|
      31
      |l0|
      (|Clos| |e0| |C75-runtime-domainPrepare!|))
    (|SetLex|
      |Struct-runtime-51-lazyGetExport!-35|
      35
      |l0|
      (|Clos| |e0| |C76-runtime-lazyGetExport!|))
    (|SetLex|
      |Struct-runtime-51-lazyForceImport-34|
      34
      |l0|
      (|Clos| |e0| |C77-runtime-lazyForceImport|))
    (|SetLex|
      |Struct-runtime-51-noOperation-38|
      38
      |l0|
      (|Clos| |e0| |C78-runtime-noOperation|))
    (|SetLex|
      |Struct-runtime-51-extendMake-37|
      37
      |l0|
      (|Clos| |e0| |C79-runtime-extendMake|))
    (|SetLex|
      |Struct-runtime-51-extendFill!-36|
      36
      |l0|
      (|Clos| |e0| |C80-runtime-extendFill!|))
    (|SetLex|
      |Struct-runtime-51-rtConstSIntFn-33|
      33
      |l0|
      (|Clos| |e0| |C81-runtime-rtConstSIntFn|))
    (setq |G-stringConcat| (|Clos| |e0| |C83-runtime-stringConcat|))
    (|SetLex|
      |Struct-runtime-51-rtAddStrings-32|
      32
      |l0|
      (|Clos| |e0| |C84-runtime-rtAddStrings|))
    (|SetLex|
      |Struct-runtime-51-rtCacheMake-30|
      30
      |l0|
      (|Clos| |e0| |C85-runtime-rtCacheMake|))
    (|SetLex|
      |Struct-runtime-51-rtCacheExplicitMake-29|
      29
      |l0|
      (|Clos| |e0| |C86-runtime-rtCacheExplicitMake|))
    (|SetLex|
      |Struct-runtime-51-rtCacheCheck-28|
      28
      |l0|
      (|Clos| |e0| |C87-runtime-rtCacheCheck|))
    (|SetLex|
      |Struct-runtime-51-rtCacheAdd-27|
      27
      |l0|
      (|Clos| |e0| |C88-runtime-rtCacheAdd|))
    (|SetLex|
      |Struct-runtime-51-rtCacheDynamicMake-26|
      26
      |l0|
      (|Clos| |e0| |C89-runtime-rtCacheDynamicMake|))
    (|SetLex|
      |Struct-runtime-51-rtCacheDynamicCheck-25|
      25
      |l0|
      (|Clos| |e0| |C90-runtime-rtCacheDynamicCheck|))
    (|SetLex|
      |Struct-runtime-51-rtCacheDynamicAdd-24|
      24
      |l0|
      (|Clos| |e0| |C91-runtime-rtCacheDynamicAdd|))
    (|SetLex|
      |Struct-runtime-51-rtDelayedInit!-23|
      23
      |l0|
      (|Clos| |e0| |C92-runtime-rtDelayedInit!|))
    (|SetLex|
      |Struct-runtime-51-rtDelayedGetExport!-22|
      22
      |l0|
      (|Clos| |e0| |C94-runtime-rtDelayedGetExport!|))
    (|SetLex|
      |Struct-runtime-51-rtLazyCatFrInit-21|
      21
      |l0|
      (|Clos| |e0| |C96-runtime-rtLazyCatFrInit|))
    (setq |G-rtLazyCatFrFn| (|Clos| |e0| |C98-runtime-rtLazyCatFrFn|))
    (|SetLex|
      |Struct-runtime-51-rtLazyDomFrInit-20|
      20
      |l0|
      (|Clos| |e0| |C99-runtime-rtLazyDomFrInit|))
    (setq |G-rtLazyDomFrFn| (|Clos| |e0| |C101-runtime-rtLazyDomFrFn|))
    (|SetLex|
      |Struct-runtime-51-namePartConcat-19|
      19
      |l0|
      (|Clos| |e0| |C102-runtime-namePartConcat|))
    (|SetLex|
      |Struct-runtime-51-namePartFrString-17|
      17
      |l0|
      (|Clos| |e0| |C103-runtime-namePartFrString|))
    (|SetLex|
      |Struct-runtime-51-namePartFrOther-18|
      18
      |l0|
      (|Clos| |e0| |C104-runtime-namePartFrOther|))
    (|SetLex|
      |Struct-runtime-51-rtConstNameFn-16|
      16
      |l0|
      (|Clos| |e0| |C105-runtime-rtConstNameFn|))
    (|SetLex|
      |Struct-runtime-51-rtSingleParamNameFn-15|
      15
      |l0|
      (|Clos| |e0| |C107-runtime-rtSingleParamNameFn|))
    (|SetLex|
      |Struct-runtime-51-rtDoDebug-14|
      14
      |l0|
      (|Clos| |e0| |C110-runtime-rtDoDebug|))
    (|SetLex|
      |Struct-runtime-51-rtDebugPaused?-3|
      3
      |l0|
      (|Clos| |e0| |C111-runtime-rtDebugPaused?|))
    (|SetLex|
      |Struct-runtime-51-rtDebugPaused!-2|
      2
      |l0|
      (|Clos| |e0| |C112-runtime-rtDebugPaused!|))
    (|SetLex|
      |Struct-runtime-51-rtDebugInit-13|
      13
      |l0|
      (|Clos| |e0| |C113-runtime-rtDebugInit|))
    (|SetLex|
      |Struct-runtime-51-rtDebugEnter-12|
      12
      |l0|
      (|Clos| |e0| |C114-runtime-rtDebugEnter|))
    (|SetLex|
      |Struct-runtime-51-rtDebugInside-11|
      11
      |l0|
      (|Clos| |e0| |C115-runtime-rtDebugInside|))
    (|SetLex|
      |Struct-runtime-51-rtDebugReturn-10|
      10
      |l0|
      (|Clos| |e0| |C116-runtime-rtDebugReturn|))
    (|SetLex|
      |Struct-runtime-51-rtDebugExit-9|
      9
      |l0|
      (|Clos| |e0| |C117-runtime-rtDebugExit|))
    (|SetLex|
      |Struct-runtime-51-rtDebugAssign-8|
      8
      |l0|
      (|Clos| |e0| |C118-runtime-rtDebugAssign|))
    (|SetLex|
      |Struct-runtime-51-rtDebugThrow-7|
      7
      |l0|
      (|Clos| |e0| |C119-runtime-rtDebugThrow|))
    (|SetLex|
      |Struct-runtime-51-rtDebugCatch-6|
      6
      |l0|
      (|Clos| |e0| |C120-runtime-rtDebugCatch|))
    (|SetLex|
      |Struct-runtime-51-rtDebugCall-5|
      5
      |l0|
      (|Clos| |e0| |C121-runtime-rtDebugCall|))
    (|SetLex|
      |Struct-runtime-51-rtDebugStep-4|
      4
      |l0|
      (|Clos| |e0| |C122-runtime-rtDebugStep|))
    (setq |T7-dInit| (|Clos| |e0| |C123-runtime-dInit|))
    (setq |T8-dEnter| (|Clos| |e0| |C124-runtime-dEnter|))
    (setq |G-dInside| (|Clos| |e0| |C125-runtime-dInside|))
    (setq |T6-dReturn| (|Clos| |e0| |C126-runtime-dReturn|))
    (setq |T5-dExit| (|Clos| |e0| |C127-runtime-dExit|))
    (setq |T4-dAssign| (|Clos| |e0| |C128-runtime-dAssign|))
    (setq |T3-dThrow| (|Clos| |e0| |C129-runtime-dThrow|))
    (setq |T2-dCatch| (|Clos| |e0| |C130-runtime-dCatch|))
    (setq |T1-dCall| (|Clos| |e0| |C131-runtime-dCall|))
    (setq |T0-dStep| (|Clos| |e0| |C132-runtime-dStep|))
    (setq |G-stringHash| (|Clos| |e0| |C133-runtime-stringHash|))
    (|SetLex|
      |Struct-runtime-51-rtAssertMessage-0|
      0
      |l0|
      (|Clos| |e0| |C134-runtime-rtAssertMessage|))
    (setq |G-stdGetRetClos0| (|Clos| |e0| |C174-runtime-lazyFnGetter|))
    (setq |G-stdGetRetNOp0| (|Clos| |e0| |C172-runtime-lazyFnGetter|))
    (setq |G-stdGetRetWord0| (|Clos| |e0| |C170-runtime-lazyFnGetter|))
    (setq |G-stdGetRetNOp2| (|Clos| |e0| |C168-runtime-lazyFnGetter|))
    (setq
      |G-stdGetClosRetClos0|
      (|Clos| |e0| |C166-runtime-lazyFnGetter|))
    (setq |G-stdGetClosRetNOp0| (|Clos| |e0| |C164-runtime-lazyFnGetter|))
    (setq
      |G-stdGetClosRetWord0|
      (|Clos| |e0| |C162-runtime-lazyFnGetter|))
    (setq |G-stdGetClosRetNOp2| (|Clos| |e0| |C160-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordRetClos0|
      (|Clos| |e0| |C158-runtime-lazyFnGetter|))
    (setq |G-stdGetWordRetNOp0| (|Clos| |e0| |C156-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordRetWord0|
      (|Clos| |e0| |C154-runtime-lazyFnGetter|))
    (setq |G-stdGetWordRetNOp2| (|Clos| |e0| |C152-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordRetClos0|
      (|Clos| |e0| |C150-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordRetNOp0|
      (|Clos| |e0| |C148-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordRetWord0|
      (|Clos| |e0| |C146-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordRetNOp2|
      (|Clos| |e0| |C144-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordWordRetClos0|
      (|Clos| |e0| |C142-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordWordRetNOp0|
      (|Clos| |e0| |C140-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordWordRetWord0|
      (|Clos| |e0| |C138-runtime-lazyFnGetter|))
    (setq
      |G-stdGetWordWordWordRetNOp2|
      (|Clos| |e0| |C136-runtime-lazyFnGetter|))
    (setq
      |G-domainMake|
      (|Lex| |Struct-runtime-51-domainMake-59| 59 |l0|))
    (setq
      |G-domainMakeDispatch|
      (|Lex| |Struct-runtime-51-domainMakeDispatch-58| 58 |l0|))
    (setq
      |G-domainAddExports!|
      (|Lex| |Struct-runtime-51-domainAddExports!-57| 57 |l0|))
    (setq
      |G-domainAddDefaults!|
      (|Lex| |Struct-runtime-51-domainAddDefaults!-56| 56 |l0|))
    (setq
      |G-domainAddParents!|
      (|Lex| |Struct-runtime-51-domainAddParents!-55| 55 |l0|))
    (setq
      |G-domainAddHash!|
      (|Lex| |Struct-runtime-51-domainAddHash!-54| 54 |l0|))
    (setq
      |G-domainAddNameFn!|
      (|Lex| |Struct-runtime-51-domainAddNameFn!-53| 53 |l0|))
    (setq
      |G-domainGetExport!|
      (|Lex| |Struct-runtime-51-domainGetExport!-52| 52 |l0|))
    (setq
      |G-domainTestExport!|
      (|Lex| |Struct-runtime-51-domainTestExport!-51| 51 |l0|))
    (setq
      |G-domainHash!|
      (|Lex| |Struct-runtime-51-domainHash!-50| 50 |l0|))
    (setq
      |G-domainName|
      (|Lex| |Struct-runtime-51-domainName-49| 49 |l0|))
    (setq
      |G-domainMakeDummy|
      (|Lex| |Struct-runtime-51-domainMakeDummy-48| 48 |l0|))
    (setq
      |G-domainFill!|
      (|Lex| |Struct-runtime-51-domainFill!-47| 47 |l0|))
    (setq
      |G-categoryAddParents!|
      (|Lex| |Struct-runtime-51-categoryAddParents!-46| 46 |l0|))
    (setq
      |G-categoryAddNameFn!|
      (|Lex| |Struct-runtime-51-categoryAddNameFn!-45| 45 |l0|))
    (setq
      |G-categoryAddExports!|
      (|Lex| |Struct-runtime-51-categoryAddExports!-44| 44 |l0|))
    (setq
      |G-categoryMake|
      (|Lex| |Struct-runtime-51-categoryMake-43| 43 |l0|))
    (setq
      |G-categoryBuild|
      (|Lex| |Struct-runtime-51-categoryBuild-42| 42 |l0|))
    (setq
      |G-categoryName|
      (|Lex| |Struct-runtime-51-categoryName-41| 41 |l0|))
    (setq
      |G-categoryMakeDummy|
      (|Lex| |Struct-runtime-51-categoryMakeDummy-40| 40 |l0|))
    (setq
      |G-categoryFill!|
      (|Lex| |Struct-runtime-51-categoryFill!-39| 39 |l0|))
    (setq
      |G-noOperation|
      (|Lex| |Struct-runtime-51-noOperation-38| 38 |l0|))
    (setq
      |G-extendMake|
      (|Lex| |Struct-runtime-51-extendMake-37| 37 |l0|))
    (setq
      |G-extendFill!|
      (|Lex| |Struct-runtime-51-extendFill!-36| 36 |l0|))
    (setq
      |G-lazyGetExport!|
      (|Lex| |Struct-runtime-51-lazyGetExport!-35| 35 |l0|))
    (setq
      |G-lazyForceImport|
      (|Lex| |Struct-runtime-51-lazyForceImport-34| 34 |l0|))
    (setq
      |G-rtConstSIntFn|
      (|Lex| |Struct-runtime-51-rtConstSIntFn-33| 33 |l0|))
    (setq
      |G-rtAddStrings|
      (|Lex| |Struct-runtime-51-rtAddStrings-32| 32 |l0|))
    (setq
      |G-domainPrepare!|
      (|Lex| |Struct-runtime-51-domainPrepare!-31| 31 |l0|))
    (setq t10 (|RNew| |Struct-runtime-30|))
    (|SetRElt| |Struct-runtime-30| |value| 0 t10 nil)
    (|SetLex| |Struct-runtime-51-box-61| 61 |l0| t10)
    (|SetLex| |Struct-runtime-51-serialThis-78| 78 |l0| (the |SInt| 0))
    (|SetLex| |Struct-runtime-51-adv-64| 64 |l0| nil)
    (|SetLex| |Struct-runtime-51-edv-63| 63 |l0| nil)
    (|SetLex| |Struct-runtime-51-ddv-62| 62 |l0| nil)
    (|SetLex| |Struct-runtime-51-pdv-83| 83 |l0| nil)
    (|SetLex| |Struct-runtime-51-dv-85| 85 |l0| nil)
    (|SetLex| |Struct-runtime-51-ddv-84| 84 |l0| nil)
    (|SetLex| |Struct-runtime-51-pcdv-104| 104 |l0| nil)
    (|SetLex| |Struct-runtime-51-names-106| 106 |l0| nil)
    (|SetLex| |Struct-runtime-51-codes-105| 105 |l0| nil)
    (setq t9 (|ANew| |Word| (the |SInt| 32)))
    (|SetAElt| t9 (the |SInt| 0) (the |SInt| 2))
    (|SetAElt| t9 (the |SInt| 1) (the |SInt| 3))
    (|SetAElt| t9 (the |SInt| 2) (the |SInt| 7))
    (|SetAElt| t9 (the |SInt| 3) (the |SInt| 13))
    (|SetAElt| t9 (the |SInt| 4) (the |SInt| 31))
    (|SetAElt| t9 (the |SInt| 5) (the |SInt| 61))
    (|SetAElt| t9 (the |SInt| 6) (the |SInt| 127))
    (|SetAElt| t9 (the |SInt| 7) (the |SInt| 251))
    (|SetAElt| t9 (the |SInt| 8) (the |SInt| 509))
    (|SetAElt| t9 (the |SInt| 9) (the |SInt| 1021))
    (|SetAElt| t9 (the |SInt| 10) (the |SInt| 2039))
    (|SetAElt| t9 (the |SInt| 11) (the |SInt| 4093))
    (|SetAElt| t9 (the |SInt| 12) (the |SInt| 8191))
    (|SetAElt| t9 (the |SInt| 13) (the |SInt| 16381))
    (|SetAElt| t9 (the |SInt| 14) (the |SInt| 32749))
    (|SetAElt| t9 (the |SInt| 15) (the |SInt| 65521))
    (|SetAElt| t9 (the |SInt| 16) (the |SInt| 131071))
    (|SetAElt| t9 (the |SInt| 17) (the |SInt| 262139))
    (|SetAElt| t9 (the |SInt| 18) (the |SInt| 524287))
    (|SetAElt| t9 (the |SInt| 19) (the |SInt| 1048573))
    (|SetAElt| t9 (the |SInt| 20) (the |SInt| 2097143))
    (|SetAElt| t9 (the |SInt| 21) (the |SInt| 4194301))
    (|SetAElt| t9 (the |SInt| 22) (the |SInt| 8388593))
    (|SetAElt| t9 (the |SInt| 23) (the |SInt| 16777213))
    (|SetAElt| t9 (the |SInt| 24) (the |SInt| 33554393))
    (|SetAElt| t9 (the |SInt| 25) (the |SInt| 67108859))
    (|SetAElt| t9 (the |SInt| 26) (the |SInt| 134217689))
    (|SetAElt| t9 (the |SInt| 27) (the |SInt| 268435399))
    (|SetAElt| t9 (the |SInt| 28) (the |SInt| 536870909))
    (|SetAElt| t9 (the |SInt| 29) (the |SInt| 1073741789))
    (|SetAElt| t9 (the |SInt| 30) (the |SInt| 2147483647))
    (|SetAElt| t9 (the |SInt| 31) (the |SInt| 2147483647))
    (setq t22 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t22 (the |SInt| 32))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t22 (the |SInt| 0))
    (|SetRElt|
      |Struct-runtime-52|
      |values|
      2
      t22
      (|ANew| |Word| (the |SInt| 32)))
    (setq t23 (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| t23 (the |SInt| 32)) (go |Lab9|))
    (|SetLex| |Struct-runtime-51-primes-108| 108 |l0| t22)
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-table-107| 107 |l0|)))
    (setq t24 (|ClosEnv| (|Lex| |Struct-runtime-51-table-107| 107 |l0|)))
    (setq
      t29
      (|EElt| |Struct-runtime-51-primes-108| 108 (|EnvLevel| t24)))
    (setq
      t28
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 t29)
        (the |SInt| 2)))
    (setq t25 (|ANew| |Word| t28))
    (setq t27 (the |SInt| 1))
    |Lab10|
    (when (|SIntLE| t27 t28) (go |Lab11|))
    (setq
      |G-rtCacheMake|
      (|Lex| |Struct-runtime-51-rtCacheMake-30| 30 |l0|))
    (setq
      |G-rtCacheExplicitMake|
      (|Lex| |Struct-runtime-51-rtCacheExplicitMake-29| 29 |l0|))
    (setq
      |G-rtCacheCheck|
      (|Lex| |Struct-runtime-51-rtCacheCheck-28| 28 |l0|))
    (setq
      |G-rtCacheAdd|
      (|Lex| |Struct-runtime-51-rtCacheAdd-27| 27 |l0|))
    (setq
      |G-rtCacheDynamicMake|
      (|Lex| |Struct-runtime-51-rtCacheDynamicMake-26| 26 |l0|))
    (setq
      |G-rtCacheDynamicCheck|
      (|Lex| |Struct-runtime-51-rtCacheDynamicCheck-25| 25 |l0|))
    (setq
      |G-rtCacheDynamicAdd|
      (|Lex| |Struct-runtime-51-rtCacheDynamicAdd-24| 24 |l0|))
    (setq
      |G-rtDelayedInit!|
      (|Lex| |Struct-runtime-51-rtDelayedInit!-23| 23 |l0|))
    (setq
      |G-rtDelayedGetExport!|
      (|Lex| |Struct-runtime-51-rtDelayedGetExport!-22| 22 |l0|))
    (setq
      |G-rtLazyCatFrInit|
      (|Lex| |Struct-runtime-51-rtLazyCatFrInit-21| 21 |l0|))
    (setq
      |G-rtLazyDomFrInit|
      (|Lex| |Struct-runtime-51-rtLazyDomFrInit-20| 20 |l0|))
    (setq
      |G-namePartConcat|
      (|Lex| |Struct-runtime-51-namePartConcat-19| 19 |l0|))
    (setq
      |G-namePartFrOther|
      (|Lex| |Struct-runtime-51-namePartFrOther-18| 18 |l0|))
    (setq
      |G-namePartFrString|
      (|Lex| |Struct-runtime-51-namePartFrString-17| 17 |l0|))
    (setq
      |G-rtConstNameFn|
      (|Lex| |Struct-runtime-51-rtConstNameFn-16| 16 |l0|))
    (setq
      |G-rtSingleParamNameFn|
      (|Lex| |Struct-runtime-51-rtSingleParamNameFn-15| 15 |l0|))
    (setq |G-rtDoDebug| (|Lex| |Struct-runtime-51-rtDoDebug-14| 14 |l0|))
    (|fiSetDebugVar| (|Clos| |e0| |C109-runtime-runtime|))
    (setq
      |G-rtDebugInit|
      (|Lex| |Struct-runtime-51-rtDebugInit-13| 13 |l0|))
    (setq
      |G-rtDebugEnter|
      (|Lex| |Struct-runtime-51-rtDebugEnter-12| 12 |l0|))
    (setq
      |G-rtDebugInside|
      (|Lex| |Struct-runtime-51-rtDebugInside-11| 11 |l0|))
    (setq
      |G-rtDebugReturn|
      (|Lex| |Struct-runtime-51-rtDebugReturn-10| 10 |l0|))
    (setq
      |G-rtDebugExit|
      (|Lex| |Struct-runtime-51-rtDebugExit-9| 9 |l0|))
    (setq
      |G-rtDebugAssign|
      (|Lex| |Struct-runtime-51-rtDebugAssign-8| 8 |l0|))
    (setq
      |G-rtDebugThrow|
      (|Lex| |Struct-runtime-51-rtDebugThrow-7| 7 |l0|))
    (setq
      |G-rtDebugCatch|
      (|Lex| |Struct-runtime-51-rtDebugCatch-6| 6 |l0|))
    (setq
      |G-rtDebugCall|
      (|Lex| |Struct-runtime-51-rtDebugCall-5| 5 |l0|))
    (setq
      |G-rtDebugStep|
      (|Lex| |Struct-runtime-51-rtDebugStep-4| 4 |l0|))
    (setq
      |G-rtDebugPaused?|
      (|Lex| |Struct-runtime-51-rtDebugPaused?-3| 3 |l0|))
    (setq
      |G-rtDebugPaused!|
      (|Lex| |Struct-runtime-51-rtDebugPaused!-2| 2 |l0|))
    (|SetLex| |Struct-runtime-51-dbgPaused?-1| 1 |l0| (the |Bool| nil))
    (|fiSetDebugger| (the |SInt| 0) |T7-dInit|)
    (|fiSetDebugger| (the |SInt| 1) |T8-dEnter|)
    (|fiSetDebugger| (the |SInt| 2) |G-dInside|)
    (|fiSetDebugger| (the |SInt| 3) |T6-dReturn|)
    (|fiSetDebugger| (the |SInt| 4) |T5-dExit|)
    (|fiSetDebugger| (the |SInt| 5) |T4-dAssign|)
    (|fiSetDebugger| (the |SInt| 6) |T3-dThrow|)
    (|fiSetDebugger| (the |SInt| 7) |T2-dCatch|)
    (|fiSetDebugger| (the |SInt| 9) |T1-dCall|)
    (|fiSetDebugger| (the |SInt| 8) |T0-dStep|)
    (setq
      |G-rtAssertMessage|
      (|Lex| |Struct-runtime-51-rtAssertMessage-0| 0 |l0|))
    (setq |G-runtime| |G-noOperation|)
    (block-return |C0-runtime-runtime| ())
    |Lab11|
    (setq t26 (|SIntPrev| t27))
    (|SetAElt| t25 t26 nil)
    (setq t27 (|SIntNext| t27))
    (go |Lab10|)
    |Lab9|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-52| |nvalues| 1 t22)
        (|RElt| |Struct-runtime-52| |size| 0 t22))
      (go |Lab0|))
    (|SetRElt|
      |Struct-runtime-52|
      |nvalues|
      1
      t22
      (|SIntNext| (|RElt| |Struct-runtime-52| |nvalues| 1 t22)))
    (setq t13 (|RElt| |Struct-runtime-52| |values| 2 t22))
    (setq t12 (|SIntPrev| (|RElt| |Struct-runtime-52| |nvalues| 1 t22)))
    (|SetAElt| t13 t12 (|AElt| t9 (|SIntPrev| t23)))
    |Lab8|
    (setq t23 (|SIntNext| t23))
    (go |Lab7|)
    |Lab0|
    (setq
      t11
      (|SIntQuo|
        (|RElt| |Struct-runtime-52| |size| 0 t22)
        (the |SInt| 2)))
    (setq
      t15
      (|SIntPlus| (|RElt| |Struct-runtime-52| |size| 0 t22) t11))
    (when (|SIntLT| t15 (the |SInt| 4)) (go |Lab1|))
    (setq t14 t15)
    |Lab2|
    (setq t20 (|RElt| |Struct-runtime-52| |values| 2 t22))
    (setq t21 (|RElt| |Struct-runtime-52| |size| 0 t22))
    (when (|SIntLE| t14 t21) (go |Lab3|))
    (setq t16 (|ANew| |Word| t14))
    (setq t18 (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| t18 t21) (go |Lab6|))
    (|FoamFree| t20)
    (setq t17 t16)
    |Lab4|
    (|SetRElt| |Struct-runtime-52| |values| 2 t22 t17)
    (|SetRElt| |Struct-runtime-52| |size| 0 t22 t14)
    (|SetRElt|
      |Struct-runtime-52|
      |nvalues|
      1
      t22
      (|SIntNext| (|RElt| |Struct-runtime-52| |nvalues| 1 t22)))
    (setq t13 (|RElt| |Struct-runtime-52| |values| 2 t22))
    (setq t12 (|SIntPrev| (|RElt| |Struct-runtime-52| |nvalues| 1 t22)))
    (|SetAElt| t13 t12 (|AElt| t9 (|SIntPrev| t23)))
    (go |Lab8|)
    |Lab6|
    (setq t19 (|SIntPrev| t18))
    (|SetAElt| t16 t19 (|AElt| t20 t19))
    (setq t18 (|SIntNext| t18))
    (go |Lab5|)
    |Lab3|
    (setq t17 t20)
    (go |Lab4|)
    |Lab1|
    (setq t14 (the |SInt| 4))
    (go |Lab2|)))

(defprog
  ((|C1-runtime-filePutc| |Clos|) ((|P0-ofile| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-6| |Struct-runtime-6|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-6-ofile-0| 0 |l0| |P0-ofile|)
  (block-return
    |C1-runtime-filePutc|
    (|Clos| |e0| |C2-runtime-filePutc|)))

(defprog
  ((|C2-runtime-filePutc|) ((|P0-c| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|Lex| |Struct-runtime-6-ofile-0| 0 |l1|))
    (when (|PtrIsNil| t0) (go |Lab0|))
    (|fputc| (|CharOrd| |P0-c|) t0)
    |Lab0|
    (block-return |C2-runtime-filePutc| ())))

(defprog
  ((|C3-runtime-filePuts| |Clos|) ((|P0-ofile| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-7| |Struct-runtime-7|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-7-ofile-0| 0 |l0| |P0-ofile|)
  (block-return
    |C3-runtime-filePuts|
    (|Clos| |e0| |C4-runtime-filePuts|)))

(defprog
  ((|C4-runtime-filePuts|)
    ((|P0-s| |Word|) (|P1-start| |Word|) (|P2-limit| |Word|) (|e1| |Env|)))
  ((t0 |SInt|) (t1 |SInt|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t2 (|Lex| |Struct-runtime-7-ofile-0| 0 |l1|))
    (when (|PtrIsNil| t2) (go |Lab3|))
    (|fputss| |P0-s| (|SIntPrev| |P1-start|) (|SIntPrev| |P2-limit|) t2)
    |Lab0|
    (block-return |C4-runtime-filePuts| ())
    |Lab3|
    (when (|SIntIsZero| |P2-limit|) (go |Lab1|))
    (go |Lab0|)
    |Lab1|
    (setq t0 (the |SInt| 1))
    |Lab2|
    (setq t1 (|SIntPrev| t0))
    (when
      (|CharEQ| (|AElt| |P0-s| t1) (the |Char| |CharCode0|))
      (go |Lab0|))
    (setq t0 (|SIntNext| t0))
    (go |Lab2|)))

(defprog
  ((|C5-runtime-PRINT| |Word|) ((|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (block-return |C5-runtime-PRINT| (|Clos| |e0| |C6-runtime-PRINT|)))

(defprog
  ((|C6-runtime-PRINT| |Clos| |Clos| |Clos|) ((|e1| |Env|)))
  ((t0 |Env|)
    (t1 |Word|)
    (t2 |Env|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-9| |Struct-runtime-9|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq
    t2
    (|MakeEnv|
      |e2|
      (|MakeLevel| |MAKE-Struct-runtime-6| |Struct-runtime-6|)))
  (setq t3 (|stdoutFile|))
  (|SetEElt| |Struct-runtime-6-ofile-0| 0 (|EnvLevel| t2) t3)
  (|SetLex|
    |Struct-runtime-9--0|
    0
    |l0|
    (|Clos| t2 |C2-runtime-filePutc|))
  (setq
    t0
    (|MakeEnv|
      |e2|
      (|MakeLevel| |MAKE-Struct-runtime-7| |Struct-runtime-7|)))
  (setq t1 (|stdoutFile|))
  (|SetEElt| |Struct-runtime-7-ofile-0| 0 (|EnvLevel| t0) t1)
  (|SetLex|
    |Struct-runtime-9--1|
    1
    |l0|
    (|Clos| t0 |C4-runtime-filePuts|))
  (|SetLex|
    |Struct-runtime-9--2|
    2
    |l0|
    (|Clos| |e0| |C7-runtime-PRINT|))
  (block-return
    |C6-runtime-PRINT|
    (values
      (|Lex| |Struct-runtime-9--0| 0 |l0|)
      (|Lex| |Struct-runtime-9--1| 1 |l0|)
      (|Lex| |Struct-runtime-9--2| 2 |l0|))))

(defprog
  ((|C7-runtime-PRINT| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C7-runtime-PRINT| (the |SInt| 0)))

(defprog
  ((|C8-runtime-printDomain| |Word|)
    ((|P0-out| |Word|) (|P1-nm| |Word|) (|e1| |Env|)))
  ((|T0-lst| |Word|)
    (|T1-isTuple| |Bool|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Arr|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Clos|)
    (t13 |Clos|)
    (t14 |Clos|)
    (t15 |Clos|)
    (t16 |Clos|)
    (t17 |Word|)
    (t18 |Word|)
    (t19 |Clos|)
    (t20 |Clos|)
    (t21 |Clos|)
    (t22 |Arr|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (|T26-l| |Word|)
    (t27 |Bool|)
    (t28 |Bool|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 |P1-nm|))
      (go |Lab0|))
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-54| |tag| 0 |P1-nm|)
        (the |SInt| 3))
      (go |Lab2|))
    (setq
      |T1-isTuple|
      (|SIntEQ|
        (|RElt| |Struct-runtime-54| |tag| 0 |P1-nm|)
        (the |SInt| 2)))
    (setq |T0-lst| (|RElt| |Struct-runtime-54| |p| 1 |P1-nm|))
    (when |T1-isTuple| (go |Lab4|))
    (setq t27 (|PtrIsNil| |T0-lst|))
    (when t27 (go |Lab5|))
    (setq t17 (|RElt| |Struct-runtime-56| |first| 0 |T0-lst|))
    (|C8-runtime-printDomain| |P0-out| t17 |e1|)
    (setq t18 (|RElt| |Struct-runtime-56| |rest| 1 |T0-lst|))
    (setq |T0-lst| t18)
    |Lab4|
    (multiple-value-setq (t11 t12 t13) (|CCall| |P0-out|))
    (|CCall| t12 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T26-l| |T0-lst|)
    |Lab6|
    (setq t28 (|PtrIsNil| |T26-l|))
    (when t28 (go |Lab7|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T26-l|))
    (setq t23 (|RElt| |Struct-runtime-56| |first| 0 |T26-l|))
    (|C8-runtime-printDomain| |P0-out| t23 |e1|)
    (setq t24 (|RElt| |Struct-runtime-56| |rest| 1 |T26-l|))
    (when (|PtrIsNil| t24) (go |Lab8|))
    (setq t7 (|MakeLit| ", "))
    (multiple-value-setq (t4 t5 t6) (|CCall| |P0-out|))
    (|CCall| t5 t7 (the |SInt| 1) (the |SInt| 0))
    |Lab8|
    (setq |T26-l| t25)
    (go |Lab6|)
    |Lab7|
    (setq t22 (|MakeLit| ")"))
    (multiple-value-setq (t19 t20 t21) (|CCall| |P0-out|))
    (|CCall| t20 t22 (the |SInt| 1) (the |SInt| 0))
    (setq t3 |P0-out|)
    |Lab3|
    (setq t2 t3)
    |Lab1|
    (block-return |C8-runtime-printDomain| t2)
    |Lab5|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab2|
    (multiple-value-setq (t8 t9 t10) (|CCall| |P0-out|))
    (|CCall| t9 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t3 |P0-out|)
    (go |Lab3|)
    |Lab0|
    (multiple-value-setq (t14 t15 t16) (|CCall| |P0-out|))
    (|CCall|
      t15
      (|RElt| |Struct-runtime-54| |p| 1 |P1-nm|)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t2 |P0-out|)
    (go |Lab1|)))

(defprog
  ((|C9-runtime-getExport!| |Word|)
    ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Arr|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Word|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Arr|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Clos|)
    (t34 |Clos|)
    (t35 |Word|)
    (t36 |Bool|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Clos|)
    (t41 |Clos|)
    (t42 |Arr|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Clos|)
    (t51 |Clos|)
    (t52 |Word|)
    (t53 |Word|)
    (t54 |Clos|)
    (t55 |Clos|)
    (t56 |Clos|)
    (t57 |Arr|)
    (t58 |Word|)
    (t59 |Word|)
    (t60 |Word|)
    (t61 |Clos|)
    (t62 |Word|)
    (t63 |Env|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Clos|)
    (t67 |Clos|)
    (t68 |Arr|)
    (t69 |Env|)
    (t70 |Word|)
    (t71 |Bool|)
    (t72 |Clos|)
    (t73 |Clos|)
    (t74 |Clos|)
    (t75 |Arr|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Clos|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Clos|)
    (t90 |Arr|)
    (t91 |Word|)
    (t92 |Word|)
    (t93 |Word|)
    (t94 |Word|)
    (t95 |Clos|)
    (t96 |Word|)
    (t97 |Bool|)
    (t98 |Clos|)
    (t99 |Clos|)
    (t100 |Clos|)
    (t101 |Arr|)
    (t102 |Clos|)
    (t103 |Clos|)
    (t104 |Clos|)
    (t105 |Clos|)
    (t106 |Clos|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Clos|)
    (t110 |Clos|)
    (t111 |Word|)
    (t112 |Word|)
    (t113 |Clos|)
    (t114 |Clos|)
    (t115 |Clos|)
    (t116 |Arr|)
    (t117 |Word|)
    (t118 |Word|)
    (t119 |Word|)
    (|T120-l| |Word|)
    (t121 |Word|)
    (|T122-l| |Word|)
    (|T123-l| |Word|)
    (|T124-l| |Word|)
    (|T125-l| |Word|)
    (t126 |Bool|)
    (t127 |Bool|)
    (t128 |Bool|)
    (t129 |Bool|)
    (t130 |Bool|)
    (t131 |Bool|)
    (t132 |Bool|)
    (t133 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq
      t95
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
    (setq
      t94
      (|CCall|
        t95
        (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)
        |P0-td|
        |P1-name|
        |P2-type|
        (|Lex| |Struct-runtime-51-box-61| 61 |l1|)
        (the |Bool| nil)))
    (when (|PtrIsNil| t94) (go |Lab33|))
    (setq t0 (|RElt| |Struct-runtime-30| |value| 0 t94))
    (block-return |C9-runtime-getExport!| t0)
    |Lab33|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t69
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t67 (|Clos| t69 |C6-runtime-PRINT|))
    (setq t68 (|MakeLit| "Looking in "))
    (multiple-value-setq (t64 t65 t66) (|CCall| t67))
    (|CCall| t65 t68 (the |SInt| 1) (the |SInt| 0))
    (setq t21 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq |T120-l| t21)
    (setq t22 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq |T122-l| t22)
    (setq t127 (|PtrIsNil| t21))
    (when t127 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t21))
    (setq t121 t26)
    |Lab6|
    (setq t130 (|PtrIsNil| |T122-l|))
    (when t130 (go |Lab0|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 |T122-l|))
    (when (|SIntEQ| t121 |P1-name|) (go |Lab1|))
    (when (|PtrIsNil| |T120-l|) (go |Lab7|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T120-l|))
    |Lab8|
    (setq |T120-l| t25)
    (setq t127 (|PtrIsNil| t25))
    (when t127 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t25))
    (setq t121 t26)
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T122-l|))
    (setq |T122-l| t23)
    (go |Lab6|)
    |Lab0|
    (setq t20 (|MakeLit| "??:             "))
    (setq t16 (the |SInt| 1))
    |Lab2|
    (setq t18 (|SIntPrev| t16))
    (when
      (|CharEQ| (|AElt| t20 t18) (the |Char| |CharCode0|))
      (go |Lab3|))
    (setq t16 (|SIntNext| t16))
    (go |Lab2|)
    |Lab3|
    (setq t15 (|ANew| |Char| (|SIntNext| t18)))
    (|SetAElt| t15 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t15 t18 (the |Char| |CharCode0|))
    (setq t17 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t17 t18) (go |Lab5|))
    (setq t14 (|FormatSInt| |P1-name| t15 (the |SInt| 2)))
    (setq t13 (|SIntNext| (|SIntNext| t14)))
    (|SetAElt| t15 (|SIntPrev| t13) (the |Char| |CharCode0|))
    (setq t27 t15)
    |Lab9|
    (setq
      t34
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t63
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t61 (|Clos| t63 |C6-runtime-PRINT|))
    (setq
      t62
      (|CCall| t34 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t62))
      (go |Lab10|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 3))
      (go |Lab12|))
    (setq
      t36
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 2)))
    (setq t35 (|RElt| |Struct-runtime-54| |p| 1 t62))
    (when t36 (go |Lab14|))
    (setq t126 (|PtrIsNil| t35))
    (when t126 (go |Lab15|))
    (setq t52 (|RElt| |Struct-runtime-56| |first| 0 t35))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t52))
      (go |Lab19|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 3))
      (go |Lab20|))
    (setq
      t71
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 2)))
    (setq t70 (|RElt| |Struct-runtime-54| |p| 1 t52))
    (when t71 (go |Lab21|))
    (setq t129 (|PtrIsNil| t70))
    (when t129 (go |Lab22|))
    (setq t85 (|RElt| |Struct-runtime-56| |first| 0 t70))
    (|C8-runtime-printDomain| t61 t85 |e1|)
    (setq t86 (|RElt| |Struct-runtime-56| |rest| 1 t70))
    (setq t70 t86)
    |Lab21|
    (multiple-value-setq (t79 t80 t81) (|CCall| t61))
    (|CCall| t80 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T124-l| t70)
    |Lab23|
    (setq t131 (|PtrIsNil| |T124-l|))
    (when t131 (go |Lab24|))
    (setq t93 (|RElt| |Struct-runtime-56| |rest| 1 |T124-l|))
    (setq t91 (|RElt| |Struct-runtime-56| |first| 0 |T124-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t91))
      (go |Lab26|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 3))
      (go |Lab27|))
    (setq
      t97
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 2)))
    (setq t96 (|RElt| |Struct-runtime-54| |p| 1 t91))
    (when t97 (go |Lab28|))
    (setq t128 (|PtrIsNil| t96))
    (when t128 (go |Lab29|))
    (setq t111 (|RElt| |Struct-runtime-56| |first| 0 t96))
    (|C8-runtime-printDomain| t61 t111 |e1|)
    (setq t112 (|RElt| |Struct-runtime-56| |rest| 1 t96))
    (setq t96 t112)
    |Lab28|
    (multiple-value-setq (t105 t106 t107) (|CCall| t61))
    (|CCall| t106 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T125-l| t96)
    |Lab30|
    (setq t132 (|PtrIsNil| |T125-l|))
    (when t132 (go |Lab31|))
    (setq t119 (|RElt| |Struct-runtime-56| |rest| 1 |T125-l|))
    (setq t117 (|RElt| |Struct-runtime-56| |first| 0 |T125-l|))
    (|C8-runtime-printDomain| t61 t117 |e1|)
    (setq t118 (|RElt| |Struct-runtime-56| |rest| 1 |T125-l|))
    (when (|PtrIsNil| t118) (go |Lab32|))
    (setq t101 (|MakeLit| ", "))
    (multiple-value-setq (t98 t99 t100) (|CCall| t61))
    (|CCall| t99 t101 (the |SInt| 1) (the |SInt| 0))
    |Lab32|
    (setq |T125-l| t119)
    (go |Lab30|)
    |Lab31|
    (setq t116 (|MakeLit| ")"))
    (multiple-value-setq (t113 t114 t115) (|CCall| t61))
    (|CCall| t114 t116 (the |SInt| 1) (the |SInt| 0))
    |Lab34|
    (setq t92 (|RElt| |Struct-runtime-56| |rest| 1 |T124-l|))
    (when (|PtrIsNil| t92) (go |Lab25|))
    (setq t75 (|MakeLit| ", "))
    (multiple-value-setq (t72 t73 t74) (|CCall| t61))
    (|CCall| t73 t75 (the |SInt| 1) (the |SInt| 0))
    |Lab25|
    (setq |T124-l| t93)
    (go |Lab23|)
    |Lab29|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab27|
    (multiple-value-setq (t102 t103 t104) (|CCall| t61))
    (|CCall| t103 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab34|)
    |Lab26|
    (multiple-value-setq (t108 t109 t110) (|CCall| t61))
    (|CCall|
      t109
      (|RElt| |Struct-runtime-54| |p| 1 t91)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab34|)
    |Lab24|
    (setq t90 (|MakeLit| ")"))
    (multiple-value-setq (t87 t88 t89) (|CCall| t61))
    (|CCall| t88 t90 (the |SInt| 1) (the |SInt| 0))
    |Lab35|
    (setq t53 (|RElt| |Struct-runtime-56| |rest| 1 t35))
    (setq t35 t53)
    |Lab14|
    (multiple-value-setq (t46 t47 t48) (|CCall| t61))
    (|CCall| t47 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T123-l| t35)
    |Lab16|
    (setq t133 (|PtrIsNil| |T123-l|))
    (when t133 (go |Lab17|))
    (setq t60 (|RElt| |Struct-runtime-56| |rest| 1 |T123-l|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 |T123-l|))
    (|C8-runtime-printDomain| t61 t58 |e1|)
    (setq t59 (|RElt| |Struct-runtime-56| |rest| 1 |T123-l|))
    (when (|PtrIsNil| t59) (go |Lab18|))
    (setq t42 (|MakeLit| ", "))
    (multiple-value-setq (t39 t40 t41) (|CCall| t61))
    (|CCall| t40 t42 (the |SInt| 1) (the |SInt| 0))
    |Lab18|
    (setq |T123-l| t60)
    (go |Lab16|)
    |Lab17|
    (setq t57 (|MakeLit| ")"))
    (multiple-value-setq (t54 t55 t56) (|CCall| t61))
    (|CCall| t55 t57 (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    |Lab13|
    (setq t37 t38)
    |Lab11|
    (multiple-value-setq (t31 t32 t33) (|CCall| t37))
    (|CCall| t32 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t28 t29 t30) (|CCall| t37))
    (|CCall| t29 t27 (the |SInt| 1) (the |SInt| 0))
    (setq t8 (|MakeLit| " with code "))
    (multiple-value-setq (t5 t6 t7) (|CCall| t37))
    (|CCall| t6 t8 (the |SInt| 1) (the |SInt| 0))
    (setq t12 (|formatSInt| |P2-type|))
    (multiple-value-setq (t9 t10 t11) (|CCall| t37))
    (|CCall| t10 t12 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t2 t3 t4) (|CCall| t37))
    (|CCall| t2 (the |Char| #\Newline))
    (setq t1 (|MakeLit| "Export not found"))
    (|fiRaiseException| t1)
    (|Halt| (the |SInt| 102))
    |Lab22|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab20|
    (multiple-value-setq (t76 t77 t78) (|CCall| t61))
    (|CCall| t77 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab35|)
    |Lab19|
    (multiple-value-setq (t82 t83 t84) (|CCall| t61))
    (|CCall|
      t83
      (|RElt| |Struct-runtime-54| |p| 1 t52)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab35|)
    |Lab15|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab12|
    (multiple-value-setq (t43 t44 t45) (|CCall| t61))
    (|CCall| t44 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    (go |Lab13|)
    |Lab10|
    (multiple-value-setq (t49 t50 t51) (|CCall| t61))
    (|CCall|
      t50
      (|RElt| |Struct-runtime-54| |p| 1 t62)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t37 t61)
    (go |Lab11|)
    |Lab5|
    (setq t19 (|SIntPrev| t17))
    (|SetAElt| t15 t19 (|AElt| t20 t19))
    (setq t17 (|SIntNext| t17))
    (go |Lab4|)
    |Lab7|
    (setq t25 |T120-l|)
    (go |Lab8|)
    |Lab1|
    (setq t27 t24)
    (go |Lab9|)))

(defprog
  ((|C10-runtime-failmsg|)
    ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))
  ((t0 |Clos|)
    (t1 |Clos|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Arr|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Word|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |Arr|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |Arr|)
    (t19 |Word|)
    (t20 |Word|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Clos|)
    (t27 |Clos|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Word|)
    (t34 |Bool|)
    (t35 |Clos|)
    (t36 |Clos|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Arr|)
    (t41 |Clos|)
    (t42 |Clos|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Word|)
    (t51 |Word|)
    (t52 |Clos|)
    (t53 |Clos|)
    (t54 |Clos|)
    (t55 |Arr|)
    (t56 |Word|)
    (t57 |Word|)
    (t58 |Word|)
    (t59 |Clos|)
    (t60 |Word|)
    (t61 |Env|)
    (t62 |Clos|)
    (t63 |Clos|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Arr|)
    (t67 |Env|)
    (t68 |Word|)
    (t69 |Bool|)
    (t70 |Clos|)
    (t71 |Clos|)
    (t72 |Clos|)
    (t73 |Arr|)
    (t74 |Clos|)
    (t75 |Clos|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Word|)
    (t84 |Word|)
    (t85 |Clos|)
    (t86 |Clos|)
    (t87 |Clos|)
    (t88 |Arr|)
    (t89 |Word|)
    (t90 |Word|)
    (t91 |Word|)
    (|T92-l| |Word|)
    (t93 |Word|)
    (|T94-l| |Word|)
    (|T95-l| |Word|)
    (|T96-l| |Word|)
    (t97 |Bool|)
    (t98 |Bool|)
    (t99 |Bool|)
    (t100 |Bool|)
    (t101 |Bool|)
    (t102 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t67
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t65 (|Clos| t67 |C6-runtime-PRINT|))
    (setq t66 (|MakeLit| "Looking in "))
    (multiple-value-setq (t62 t63 t64) (|CCall| t65))
    (|CCall| t63 t66 (the |SInt| 1) (the |SInt| 0))
    (setq t19 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq |T92-l| t19)
    (setq t20 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq |T94-l| t20)
    (setq t98 (|PtrIsNil| t19))
    (when t98 (go |Lab0|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 t19))
    (setq t93 t24)
    |Lab6|
    (setq t100 (|PtrIsNil| |T94-l|))
    (when t100 (go |Lab0|))
    (setq t22 (|RElt| |Struct-runtime-56| |first| 0 |T94-l|))
    (when (|SIntEQ| t93 |P1-name|) (go |Lab1|))
    (when (|PtrIsNil| |T92-l|) (go |Lab7|))
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T92-l|))
    |Lab8|
    (setq |T92-l| t23)
    (setq t98 (|PtrIsNil| t23))
    (when t98 (go |Lab0|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 t23))
    (setq t93 t24)
    (setq t21 (|RElt| |Struct-runtime-56| |rest| 1 |T94-l|))
    (setq |T94-l| t21)
    (go |Lab6|)
    |Lab0|
    (setq t18 (|MakeLit| "??:             "))
    (setq t14 (the |SInt| 1))
    |Lab2|
    (setq t16 (|SIntPrev| t14))
    (when
      (|CharEQ| (|AElt| t18 t16) (the |Char| |CharCode0|))
      (go |Lab3|))
    (setq t14 (|SIntNext| t14))
    (go |Lab2|)
    |Lab3|
    (setq t13 (|ANew| |Char| (|SIntNext| t16)))
    (|SetAElt| t13 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t13 t16 (the |Char| |CharCode0|))
    (setq t15 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t15 t16) (go |Lab5|))
    (setq t12 (|FormatSInt| |P1-name| t13 (the |SInt| 2)))
    (setq t11 (|SIntNext| (|SIntNext| t12)))
    (|SetAElt| t13 (|SIntPrev| t11) (the |Char| |CharCode0|))
    (setq t25 t13)
    |Lab9|
    (setq
      t32
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t61
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t59 (|Clos| t61 |C6-runtime-PRINT|))
    (setq
      t60
      (|CCall| t32 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t60))
      (go |Lab10|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t60) (the |SInt| 3))
      (go |Lab12|))
    (setq
      t34
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t60) (the |SInt| 2)))
    (setq t33 (|RElt| |Struct-runtime-54| |p| 1 t60))
    (when t34 (go |Lab14|))
    (setq t97 (|PtrIsNil| t33))
    (when t97 (go |Lab15|))
    (setq t50 (|RElt| |Struct-runtime-56| |first| 0 t33))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t50))
      (go |Lab19|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t50) (the |SInt| 3))
      (go |Lab20|))
    (setq
      t69
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t50) (the |SInt| 2)))
    (setq t68 (|RElt| |Struct-runtime-54| |p| 1 t50))
    (when t69 (go |Lab21|))
    (setq t99 (|PtrIsNil| t68))
    (when t99 (go |Lab22|))
    (setq t83 (|RElt| |Struct-runtime-56| |first| 0 t68))
    (|C8-runtime-printDomain| t59 t83 |e1|)
    (setq t84 (|RElt| |Struct-runtime-56| |rest| 1 t68))
    (setq t68 t84)
    |Lab21|
    (multiple-value-setq (t77 t78 t79) (|CCall| t59))
    (|CCall| t78 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T96-l| t68)
    |Lab23|
    (setq t101 (|PtrIsNil| |T96-l|))
    (when t101 (go |Lab24|))
    (setq t91 (|RElt| |Struct-runtime-56| |rest| 1 |T96-l|))
    (setq t89 (|RElt| |Struct-runtime-56| |first| 0 |T96-l|))
    (|C8-runtime-printDomain| t59 t89 |e1|)
    (setq t90 (|RElt| |Struct-runtime-56| |rest| 1 |T96-l|))
    (when (|PtrIsNil| t90) (go |Lab25|))
    (setq t73 (|MakeLit| ", "))
    (multiple-value-setq (t70 t71 t72) (|CCall| t59))
    (|CCall| t71 t73 (the |SInt| 1) (the |SInt| 0))
    |Lab25|
    (setq |T96-l| t91)
    (go |Lab23|)
    |Lab24|
    (setq t88 (|MakeLit| ")"))
    (multiple-value-setq (t85 t86 t87) (|CCall| t59))
    (|CCall| t86 t88 (the |SInt| 1) (the |SInt| 0))
    |Lab26|
    (setq t51 (|RElt| |Struct-runtime-56| |rest| 1 t33))
    (setq t33 t51)
    |Lab14|
    (multiple-value-setq (t44 t45 t46) (|CCall| t59))
    (|CCall| t45 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T95-l| t33)
    |Lab16|
    (setq t102 (|PtrIsNil| |T95-l|))
    (when t102 (go |Lab17|))
    (setq t58 (|RElt| |Struct-runtime-56| |rest| 1 |T95-l|))
    (setq t56 (|RElt| |Struct-runtime-56| |first| 0 |T95-l|))
    (|C8-runtime-printDomain| t59 t56 |e1|)
    (setq t57 (|RElt| |Struct-runtime-56| |rest| 1 |T95-l|))
    (when (|PtrIsNil| t57) (go |Lab18|))
    (setq t40 (|MakeLit| ", "))
    (multiple-value-setq (t37 t38 t39) (|CCall| t59))
    (|CCall| t38 t40 (the |SInt| 1) (the |SInt| 0))
    |Lab18|
    (setq |T95-l| t58)
    (go |Lab16|)
    |Lab17|
    (setq t55 (|MakeLit| ")"))
    (multiple-value-setq (t52 t53 t54) (|CCall| t59))
    (|CCall| t53 t55 (the |SInt| 1) (the |SInt| 0))
    (setq t36 t59)
    |Lab13|
    (setq t35 t36)
    |Lab11|
    (multiple-value-setq (t29 t30 t31) (|CCall| t35))
    (|CCall| t30 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t26 t27 t28) (|CCall| t35))
    (|CCall| t27 t25 (the |SInt| 1) (the |SInt| 0))
    (setq t6 (|MakeLit| " with code "))
    (multiple-value-setq (t3 t4 t5) (|CCall| t35))
    (|CCall| t4 t6 (the |SInt| 1) (the |SInt| 0))
    (setq t10 (|formatSInt| |P2-type|))
    (multiple-value-setq (t7 t8 t9) (|CCall| t35))
    (|CCall| t8 t10 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t0 t1 t2) (|CCall| t35))
    (|CCall| t0 (the |Char| #\Newline))
    (block-return |C10-runtime-failmsg| ())
    |Lab22|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab20|
    (multiple-value-setq (t74 t75 t76) (|CCall| t59))
    (|CCall| t75 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab26|)
    |Lab19|
    (multiple-value-setq (t80 t81 t82) (|CCall| t59))
    (|CCall|
      t81
      (|RElt| |Struct-runtime-54| |p| 1 t50)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab26|)
    |Lab15|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab12|
    (multiple-value-setq (t41 t42 t43) (|CCall| t59))
    (|CCall| t42 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t36 t59)
    (go |Lab13|)
    |Lab10|
    (multiple-value-setq (t47 t48 t49) (|CCall| t59))
    (|CCall|
      t48
      (|RElt| |Struct-runtime-54| |p| 1 t60)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t35 t59)
    (go |Lab11|)
    |Lab5|
    (setq t17 (|SIntPrev| t15))
    (|SetAElt| t13 t17 (|AElt| t18 t17))
    (setq t15 (|SIntNext| t15))
    (go |Lab4|)
    |Lab7|
    (setq t23 |T92-l|)
    (go |Lab8|)
    |Lab1|
    (setq t25 t22)
    (go |Lab9|)))

(defprog
  ((|C11-runtime-domainStdName| |Word|) ((|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 0))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 (|MakeLit| "Dunno"))
  (block-return |C11-runtime-domainStdName| t0))

(defprog
  ((|C12-runtime-get| |Word|)
    ((|P0-dom| |Word|)
      (|P1-pcent| |Word|)
      (|P2-nameCode| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|P5-skip| |Word|)
      (|e1| |Env|)))
  ((|T0-newBox| |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Arr|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |Word|)
    (t9 |Word|)
    (t10 |SInt|)
    (t11 |Word|)
    (t12 |SInt|)
    (t13 |Word|)
    (t14 |Word|)
    (t15 |Record|)
    (t16 |Word|)
    (t17 |SInt|)
    (t18 |Word|)
    (t19 |Word|)
    (t20 |SInt|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |SInt|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Env|)
    (t33 |Word|)
    (t34 |Bool|)
    (t35 |Clos|)
    (t36 |Clos|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Arr|)
    (t41 |Clos|)
    (t42 |Clos|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Word|)
    (t51 |Word|)
    (t52 |Clos|)
    (t53 |Clos|)
    (t54 |Clos|)
    (t55 |Arr|)
    (t56 |Word|)
    (t57 |Word|)
    (t58 |Word|)
    (t59 |Clos|)
    (t60 |Word|)
    (t61 |Word|)
    (t62 |Word|)
    (t63 |Word|)
    (t64 |Word|)
    (t65 |Nil|)
    (t66 |Clos|)
    (t67 |Word|)
    (t68 |Word|)
    (t69 |SInt|)
    (t70 |Word|)
    (t71 |Clos|)
    (t72 |Word|)
    (t73 |Word|)
    (t74 |Clos|)
    (t75 |Clos|)
    (t76 |Word|)
    (t77 |Word|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Word|)
    (t81 |Word|)
    (t82 |SInt|)
    (t83 |Word|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Word|)
    (t90 |Word|)
    (t91 |Word|)
    (t92 |SInt|)
    (t93 |Word|)
    (t94 |Clos|)
    (t95 |Word|)
    (t96 |Word|)
    (t97 |Clos|)
    (t98 |Clos|)
    (t99 |Word|)
    (t100 |Word|)
    (t101 |Word|)
    (t102 |SInt|)
    (t103 |Word|)
    (t104 |Clos|)
    (t105 |Word|)
    (t106 |Word|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Word|)
    (t110 |Word|)
    (t111 |Word|)
    (t112 |SInt|)
    (t113 |Word|)
    (t114 |Clos|)
    (t115 |Word|)
    (t116 |Word|)
    (t117 |Clos|)
    (t118 |Clos|)
    (t119 |Word|)
    (t120 |Word|)
    (t121 |Word|)
    (t122 |SInt|)
    (t123 |Word|)
    (t124 |Clos|)
    (t125 |Word|)
    (t126 |Word|)
    (t127 |Clos|)
    (t128 |Clos|)
    (t129 |Word|)
    (t130 |Word|)
    (t131 |Word|)
    (t132 |SInt|)
    (t133 |Word|)
    (t134 |Clos|)
    (t135 |Word|)
    (t136 |Word|)
    (t137 |Clos|)
    (t138 |Clos|)
    (t139 |Word|)
    (t140 |Word|)
    (t141 |Word|)
    (t142 |SInt|)
    (t143 |Word|)
    (t144 |Clos|)
    (t145 |Word|)
    (t146 |Word|)
    (t147 |Clos|)
    (t148 |Clos|)
    (t149 |Word|)
    (t150 |Word|)
    (t151 |Word|)
    (t152 |SInt|)
    (t153 |Word|)
    (t154 |Clos|)
    (t155 |Word|)
    (t156 |Word|)
    (t157 |Clos|)
    (t158 |Clos|)
    (t159 |Word|)
    (t160 |Word|)
    (t161 |Word|)
    (t162 |SInt|)
    (t163 |Word|)
    (t164 |Clos|)
    (t165 |Word|)
    (t166 |Word|)
    (t167 |Clos|)
    (t168 |Clos|)
    (t169 |Word|)
    (t170 |Word|)
    (t171 |SInt|)
    (t172 |Word|)
    (t173 |Word|)
    (t174 |Word|)
    (t175 |Word|)
    (t176 |SInt|)
    (t177 |Word|)
    (t178 |Word|)
    (t179 |SInt|)
    (t180 |Word|)
    (t181 |Clos|)
    (t182 |Word|)
    (t183 |Word|)
    (t184 |Clos|)
    (t185 |Clos|)
    (t186 |Word|)
    (t187 |Word|)
    (t188 |Clos|)
    (t189 |Word|)
    (t190 |SInt|)
    (t191 |Word|)
    (t192 |Word|)
    (t193 |Clos|)
    (t194 |Word|)
    (t195 |SInt|)
    (t196 |Word|)
    (t197 |Word|)
    (t198 |Word|)
    (t199 |SInt|)
    (t200 |Word|)
    (t201 |Clos|)
    (t202 |Word|)
    (t203 |Word|)
    (t204 |Clos|)
    (t205 |Clos|)
    (t206 |Word|)
    (t207 |Word|)
    (t208 |Word|)
    (t209 |SInt|)
    (t210 |Word|)
    (t211 |Clos|)
    (t212 |Word|)
    (t213 |Word|)
    (t214 |Clos|)
    (t215 |Clos|)
    (t216 |Word|)
    (t217 |Word|)
    (t218 |Word|)
    (t219 |SInt|)
    (t220 |Word|)
    (t221 |Clos|)
    (t222 |Word|)
    (t223 |Word|)
    (t224 |Clos|)
    (t225 |Clos|)
    (t226 |Word|)
    (t227 |Word|)
    (t228 |Word|)
    (t229 |SInt|)
    (t230 |Word|)
    (t231 |Clos|)
    (t232 |Word|)
    (t233 |Word|)
    (t234 |Clos|)
    (t235 |Clos|)
    (t236 |Word|)
    (t237 |Word|)
    (t238 |Word|)
    (t239 |SInt|)
    (t240 |Word|)
    (t241 |Clos|)
    (t242 |Word|)
    (t243 |Word|)
    (t244 |Clos|)
    (t245 |Clos|)
    (t246 |Word|)
    (t247 |Word|)
    (t248 |Word|)
    (t249 |SInt|)
    (t250 |Word|)
    (t251 |Clos|)
    (t252 |Word|)
    (t253 |Word|)
    (t254 |Clos|)
    (t255 |Clos|)
    (t256 |Word|)
    (t257 |Word|)
    (t258 |Word|)
    (t259 |SInt|)
    (t260 |Word|)
    (t261 |Clos|)
    (t262 |Word|)
    (t263 |Word|)
    (t264 |Clos|)
    (t265 |Clos|)
    (t266 |Word|)
    (t267 |Word|)
    (t268 |Word|)
    (t269 |SInt|)
    (t270 |Word|)
    (t271 |Clos|)
    (t272 |Word|)
    (t273 |Word|)
    (t274 |Clos|)
    (t275 |Clos|)
    (t276 |Word|)
    (t277 |Word|)
    (t278 |Word|)
    (t279 |SInt|)
    (t280 |Word|)
    (t281 |Clos|)
    (t282 |Word|)
    (t283 |Word|)
    (t284 |Clos|)
    (t285 |Clos|)
    (t286 |Word|)
    (t287 |Word|)
    (t288 |Word|)
    (t289 |SInt|)
    (t290 |Word|)
    (t291 |Clos|)
    (t292 |Word|)
    (t293 |Word|)
    (t294 |Clos|)
    (t295 |Clos|)
    (t296 |Word|)
    (t297 |Word|)
    (t298 |Word|)
    (t299 |SInt|)
    (t300 |Word|)
    (t301 |Clos|)
    (t302 |Word|)
    (t303 |Word|)
    (t304 |Clos|)
    (t305 |Clos|)
    (t306 |Word|)
    (t307 |Word|)
    (t308 |Word|)
    (t309 |SInt|)
    (t310 |Word|)
    (t311 |Clos|)
    (t312 |Word|)
    (t313 |Word|)
    (t314 |Clos|)
    (t315 |Clos|)
    (t316 |Word|)
    (t317 |Word|)
    (t318 |Word|)
    (t319 |SInt|)
    (t320 |Word|)
    (t321 |Clos|)
    (t322 |Word|)
    (t323 |Word|)
    (t324 |Clos|)
    (t325 |Clos|)
    (t326 |Word|)
    (t327 |Word|)
    (t328 |Word|)
    (t329 |SInt|)
    (t330 |Word|)
    (t331 |Clos|)
    (t332 |Word|)
    (t333 |Word|)
    (t334 |Clos|)
    (t335 |Clos|)
    (t336 |Word|)
    (t337 |Word|)
    (t338 |Word|)
    (t339 |SInt|)
    (t340 |Word|)
    (t341 |Clos|)
    (t342 |Word|)
    (t343 |Word|)
    (t344 |Clos|)
    (t345 |Clos|)
    (t346 |Word|)
    (t347 |Word|)
    (t348 |Word|)
    (t349 |SInt|)
    (t350 |Word|)
    (t351 |Clos|)
    (t352 |Word|)
    (t353 |Word|)
    (t354 |Clos|)
    (t355 |Clos|)
    (t356 |Word|)
    (t357 |Word|)
    (t358 |Word|)
    (t359 |SInt|)
    (t360 |Word|)
    (t361 |Clos|)
    (t362 |Word|)
    (t363 |Word|)
    (t364 |Clos|)
    (t365 |Clos|)
    (t366 |Word|)
    (t367 |Word|)
    (t368 |Word|)
    (t369 |SInt|)
    (t370 |Word|)
    (t371 |Clos|)
    (t372 |Word|)
    (t373 |Word|)
    (t374 |Clos|)
    (t375 |Clos|)
    (t376 |Word|)
    (t377 |Word|)
    (t378 |Word|)
    (t379 |SInt|)
    (t380 |Word|)
    (t381 |Clos|)
    (t382 |Word|)
    (t383 |Word|)
    (t384 |Clos|)
    (t385 |Clos|)
    (t386 |Word|)
    (t387 |Word|)
    (t388 |Word|)
    (t389 |SInt|)
    (t390 |Word|)
    (t391 |Clos|)
    (t392 |Word|)
    (t393 |Word|)
    (t394 |Clos|)
    (t395 |Clos|)
    (t396 |Word|)
    (t397 |Word|)
    (t398 |Word|)
    (t399 |SInt|)
    (t400 |Word|)
    (t401 |Clos|)
    (t402 |Word|)
    (t403 |Word|)
    (t404 |Clos|)
    (t405 |Clos|)
    (t406 |Word|)
    (t407 |Word|)
    (t408 |Word|)
    (t409 |SInt|)
    (t410 |Word|)
    (t411 |Clos|)
    (t412 |Word|)
    (t413 |Word|)
    (t414 |Clos|)
    (t415 |Clos|)
    (t416 |Word|)
    (t417 |Word|)
    (t418 |SInt|)
    (t419 |Word|)
    (t420 |SInt|)
    (t421 |Word|)
    (t422 |SInt|)
    (t423 |Word|)
    (t424 |Word|)
    (t425 |Word|)
    (t426 |Clos|)
    (t427 |Clos|)
    (t428 |Word|)
    (t429 |Word|)
    (t430 |SInt|)
    (t431 |Word|)
    (t432 |Clos|)
    (t433 |Word|)
    (t434 |Word|)
    (t435 |Clos|)
    (t436 |Clos|)
    (t437 |Word|)
    (t438 |Word|)
    (t439 |Word|)
    (t440 |SInt|)
    (t441 |Word|)
    (t442 |Clos|)
    (t443 |Word|)
    (t444 |Word|)
    (t445 |Clos|)
    (t446 |Clos|)
    (t447 |Word|)
    (t448 |Word|)
    (t449 |Bool|)
    (t450 |Clos|)
    (t451 |Clos|)
    (t452 |Clos|)
    (t453 |Arr|)
    (t454 |Clos|)
    (t455 |Clos|)
    (t456 |Clos|)
    (t457 |Clos|)
    (t458 |Clos|)
    (t459 |Clos|)
    (t460 |Clos|)
    (t461 |Clos|)
    (t462 |Clos|)
    (t463 |Word|)
    (t464 |Word|)
    (t465 |Clos|)
    (t466 |Clos|)
    (t467 |Clos|)
    (t468 |Arr|)
    (t469 |Word|)
    (t470 |Word|)
    (t471 |Word|)
    (t472 |Word|)
    (t473 |Bool|)
    (t474 |Clos|)
    (t475 |Clos|)
    (t476 |Clos|)
    (t477 |Arr|)
    (t478 |Clos|)
    (t479 |Clos|)
    (t480 |Clos|)
    (t481 |Clos|)
    (t482 |Clos|)
    (t483 |Clos|)
    (t484 |Clos|)
    (t485 |Clos|)
    (t486 |Clos|)
    (t487 |Word|)
    (t488 |Word|)
    (t489 |Clos|)
    (t490 |Clos|)
    (t491 |Clos|)
    (t492 |Arr|)
    (t493 |Word|)
    (t494 |Word|)
    (t495 |Word|)
    (t496 |Word|)
    (t497 |Word|)
    (t498 |SInt|)
    (t499 |Word|)
    (t500 |Clos|)
    (t501 |Word|)
    (t502 |Word|)
    (t503 |Clos|)
    (t504 |Clos|)
    (t505 |Word|)
    (t506 |Word|)
    (t507 |Word|)
    (t508 |SInt|)
    (t509 |Word|)
    (t510 |Clos|)
    (t511 |Word|)
    (t512 |Word|)
    (t513 |Clos|)
    (t514 |Clos|)
    (t515 |Word|)
    (t516 |Word|)
    (t517 |Bool|)
    (t518 |Clos|)
    (t519 |Clos|)
    (t520 |Clos|)
    (t521 |Arr|)
    (t522 |Clos|)
    (t523 |Clos|)
    (t524 |Clos|)
    (t525 |Clos|)
    (t526 |Clos|)
    (t527 |Clos|)
    (t528 |Clos|)
    (t529 |Clos|)
    (t530 |Clos|)
    (t531 |Word|)
    (t532 |Word|)
    (t533 |Clos|)
    (t534 |Clos|)
    (t535 |Clos|)
    (t536 |Arr|)
    (t537 |Word|)
    (t538 |Word|)
    (t539 |Word|)
    (t540 |Word|)
    (t541 |Word|)
    (t542 |SInt|)
    (t543 |Word|)
    (t544 |Clos|)
    (t545 |Word|)
    (t546 |Word|)
    (t547 |Clos|)
    (t548 |Clos|)
    (t549 |Word|)
    (|T550-a| |SInt|)
    (t551 |Word|)
    (|T552-v| |Word|)
    (|T553-l| |Word|)
    (|T554-v| |Word|)
    (|T555-a| |SInt|)
    (|T556-v| |Word|)
    (t557 |Word|)
    (|T558-v| |Word|)
    (t559 |Word|)
    (|T560-l| |Word|)
    (|T561-l| |Word|)
    (|T562-l| |Word|)
    (|T563-a| |SInt|)
    (|T564-a| |SInt|)
    (|T565-a| |SInt|)
    (|T566-a| |SInt|)
    (|T567-a| |SInt|)
    (|T568-a| |SInt|)
    (|T569-a| |SInt|)
    (|T570-a| |SInt|)
    (|T571-high| |Word|)
    (|T572-high| |Word|)
    (|T573-high| |Word|)
    (|T574-high| |Word|)
    (|T575-high| |Word|)
    (|T576-high| |Word|)
    (|T577-high| |Word|)
    (|T578-high| |Word|)
    (t579 |Bool|)
    (t580 |Bool|)
    (t581 |SInt|)
    (t582 |Bool|)
    (t583 |Bool|)
    (t584 |Bool|)
    (t585 |Bool|)
    (t586 |Bool|)
    (t587 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t13 (|RElt| |Struct-runtime-13| |cache| 11 |P0-dom|))
    (setq t4 (|ANew| |Word| (the |SInt| 4)))
    (setq t5 (|RNew| |Struct-runtime-25|))
    (|SetRElt| |Struct-runtime-25| |size| 0 t5 (the |SInt| 4))
    (|SetRElt| |Struct-runtime-25| |values| 1 t5 t4)
    (|SetAElt| t4 (the |SInt| 0) |P1-pcent|)
    (|SetAElt| t4 (the |SInt| 1) |P2-nameCode|)
    (|SetAElt| t4 (the |SInt| 2) |P3-type|)
    (|SetAElt| t4 (the |SInt| 3) |P5-skip|)
    (setq t8 (|RElt| |Struct-runtime-34| |keys| 1 t13))
    (setq |T552-v| (|RElt| |Struct-runtime-34| |values| 2 t13))
    (setq |T572-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t8))
    (setq |T563-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T572-high|) (go |Lab325|))
    |Lab6|
    (|SetRElt|
      |Struct-runtime-13|
      |ngets|
      9
      |P0-dom|
      (|SIntNext| (|RElt| |Struct-runtime-13| |ngets| 9 |P0-dom|)))
    (when
      (|SIntLT|
        (the |SInt| 10)
        (|RElt| |Struct-runtime-13| |ngets| 9 |P0-dom|))
      (go |Lab1|))
    (when (|SIntEQ| |P2-nameCode| (the |SInt| 51482908)) (go |Lab2|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab223|))
    |Lab224|
    (setq t425 (|RElt| |Struct-runtime-13| |hashcode| 2 |P0-dom|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |names| 6 |P0-dom|) nil)
      (go |Lab221|))
    |Lab222|
    (setq |T556-v| (|RElt| |Struct-runtime-13| |names| 6 |P0-dom|))
    (setq |T558-v| (|RElt| |Struct-runtime-13| |types| 7 |P0-dom|))
    (setq |T554-v| (|RElt| |Struct-runtime-13| |exports| 8 |P0-dom|))
    (setq |T578-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T556-v|))
    (setq |T567-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T578-high|) (go |Lab320|))
    |Lab88|
    (when |P5-skip| (go |Lab90|))
    (setq t176 (the |SInt| 2))
    |Lab91|
    (setq t423 (the |Bool| t))
    (setq |T555-a| (the |SInt| 1))
    |Lab217|
    (when (|SIntLE| |T555-a| t176) (go |Lab218|))
    (setq t424 nil)
    |Lab220|
    (setq |T0-newBox| t424)
    |Lab3|
    (|SetRElt|
      |Struct-runtime-13|
      |ngets|
      9
      |P0-dom|
      (|SIntPrev| (|RElt| |Struct-runtime-13| |ngets| 9 |P0-dom|)))
    (setq t27 (|RElt| |Struct-runtime-13| |cache| 11 |P0-dom|))
    (when (|PtrIsNil| |T0-newBox|) (go |Lab12|))
    (setq t16 (|RElt| |Struct-runtime-30| |value| 0 |T0-newBox|))
    (setq t15 (|RNew| |Struct-runtime-30|))
    (|SetRElt| |Struct-runtime-30| |value| 0 t15 t16)
    (setq t14 t15)
    |Lab13|
    (setq t24 (|RElt| |Struct-runtime-34| |posn| 0 t27))
    (setq t26 (|RElt| |Struct-runtime-34| |keys| 1 t27))
    (setq t25 (|RElt| |Struct-runtime-52| |values| 2 t26))
    (|SetAElt| t25 t24 t5)
    (setq t22 (|RElt| |Struct-runtime-34| |values| 2 t27))
    (setq t23 (|SIntNext| (|RElt| |Struct-runtime-34| |posn| 0 t27)))
    (setq t21 (|RElt| |Struct-runtime-52| |values| 2 t22))
    (setq t20 (|SIntPrev| t23))
    (|SetAElt| t21 t20 t14)
    (setq t18 (|RElt| |Struct-runtime-34| |posn| 0 t27))
    (setq t19 (|RElt| |Struct-runtime-34| |size| 3 t27))
    (setq t18 (|SIntMinus| t18 t19))
    (setq t17 (|SIntNext| t18))
    (when (|SIntIsNeg| t17) (go |Lab14|))
    |Lab15|
    (|SetRElt| |Struct-runtime-34| |posn| 0 t27 t17)
    (setq t2 |T0-newBox|)
    |Lab0|
    (block-return |C12-runtime-get| t2)
    |Lab14|
    (setq t17 (|SIntPlus| t17 t19))
    (go |Lab15|)
    |Lab12|
    (setq t14 nil)
    (go |Lab13|)
    |Lab218|
    (setq t175 (|RElt| |Struct-runtime-13| |defaults| 5 |P0-dom|))
    (when t423 (go |Lab92|))
    (when (|PtrIsNil| t175) (go |Lab92|))
    (setq t183 (|RElt| |Struct-runtime-22| |cdv| 0 t175))
    (setq t181 (|RElt| |Struct-runtime-28| |getter| 3 t183))
    (setq
      t180
      (|CCall|
        t181
        (|RElt| |Struct-runtime-22| |catRep| 1 t175)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t180) (go |Lab272|))
    (setq t182 t180)
    |Lab93|
    (setq t186 t182)
    |Lab97|
    (when (|PtrIsNil| t186) (go |Lab92|))
    (setq t424 t186)
    (go |Lab220|)
    |Lab92|
    (setq t174 (|RElt| |Struct-runtime-13| |parents| 3 |P0-dom|))
    (when (|PtrEQ| t174 nil) (go |Lab102|))
    (setq |T575-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t174))
    (setq |T570-a| (the |SInt| 1))
    |Lab103|
    (when (|SIntLE| |T570-a| |T575-high|) (go |Lab318|))
    (setq t196 nil)
    |Lab105|
    (when (|PtrIsNil| t196) (go |Lab271|))
    (setq t424 t196)
    (go |Lab220|)
    |Lab271|
    (setq t173 (|RElt| |Struct-runtime-13| |extendees| 4 |P0-dom|))
    (when (|PtrEQ| t173 nil) (go |Lab98|))
    (setq |T574-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t173))
    (setq |T568-a| (the |SInt| 1))
    |Lab99|
    (when (|SIntLE| |T568-a| |T574-high|) (go |Lab319|))
    (setq t191 nil)
    |Lab101|
    (when (|PtrIsNil| t191) (go |Lab316|))
    (setq t424 t191)
    (go |Lab220|)
    |Lab316|
    (setq t423 (|BoolNot| t423))
    (setq |T555-a| (|SIntNext| |T555-a|))
    (go |Lab217|)
    |Lab319|
    (setq t190 (|SIntPrev| |T568-a|))
    (setq
      t189
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t173) t190))
    (when (|PtrIsNil| t189) (go |Lab100|))
    (setq
      t188
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t189)))
    (setq
      t187
      (|CCall|
        t188
        (|RElt| |Struct-runtime-11| |domainRep| 1 t189)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|
        t423))
    (when (|PtrIsNil| t187) (go |Lab100|))
    (setq t191 t187)
    (go |Lab101|)
    |Lab100|
    (setq |T568-a| (|SIntNext| |T568-a|))
    (go |Lab99|)
    |Lab98|
    (setq t191 nil)
    (go |Lab101|)
    |Lab318|
    (setq t195 (|SIntPrev| |T570-a|))
    (setq
      t194
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t174) t195))
    (when (|PtrIsNil| t194) (go |Lab104|))
    (setq
      t193
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t194)))
    (setq
      t192
      (|CCall|
        t193
        (|RElt| |Struct-runtime-11| |domainRep| 1 t194)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|
        t423))
    (when (|PtrIsNil| t192) (go |Lab104|))
    (setq t196 t192)
    (go |Lab105|)
    |Lab104|
    (setq |T570-a| (|SIntNext| |T570-a|))
    (go |Lab103|)
    |Lab102|
    (setq t196 nil)
    (go |Lab105|)
    |Lab272|
    (setq t179 (the |SInt| 1))
    (setq
      t184
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t175)))
    (setq
      t178
      (|CCall| t184 (|RElt| |Struct-runtime-22| |catRep| 1 t175)))
    |Lab94|
    (when (|SIntLT| t178 t179) (go |Lab95|))
    (setq
      t185
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t175)))
    (setq
      t177
      (|CCall| t185 (|RElt| |Struct-runtime-22| |catRep| 1 t175) t179))
    (when (|PtrIsNil| t177) (go |Lab96|))
    (setq t203 (|RElt| |Struct-runtime-22| |cdv| 0 t177))
    (setq t201 (|RElt| |Struct-runtime-28| |getter| 3 t203))
    (setq
      t200
      (|CCall|
        t201
        (|RElt| |Struct-runtime-22| |catRep| 1 t177)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t200) (go |Lab273|))
    (setq t202 t200)
    |Lab106|
    (setq t206 t202)
    |Lab110|
    (when (|PtrIsNil| t206) (go |Lab96|))
    (setq t186 t206)
    (go |Lab97|)
    |Lab96|
    (setq t179 (|SIntNext| t179))
    (go |Lab94|)
    |Lab273|
    (setq t199 (the |SInt| 1))
    (setq
      t204
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t177)))
    (setq
      t198
      (|CCall| t204 (|RElt| |Struct-runtime-22| |catRep| 1 t177)))
    |Lab107|
    (when (|SIntLT| t198 t199) (go |Lab108|))
    (setq
      t205
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t177)))
    (setq
      t197
      (|CCall| t205 (|RElt| |Struct-runtime-22| |catRep| 1 t177) t199))
    (when (|PtrIsNil| t197) (go |Lab109|))
    (setq t213 (|RElt| |Struct-runtime-22| |cdv| 0 t197))
    (setq t211 (|RElt| |Struct-runtime-28| |getter| 3 t213))
    (setq
      t210
      (|CCall|
        t211
        (|RElt| |Struct-runtime-22| |catRep| 1 t197)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t210) (go |Lab274|))
    (setq t212 t210)
    |Lab111|
    (setq t216 t212)
    |Lab115|
    (when (|PtrIsNil| t216) (go |Lab109|))
    (setq t206 t216)
    (go |Lab110|)
    |Lab109|
    (setq t199 (|SIntNext| t199))
    (go |Lab107|)
    |Lab274|
    (setq t209 (the |SInt| 1))
    (setq
      t214
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t197)))
    (setq
      t208
      (|CCall| t214 (|RElt| |Struct-runtime-22| |catRep| 1 t197)))
    |Lab112|
    (when (|SIntLT| t208 t209) (go |Lab113|))
    (setq
      t215
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t197)))
    (setq
      t207
      (|CCall| t215 (|RElt| |Struct-runtime-22| |catRep| 1 t197) t209))
    (when (|PtrIsNil| t207) (go |Lab114|))
    (setq t223 (|RElt| |Struct-runtime-22| |cdv| 0 t207))
    (setq t221 (|RElt| |Struct-runtime-28| |getter| 3 t223))
    (setq
      t220
      (|CCall|
        t221
        (|RElt| |Struct-runtime-22| |catRep| 1 t207)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t220) (go |Lab275|))
    (setq t222 t220)
    |Lab116|
    (setq t226 t222)
    |Lab120|
    (when (|PtrIsNil| t226) (go |Lab114|))
    (setq t216 t226)
    (go |Lab115|)
    |Lab114|
    (setq t209 (|SIntNext| t209))
    (go |Lab112|)
    |Lab275|
    (setq t219 (the |SInt| 1))
    (setq
      t224
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t207)))
    (setq
      t218
      (|CCall| t224 (|RElt| |Struct-runtime-22| |catRep| 1 t207)))
    |Lab117|
    (when (|SIntLT| t218 t219) (go |Lab118|))
    (setq
      t225
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t207)))
    (setq
      t217
      (|CCall| t225 (|RElt| |Struct-runtime-22| |catRep| 1 t207) t219))
    (when (|PtrIsNil| t217) (go |Lab119|))
    (setq t233 (|RElt| |Struct-runtime-22| |cdv| 0 t217))
    (setq t231 (|RElt| |Struct-runtime-28| |getter| 3 t233))
    (setq
      t230
      (|CCall|
        t231
        (|RElt| |Struct-runtime-22| |catRep| 1 t217)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t230) (go |Lab276|))
    (setq t232 t230)
    |Lab121|
    (setq t236 t232)
    |Lab125|
    (when (|PtrIsNil| t236) (go |Lab119|))
    (setq t226 t236)
    (go |Lab120|)
    |Lab119|
    (setq t219 (|SIntNext| t219))
    (go |Lab117|)
    |Lab276|
    (setq t229 (the |SInt| 1))
    (setq
      t234
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t217)))
    (setq
      t228
      (|CCall| t234 (|RElt| |Struct-runtime-22| |catRep| 1 t217)))
    |Lab122|
    (when (|SIntLT| t228 t229) (go |Lab123|))
    (setq
      t235
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t217)))
    (setq
      t227
      (|CCall| t235 (|RElt| |Struct-runtime-22| |catRep| 1 t217) t229))
    (when (|PtrIsNil| t227) (go |Lab124|))
    (setq t243 (|RElt| |Struct-runtime-22| |cdv| 0 t227))
    (setq t241 (|RElt| |Struct-runtime-28| |getter| 3 t243))
    (setq
      t240
      (|CCall|
        t241
        (|RElt| |Struct-runtime-22| |catRep| 1 t227)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t240) (go |Lab277|))
    (setq t242 t240)
    |Lab126|
    (setq t246 t242)
    |Lab130|
    (when (|PtrIsNil| t246) (go |Lab124|))
    (setq t236 t246)
    (go |Lab125|)
    |Lab124|
    (setq t229 (|SIntNext| t229))
    (go |Lab122|)
    |Lab277|
    (setq t239 (the |SInt| 1))
    (setq
      t244
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t227)))
    (setq
      t238
      (|CCall| t244 (|RElt| |Struct-runtime-22| |catRep| 1 t227)))
    |Lab127|
    (when (|SIntLT| t238 t239) (go |Lab128|))
    (setq
      t245
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t227)))
    (setq
      t237
      (|CCall| t245 (|RElt| |Struct-runtime-22| |catRep| 1 t227) t239))
    (when (|PtrIsNil| t237) (go |Lab129|))
    (setq t253 (|RElt| |Struct-runtime-22| |cdv| 0 t237))
    (setq t251 (|RElt| |Struct-runtime-28| |getter| 3 t253))
    (setq
      t250
      (|CCall|
        t251
        (|RElt| |Struct-runtime-22| |catRep| 1 t237)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t250) (go |Lab278|))
    (setq t252 t250)
    |Lab131|
    (setq t256 t252)
    |Lab135|
    (when (|PtrIsNil| t256) (go |Lab129|))
    (setq t246 t256)
    (go |Lab130|)
    |Lab129|
    (setq t239 (|SIntNext| t239))
    (go |Lab127|)
    |Lab278|
    (setq t249 (the |SInt| 1))
    (setq
      t254
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t237)))
    (setq
      t248
      (|CCall| t254 (|RElt| |Struct-runtime-22| |catRep| 1 t237)))
    |Lab132|
    (when (|SIntLT| t248 t249) (go |Lab133|))
    (setq
      t255
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t237)))
    (setq
      t247
      (|CCall| t255 (|RElt| |Struct-runtime-22| |catRep| 1 t237) t249))
    (when (|PtrIsNil| t247) (go |Lab134|))
    (setq t263 (|RElt| |Struct-runtime-22| |cdv| 0 t247))
    (setq t261 (|RElt| |Struct-runtime-28| |getter| 3 t263))
    (setq
      t260
      (|CCall|
        t261
        (|RElt| |Struct-runtime-22| |catRep| 1 t247)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t260) (go |Lab279|))
    (setq t262 t260)
    |Lab136|
    (setq t266 t262)
    |Lab140|
    (when (|PtrIsNil| t266) (go |Lab134|))
    (setq t256 t266)
    (go |Lab135|)
    |Lab134|
    (setq t249 (|SIntNext| t249))
    (go |Lab132|)
    |Lab279|
    (setq t259 (the |SInt| 1))
    (setq
      t264
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t247)))
    (setq
      t258
      (|CCall| t264 (|RElt| |Struct-runtime-22| |catRep| 1 t247)))
    |Lab137|
    (when (|SIntLT| t258 t259) (go |Lab138|))
    (setq
      t265
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t247)))
    (setq
      t257
      (|CCall| t265 (|RElt| |Struct-runtime-22| |catRep| 1 t247) t259))
    (when (|PtrIsNil| t257) (go |Lab139|))
    (setq t273 (|RElt| |Struct-runtime-22| |cdv| 0 t257))
    (setq t271 (|RElt| |Struct-runtime-28| |getter| 3 t273))
    (setq
      t270
      (|CCall|
        t271
        (|RElt| |Struct-runtime-22| |catRep| 1 t257)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t270) (go |Lab280|))
    (setq t272 t270)
    |Lab141|
    (setq t276 t272)
    |Lab145|
    (when (|PtrIsNil| t276) (go |Lab139|))
    (setq t266 t276)
    (go |Lab140|)
    |Lab139|
    (setq t259 (|SIntNext| t259))
    (go |Lab137|)
    |Lab280|
    (setq t269 (the |SInt| 1))
    (setq
      t274
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t257)))
    (setq
      t268
      (|CCall| t274 (|RElt| |Struct-runtime-22| |catRep| 1 t257)))
    |Lab142|
    (when (|SIntLT| t268 t269) (go |Lab143|))
    (setq
      t275
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t257)))
    (setq
      t267
      (|CCall| t275 (|RElt| |Struct-runtime-22| |catRep| 1 t257) t269))
    (when (|PtrIsNil| t267) (go |Lab144|))
    (setq t283 (|RElt| |Struct-runtime-22| |cdv| 0 t267))
    (setq t281 (|RElt| |Struct-runtime-28| |getter| 3 t283))
    (setq
      t280
      (|CCall|
        t281
        (|RElt| |Struct-runtime-22| |catRep| 1 t267)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t280) (go |Lab281|))
    (setq t282 t280)
    |Lab146|
    (setq t286 t282)
    |Lab150|
    (when (|PtrIsNil| t286) (go |Lab144|))
    (setq t276 t286)
    (go |Lab145|)
    |Lab144|
    (setq t269 (|SIntNext| t269))
    (go |Lab142|)
    |Lab281|
    (setq t279 (the |SInt| 1))
    (setq
      t284
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t267)))
    (setq
      t278
      (|CCall| t284 (|RElt| |Struct-runtime-22| |catRep| 1 t267)))
    |Lab147|
    (when (|SIntLT| t278 t279) (go |Lab148|))
    (setq
      t285
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t267)))
    (setq
      t277
      (|CCall| t285 (|RElt| |Struct-runtime-22| |catRep| 1 t267) t279))
    (when (|PtrIsNil| t277) (go |Lab149|))
    (setq t293 (|RElt| |Struct-runtime-22| |cdv| 0 t277))
    (setq t291 (|RElt| |Struct-runtime-28| |getter| 3 t293))
    (setq
      t290
      (|CCall|
        t291
        (|RElt| |Struct-runtime-22| |catRep| 1 t277)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t290) (go |Lab282|))
    (setq t292 t290)
    |Lab151|
    (setq t296 t292)
    |Lab155|
    (when (|PtrIsNil| t296) (go |Lab149|))
    (setq t286 t296)
    (go |Lab150|)
    |Lab149|
    (setq t279 (|SIntNext| t279))
    (go |Lab147|)
    |Lab282|
    (setq t289 (the |SInt| 1))
    (setq
      t294
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t277)))
    (setq
      t288
      (|CCall| t294 (|RElt| |Struct-runtime-22| |catRep| 1 t277)))
    |Lab152|
    (when (|SIntLT| t288 t289) (go |Lab153|))
    (setq
      t295
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t277)))
    (setq
      t287
      (|CCall| t295 (|RElt| |Struct-runtime-22| |catRep| 1 t277) t289))
    (when (|PtrIsNil| t287) (go |Lab154|))
    (setq t303 (|RElt| |Struct-runtime-22| |cdv| 0 t287))
    (setq t301 (|RElt| |Struct-runtime-28| |getter| 3 t303))
    (setq
      t300
      (|CCall|
        t301
        (|RElt| |Struct-runtime-22| |catRep| 1 t287)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t300) (go |Lab283|))
    (setq t302 t300)
    |Lab156|
    (setq t306 t302)
    |Lab160|
    (when (|PtrIsNil| t306) (go |Lab154|))
    (setq t296 t306)
    (go |Lab155|)
    |Lab154|
    (setq t289 (|SIntNext| t289))
    (go |Lab152|)
    |Lab283|
    (setq t299 (the |SInt| 1))
    (setq
      t304
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t287)))
    (setq
      t298
      (|CCall| t304 (|RElt| |Struct-runtime-22| |catRep| 1 t287)))
    |Lab157|
    (when (|SIntLT| t298 t299) (go |Lab158|))
    (setq
      t305
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t287)))
    (setq
      t297
      (|CCall| t305 (|RElt| |Struct-runtime-22| |catRep| 1 t287) t299))
    (when (|PtrIsNil| t297) (go |Lab159|))
    (setq t313 (|RElt| |Struct-runtime-22| |cdv| 0 t297))
    (setq t311 (|RElt| |Struct-runtime-28| |getter| 3 t313))
    (setq
      t310
      (|CCall|
        t311
        (|RElt| |Struct-runtime-22| |catRep| 1 t297)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t310) (go |Lab284|))
    (setq t312 t310)
    |Lab161|
    (setq t316 t312)
    |Lab165|
    (when (|PtrIsNil| t316) (go |Lab159|))
    (setq t306 t316)
    (go |Lab160|)
    |Lab159|
    (setq t299 (|SIntNext| t299))
    (go |Lab157|)
    |Lab284|
    (setq t309 (the |SInt| 1))
    (setq
      t314
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t297)))
    (setq
      t308
      (|CCall| t314 (|RElt| |Struct-runtime-22| |catRep| 1 t297)))
    |Lab162|
    (when (|SIntLT| t308 t309) (go |Lab163|))
    (setq
      t315
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t297)))
    (setq
      t307
      (|CCall| t315 (|RElt| |Struct-runtime-22| |catRep| 1 t297) t309))
    (when (|PtrIsNil| t307) (go |Lab164|))
    (setq t323 (|RElt| |Struct-runtime-22| |cdv| 0 t307))
    (setq t321 (|RElt| |Struct-runtime-28| |getter| 3 t323))
    (setq
      t320
      (|CCall|
        t321
        (|RElt| |Struct-runtime-22| |catRep| 1 t307)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t320) (go |Lab285|))
    (setq t322 t320)
    |Lab166|
    (setq t326 t322)
    |Lab170|
    (when (|PtrIsNil| t326) (go |Lab164|))
    (setq t316 t326)
    (go |Lab165|)
    |Lab164|
    (setq t309 (|SIntNext| t309))
    (go |Lab162|)
    |Lab285|
    (setq t319 (the |SInt| 1))
    (setq
      t324
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t307)))
    (setq
      t318
      (|CCall| t324 (|RElt| |Struct-runtime-22| |catRep| 1 t307)))
    |Lab167|
    (when (|SIntLT| t318 t319) (go |Lab168|))
    (setq
      t325
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t307)))
    (setq
      t317
      (|CCall| t325 (|RElt| |Struct-runtime-22| |catRep| 1 t307) t319))
    (when (|PtrIsNil| t317) (go |Lab169|))
    (setq t333 (|RElt| |Struct-runtime-22| |cdv| 0 t317))
    (setq t331 (|RElt| |Struct-runtime-28| |getter| 3 t333))
    (setq
      t330
      (|CCall|
        t331
        (|RElt| |Struct-runtime-22| |catRep| 1 t317)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t330) (go |Lab286|))
    (setq t332 t330)
    |Lab171|
    (setq t336 t332)
    |Lab175|
    (when (|PtrIsNil| t336) (go |Lab169|))
    (setq t326 t336)
    (go |Lab170|)
    |Lab169|
    (setq t319 (|SIntNext| t319))
    (go |Lab167|)
    |Lab286|
    (setq t329 (the |SInt| 1))
    (setq
      t334
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t317)))
    (setq
      t328
      (|CCall| t334 (|RElt| |Struct-runtime-22| |catRep| 1 t317)))
    |Lab172|
    (when (|SIntLT| t328 t329) (go |Lab173|))
    (setq
      t335
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t317)))
    (setq
      t327
      (|CCall| t335 (|RElt| |Struct-runtime-22| |catRep| 1 t317) t329))
    (when (|PtrIsNil| t327) (go |Lab174|))
    (setq t343 (|RElt| |Struct-runtime-22| |cdv| 0 t327))
    (setq t341 (|RElt| |Struct-runtime-28| |getter| 3 t343))
    (setq
      t340
      (|CCall|
        t341
        (|RElt| |Struct-runtime-22| |catRep| 1 t327)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t340) (go |Lab287|))
    (setq t342 t340)
    |Lab176|
    (setq t346 t342)
    |Lab180|
    (when (|PtrIsNil| t346) (go |Lab174|))
    (setq t336 t346)
    (go |Lab175|)
    |Lab174|
    (setq t329 (|SIntNext| t329))
    (go |Lab172|)
    |Lab287|
    (setq t339 (the |SInt| 1))
    (setq
      t344
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t327)))
    (setq
      t338
      (|CCall| t344 (|RElt| |Struct-runtime-22| |catRep| 1 t327)))
    |Lab177|
    (when (|SIntLT| t338 t339) (go |Lab178|))
    (setq
      t345
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t327)))
    (setq
      t337
      (|CCall| t345 (|RElt| |Struct-runtime-22| |catRep| 1 t327) t339))
    (when (|PtrIsNil| t337) (go |Lab179|))
    (setq t353 (|RElt| |Struct-runtime-22| |cdv| 0 t337))
    (setq t351 (|RElt| |Struct-runtime-28| |getter| 3 t353))
    (setq
      t350
      (|CCall|
        t351
        (|RElt| |Struct-runtime-22| |catRep| 1 t337)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t350) (go |Lab288|))
    (setq t352 t350)
    |Lab181|
    (setq t356 t352)
    |Lab185|
    (when (|PtrIsNil| t356) (go |Lab179|))
    (setq t346 t356)
    (go |Lab180|)
    |Lab179|
    (setq t339 (|SIntNext| t339))
    (go |Lab177|)
    |Lab288|
    (setq t349 (the |SInt| 1))
    (setq
      t354
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t337)))
    (setq
      t348
      (|CCall| t354 (|RElt| |Struct-runtime-22| |catRep| 1 t337)))
    |Lab182|
    (when (|SIntLT| t348 t349) (go |Lab183|))
    (setq
      t355
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t337)))
    (setq
      t347
      (|CCall| t355 (|RElt| |Struct-runtime-22| |catRep| 1 t337) t349))
    (when (|PtrIsNil| t347) (go |Lab184|))
    (setq t363 (|RElt| |Struct-runtime-22| |cdv| 0 t347))
    (setq t361 (|RElt| |Struct-runtime-28| |getter| 3 t363))
    (setq
      t360
      (|CCall|
        t361
        (|RElt| |Struct-runtime-22| |catRep| 1 t347)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t360) (go |Lab289|))
    (setq t362 t360)
    |Lab186|
    (setq t366 t362)
    |Lab190|
    (when (|PtrIsNil| t366) (go |Lab184|))
    (setq t356 t366)
    (go |Lab185|)
    |Lab184|
    (setq t349 (|SIntNext| t349))
    (go |Lab182|)
    |Lab289|
    (setq t359 (the |SInt| 1))
    (setq
      t364
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t347)))
    (setq
      t358
      (|CCall| t364 (|RElt| |Struct-runtime-22| |catRep| 1 t347)))
    |Lab187|
    (when (|SIntLT| t358 t359) (go |Lab188|))
    (setq
      t365
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t347)))
    (setq
      t357
      (|CCall| t365 (|RElt| |Struct-runtime-22| |catRep| 1 t347) t359))
    (when (|PtrIsNil| t357) (go |Lab189|))
    (setq t373 (|RElt| |Struct-runtime-22| |cdv| 0 t357))
    (setq t371 (|RElt| |Struct-runtime-28| |getter| 3 t373))
    (setq
      t370
      (|CCall|
        t371
        (|RElt| |Struct-runtime-22| |catRep| 1 t357)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t370) (go |Lab290|))
    (setq t372 t370)
    |Lab191|
    (setq t376 t372)
    |Lab195|
    (when (|PtrIsNil| t376) (go |Lab189|))
    (setq t366 t376)
    (go |Lab190|)
    |Lab189|
    (setq t359 (|SIntNext| t359))
    (go |Lab187|)
    |Lab290|
    (setq t369 (the |SInt| 1))
    (setq
      t374
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t357)))
    (setq
      t368
      (|CCall| t374 (|RElt| |Struct-runtime-22| |catRep| 1 t357)))
    |Lab192|
    (when (|SIntLT| t368 t369) (go |Lab193|))
    (setq
      t375
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t357)))
    (setq
      t367
      (|CCall| t375 (|RElt| |Struct-runtime-22| |catRep| 1 t357) t369))
    (when (|PtrIsNil| t367) (go |Lab194|))
    (setq t383 (|RElt| |Struct-runtime-22| |cdv| 0 t367))
    (setq t381 (|RElt| |Struct-runtime-28| |getter| 3 t383))
    (setq
      t380
      (|CCall|
        t381
        (|RElt| |Struct-runtime-22| |catRep| 1 t367)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t380) (go |Lab291|))
    (setq t382 t380)
    |Lab196|
    (setq t386 t382)
    |Lab200|
    (when (|PtrIsNil| t386) (go |Lab194|))
    (setq t376 t386)
    (go |Lab195|)
    |Lab194|
    (setq t369 (|SIntNext| t369))
    (go |Lab192|)
    |Lab291|
    (setq t379 (the |SInt| 1))
    (setq
      t384
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t367)))
    (setq
      t378
      (|CCall| t384 (|RElt| |Struct-runtime-22| |catRep| 1 t367)))
    |Lab197|
    (when (|SIntLT| t378 t379) (go |Lab198|))
    (setq
      t385
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t367)))
    (setq
      t377
      (|CCall| t385 (|RElt| |Struct-runtime-22| |catRep| 1 t367) t379))
    (when (|PtrIsNil| t377) (go |Lab199|))
    (setq t393 (|RElt| |Struct-runtime-22| |cdv| 0 t377))
    (setq t391 (|RElt| |Struct-runtime-28| |getter| 3 t393))
    (setq
      t390
      (|CCall|
        t391
        (|RElt| |Struct-runtime-22| |catRep| 1 t377)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t390) (go |Lab292|))
    (setq t392 t390)
    |Lab201|
    (setq t396 t392)
    |Lab205|
    (when (|PtrIsNil| t396) (go |Lab199|))
    (setq t386 t396)
    (go |Lab200|)
    |Lab199|
    (setq t379 (|SIntNext| t379))
    (go |Lab197|)
    |Lab292|
    (setq t389 (the |SInt| 1))
    (setq
      t394
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t377)))
    (setq
      t388
      (|CCall| t394 (|RElt| |Struct-runtime-22| |catRep| 1 t377)))
    |Lab202|
    (when (|SIntLT| t388 t389) (go |Lab203|))
    (setq
      t395
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t377)))
    (setq
      t387
      (|CCall| t395 (|RElt| |Struct-runtime-22| |catRep| 1 t377) t389))
    (when (|PtrIsNil| t387) (go |Lab204|))
    (setq t403 (|RElt| |Struct-runtime-22| |cdv| 0 t387))
    (setq t401 (|RElt| |Struct-runtime-28| |getter| 3 t403))
    (setq
      t400
      (|CCall|
        t401
        (|RElt| |Struct-runtime-22| |catRep| 1 t387)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t400) (go |Lab293|))
    (setq t402 t400)
    |Lab206|
    (setq t406 t402)
    |Lab210|
    (when (|PtrIsNil| t406) (go |Lab204|))
    (setq t396 t406)
    (go |Lab205|)
    |Lab204|
    (setq t389 (|SIntNext| t389))
    (go |Lab202|)
    |Lab293|
    (setq t399 (the |SInt| 1))
    (setq
      t404
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t387)))
    (setq
      t398
      (|CCall| t404 (|RElt| |Struct-runtime-22| |catRep| 1 t387)))
    |Lab207|
    (when (|SIntLT| t398 t399) (go |Lab208|))
    (setq
      t405
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t387)))
    (setq
      t397
      (|CCall| t405 (|RElt| |Struct-runtime-22| |catRep| 1 t387) t399))
    (when (|PtrIsNil| t397) (go |Lab209|))
    (setq t413 (|RElt| |Struct-runtime-22| |cdv| 0 t397))
    (setq t411 (|RElt| |Struct-runtime-28| |getter| 3 t413))
    (setq
      t410
      (|CCall|
        t411
        (|RElt| |Struct-runtime-22| |catRep| 1 t397)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t410) (go |Lab294|))
    (setq t412 t410)
    |Lab211|
    (setq t416 t412)
    |Lab215|
    (when (|PtrIsNil| t416) (go |Lab209|))
    (setq t406 t416)
    (go |Lab210|)
    |Lab209|
    (setq t399 (|SIntNext| t399))
    (go |Lab207|)
    |Lab294|
    (setq t409 (the |SInt| 1))
    (setq
      t414
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t397)))
    (setq
      t408
      (|CCall| t414 (|RElt| |Struct-runtime-22| |catRep| 1 t397)))
    |Lab212|
    (when (|SIntLT| t408 t409) (go |Lab213|))
    (setq
      t415
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t397)))
    (setq
      t407
      (|CCall| t415 (|RElt| |Struct-runtime-22| |catRep| 1 t397) t409))
    (when (|PtrIsNil| t407) (go |Lab214|))
    (setq t444 (|RElt| |Struct-runtime-22| |cdv| 0 t407))
    (setq t442 (|RElt| |Struct-runtime-28| |getter| 3 t444))
    (setq
      t441
      (|CCall|
        t442
        (|RElt| |Struct-runtime-22| |catRep| 1 t407)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t441) (go |Lab295|))
    (setq t443 t441)
    |Lab230|
    (setq t447 t443)
    |Lab234|
    (when (|PtrIsNil| t447) (go |Lab214|))
    (setq t416 t447)
    (go |Lab215|)
    |Lab214|
    (setq t409 (|SIntNext| t409))
    (go |Lab212|)
    |Lab295|
    (setq t440 (the |SInt| 1))
    (setq
      t445
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t407)))
    (setq
      t439
      (|CCall| t445 (|RElt| |Struct-runtime-22| |catRep| 1 t407)))
    |Lab231|
    (when (|SIntLT| t439 t440) (go |Lab232|))
    (setq
      t446
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t407)))
    (setq
      t438
      (|CCall| t446 (|RElt| |Struct-runtime-22| |catRep| 1 t407) t440))
    (when (|PtrIsNil| t438) (go |Lab233|))
    (setq t512 (|RElt| |Struct-runtime-22| |cdv| 0 t438))
    (setq t510 (|RElt| |Struct-runtime-28| |getter| 3 t512))
    (setq
      t509
      (|CCall|
        t510
        (|RElt| |Struct-runtime-22| |catRep| 1 t438)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t509) (go |Lab296|))
    (setq t511 t509)
    |Lab254|
    (setq t515 t511)
    |Lab258|
    (when (|PtrIsNil| t515) (go |Lab233|))
    (setq t447 t515)
    (go |Lab234|)
    |Lab233|
    (setq t440 (|SIntNext| t440))
    (go |Lab231|)
    |Lab296|
    (setq t508 (the |SInt| 1))
    (setq
      t513
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t438)))
    (setq
      t507
      (|CCall| t513 (|RElt| |Struct-runtime-22| |catRep| 1 t438)))
    |Lab255|
    (when (|SIntLT| t507 t508) (go |Lab256|))
    (setq
      t514
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t438)))
    (setq
      t506
      (|CCall| t514 (|RElt| |Struct-runtime-22| |catRep| 1 t438) t508))
    (when (|PtrIsNil| t506) (go |Lab257|))
    (setq t546 (|RElt| |Struct-runtime-22| |cdv| 0 t506))
    (setq t544 (|RElt| |Struct-runtime-28| |getter| 3 t546))
    (setq
      t543
      (|CCall|
        t544
        (|RElt| |Struct-runtime-22| |catRep| 1 t506)
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t543) (go |Lab297|))
    (setq t545 t543)
    |Lab266|
    (setq t549 t545)
    |Lab270|
    (when (|PtrIsNil| t549) (go |Lab257|))
    (setq t515 t549)
    (go |Lab258|)
    |Lab257|
    (setq t508 (|SIntNext| t508))
    (go |Lab255|)
    |Lab297|
    (setq t542 (the |SInt| 1))
    (setq
      t547
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t506)))
    (setq
      t541
      (|CCall| t547 (|RElt| |Struct-runtime-22| |catRep| 1 t506)))
    |Lab267|
    (when (|SIntLT| t541 t542) (go |Lab268|))
    (setq
      t548
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t506)))
    (setq
      t540
      (|CCall| t548 (|RElt| |Struct-runtime-22| |catRep| 1 t506) t542))
    (when (|PtrIsNil| t540) (go |Lab269|))
    (setq
      t543
      (|C32-runtime-getDefault!|
        t540
        |P1-pcent|
        |P2-nameCode|
        |P3-type|
        |P4-box|
        |e1|))
    (when (|PtrIsNil| t543) (go |Lab269|))
    (setq t549 t543)
    (go |Lab270|)
    |Lab269|
    (setq t542 (|SIntNext| t542))
    (go |Lab267|)
    |Lab268|
    (setq t545 nil)
    (go |Lab266|)
    |Lab256|
    (setq t511 nil)
    (go |Lab254|)
    |Lab232|
    (setq t443 nil)
    (go |Lab230|)
    |Lab213|
    (setq t412 nil)
    (go |Lab211|)
    |Lab208|
    (setq t402 nil)
    (go |Lab206|)
    |Lab203|
    (setq t392 nil)
    (go |Lab201|)
    |Lab198|
    (setq t382 nil)
    (go |Lab196|)
    |Lab193|
    (setq t372 nil)
    (go |Lab191|)
    |Lab188|
    (setq t362 nil)
    (go |Lab186|)
    |Lab183|
    (setq t352 nil)
    (go |Lab181|)
    |Lab178|
    (setq t342 nil)
    (go |Lab176|)
    |Lab173|
    (setq t332 nil)
    (go |Lab171|)
    |Lab168|
    (setq t322 nil)
    (go |Lab166|)
    |Lab163|
    (setq t312 nil)
    (go |Lab161|)
    |Lab158|
    (setq t302 nil)
    (go |Lab156|)
    |Lab153|
    (setq t292 nil)
    (go |Lab151|)
    |Lab148|
    (setq t282 nil)
    (go |Lab146|)
    |Lab143|
    (setq t272 nil)
    (go |Lab141|)
    |Lab138|
    (setq t262 nil)
    (go |Lab136|)
    |Lab133|
    (setq t252 nil)
    (go |Lab131|)
    |Lab128|
    (setq t242 nil)
    (go |Lab126|)
    |Lab123|
    (setq t232 nil)
    (go |Lab121|)
    |Lab118|
    (setq t222 nil)
    (go |Lab116|)
    |Lab113|
    (setq t212 nil)
    (go |Lab111|)
    |Lab108|
    (setq t202 nil)
    (go |Lab106|)
    |Lab95|
    (setq t182 nil)
    (go |Lab93|)
    |Lab90|
    (setq t176 (the |SInt| 1))
    (go |Lab91|)
    |Lab320|
    (setq
      t421
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |T556-v|)
        (the |SInt| 0)))
    (setq t557 t421)
    (setq |T577-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T558-v|))
    (setq |T569-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T577-high|) (go |Lab322|))
    (go |Lab88|)
    |Lab322|
    (setq
      t419
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |T558-v|)
        (the |SInt| 0)))
    (setq t559 t419)
    (setq |T576-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T554-v|))
    (setq |T566-a| (the |SInt| 1))
    |Lab216|
    (when (|SIntLE| |T566-a| |T576-high|) (go |Lab317|))
    (go |Lab88|)
    |Lab317|
    (setq t418 (|SIntPrev| |T566-a|))
    (setq
      t417
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T554-v|) t418))
    (when (|PtrEQ| t557 nil) (go |Lab219|))
    (when (|SIntNE| t557 |P2-nameCode|) (go |Lab219|))
    (when (|SIntEQ| |P3-type| t559) (go |Lab89|))
    (when (|SIntEQ| |P3-type| (the |SInt| -1)) (go |Lab89|))
    |Lab219|
    (setq |T567-a| (|SIntNext| |T567-a|))
    (when (|SIntLE| |T567-a| |T578-high|) (go |Lab321|))
    (go |Lab88|)
    |Lab321|
    (setq t422 (|SIntPrev| |T567-a|))
    (setq
      t421
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T556-v|) t422))
    (setq t557 t421)
    (setq |T569-a| (|SIntNext| |T569-a|))
    (when (|SIntLE| |T569-a| |T577-high|) (go |Lab323|))
    (go |Lab88|)
    |Lab323|
    (setq t420 (|SIntPrev| |T569-a|))
    (setq
      t419
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T558-v|) t420))
    (setq t559 t419)
    (setq |T566-a| (|SIntNext| |T566-a|))
    (go |Lab216|)
    |Lab89|
    (|SetRElt| |Struct-runtime-30| |value| 0 |P4-box| t417)
    (setq t424 |P4-box|)
    (go |Lab220|)
    |Lab221|
    (setq t426 (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|))
    (|CCall| t426 |P0-dom| t425)
    (go |Lab222|)
    |Lab223|
    (setq t427 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t427 |P0-dom|))
    (go |Lab224|)
    |Lab2|
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab38|))
    |Lab39|
    (setq t77 (|RElt| |Struct-runtime-13| |hashcode| 2 |P0-dom|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |names| 6 |P0-dom|) nil)
      (go |Lab36|))
    |Lab37|
    (setq t63 (|RElt| |Struct-runtime-13| |defaults| 5 |P0-dom|))
    (when (|PtrIsNil| t63) (go |Lab27|))
    (setq t73 (|RElt| |Struct-runtime-22| |cdv| 0 t63))
    (setq t71 (|RElt| |Struct-runtime-28| |getter| 3 t73))
    (setq
      t70
      (|CCall|
        t71
        (|RElt| |Struct-runtime-22| |catRep| 1 t63)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t70) (go |Lab298|))
    (setq t72 t70)
    |Lab31|
    (setq t76 t72)
    |Lab35|
    (when (|PtrIsNil| t76) (go |Lab310|))
    (setq t64 t76)
    |Lab28|
    (setq t172 t64)
    |Lab87|
    (setq |T0-newBox| t172)
    (go |Lab3|)
    |Lab310|
    (setq t61 (|RElt| |Struct-runtime-13| |extendees| 4 |P0-dom|))
    (when (|PtrEQ| t61 nil) (go |Lab29|))
    (setq |T573-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t61))
    (setq |T565-a| (the |SInt| 1))
    |Lab85|
    (when (|SIntLE| |T565-a| |T573-high|) (go |Lab315|))
    (setq t65 nil)
    |Lab30|
    (setq t64 t65)
    (go |Lab28|)
    |Lab315|
    (setq t171 (|SIntPrev| |T565-a|))
    (setq
      t170
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t61) t171))
    (when (|PtrIsNil| t170) (go |Lab86|))
    (setq
      t66
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t170)))
    (setq
      t62
      (|CCall|
        t66
        (|RElt| |Struct-runtime-11| |domainRep| 1 t170)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|
        |P5-skip|))
    (when (|PtrIsNil| t62) (go |Lab86|))
    (setq t172 t62)
    (go |Lab87|)
    |Lab86|
    (setq |T565-a| (|SIntNext| |T565-a|))
    (go |Lab85|)
    |Lab29|
    (setq t65 nil)
    (go |Lab30|)
    |Lab298|
    (setq t69 (the |SInt| 1))
    (setq
      t74
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t63)))
    (setq t68 (|CCall| t74 (|RElt| |Struct-runtime-22| |catRep| 1 t63)))
    |Lab32|
    (when (|SIntLT| t68 t69) (go |Lab33|))
    (setq
      t75
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t63)))
    (setq
      t67
      (|CCall| t75 (|RElt| |Struct-runtime-22| |catRep| 1 t63) t69))
    (when (|PtrIsNil| t67) (go |Lab34|))
    (setq t86 (|RElt| |Struct-runtime-22| |cdv| 0 t67))
    (setq t84 (|RElt| |Struct-runtime-28| |getter| 3 t86))
    (setq
      t83
      (|CCall|
        t84
        (|RElt| |Struct-runtime-22| |catRep| 1 t67)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t83) (go |Lab299|))
    (setq t85 t83)
    |Lab40|
    (setq t89 t85)
    |Lab44|
    (when (|PtrIsNil| t89) (go |Lab34|))
    (setq t76 t89)
    (go |Lab35|)
    |Lab34|
    (setq t69 (|SIntNext| t69))
    (go |Lab32|)
    |Lab299|
    (setq t82 (the |SInt| 1))
    (setq
      t87
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t67)))
    (setq t81 (|CCall| t87 (|RElt| |Struct-runtime-22| |catRep| 1 t67)))
    |Lab41|
    (when (|SIntLT| t81 t82) (go |Lab42|))
    (setq
      t88
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t67)))
    (setq
      t80
      (|CCall| t88 (|RElt| |Struct-runtime-22| |catRep| 1 t67) t82))
    (when (|PtrIsNil| t80) (go |Lab43|))
    (setq t96 (|RElt| |Struct-runtime-22| |cdv| 0 t80))
    (setq t94 (|RElt| |Struct-runtime-28| |getter| 3 t96))
    (setq
      t93
      (|CCall|
        t94
        (|RElt| |Struct-runtime-22| |catRep| 1 t80)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t93) (go |Lab300|))
    (setq t95 t93)
    |Lab45|
    (setq t99 t95)
    |Lab49|
    (when (|PtrIsNil| t99) (go |Lab43|))
    (setq t89 t99)
    (go |Lab44|)
    |Lab43|
    (setq t82 (|SIntNext| t82))
    (go |Lab41|)
    |Lab300|
    (setq t92 (the |SInt| 1))
    (setq
      t97
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t80)))
    (setq t91 (|CCall| t97 (|RElt| |Struct-runtime-22| |catRep| 1 t80)))
    |Lab46|
    (when (|SIntLT| t91 t92) (go |Lab47|))
    (setq
      t98
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t80)))
    (setq
      t90
      (|CCall| t98 (|RElt| |Struct-runtime-22| |catRep| 1 t80) t92))
    (when (|PtrIsNil| t90) (go |Lab48|))
    (setq t106 (|RElt| |Struct-runtime-22| |cdv| 0 t90))
    (setq t104 (|RElt| |Struct-runtime-28| |getter| 3 t106))
    (setq
      t103
      (|CCall|
        t104
        (|RElt| |Struct-runtime-22| |catRep| 1 t90)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t103) (go |Lab301|))
    (setq t105 t103)
    |Lab50|
    (setq t109 t105)
    |Lab54|
    (when (|PtrIsNil| t109) (go |Lab48|))
    (setq t99 t109)
    (go |Lab49|)
    |Lab48|
    (setq t92 (|SIntNext| t92))
    (go |Lab46|)
    |Lab301|
    (setq t102 (the |SInt| 1))
    (setq
      t107
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t90)))
    (setq
      t101
      (|CCall| t107 (|RElt| |Struct-runtime-22| |catRep| 1 t90)))
    |Lab51|
    (when (|SIntLT| t101 t102) (go |Lab52|))
    (setq
      t108
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t90)))
    (setq
      t100
      (|CCall| t108 (|RElt| |Struct-runtime-22| |catRep| 1 t90) t102))
    (when (|PtrIsNil| t100) (go |Lab53|))
    (setq t116 (|RElt| |Struct-runtime-22| |cdv| 0 t100))
    (setq t114 (|RElt| |Struct-runtime-28| |getter| 3 t116))
    (setq
      t113
      (|CCall|
        t114
        (|RElt| |Struct-runtime-22| |catRep| 1 t100)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t113) (go |Lab302|))
    (setq t115 t113)
    |Lab55|
    (setq t119 t115)
    |Lab59|
    (when (|PtrIsNil| t119) (go |Lab53|))
    (setq t109 t119)
    (go |Lab54|)
    |Lab53|
    (setq t102 (|SIntNext| t102))
    (go |Lab51|)
    |Lab302|
    (setq t112 (the |SInt| 1))
    (setq
      t117
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t100)))
    (setq
      t111
      (|CCall| t117 (|RElt| |Struct-runtime-22| |catRep| 1 t100)))
    |Lab56|
    (when (|SIntLT| t111 t112) (go |Lab57|))
    (setq
      t118
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t100)))
    (setq
      t110
      (|CCall| t118 (|RElt| |Struct-runtime-22| |catRep| 1 t100) t112))
    (when (|PtrIsNil| t110) (go |Lab58|))
    (setq t126 (|RElt| |Struct-runtime-22| |cdv| 0 t110))
    (setq t124 (|RElt| |Struct-runtime-28| |getter| 3 t126))
    (setq
      t123
      (|CCall|
        t124
        (|RElt| |Struct-runtime-22| |catRep| 1 t110)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t123) (go |Lab303|))
    (setq t125 t123)
    |Lab60|
    (setq t129 t125)
    |Lab64|
    (when (|PtrIsNil| t129) (go |Lab58|))
    (setq t119 t129)
    (go |Lab59|)
    |Lab58|
    (setq t112 (|SIntNext| t112))
    (go |Lab56|)
    |Lab303|
    (setq t122 (the |SInt| 1))
    (setq
      t127
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t110)))
    (setq
      t121
      (|CCall| t127 (|RElt| |Struct-runtime-22| |catRep| 1 t110)))
    |Lab61|
    (when (|SIntLT| t121 t122) (go |Lab62|))
    (setq
      t128
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t110)))
    (setq
      t120
      (|CCall| t128 (|RElt| |Struct-runtime-22| |catRep| 1 t110) t122))
    (when (|PtrIsNil| t120) (go |Lab63|))
    (setq t136 (|RElt| |Struct-runtime-22| |cdv| 0 t120))
    (setq t134 (|RElt| |Struct-runtime-28| |getter| 3 t136))
    (setq
      t133
      (|CCall|
        t134
        (|RElt| |Struct-runtime-22| |catRep| 1 t120)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t133) (go |Lab304|))
    (setq t135 t133)
    |Lab65|
    (setq t139 t135)
    |Lab69|
    (when (|PtrIsNil| t139) (go |Lab63|))
    (setq t129 t139)
    (go |Lab64|)
    |Lab63|
    (setq t122 (|SIntNext| t122))
    (go |Lab61|)
    |Lab304|
    (setq t132 (the |SInt| 1))
    (setq
      t137
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t120)))
    (setq
      t131
      (|CCall| t137 (|RElt| |Struct-runtime-22| |catRep| 1 t120)))
    |Lab66|
    (when (|SIntLT| t131 t132) (go |Lab67|))
    (setq
      t138
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t120)))
    (setq
      t130
      (|CCall| t138 (|RElt| |Struct-runtime-22| |catRep| 1 t120) t132))
    (when (|PtrIsNil| t130) (go |Lab68|))
    (setq t146 (|RElt| |Struct-runtime-22| |cdv| 0 t130))
    (setq t144 (|RElt| |Struct-runtime-28| |getter| 3 t146))
    (setq
      t143
      (|CCall|
        t144
        (|RElt| |Struct-runtime-22| |catRep| 1 t130)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t143) (go |Lab305|))
    (setq t145 t143)
    |Lab70|
    (setq t149 t145)
    |Lab74|
    (when (|PtrIsNil| t149) (go |Lab68|))
    (setq t139 t149)
    (go |Lab69|)
    |Lab68|
    (setq t132 (|SIntNext| t132))
    (go |Lab66|)
    |Lab305|
    (setq t142 (the |SInt| 1))
    (setq
      t147
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t130)))
    (setq
      t141
      (|CCall| t147 (|RElt| |Struct-runtime-22| |catRep| 1 t130)))
    |Lab71|
    (when (|SIntLT| t141 t142) (go |Lab72|))
    (setq
      t148
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t130)))
    (setq
      t140
      (|CCall| t148 (|RElt| |Struct-runtime-22| |catRep| 1 t130) t142))
    (when (|PtrIsNil| t140) (go |Lab73|))
    (setq t156 (|RElt| |Struct-runtime-22| |cdv| 0 t140))
    (setq t154 (|RElt| |Struct-runtime-28| |getter| 3 t156))
    (setq
      t153
      (|CCall|
        t154
        (|RElt| |Struct-runtime-22| |catRep| 1 t140)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t153) (go |Lab306|))
    (setq t155 t153)
    |Lab75|
    (setq t159 t155)
    |Lab79|
    (when (|PtrIsNil| t159) (go |Lab73|))
    (setq t149 t159)
    (go |Lab74|)
    |Lab73|
    (setq t142 (|SIntNext| t142))
    (go |Lab71|)
    |Lab306|
    (setq t152 (the |SInt| 1))
    (setq
      t157
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t140)))
    (setq
      t151
      (|CCall| t157 (|RElt| |Struct-runtime-22| |catRep| 1 t140)))
    |Lab76|
    (when (|SIntLT| t151 t152) (go |Lab77|))
    (setq
      t158
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t140)))
    (setq
      t150
      (|CCall| t158 (|RElt| |Struct-runtime-22| |catRep| 1 t140) t152))
    (when (|PtrIsNil| t150) (go |Lab78|))
    (setq t166 (|RElt| |Struct-runtime-22| |cdv| 0 t150))
    (setq t164 (|RElt| |Struct-runtime-28| |getter| 3 t166))
    (setq
      t163
      (|CCall|
        t164
        (|RElt| |Struct-runtime-22| |catRep| 1 t150)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t163) (go |Lab307|))
    (setq t165 t163)
    |Lab80|
    (setq t169 t165)
    |Lab84|
    (when (|PtrIsNil| t169) (go |Lab78|))
    (setq t159 t169)
    (go |Lab79|)
    |Lab78|
    (setq t152 (|SIntNext| t152))
    (go |Lab76|)
    |Lab307|
    (setq t162 (the |SInt| 1))
    (setq
      t167
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t150)))
    (setq
      t161
      (|CCall| t167 (|RElt| |Struct-runtime-22| |catRep| 1 t150)))
    |Lab81|
    (when (|SIntLT| t161 t162) (go |Lab82|))
    (setq
      t168
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t150)))
    (setq
      t160
      (|CCall| t168 (|RElt| |Struct-runtime-22| |catRep| 1 t150) t162))
    (when (|PtrIsNil| t160) (go |Lab83|))
    (setq t434 (|RElt| |Struct-runtime-22| |cdv| 0 t160))
    (setq t432 (|RElt| |Struct-runtime-28| |getter| 3 t434))
    (setq
      t431
      (|CCall|
        t432
        (|RElt| |Struct-runtime-22| |catRep| 1 t160)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t431) (go |Lab308|))
    (setq t433 t431)
    |Lab225|
    (setq t437 t433)
    |Lab229|
    (when (|PtrIsNil| t437) (go |Lab83|))
    (setq t169 t437)
    (go |Lab84|)
    |Lab83|
    (setq t162 (|SIntNext| t162))
    (go |Lab81|)
    |Lab308|
    (setq t430 (the |SInt| 1))
    (setq
      t435
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t160)))
    (setq
      t429
      (|CCall| t435 (|RElt| |Struct-runtime-22| |catRep| 1 t160)))
    |Lab226|
    (when (|SIntLT| t429 t430) (go |Lab227|))
    (setq
      t436
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t160)))
    (setq
      t428
      (|CCall| t436 (|RElt| |Struct-runtime-22| |catRep| 1 t160) t430))
    (when (|PtrIsNil| t428) (go |Lab228|))
    (setq t502 (|RElt| |Struct-runtime-22| |cdv| 0 t428))
    (setq t500 (|RElt| |Struct-runtime-28| |getter| 3 t502))
    (setq
      t499
      (|CCall|
        t500
        (|RElt| |Struct-runtime-22| |catRep| 1 t428)
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| t499) (go |Lab309|))
    (setq t501 t499)
    |Lab249|
    (setq t505 t501)
    |Lab253|
    (when (|PtrIsNil| t505) (go |Lab228|))
    (setq t437 t505)
    (go |Lab229|)
    |Lab228|
    (setq t430 (|SIntNext| t430))
    (go |Lab226|)
    |Lab309|
    (setq t498 (the |SInt| 1))
    (setq
      t503
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t428)))
    (setq
      t497
      (|CCall| t503 (|RElt| |Struct-runtime-22| |catRep| 1 t428)))
    |Lab250|
    (when (|SIntLT| t497 t498) (go |Lab251|))
    (setq
      t504
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t428)))
    (setq
      t496
      (|CCall| t504 (|RElt| |Struct-runtime-22| |catRep| 1 t428) t498))
    (when (|PtrIsNil| t496) (go |Lab252|))
    (setq
      t499
      (|C32-runtime-getDefault!|
        t496
        |P1-pcent|
        (the |SInt| 51482908)
        |P3-type|
        |P4-box|
        |e1|))
    (when (|PtrIsNil| t499) (go |Lab252|))
    (setq t505 t499)
    (go |Lab253|)
    |Lab252|
    (setq t498 (|SIntNext| t498))
    (go |Lab250|)
    |Lab251|
    (setq t501 nil)
    (go |Lab249|)
    |Lab227|
    (setq t433 nil)
    (go |Lab225|)
    |Lab82|
    (setq t165 nil)
    (go |Lab80|)
    |Lab77|
    (setq t155 nil)
    (go |Lab75|)
    |Lab72|
    (setq t145 nil)
    (go |Lab70|)
    |Lab67|
    (setq t135 nil)
    (go |Lab65|)
    |Lab62|
    (setq t125 nil)
    (go |Lab60|)
    |Lab57|
    (setq t115 nil)
    (go |Lab55|)
    |Lab52|
    (setq t105 nil)
    (go |Lab50|)
    |Lab47|
    (setq t95 nil)
    (go |Lab45|)
    |Lab42|
    (setq t85 nil)
    (go |Lab40|)
    |Lab33|
    (setq t72 nil)
    (go |Lab31|)
    |Lab27|
    (setq t172 nil)
    (go |Lab87|)
    |Lab36|
    (setq t78 (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|))
    (|CCall| t78 |P0-dom| t77)
    (go |Lab37|)
    |Lab38|
    (setq t79 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t79 |P0-dom|))
    (go |Lab39|)
    |Lab1|
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab16|))
    |Lab17|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t32
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t59 (|Clos| t32 |C6-runtime-PRINT|))
    (setq
      t60
      (|CCall| (|RElt| |Struct-runtime-13| |nameFn| 12 |P0-dom|)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t60))
      (go |Lab18|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t60) (the |SInt| 3))
      (go |Lab20|))
    (setq
      t34
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t60) (the |SInt| 2)))
    (setq t33 (|RElt| |Struct-runtime-54| |p| 1 t60))
    (when t34 (go |Lab22|))
    (setq t579 (|PtrIsNil| t33))
    (when t579 (go |Lab23|))
    (setq t50 (|RElt| |Struct-runtime-56| |first| 0 t33))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t50))
      (go |Lab242|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t50) (the |SInt| 3))
      (go |Lab243|))
    (setq
      t473
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t50) (the |SInt| 2)))
    (setq t472 (|RElt| |Struct-runtime-54| |p| 1 t50))
    (when t473 (go |Lab244|))
    (setq t583 (|PtrIsNil| t472))
    (when t583 (go |Lab245|))
    (setq t487 (|RElt| |Struct-runtime-56| |first| 0 t472))
    (|C8-runtime-printDomain| t59 t487 |e1|)
    (setq t488 (|RElt| |Struct-runtime-56| |rest| 1 t472))
    (setq t472 t488)
    |Lab244|
    (multiple-value-setq (t481 t482 t483) (|CCall| t59))
    (|CCall| t482 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T561-l| t472)
    |Lab246|
    (setq t584 (|PtrIsNil| |T561-l|))
    (when t584 (go |Lab247|))
    (setq t495 (|RElt| |Struct-runtime-56| |rest| 1 |T561-l|))
    (setq t493 (|RElt| |Struct-runtime-56| |first| 0 |T561-l|))
    (|C8-runtime-printDomain| t59 t493 |e1|)
    (setq t494 (|RElt| |Struct-runtime-56| |rest| 1 |T561-l|))
    (when (|PtrIsNil| t494) (go |Lab248|))
    (setq t477 (|MakeLit| ", "))
    (multiple-value-setq (t474 t475 t476) (|CCall| t59))
    (|CCall| t475 t477 (the |SInt| 1) (the |SInt| 0))
    |Lab248|
    (setq |T561-l| t495)
    (go |Lab246|)
    |Lab247|
    (setq t492 (|MakeLit| ")"))
    (multiple-value-setq (t489 t490 t491) (|CCall| t59))
    (|CCall| t490 t492 (the |SInt| 1) (the |SInt| 0))
    |Lab313|
    (setq t51 (|RElt| |Struct-runtime-56| |rest| 1 t33))
    (setq t33 t51)
    |Lab22|
    (multiple-value-setq (t44 t45 t46) (|CCall| t59))
    (|CCall| t45 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T553-l| t33)
    |Lab24|
    (setq t585 (|PtrIsNil| |T553-l|))
    (when t585 (go |Lab25|))
    (setq t58 (|RElt| |Struct-runtime-56| |rest| 1 |T553-l|))
    (setq t56 (|RElt| |Struct-runtime-56| |first| 0 |T553-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t56))
      (go |Lab235|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t56) (the |SInt| 3))
      (go |Lab236|))
    (setq
      t449
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t56) (the |SInt| 2)))
    (setq t448 (|RElt| |Struct-runtime-54| |p| 1 t56))
    (when t449 (go |Lab237|))
    (setq t580 (|PtrIsNil| t448))
    (when t580 (go |Lab238|))
    (setq t463 (|RElt| |Struct-runtime-56| |first| 0 t448))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t463))
      (go |Lab259|))
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-54| |tag| 0 t463)
        (the |SInt| 3))
      (go |Lab260|))
    (setq
      t517
      (|SIntEQ|
        (|RElt| |Struct-runtime-54| |tag| 0 t463)
        (the |SInt| 2)))
    (setq t516 (|RElt| |Struct-runtime-54| |p| 1 t463))
    (when t517 (go |Lab261|))
    (setq t582 (|PtrIsNil| t516))
    (when t582 (go |Lab262|))
    (setq t531 (|RElt| |Struct-runtime-56| |first| 0 t516))
    (|C8-runtime-printDomain| t59 t531 |e1|)
    (setq t532 (|RElt| |Struct-runtime-56| |rest| 1 t516))
    (setq t516 t532)
    |Lab261|
    (multiple-value-setq (t525 t526 t527) (|CCall| t59))
    (|CCall| t526 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T562-l| t516)
    |Lab263|
    (setq t586 (|PtrIsNil| |T562-l|))
    (when t586 (go |Lab264|))
    (setq t539 (|RElt| |Struct-runtime-56| |rest| 1 |T562-l|))
    (setq t537 (|RElt| |Struct-runtime-56| |first| 0 |T562-l|))
    (|C8-runtime-printDomain| t59 t537 |e1|)
    (setq t538 (|RElt| |Struct-runtime-56| |rest| 1 |T562-l|))
    (when (|PtrIsNil| t538) (go |Lab265|))
    (setq t521 (|MakeLit| ", "))
    (multiple-value-setq (t518 t519 t520) (|CCall| t59))
    (|CCall| t519 t521 (the |SInt| 1) (the |SInt| 0))
    |Lab265|
    (setq |T562-l| t539)
    (go |Lab263|)
    |Lab264|
    (setq t536 (|MakeLit| ")"))
    (multiple-value-setq (t533 t534 t535) (|CCall| t59))
    (|CCall| t534 t536 (the |SInt| 1) (the |SInt| 0))
    |Lab312|
    (setq t464 (|RElt| |Struct-runtime-56| |rest| 1 t448))
    (setq t448 t464)
    |Lab237|
    (multiple-value-setq (t457 t458 t459) (|CCall| t59))
    (|CCall| t458 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T560-l| t448)
    |Lab239|
    (setq t587 (|PtrIsNil| |T560-l|))
    (when t587 (go |Lab240|))
    (setq t471 (|RElt| |Struct-runtime-56| |rest| 1 |T560-l|))
    (setq t469 (|RElt| |Struct-runtime-56| |first| 0 |T560-l|))
    (|C8-runtime-printDomain| t59 t469 |e1|)
    (setq t470 (|RElt| |Struct-runtime-56| |rest| 1 |T560-l|))
    (when (|PtrIsNil| t470) (go |Lab241|))
    (setq t453 (|MakeLit| ", "))
    (multiple-value-setq (t450 t451 t452) (|CCall| t59))
    (|CCall| t451 t453 (the |SInt| 1) (the |SInt| 0))
    |Lab241|
    (setq |T560-l| t471)
    (go |Lab239|)
    |Lab240|
    (setq t468 (|MakeLit| ")"))
    (multiple-value-setq (t465 t466 t467) (|CCall| t59))
    (|CCall| t466 t468 (the |SInt| 1) (the |SInt| 0))
    |Lab311|
    (setq t57 (|RElt| |Struct-runtime-56| |rest| 1 |T553-l|))
    (when (|PtrIsNil| t57) (go |Lab26|))
    (setq t40 (|MakeLit| ", "))
    (multiple-value-setq (t37 t38 t39) (|CCall| t59))
    (|CCall| t38 t40 (the |SInt| 1) (the |SInt| 0))
    |Lab26|
    (setq |T553-l| t58)
    (go |Lab24|)
    |Lab262|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab260|
    (multiple-value-setq (t522 t523 t524) (|CCall| t59))
    (|CCall| t523 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab312|)
    |Lab259|
    (multiple-value-setq (t528 t529 t530) (|CCall| t59))
    (|CCall|
      t529
      (|RElt| |Struct-runtime-54| |p| 1 t463)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab312|)
    |Lab238|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab236|
    (multiple-value-setq (t454 t455 t456) (|CCall| t59))
    (|CCall| t455 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab311|)
    |Lab235|
    (multiple-value-setq (t460 t461 t462) (|CCall| t59))
    (|CCall|
      t461
      (|RElt| |Struct-runtime-54| |p| 1 t56)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab311|)
    |Lab25|
    (setq t55 (|MakeLit| ")"))
    (multiple-value-setq (t52 t53 t54) (|CCall| t59))
    (|CCall| t53 t55 (the |SInt| 1) (the |SInt| 0))
    (setq t36 t59)
    |Lab21|
    (setq t35 t36)
    |Lab19|
    (multiple-value-setq (t29 t30 t31) (|CCall| t35))
    (|CCall| t29 (the |Char| #\Newline))
    (|fiRaiseException| (|MakeLit| "Circular get broken"))
    (|Halt| (the |SInt| 102))
    |Lab245|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab243|
    (multiple-value-setq (t478 t479 t480) (|CCall| t59))
    (|CCall| t479 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab313|)
    |Lab242|
    (multiple-value-setq (t484 t485 t486) (|CCall| t59))
    (|CCall|
      t485
      (|RElt| |Struct-runtime-54| |p| 1 t50)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab313|)
    |Lab23|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab20|
    (multiple-value-setq (t41 t42 t43) (|CCall| t59))
    (|CCall| t42 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t36 t59)
    (go |Lab21|)
    |Lab18|
    (multiple-value-setq (t47 t48 t49) (|CCall| t59))
    (|CCall|
      t48
      (|RElt| |Struct-runtime-54| |p| 1 t60)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t35 t59)
    (go |Lab19|)
    |Lab16|
    (setq t28 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t28 |P0-dom|))
    (go |Lab17|)
    |Lab325|
    (setq
      t11
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t8) (the |SInt| 0)))
    (setq t551 t11)
    (setq |T571-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T552-v|))
    (setq |T564-a| (the |SInt| 1))
    |Lab10|
    (when (|SIntLE| |T564-a| |T571-high|) (go |Lab314|))
    (go |Lab6|)
    |Lab314|
    (setq t10 (|SIntPrev| |T564-a|))
    (setq
      t9
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T552-v|) t10))
    (when (|PtrEQ| t551 nil) (go |Lab11|))
    (setq t7 (|RElt| |Struct-runtime-25| |size| 0 t5))
    (when
      (|SIntNE| (|RElt| |Struct-runtime-53| |size| 0 t551) t7)
      (go |Lab11|))
    (setq t6 (|RElt| |Struct-runtime-53| |size| 0 t551))
    (setq |T550-a| (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| |T550-a| t6) (go |Lab9|))
    (|FoamFree| (|RElt| |Struct-runtime-25| |values| 1 t5))
    (|FoamFree| t5)
    (when (|PtrIsNil| t9) (go |Lab4|))
    (setq t3 (|RElt| |Struct-runtime-30| |value| 0 t9))
    (|SetRElt| |Struct-runtime-30| |value| 0 |P4-box| t3)
    (setq t1 |P4-box|)
    |Lab5|
    (setq t2 t1)
    (go |Lab0|)
    |Lab4|
    (setq t1 t9)
    (go |Lab5|)
    |Lab9|
    (setq t581 (|SIntPrev| |T550-a|))
    (when
      (|PtrMagicEQ|
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 t551) t581)
        (|AElt| (|RElt| |Struct-runtime-25| |values| 1 t5) t581))
      (go |Lab8|))
    |Lab11|
    (setq |T563-a| (|SIntNext| |T563-a|))
    (when (|SIntLE| |T563-a| |T572-high|) (go |Lab324|))
    (go |Lab6|)
    |Lab324|
    (setq t12 (|SIntPrev| |T563-a|))
    (setq t11 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t8) t12))
    (setq t551 t11)
    (setq |T564-a| (|SIntNext| |T564-a|))
    (go |Lab10|)
    |Lab8|
    (setq |T550-a| (|SIntNext| |T550-a|))
    (go |Lab7|)))

(defprog
  ((|C13-runtime-hash| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (tagbody
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab0|))
    |Lab1|
    (block-return
      |C13-runtime-hash|
      (|RElt| |Struct-runtime-13| |hashcode| 2 |P0-dom|))
    |Lab0|
    (setq t0 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t0 |P0-dom|))
    (go |Lab1|)))

(defprog
  ((|C14-runtime-name| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (tagbody
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab0|))
    |Lab1|
    (block-return
      |C14-runtime-name|
      (|CCall| (|RElt| |Struct-runtime-13| |nameFn| 12 |P0-dom|)))
    |Lab0|
    (setq t0 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t0 |P0-dom|))
    (go |Lab1|)))

(defprog
  ((|C15-runtime-inheritTo| |Word|)
    ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))
  ((|T0-fn1| |Clos|)
    (t1 |Env|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Record|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Record|)
    (t11 |Record|)
    (t12 |Record|)
    (t13 |Arr|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |Record|)
    (t17 |Arr|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-15| |Struct-runtime-15|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-runtime-15-dom-0| 0 |l0| |P0-dom|)
    (|SetLex| |Struct-runtime-15-child-1| 1 |l0| |P1-child|)
    (setq |T0-fn1| (|Clos| |e0| |C16-runtime-fn1|))
    (setq t20 (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (|SetLex| |Struct-runtime-51-serialThis-78| 78 |l1| (|SIntNext| t20))
    (setq t10 (|RNew| |Struct-runtime-13|))
    (|SetRElt| |Struct-runtime-13| |f1| 0 t10 |T0-fn1|)
    (|SetRElt| |Struct-runtime-13| |f2| 1 t10 nil)
    (|SetRElt| |Struct-runtime-13| |hashcode| 2 t10 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-13| |parents| 3 t10 nil)
    (|SetRElt| |Struct-runtime-13| |extendees| 4 t10 nil)
    (|SetRElt| |Struct-runtime-13| |defaults| 5 t10 nil)
    (|SetRElt| |Struct-runtime-13| |names| 6 t10 nil)
    (|SetRElt| |Struct-runtime-13| |types| 7 t10 nil)
    (|SetRElt| |Struct-runtime-13| |exports| 8 t10 nil)
    (|SetRElt| |Struct-runtime-13| |ngets| 9 t10 (the |SInt| 0))
    (|SetRElt|
      |Struct-runtime-13|
      |serial|
      10
      t10
      (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (setq t11 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t11 (the |SInt| 0))
    (setq t12 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t12 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t12 (the |SInt| 15))
    (setq t13 (|ANew| |Word| (the |SInt| 15)))
    (setq t15 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t15 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t12 t13)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t11 t12)
    (setq t16 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t16 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t16 (the |SInt| 15))
    (setq t17 (|ANew| |Word| (the |SInt| 15)))
    (setq t19 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t19 (the |SInt| 15)) (go |Lab5|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t16 t17)
    (|SetRElt| |Struct-runtime-34| |values| 2 t11 t16)
    (|SetRElt| |Struct-runtime-34| |size| 3 t11 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 t10 t11)
    (|SetRElt|
      |Struct-runtime-13|
      |nameFn|
      12
      t10
      (|Lex| |Struct-runtime-51-domainStdName-77| 77 |l1|))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-domainMakeDispatch-58| 58 |l1|)))
    (setq
      t1
      (|ClosEnv| (|Lex| |Struct-runtime-51-domainMakeDispatch-58| 58 |l1|)))
    (setq t2 (|RNew| |Struct-runtime-11|))
    (setq t4 (|EElt| |Struct-runtime-51-adv-64| 64 (|EnvLevel| t1)))
    (when (|PtrIsNil| t4) (go |Lab0|))
    (setq t3 (|EElt| |Struct-runtime-51-adv-64| 64 (|EnvLevel| t1)))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t2 t3)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t2 t10)
    (block-return |C15-runtime-inheritTo| t2)
    |Lab0|
    (setq t6 (|EElt| |Struct-runtime-51-name-74| 74 (|EnvLevel| t1)))
    (setq t7 (|EElt| |Struct-runtime-51-get-76| 76 (|EnvLevel| t1)))
    (setq t8 (|EElt| |Struct-runtime-51-hash-75| 75 (|EnvLevel| t1)))
    (setq
      t9
      (|EElt| |Struct-runtime-51-inheritTo-73| 73 (|EnvLevel| t1)))
    (setq t5 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t5 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t5 t6)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t5 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t5 t7)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t5 t8)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t5 t9)
    (|SetEElt| |Struct-runtime-51-adv-64| 64 (|EnvLevel| t1) t5)
    (setq t3 (|EElt| |Struct-runtime-51-adv-64| 64 (|EnvLevel| t1)))
    (go |Lab1|)
    |Lab5|
    (setq t18 (|SIntPrev| t19))
    (|SetAElt| t17 t18 nil)
    (setq t19 (|SIntNext| t19))
    (go |Lab4|)
    |Lab3|
    (setq t14 (|SIntPrev| t15))
    (|SetAElt| t13 t14 nil)
    (setq t15 (|SIntNext| t15))
    (go |Lab2|)))

(defprog
  ((|C16-runtime-fn1| |Clos|) ((|P0-self| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Clos|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |Word|)
    (t10 |Clos|)
    (t11 |Word|)
    (t12 |Record|)
    (t13 |Record|)
    (t14 |Arr|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |Record|)
    (t18 |Arr|)
    (t19 |SInt|)
    (t20 |SInt|)
    (t21 |Word|)
    (t22 |Clos|)
    (t23 |Word|)
    (|T24-a| |SInt|)
    (|T25-high| |Word|)
    (t26 |SInt|)
    (|l1| |Level|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (tagbody
    (setq t23 (|Lex| |Struct-runtime-15-dom-0| 0 |l1|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 t23) nil)
      (go |Lab7|))
    |Lab8|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-domainHash!-50| 50 |l2|)))
    (setq t11 (|Lex| |Struct-runtime-15-child-1| 1 |l1|))
    (setq
      t10
      (|RElt|
        |Struct-runtime-20|
        |hasher|
        4
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t11)))
    (setq
      t21
      (|CCall| t10 (|RElt| |Struct-runtime-11| |domainRep| 1 t11)))
    (|SetRElt| |Struct-runtime-13| |hashcode| 2 |P0-self| t21)
    (|SetRElt|
      |Struct-runtime-13|
      |nameFn|
      12
      |P0-self|
      (|RElt|
        |Struct-runtime-13|
        |nameFn|
        12
        (|Lex| |Struct-runtime-15-dom-0| 0 |l1|)))
    (when
      (|PtrEQ|
        (|RElt|
          |Struct-runtime-13|
          |extendees|
          4
          (|Lex| |Struct-runtime-15-dom-0| 0 |l1|))
        nil)
      (go |Lab0|))
    (setq
      t9
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt|
          |Struct-runtime-13|
          |extendees|
          4
          (|Lex| |Struct-runtime-15-dom-0| 0 |l1|))))
    (setq t5 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t5 t9)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t5 t9)
    (setq t6 (|ANew| |Word| t9))
    (setq t8 (the |SInt| 1))
    |Lab1|
    (when (|SIntLE| t8 t9) (go |Lab2|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t5 t6)
    (setq |T25-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t5))
    (setq |T24-a| (the |SInt| 1))
    |Lab9|
    (when (|SIntLE| |T24-a| |T25-high|) (go |Lab10|))
    (|SetRElt| |Struct-runtime-13| |extendees| 4 |P0-self| t5)
    |Lab0|
    (setq t12 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t12 (the |SInt| 0))
    (setq t13 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t13 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t13 (the |SInt| 15))
    (setq t14 (|ANew| |Word| (the |SInt| 15)))
    (setq t16 (the |SInt| 1))
    |Lab3|
    (when (|SIntLE| t16 (the |SInt| 15)) (go |Lab4|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t13 t14)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t12 t13)
    (setq t17 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t17 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t17 (the |SInt| 15))
    (setq t18 (|ANew| |Word| (the |SInt| 15)))
    (setq t20 (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| t20 (the |SInt| 15)) (go |Lab6|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t17 t18)
    (|SetRElt| |Struct-runtime-34| |values| 2 t12 t17)
    (|SetRElt| |Struct-runtime-34| |size| 3 t12 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 |P0-self| t12)
    (block-return
      |C16-runtime-fn1|
      (|RElt|
        |Struct-runtime-13|
        |f2|
        1
        (|Lex| |Struct-runtime-15-dom-0| 0 |l1|)))
    |Lab6|
    (setq t19 (|SIntPrev| t20))
    (|SetAElt| t18 t19 nil)
    (setq t20 (|SIntNext| t20))
    (go |Lab5|)
    |Lab4|
    (setq t15 (|SIntPrev| t16))
    (|SetAElt| t14 t15 nil)
    (setq t16 (|SIntNext| t16))
    (go |Lab3|)
    |Lab10|
    (setq t26 (|SIntPrev| |T24-a|))
    (setq
      t3
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt|
            |Struct-runtime-13|
            |extendees|
            4
            (|Lex| |Struct-runtime-15-dom-0| 0 |l1|)))
        t26))
    (setq t4 (|Lex| |Struct-runtime-15-child-1| 1 |l1|))
    (setq
      t2
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t3)))
    (setq
      t1
      (|CCall| t2 (|RElt| |Struct-runtime-11| |domainRep| 1 t3) t4))
    (setq t0 (|RElt| |Struct-runtime-52| |values| 2 t5))
    (|SetAElt| t0 t26 t1)
    (setq |T24-a| (|SIntNext| |T24-a|))
    (go |Lab9|)
    |Lab2|
    (setq t7 (|SIntPrev| t8))
    (|SetAElt| t6 t7 nil)
    (setq t8 (|SIntNext| t8))
    (go |Lab1|)
    |Lab7|
    (setq t22 (|RElt| |Struct-runtime-13| |f1| 0 t23))
    (|SetRElt| |Struct-runtime-13| |f2| 1 t23 (|CCall| t22 t23))
    (go |Lab8|)))

(defprog
  ((|C17-runtime-getExtend| |Word|)
    ((|P0-dom| |Word|)
      (|P1-pcent| |Word|)
      (|P2-name| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|P5-skip| |Word|)
      (|e1| |Env|)))
  ((|T0-pars| |Word|)
    (t1 |Clos|)
    (t2 |Word|)
    (t3 |Clos|)
    (t4 |Word|)
    (t5 |SInt|)
    (t6 |Word|)
    (|T7-a| |SInt|)
    (|T8-high| |Word|))
  (tagbody
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab0|))
    |Lab1|
    (setq |T0-pars| (|RElt| |Struct-runtime-13| |parents| 3 |P0-dom|))
    (when (|PtrEQ| |T0-pars| nil) (go |Lab2|))
    (setq |T8-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T0-pars|))
    (setq |T7-a| (the |SInt| 1))
    |Lab3|
    (when (|SIntLE| |T7-a| |T8-high|) (go |Lab7|))
    (setq t6 nil)
    |Lab5|
    (when (|PtrIsNil| t6) (go |Lab6|))
    (block-return |C17-runtime-getExtend| t6)
    |Lab6|
    (block-return |C17-runtime-getExtend| nil)
    |Lab7|
    (setq t5 (|SIntPrev| |T7-a|))
    (setq
      t4
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T0-pars|) t5))
    (when (|PtrIsNil| t4) (go |Lab4|))
    (setq
      t3
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t4)))
    (setq
      t2
      (|CCall|
        t3
        (|RElt| |Struct-runtime-11| |domainRep| 1 t4)
        |P1-pcent|
        |P2-name|
        |P3-type|
        |P4-box|
        |P5-skip|))
    (when (|PtrIsNil| t2) (go |Lab4|))
    (setq t6 t2)
    (go |Lab5|)
    |Lab4|
    (setq |T7-a| (|SIntNext| |T7-a|))
    (go |Lab3|)
    |Lab2|
    (setq t6 nil)
    (go |Lab5|)
    |Lab0|
    (setq t1 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t1 |P0-dom|))
    (go |Lab1|)))

(defprog
  ((|C18-runtime-hashExtend| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((|T0-pars| |Word|) (t1 |Word|) (t2 |Clos|) (t3 |Word|) (t4 |Clos|))
  (tagbody
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab2|))
    |Lab3|
    (setq |T0-pars| (|RElt| |Struct-runtime-13| |parents| 3 |P0-dom|))
    (when (|PtrEQ| |T0-pars| nil) (go |Lab5|))
    (setq
      t3
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |T0-pars|)
        (the |SInt| 0)))
    (setq
      t2
      (|RElt|
        |Struct-runtime-20|
        |hasher|
        4
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t3)))
    (setq t1 (|CCall| t2 (|RElt| |Struct-runtime-11| |domainRep| 1 t3)))
    |Lab1|
    (block-return |C18-runtime-hashExtend| t1)
    |Lab5|
    (setq t1 (the |SInt| 0))
    (go |Lab1|)
    |Lab2|
    (setq t4 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t4 |P0-dom|))
    (go |Lab3|)))

(defprog
  ((|C19-runtime-nameExtend| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((|T0-pars| |Word|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |Clos|)
    (t4 |Word|)
    (t5 |Clos|))
  (tagbody
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 |P0-dom|) nil)
      (go |Lab2|))
    |Lab3|
    (setq |T0-pars| (|RElt| |Struct-runtime-13| |parents| 3 |P0-dom|))
    (when (|PtrEQ| |T0-pars| nil) (go |Lab5|))
    (setq
      t4
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |T0-pars|)
        (the |SInt| 0)))
    (setq
      t3
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t4)))
    (setq t1 (|CCall| t3 (|RElt| |Struct-runtime-11| |domainRep| 1 t4)))
    |Lab1|
    (block-return |C19-runtime-nameExtend| t1)
    |Lab5|
    (setq t2 (|RNew| |Struct-runtime-54|))
    (|SetRElt| |Struct-runtime-54| |tag| 0 t2 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-54| |p| 1 t2 (|MakeLit| "Dunno"))
    (setq t1 t2)
    (go |Lab1|)
    |Lab2|
    (setq t5 (|RElt| |Struct-runtime-13| |f1| 0 |P0-dom|))
    (|SetRElt|
      |Struct-runtime-13|
      |f2|
      1
      |P0-dom|
      (|CCall| t5 |P0-dom|))
    (go |Lab3|)))

(defprog
  ((|C20-runtime-inheritToExtend| |Word|)
    ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))
  ((|T0-fn1| |Clos|)
    (t1 |Env|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Record|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Record|)
    (t11 |Record|)
    (t12 |Record|)
    (t13 |Arr|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |Record|)
    (t17 |Arr|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-16| |Struct-runtime-16|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-runtime-16-dom-0| 0 |l0| |P0-dom|)
    (|SetLex| |Struct-runtime-16-child-1| 1 |l0| |P1-child|)
    (setq |T0-fn1| (|Clos| |e0| |C21-runtime-fn1|))
    (setq t20 (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (|SetLex| |Struct-runtime-51-serialThis-78| 78 |l1| (|SIntNext| t20))
    (setq t10 (|RNew| |Struct-runtime-13|))
    (|SetRElt| |Struct-runtime-13| |f1| 0 t10 |T0-fn1|)
    (|SetRElt| |Struct-runtime-13| |f2| 1 t10 nil)
    (|SetRElt| |Struct-runtime-13| |hashcode| 2 t10 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-13| |parents| 3 t10 nil)
    (|SetRElt| |Struct-runtime-13| |extendees| 4 t10 nil)
    (|SetRElt| |Struct-runtime-13| |defaults| 5 t10 nil)
    (|SetRElt| |Struct-runtime-13| |names| 6 t10 nil)
    (|SetRElt| |Struct-runtime-13| |types| 7 t10 nil)
    (|SetRElt| |Struct-runtime-13| |exports| 8 t10 nil)
    (|SetRElt| |Struct-runtime-13| |ngets| 9 t10 (the |SInt| 0))
    (|SetRElt|
      |Struct-runtime-13|
      |serial|
      10
      t10
      (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (setq t11 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t11 (the |SInt| 0))
    (setq t12 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t12 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t12 (the |SInt| 15))
    (setq t13 (|ANew| |Word| (the |SInt| 15)))
    (setq t15 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t15 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t12 t13)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t11 t12)
    (setq t16 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t16 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t16 (the |SInt| 15))
    (setq t17 (|ANew| |Word| (the |SInt| 15)))
    (setq t19 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t19 (the |SInt| 15)) (go |Lab5|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t16 t17)
    (|SetRElt| |Struct-runtime-34| |values| 2 t11 t16)
    (|SetRElt| |Struct-runtime-34| |size| 3 t11 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 t10 t11)
    (|SetRElt|
      |Struct-runtime-13|
      |nameFn|
      12
      t10
      (|Lex| |Struct-runtime-51-domainStdName-77| 77 |l1|))
    (|FoamEnvEnsure| (|ClosEnv| |G-extendMakeDispatch|))
    (setq t1 (|ClosEnv| |G-extendMakeDispatch|))
    (setq t2 (|RNew| |Struct-runtime-11|))
    (setq t4 (|EElt| |Struct-runtime-51-edv-63| 63 (|EnvLevel| t1)))
    (when (|PtrIsNil| t4) (go |Lab0|))
    (setq t3 (|EElt| |Struct-runtime-51-edv-63| 63 (|EnvLevel| t1)))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t2 t3)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t2 t10)
    (block-return |C20-runtime-inheritToExtend| t2)
    |Lab0|
    (setq
      t6
      (|EElt| |Struct-runtime-51-nameExtend-70| 70 (|EnvLevel| t1)))
    (setq
      t7
      (|EElt| |Struct-runtime-51-getExtend-72| 72 (|EnvLevel| t1)))
    (setq
      t8
      (|EElt| |Struct-runtime-51-hashExtend-71| 71 (|EnvLevel| t1)))
    (setq
      t9
      (|EElt| |Struct-runtime-51-inheritToExtend-69| 69 (|EnvLevel| t1)))
    (setq t5 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t5 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t5 t6)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t5 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t5 t7)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t5 t8)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t5 t9)
    (|SetEElt| |Struct-runtime-51-edv-63| 63 (|EnvLevel| t1) t5)
    (setq t3 (|EElt| |Struct-runtime-51-edv-63| 63 (|EnvLevel| t1)))
    (go |Lab1|)
    |Lab5|
    (setq t18 (|SIntPrev| t19))
    (|SetAElt| t17 t18 nil)
    (setq t19 (|SIntNext| t19))
    (go |Lab4|)
    |Lab3|
    (setq t14 (|SIntPrev| t15))
    (|SetAElt| t13 t14 nil)
    (setq t15 (|SIntNext| t15))
    (go |Lab2|)))

(defprog
  ((|C21-runtime-fn1| |Clos|) ((|P0-self| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Clos|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |Word|)
    (t10 |Word|)
    (t11 |Record|)
    (t12 |Arr|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Word|)
    (t16 |Record|)
    (t17 |Record|)
    (t18 |Arr|)
    (t19 |SInt|)
    (t20 |SInt|)
    (t21 |Record|)
    (t22 |Arr|)
    (t23 |SInt|)
    (t24 |SInt|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Clos|)
    (t28 |Word|)
    (t29 |Word|)
    (t30 |Word|)
    (t31 |Clos|)
    (t32 |Word|)
    (|T33-a| |SInt|)
    (|T34-a| |SInt|)
    (|T35-a| |SInt|)
    (|T36-high| |Word|)
    (|T37-high| |Word|)
    (t38 |SInt|)
    (t39 |SInt|)
    (t40 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t32 (|Lex| |Struct-runtime-16-dom-0| 0 |l1|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 t32) nil)
      (go |Lab11|))
    |Lab12|
    (setq
      t15
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt|
          |Struct-runtime-13|
          |parents|
          3
          (|Lex| |Struct-runtime-16-dom-0| 0 |l1|))))
    (setq t11 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t11 t15)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t11 t15)
    (setq t12 (|ANew| |Word| t15))
    (setq t14 (the |SInt| 1))
    |Lab3|
    (when (|SIntLE| t14 t15) (go |Lab4|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t11 t12)
    (setq |T37-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t11))
    (setq |T33-a| (the |SInt| 1))
    |Lab15|
    (when (|SIntLE| |T33-a| |T37-high|) (go |Lab16|))
    (setq t30 (|Lex| |Struct-runtime-16-child-1| 1 |l1|))
    (setq t29 (|RElt| |Struct-runtime-52| |nvalues| 1 t11))
    (setq |T35-a| (the |SInt| 1))
    |Lab9|
    (when (|SIntLE| |T35-a| t29) (go |Lab10|))
    (|SetRElt| |Struct-runtime-13| |parents| 3 |P0-self| t11)
    (when
      (|PtrEQ|
        (|RElt|
          |Struct-runtime-13|
          |extendees|
          4
          (|Lex| |Struct-runtime-16-dom-0| 0 |l1|))
        nil)
      (go |Lab0|))
    (setq
      t9
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt|
          |Struct-runtime-13|
          |extendees|
          4
          (|Lex| |Struct-runtime-16-dom-0| 0 |l1|))))
    (setq t5 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t5 t9)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t5 t9)
    (setq t6 (|ANew| |Word| t9))
    (setq t8 (the |SInt| 1))
    |Lab1|
    (when (|SIntLE| t8 t9) (go |Lab2|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t5 t6)
    (setq |T36-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t5))
    (setq |T34-a| (the |SInt| 1))
    |Lab13|
    (when (|SIntLE| |T34-a| |T36-high|) (go |Lab14|))
    (|SetRElt| |Struct-runtime-13| |extendees| 4 |P0-self| t5)
    |Lab0|
    (setq t16 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t16 (the |SInt| 0))
    (setq t17 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t17 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t17 (the |SInt| 15))
    (setq t18 (|ANew| |Word| (the |SInt| 15)))
    (setq t20 (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| t20 (the |SInt| 15)) (go |Lab6|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t17 t18)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t16 t17)
    (setq t21 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t21 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t21 (the |SInt| 15))
    (setq t22 (|ANew| |Word| (the |SInt| 15)))
    (setq t24 (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| t24 (the |SInt| 15)) (go |Lab8|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t21 t22)
    (|SetRElt| |Struct-runtime-34| |values| 2 t16 t21)
    (|SetRElt| |Struct-runtime-34| |size| 3 t16 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 |P0-self| t16)
    (block-return |C21-runtime-fn1| (|Clos| |e0| |C22-runtime-fn1|))
    |Lab8|
    (setq t23 (|SIntPrev| t24))
    (|SetAElt| t22 t23 nil)
    (setq t24 (|SIntNext| t24))
    (go |Lab7|)
    |Lab6|
    (setq t19 (|SIntPrev| t20))
    (|SetAElt| t18 t19 nil)
    (setq t20 (|SIntNext| t20))
    (go |Lab5|)
    |Lab14|
    (setq t40 (|SIntPrev| |T34-a|))
    (setq
      t3
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt|
            |Struct-runtime-13|
            |extendees|
            4
            (|Lex| |Struct-runtime-16-dom-0| 0 |l1|)))
        t40))
    (setq t4 (|Lex| |Struct-runtime-16-child-1| 1 |l1|))
    (setq
      t2
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t3)))
    (setq
      t1
      (|CCall| t2 (|RElt| |Struct-runtime-11| |domainRep| 1 t3) t4))
    (setq t0 (|RElt| |Struct-runtime-52| |values| 2 t5))
    (|SetAElt| t0 t40 t1)
    (setq |T34-a| (|SIntNext| |T34-a|))
    (go |Lab13|)
    |Lab2|
    (setq t7 (|SIntPrev| t8))
    (|SetAElt| t6 t7 nil)
    (setq t8 (|SIntNext| t8))
    (go |Lab1|)
    |Lab10|
    (setq t39 (|SIntPrev| |T35-a|))
    (setq t28 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t11) t39))
    (setq
      t27
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t28)))
    (setq
      t26
      (|CCall| t27 (|RElt| |Struct-runtime-11| |domainRep| 1 t28) t30))
    (setq t25 (|RElt| |Struct-runtime-52| |values| 2 t11))
    (|SetAElt| t25 t39 t26)
    (setq |T35-a| (|SIntNext| |T35-a|))
    (go |Lab9|)
    |Lab16|
    (setq t38 (|SIntPrev| |T33-a|))
    (setq t10 (|RElt| |Struct-runtime-52| |values| 2 t11))
    (|SetAElt|
      t10
      t38
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt|
            |Struct-runtime-13|
            |parents|
            3
            (|Lex| |Struct-runtime-16-dom-0| 0 |l1|)))
        t38))
    (setq |T33-a| (|SIntNext| |T33-a|))
    (go |Lab15|)
    |Lab4|
    (setq t13 (|SIntPrev| t14))
    (|SetAElt| t12 t13 nil)
    (setq t14 (|SIntNext| t14))
    (go |Lab3|)
    |Lab11|
    (setq t31 (|RElt| |Struct-runtime-13| |f1| 0 t32))
    (|SetRElt| |Struct-runtime-13| |f2| 1 t32 (|CCall| t31 t32))
    (go |Lab12|)))

(defprog
  ((|C22-runtime-fn1|) ((|P0-x| |Word|) (|P1-h| |Word|) (|e1| |Env|)))
  ()
  (block-return |C22-runtime-fn1| ()))

(defprog
  ((|C23-runtime-nameDummy| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 0))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 (|MakeLit| "Dunno"))
  (block-return |C23-runtime-nameDummy| t0))

(defprog
  ((|C24-runtime-getDummy| |Word|)
    ((|P0-dom| |Word|)
      (|P1-pcent| |Word|)
      (|P2-name| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|P5-skip| |Word|)
      (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "get on incomplete domain"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C25-runtime-hashDummy| |Word|) ((|P0-dom| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "hash value read on incomplete domain"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C26-runtime-inheritToDummy| |Word|)
    ((|P0-dom| |Word|) (|P1-child| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "inherit to incomplete domain"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C27-runtime-name| |Word|) ((|P0-d| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t1)))
    (block-return
      |C27-runtime-name|
      (|CCall| t0 (|RElt| |Struct-runtime-11| |domainRep| 1 t1)))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-d| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-d| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C28-runtime-domHash| |Word|) ((|P0-d| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-20|
        |hasher|
        4
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t1)))
    (block-return
      |C28-runtime-domHash|
      (|CCall| t0 (|RElt| |Struct-runtime-11| |domainRep| 1 t1)))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-d| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-d| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C29-runtime-get| |Word|)
    ((|P0-d| |Word|)
      (|P1-pc| |Word|)
      (|P2-n1| |Word|)
      (|P3-n2| |Word|)
      (|P4-box| |Word|)
      (|P5-skip| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t1)))
    (block-return
      |C29-runtime-get|
      (|CCall|
        t0
        (|RElt| |Struct-runtime-11| |domainRep| 1 t1)
        |P1-pc|
        |P2-n1|
        |P3-n2|
        |P4-box|
        |P5-skip|))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-d|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-d|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-d| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-d| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C30-runtime-inheritTo| |Word|)
    ((|P0-d| |Word|) (|P1-d2| |Word|) (|e1| |Env|)))
  ((|T0-fn| |Clos|)
    (t1 |Word|)
    (t2 |Clos|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Env|)
    (t6 |Word|)
    (t7 |Word|)
    (t8 |Record|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Clos|)
    (t13 |Record|)
    (t14 |Record|)
    (t15 |Word|)
    (t16 |Word|)
    (t17 |Record|)
    (t18 |Clos|)
    (t19 |Clos|)
    (t20 |Clos|)
    (t21 |Clos|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-19| |Struct-runtime-19|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (tagbody
    (|SetLex| |Struct-runtime-19-d-0| 0 |l0| |P0-d|)
    (|SetLex| |Struct-runtime-19-d2-1| 1 |l0| |P1-d2|)
    (setq |T0-fn| (|Clos| |e0| |C31-runtime-fn|))
    (when
      (|SIntEQ|
        (|RElt|
          |Struct-runtime-18|
          |tag|
          0
          (|Lex| |Struct-runtime-19-d-0| 0 |l0|))
        (the |SInt| 1))
      (go |Lab0|))
    (|FoamEnvEnsure| (|ClosEnv| |G-rtLazyDomFrFn|))
    (setq t5 (|ClosEnv| |G-rtLazyDomFrFn|))
    (setq t14 (|RNew| |Struct-runtime-11|))
    (setq t16 (|EElt| |Struct-runtime-51-ddv-62| 62 (|EnvLevel| t5)))
    (when (|PtrIsNil| t16) (go |Lab5|))
    (setq t15 (|EElt| |Struct-runtime-51-ddv-62| 62 (|EnvLevel| t5)))
    |Lab6|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t14 t15)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t14 nil)
    (setq t7 (|EElt| |Struct-runtime-51-pdv-83| 83 (|EnvLevel| t5)))
    (when (|PtrIsNil| t7) (go |Lab3|))
    (setq t6 (|EElt| |Struct-runtime-51-pdv-83| 83 (|EnvLevel| t5)))
    |Lab4|
    (setq t13 (|RNew| |Struct-runtime-18|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t13 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-18| |value| 1 t13 |T0-fn|)
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t14 t6)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t14 t13)
    (setq t1 t14)
    |Lab1|
    (block-return |C30-runtime-inheritTo| t1)
    |Lab3|
    (setq t9 (|EElt| |Struct-runtime-51-name-82| 82 (|EnvLevel| t5)))
    (setq t10 (|EElt| |Struct-runtime-51-get-80| 80 (|EnvLevel| t5)))
    (setq t11 (|EElt| |Struct-runtime-51-domHash-81| 81 (|EnvLevel| t5)))
    (setq
      t12
      (|EElt| |Struct-runtime-51-inheritTo-79| 79 (|EnvLevel| t5)))
    (setq t8 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t8 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t8 t9)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t8 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t8 t10)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t8 t11)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t8 t12)
    (|SetEElt| |Struct-runtime-51-pdv-83| 83 (|EnvLevel| t5) t8)
    (setq t6 (|EElt| |Struct-runtime-51-pdv-83| 83 (|EnvLevel| t5)))
    (go |Lab4|)
    |Lab5|
    (setq
      t18
      (|EElt| |Struct-runtime-51-nameDummy-68| 68 (|EnvLevel| t5)))
    (setq
      t19
      (|EElt| |Struct-runtime-51-getDummy-67| 67 (|EnvLevel| t5)))
    (setq
      t20
      (|EElt| |Struct-runtime-51-hashDummy-66| 66 (|EnvLevel| t5)))
    (setq
      t21
      (|EElt| |Struct-runtime-51-inheritToDummy-65| 65 (|EnvLevel| t5)))
    (setq t17 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t17 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t17 t18)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t17 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t17 t19)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t17 t20)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t17 t21)
    (|SetEElt| |Struct-runtime-51-ddv-62| 62 (|EnvLevel| t5) t17)
    (setq t15 (|EElt| |Struct-runtime-51-ddv-62| 62 (|EnvLevel| t5)))
    (go |Lab6|)
    |Lab0|
    (when
      (|SIntEQ|
        (|RElt|
          |Struct-runtime-18|
          |tag|
          0
          (|Lex| |Struct-runtime-19-d-0| 0 |l0|))
        (the |SInt| 1))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq
      t3
      (|RElt|
        |Struct-runtime-18|
        |value|
        1
        (|Lex| |Struct-runtime-19-d-0| 0 |l0|)))
    (setq t4 (|Lex| |Struct-runtime-19-d2-1| 1 |l0|))
    (setq
      t2
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t3)))
    (setq
      t1
      (|CCall| t2 (|RElt| |Struct-runtime-11| |domainRep| 1 t3) t4))
    (go |Lab1|)))

(defprog
  ((|C31-runtime-fn| |Word|) ((|e1| |Env|)))
  ((t0 |Clos|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Clos|)
    (t4 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t4 (|Lex| |Struct-runtime-19-d-0| 0 |l1|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 t4))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-18| |tag| 0 t4) (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 t4))
    (setq t2 (|Lex| |Struct-runtime-19-d2-1| 1 |l1|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t1)))
    (block-return
      |C31-runtime-fn|
      (|CCall| t0 (|RElt| |Struct-runtime-11| |domainRep| 1 t1) t2))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 t4))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t3 (|RElt| |Struct-runtime-18| |value| 1 t4))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t4 (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 t4 (|CCall| t3))
    (go |Lab1|)))

(defprog
  ((|C32-runtime-getDefault!| |Word|)
    ((|P0-cat| |Word|)
      (|P1-pcent| |Word|)
      (|P2-nm| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|e1| |Env|)))
  ((|T0-p| |Word|)
    (|T1-l| |Word|)
    (|T2-i| |SInt|)
    (|T3-val| |Word|)
    (t4 |Clos|)
    (t5 |Word|)
    (t6 |Word|)
    (t7 |Clos|)
    (t8 |Clos|))
  (tagbody
    (setq t6 (|RElt| |Struct-runtime-22| |cdv| 0 |P0-cat|))
    (setq t4 (|RElt| |Struct-runtime-28| |getter| 3 t6))
    (setq
      |T3-val|
      (|CCall|
        t4
        (|RElt| |Struct-runtime-22| |catRep| 1 |P0-cat|)
        |P1-pcent|
        |P2-nm|
        |P3-type|
        |P4-box|))
    (when (|PtrIsNil| |T3-val|) (go |Lab8|))
    (setq t5 |T3-val|)
    |Lab1|
    (block-return |C32-runtime-getDefault!| t5)
    |Lab8|
    (setq |T2-i| (the |SInt| 1))
    (setq
      t7
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 |P0-cat|)))
    (setq
      |T1-l|
      (|CCall| t7 (|RElt| |Struct-runtime-22| |catRep| 1 |P0-cat|)))
    |Lab2|
    (when (|SIntLT| |T1-l| |T2-i|) (go |Lab3|))
    (setq
      t8
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 |P0-cat|)))
    (setq
      |T0-p|
      (|CCall| t8 (|RElt| |Struct-runtime-22| |catRep| 1 |P0-cat|) |T2-i|))
    (when (|PtrIsNil| |T0-p|) (go |Lab5|))
    (setq
      |T3-val|
      (|C32-runtime-getDefault!|
        |T0-p|
        |P1-pcent|
        |P2-nm|
        |P3-type|
        |P4-box|
        |e1|))
    (when (|PtrIsNil| |T3-val|) (go |Lab5|))
    (block-return |C32-runtime-getDefault!| |T3-val|)
    |Lab5|
    (setq |T2-i| (|SIntNext| |T2-i|))
    (go |Lab2|)
    |Lab3|
    (setq t5 nil)
    (go |Lab1|)))

(defprog
  ((|C33-runtime-name0| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq t0 (|RElt| |Struct-runtime-24| |nameFn| 9 |P0-cat|))
  (block-return |C33-runtime-name0| (|CCall| t0)))

(defprog
  ((|C34-runtime-build0| |Word|)
    ((|P0-cat| |Word|) (|P1-d| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |SInt|)
    (t4 |Word|)
    (t5 |Word|)
    (t6 |SInt|)
    (t7 |Word|)
    (t8 |Word|)
    (t9 |SInt|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |Word|)
    (t13 |Word|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |Word|)
    (t17 |Word|)
    (t18 |SInt|)
    (t19 |Word|)
    (t20 |SInt|)
    (t21 |Word|)
    (t22 |Record|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Record|)
    (t26 |Clos|)
    (t27 |Clos|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Record|)
    (t33 |Record|)
    (t34 |Record|)
    (t35 |Arr|)
    (t36 |SInt|)
    (t37 |SInt|)
    (t38 |Record|)
    (t39 |Arr|)
    (t40 |SInt|)
    (t41 |SInt|)
    (|T42-a| |SInt|)
    (t43 |Word|)
    (|T44-v| |Word|)
    (|T45-a| |SInt|)
    (|T46-a| |SInt|)
    (|T47-high| |Word|)
    (|T48-high| |Word|)
    (t49 |SInt|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-runtime-25|))
    (|SetRElt| |Struct-runtime-25| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-runtime-25| |values| 1 t1 t0)
    (|SetAElt| t0 (the |SInt| 0) |P1-d|)
    (setq t21 (|RElt| |Struct-runtime-24| |dc| 2 |P0-cat|))
    (setq t16 (|RElt| |Struct-runtime-34| |keys| 1 t21))
    (setq |T44-v| (|RElt| |Struct-runtime-34| |values| 2 t21))
    (setq |T48-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t16))
    (setq |T45-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T48-high|) (go |Lab18|))
    |Lab3|
    (setq t32 (|RNew| |Struct-runtime-24|))
    (|SetRElt|
      |Struct-runtime-24|
      |buildFn|
      0
      t32
      (|RElt| |Struct-runtime-24| |buildFn| 0 |P0-cat|))
    (|SetRElt|
      |Struct-runtime-24|
      |hashFn|
      1
      t32
      (|RElt| |Struct-runtime-24| |hashFn| 1 |P0-cat|))
    (setq t33 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t33 (the |SInt| 0))
    (setq t34 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t34 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t34 (the |SInt| 15))
    (setq t35 (|ANew| |Word| (the |SInt| 15)))
    (setq t37 (the |SInt| 1))
    |Lab12|
    (when (|SIntLE| t37 (the |SInt| 15)) (go |Lab13|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t34 t35)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t33 t34)
    (setq t38 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t38 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t38 (the |SInt| 15))
    (setq t39 (|ANew| |Word| (the |SInt| 15)))
    (setq t41 (the |SInt| 1))
    |Lab14|
    (when (|SIntLE| t41 (the |SInt| 15)) (go |Lab15|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t38 t39)
    (|SetRElt| |Struct-runtime-34| |values| 2 t33 t38)
    (|SetRElt| |Struct-runtime-34| |size| 3 t33 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-24| |dc| 2 t32 t33)
    (|SetRElt| |Struct-runtime-24| |domain| 3 t32 nil)
    (|SetRElt| |Struct-runtime-24| |parents| 4 t32 nil)
    (|SetRElt| |Struct-runtime-24| |nparents| 5 t32 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-24| |names| 6 t32 nil)
    (|SetRElt| |Struct-runtime-24| |types| 7 t32 nil)
    (|SetRElt| |Struct-runtime-24| |exports| 8 t32 nil)
    (|SetRElt|
      |Struct-runtime-24|
      |nameFn|
      9
      t32
      (|RElt| |Struct-runtime-24| |nameFn| 9 |P0-cat|))
    (|SetRElt| |Struct-runtime-24| |domain| 3 t32 |P1-d|)
    (|SetRElt| |Struct-runtime-24| |dc| 2 t32 nil)
    (setq t22 (|RNew| |Struct-runtime-22|))
    (setq t24 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    (when (|PtrIsNil| t24) (go |Lab10|))
    (setq t23 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    |Lab11|
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t22 t23)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t22 t32)
    (setq t13 (|RElt| |Struct-runtime-24| |dc| 2 |P0-cat|))
    (setq t10 (|RElt| |Struct-runtime-34| |posn| 0 t13))
    (setq t12 (|RElt| |Struct-runtime-34| |keys| 1 t13))
    (setq t11 (|RElt| |Struct-runtime-52| |values| 2 t12))
    (|SetAElt| t11 t10 t1)
    (setq t8 (|RElt| |Struct-runtime-34| |values| 2 t13))
    (setq t9 (|SIntNext| (|RElt| |Struct-runtime-34| |posn| 0 t13)))
    (setq t7 (|RElt| |Struct-runtime-52| |values| 2 t8))
    (setq t6 (|SIntPrev| t9))
    (|SetAElt| t7 t6 t22)
    (setq t4 (|RElt| |Struct-runtime-34| |posn| 0 t13))
    (setq t5 (|RElt| |Struct-runtime-34| |size| 3 t13))
    (setq t4 (|SIntMinus| t4 t5))
    (setq t3 (|SIntNext| t4))
    (when (|SIntIsNeg| t3) (go |Lab1|))
    |Lab2|
    (|SetRElt| |Struct-runtime-34| |posn| 0 t13 t3)
    (setq t2 t22)
    |Lab0|
    (block-return |C34-runtime-build0| t2)
    |Lab1|
    (setq t3 (|SIntPlus| t3 t5))
    (go |Lab2|)
    |Lab10|
    (setq t26 (|Lex| |Struct-runtime-51-name0-97| 97 |l1|))
    (setq t27 (|Lex| |Struct-runtime-51-build0-96| 96 |l1|))
    (setq t28 (|Lex| |Struct-runtime-51-get0-95| 95 |l1|))
    (setq t29 (|Lex| |Struct-runtime-51-hash0-94| 94 |l1|))
    (setq t30 (|Lex| |Struct-runtime-51-parentCount0-93| 93 |l1|))
    (setq t31 (|Lex| |Struct-runtime-51-parentGet-92| 92 |l1|))
    (setq t25 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t25 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t25 t26)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t25 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t25 t28)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t25 t29)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t25 t27)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t25 t30)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t25 t31)
    (|SetLex| |Struct-runtime-51-dv-85| 85 |l1| t25)
    (setq t23 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    (go |Lab11|)
    |Lab15|
    (setq t40 (|SIntPrev| t41))
    (|SetAElt| t39 t40 nil)
    (setq t41 (|SIntNext| t41))
    (go |Lab14|)
    |Lab13|
    (setq t36 (|SIntPrev| t37))
    (|SetAElt| t35 t36 nil)
    (setq t37 (|SIntNext| t37))
    (go |Lab12|)
    |Lab18|
    (setq
      t19
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 t16)
        (the |SInt| 0)))
    (setq t43 t19)
    (setq |T47-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T44-v|))
    (setq |T46-a| (the |SInt| 1))
    |Lab8|
    (when (|SIntLE| |T46-a| |T47-high|) (go |Lab16|))
    (go |Lab3|)
    |Lab16|
    (setq t18 (|SIntPrev| |T46-a|))
    (setq
      t17
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T44-v|) t18))
    (when (|PtrEQ| t43 nil) (go |Lab9|))
    (setq t15 (|RElt| |Struct-runtime-25| |size| 0 t1))
    (when
      (|SIntNE| (|RElt| |Struct-runtime-53| |size| 0 t43) t15)
      (go |Lab4|))
    (setq t14 (|RElt| |Struct-runtime-53| |size| 0 t43))
    (setq |T42-a| (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| |T42-a| t14) (go |Lab7|))
    (setq t2 t17)
    (go |Lab0|)
    |Lab7|
    (setq t49 (|SIntPrev| |T42-a|))
    (when
      (|PtrMagicEQ|
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 t43) t49)
        (|AElt| (|RElt| |Struct-runtime-25| |values| 1 t1) t49))
      (go |Lab6|))
    |Lab9|
    (setq |T45-a| (|SIntNext| |T45-a|))
    (when (|SIntLE| |T45-a| |T48-high|) (go |Lab17|))
    (go |Lab3|)
    |Lab17|
    (setq t20 (|SIntPrev| |T45-a|))
    (setq t19 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t16) t20))
    (setq t43 t19)
    (setq |T46-a| (|SIntNext| |T46-a|))
    (go |Lab8|)
    |Lab6|
    (setq |T42-a| (|SIntNext| |T42-a|))
    (go |Lab5|)
    |Lab4|
    (go |Lab9|)))

(defprog
  ((|C35-runtime-get0| |Word|)
    ((|P0-cat| |Word|)
      (|P1-pcent| |Word|)
      (|P2-name| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Clos|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |SInt|)
    (t6 |Word|)
    (t7 |SInt|)
    (t8 |Word|)
    (t9 |SInt|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |Clos|)
    (t13 |Word|)
    (|T14-v| |Word|)
    (t15 |Word|)
    (|T16-a| |SInt|)
    (|T17-a| |SInt|)
    (|T18-a| |SInt|)
    (|T19-high| |Word|)
    (|T20-high| |Word|)
    (|T21-high| |Word|))
  (tagbody
    (when (|SIntEQ| |P2-name| (the |SInt| 51482908)) (go |Lab0|))
    (setq t3 (|RElt| |Struct-runtime-24| |names| 6 |P0-cat|))
    (when (|PtrEQ| t3 nil) (go |Lab4|))
    |Lab5|
    (setq t0 (|RElt| |Struct-runtime-24| |names| 6 |P0-cat|))
    (setq t1 (|RElt| |Struct-runtime-24| |types| 7 |P0-cat|))
    (setq |T14-v| (|RElt| |Struct-runtime-24| |exports| 8 |P0-cat|))
    (setq |T20-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t0))
    (setq |T16-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T20-high|) (go |Lab10|))
    |Lab2|
    (setq t10 nil)
    |Lab8|
    (block-return |C35-runtime-get0| t10)
    |Lab10|
    (setq
      t6
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t0) (the |SInt| 0)))
    (setq t13 t6)
    (setq |T19-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t1))
    (setq |T18-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T19-high|) (go |Lab12|))
    (go |Lab2|)
    |Lab12|
    (setq
      t4
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t1) (the |SInt| 0)))
    (setq t15 t4)
    (setq |T21-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T14-v|))
    (setq |T17-a| (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| |T17-a| |T21-high|) (go |Lab9|))
    (go |Lab2|)
    |Lab9|
    (setq t9 (|SIntPrev| |T17-a|))
    (setq
      t8
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T14-v|) t9))
    (when (|SIntNE| t13 |P2-name|) (go |Lab6|))
    (when (|SIntEQ| |P3-type| t15) (go |Lab3|))
    (when (|SIntEQ| |P3-type| (the |SInt| -1)) (go |Lab3|))
    |Lab6|
    (setq |T16-a| (|SIntNext| |T16-a|))
    (when (|SIntLE| |T16-a| |T20-high|) (go |Lab11|))
    (go |Lab2|)
    |Lab11|
    (setq t7 (|SIntPrev| |T16-a|))
    (setq t6 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t0) t7))
    (setq t13 t6)
    (setq |T18-a| (|SIntNext| |T18-a|))
    (when (|SIntLE| |T18-a| |T19-high|) (go |Lab13|))
    (go |Lab2|)
    |Lab13|
    (setq t5 (|SIntPrev| |T18-a|))
    (setq t4 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t1) t5))
    (setq t15 t4)
    (setq |T17-a| (|SIntNext| |T17-a|))
    (go |Lab7|)
    |Lab3|
    (|SetRElt| |Struct-runtime-30| |value| 0 |P4-box| t8)
    (setq t10 |P4-box|)
    (go |Lab8|)
    |Lab4|
    (setq t2 (|RElt| |Struct-runtime-24| |buildFn| 0 |P0-cat|))
    (|CCall|
      t2
      |P0-cat|
      (|RElt| |Struct-runtime-24| |domain| 3 |P0-cat|))
    (go |Lab5|)
    |Lab0|
    (setq t12 (|RElt| |Struct-runtime-24| |hashFn| 1 |P0-cat|))
    (setq t11 (|CCall| t12))
    (when (|SIntNE| |P3-type| t11) (go |Lab1|))
    (|SetRElt| |Struct-runtime-30| |value| 0 |P4-box| |P1-pcent|)
    (block-return |C35-runtime-get0| |P4-box|)
    |Lab1|
    (block-return |C35-runtime-get0| nil)))

(defprog
  ((|C36-runtime-hash0| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq t0 (|RElt| |Struct-runtime-24| |hashFn| 1 |P0-cat|))
  (block-return |C36-runtime-hash0| (|CCall| t0)))

(defprog
  ((|C37-runtime-parentCount0| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|))
  (tagbody
    (setq t1 (|RElt| |Struct-runtime-24| |names| 6 |P0-cat|))
    (when (|PtrEQ| t1 nil) (go |Lab0|))
    |Lab1|
    (block-return
      |C37-runtime-parentCount0|
      (|RElt| |Struct-runtime-24| |nparents| 5 |P0-cat|))
    |Lab0|
    (setq t0 (|RElt| |Struct-runtime-24| |buildFn| 0 |P0-cat|))
    (|CCall|
      t0
      |P0-cat|
      (|RElt| |Struct-runtime-24| |domain| 3 |P0-cat|))
    (go |Lab1|)))

(defprog
  ((|C38-runtime-parentGet| |Word|)
    ((|P0-cat| |Word|) (|P1-i| |Word|) (|e1| |Env|)))
  ((t0 |SInt|) (t1 |Word|) (t2 |Clos|) (t3 |Word|))
  (tagbody
    (setq t3 (|RElt| |Struct-runtime-24| |names| 6 |P0-cat|))
    (when (|PtrEQ| t3 nil) (go |Lab0|))
    |Lab1|
    (setq t1 (|RElt| |Struct-runtime-24| |parents| 4 |P0-cat|))
    (setq t0 (|SIntPrev| |P1-i|))
    (block-return
      |C38-runtime-parentGet|
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t1) t0))
    |Lab0|
    (setq t2 (|RElt| |Struct-runtime-24| |buildFn| 0 |P0-cat|))
    (|CCall|
      t2
      |P0-cat|
      (|RElt| |Struct-runtime-24| |domain| 3 |P0-cat|))
    (go |Lab1|)))

(defprog
  ((|C39-runtime-nameDummy| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 0))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 (|MakeLit| "Dunno"))
  (block-return |C39-runtime-nameDummy| t0))

(defprog
  ((|C40-runtime-buildDummy| |Word|)
    ((|P0-cat| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "build on incomplete category"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C41-runtime-getDummy| |Word|)
    ((|P0-cat| |Word|)
      (|P1-pcent| |Word|)
      (|P2-name| |Word|)
      (|P3-type| |Word|)
      (|P4-box| |Word|)
      (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "get on incomplete category"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C42-runtime-hashDummy| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "hash on incomplete category"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C43-runtime-parentGetDummy| |Word|)
    ((|P0-cat| |Word|) (|P1-i| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "parent get on incomplete category"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C44-runtime-parentCountDummy| |Word|)
    ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Arr|))
  (setq t0 (|MakeLit| "parent count on incomplete category"))
  (|fiRaiseException| t0)
  (|Halt| (the |SInt| 102)))

(defprog
  ((|C45-runtime-name0| |Word|) ((|P0-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-28|
        |namer|
        1
        (|RElt| |Struct-runtime-22| |cdv| 0 t1)))
    (block-return
      |C45-runtime-name0|
      (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 t1)))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C46-runtime-build0| |Word|)
    ((|P0-c| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-28|
        |builder|
        5
        (|RElt| |Struct-runtime-22| |cdv| 0 t1)))
    (block-return
      |C46-runtime-build0|
      (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 t1) |P1-dom|))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C47-runtime-get0| |Word|)
    ((|P0-c| |Word|)
      (|P1-pc| |Word|)
      (|P2-n1| |Word|)
      (|P3-n2| |Word|)
      (|P4-box| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |SInt|)
    (t3 |Word|)
    (t4 |Clos|)
    (t5 |Word|)
    (t6 |Word|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Word|)
    (t10 |Word|)
    (t11 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab8|))
    |Lab9|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab11|))
    (|Halt| (the |SInt| 103))
    |Lab11|
    (setq t9 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq t6 (|RElt| |Struct-runtime-22| |cdv| 0 t9))
    (setq t4 (|RElt| |Struct-runtime-28| |getter| 3 t6))
    (setq
      t3
      (|CCall|
        t4
        (|RElt| |Struct-runtime-22| |catRep| 1 t9)
        |P1-pc|
        |P2-n1|
        |P3-n2|
        |P4-box|))
    (when (|PtrIsNil| t3) (go |Lab14|))
    (setq t5 t3)
    |Lab1|
    (setq t10 t5)
    |Lab7|
    (block-return |C47-runtime-get0| t10)
    |Lab14|
    (setq t2 (the |SInt| 1))
    (setq
      t7
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t9)))
    (setq t1 (|CCall| t7 (|RElt| |Struct-runtime-22| |catRep| 1 t9)))
    |Lab2|
    (when (|SIntLT| t1 t2) (go |Lab3|))
    (setq
      t8
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t9)))
    (setq t0 (|CCall| t8 (|RElt| |Struct-runtime-22| |catRep| 1 t9) t2))
    (when (|PtrIsNil| t0) (go |Lab5|))
    (setq
      t3
      (|C32-runtime-getDefault!| t0 |P1-pc| |P2-n1| |P3-n2| |P4-box| |e1|))
    (when (|PtrIsNil| t3) (go |Lab5|))
    (setq t10 t3)
    (go |Lab7|)
    |Lab5|
    (setq t2 (|SIntNext| t2))
    (go |Lab2|)
    |Lab3|
    (setq t5 nil)
    (go |Lab1|)
    |Lab8|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab10|))
    (|Halt| (the |SInt| 103))
    |Lab10|
    (setq t11 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t11))
    (go |Lab9|)))

(defprog
  ((|C48-runtime-hash0| |Word|) ((|P0-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-28|
        |hasher|
        4
        (|RElt| |Struct-runtime-22| |cdv| 0 t1)))
    (block-return
      |C48-runtime-hash0|
      (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 t1)))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C49-runtime-parentCount0| |Word|) ((|P0-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-28|
        |parentCounter|
        6
        (|RElt| |Struct-runtime-22| |cdv| 0 t1)))
    (block-return
      |C49-runtime-parentCount0|
      (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 t1)))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C50-runtime-parentGet| |Word|)
    ((|P0-c| |Word|) (|P1-n| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Clos|))
  (tagbody
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab0|))
    |Lab1|
    (when
      (|SIntEQ|
        (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq t1 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (setq
      t0
      (|RElt|
        |Struct-runtime-28|
        |parentGetter|
        7
        (|RElt| |Struct-runtime-22| |cdv| 0 t1)))
    (block-return
      |C50-runtime-parentGet|
      (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 t1) |P1-n|))
    |Lab0|
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-18| |tag| 0 |P0-c|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-18| |value| 1 |P0-c|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 |P0-c| (the |SInt| 1))
    (|SetRElt| |Struct-runtime-18| |value| 1 |P0-c| (|CCall| t2))
    (go |Lab1|)))

(defprog
  ((|C51-runtime-force| |Word|) ((|P0-lv| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Arr|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Word|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Arr|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Clos|)
    (t34 |Clos|)
    (t35 |Word|)
    (t36 |Bool|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Clos|)
    (t41 |Clos|)
    (t42 |Arr|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Clos|)
    (t51 |Clos|)
    (t52 |Word|)
    (t53 |Word|)
    (t54 |Clos|)
    (t55 |Clos|)
    (t56 |Clos|)
    (t57 |Arr|)
    (t58 |Word|)
    (t59 |Word|)
    (t60 |Word|)
    (t61 |Clos|)
    (t62 |Word|)
    (t63 |Env|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Clos|)
    (t67 |Clos|)
    (t68 |Arr|)
    (t69 |Env|)
    (t70 |Word|)
    (t71 |Bool|)
    (t72 |Clos|)
    (t73 |Clos|)
    (t74 |Clos|)
    (t75 |Arr|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Clos|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Clos|)
    (t90 |Arr|)
    (t91 |Word|)
    (t92 |Word|)
    (t93 |Word|)
    (t94 |Word|)
    (t95 |Clos|)
    (t96 |Word|)
    (t97 |Bool|)
    (t98 |Clos|)
    (t99 |Clos|)
    (t100 |Clos|)
    (t101 |Arr|)
    (t102 |Clos|)
    (t103 |Clos|)
    (t104 |Clos|)
    (t105 |Clos|)
    (t106 |Clos|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Clos|)
    (t110 |Clos|)
    (t111 |Word|)
    (t112 |Word|)
    (t113 |Clos|)
    (t114 |Clos|)
    (t115 |Clos|)
    (t116 |Arr|)
    (t117 |Word|)
    (t118 |Word|)
    (t119 |Word|)
    (t120 |Word|)
    (t121 |Word|)
    (t122 |Word|)
    (t123 |Word|)
    (t124 |Bool|)
    (t125 |Clos|)
    (t126 |Clos|)
    (t127 |Clos|)
    (t128 |Arr|)
    (t129 |Clos|)
    (t130 |Clos|)
    (t131 |Clos|)
    (t132 |Clos|)
    (t133 |Clos|)
    (t134 |Clos|)
    (t135 |Clos|)
    (t136 |Clos|)
    (t137 |Clos|)
    (t138 |Word|)
    (t139 |Word|)
    (t140 |Clos|)
    (t141 |Clos|)
    (t142 |Clos|)
    (t143 |Arr|)
    (t144 |Word|)
    (t145 |Word|)
    (t146 |Word|)
    (|T147-l| |Word|)
    (t148 |Word|)
    (|T149-l| |Word|)
    (|T150-l| |Word|)
    (|T151-l| |Word|)
    (|T152-l| |Word|)
    (|T153-l| |Word|)
    (t154 |Bool|)
    (t155 |Bool|)
    (t156 |Bool|)
    (t157 |Bool|)
    (t158 |Bool|)
    (t159 |Bool|)
    (t160 |Bool|)
    (t161 |Bool|)
    (t162 |Bool|)
    (t163 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|RElt| |Struct-runtime-32| |got| 0 |P0-lv|) (go |Lab0|))
    (setq t120 (|RElt| |Struct-runtime-32| |dom| 1 |P0-lv|))
    (setq t121 (|RElt| |Struct-runtime-32| |name| 2 |P0-lv|))
    (setq t122 (|RElt| |Struct-runtime-32| |type| 3 |P0-lv|))
    (setq
      t95
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (setq
      t94
      (|CCall|
        t95
        (|RElt| |Struct-runtime-11| |domainRep| 1 t120)
        t120
        t121
        t122
        (|Lex| |Struct-runtime-51-box-61| 61 |l1|)
        (the |Bool| nil)))
    (when (|PtrIsNil| t94) (go |Lab41|))
    (setq t0 (|RElt| |Struct-runtime-30| |value| 0 t94))
    (|SetRElt| |Struct-runtime-32| |value| 4 |P0-lv| t0)
    (|SetRElt| |Struct-runtime-32| |got| 0 |P0-lv| (the |Bool| t))
    (|SetRElt| |Struct-runtime-32| |dom| 1 |P0-lv| nil)
    |Lab0|
    (block-return
      |C51-runtime-force|
      (|RElt| |Struct-runtime-32| |value| 4 |P0-lv|))
    |Lab41|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t69
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t67 (|Clos| t69 |C6-runtime-PRINT|))
    (setq t68 (|MakeLit| "Looking in "))
    (multiple-value-setq (t64 t65 t66) (|CCall| t67))
    (|CCall| t65 t68 (the |SInt| 1) (the |SInt| 0))
    (setq t21 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq |T147-l| t21)
    (setq t22 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq |T149-l| t22)
    (setq t156 (|PtrIsNil| t21))
    (when t156 (go |Lab1|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t21))
    (setq t148 t26)
    |Lab7|
    (setq t159 (|PtrIsNil| |T149-l|))
    (when t159 (go |Lab1|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 |T149-l|))
    (when (|SIntEQ| t148 t121) (go |Lab2|))
    (when (|PtrIsNil| |T147-l|) (go |Lab8|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T147-l|))
    |Lab9|
    (setq |T147-l| t25)
    (setq t156 (|PtrIsNil| t25))
    (when t156 (go |Lab1|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t25))
    (setq t148 t26)
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T149-l|))
    (setq |T149-l| t23)
    (go |Lab7|)
    |Lab1|
    (setq t20 (|MakeLit| "??:             "))
    (setq t16 (the |SInt| 1))
    |Lab3|
    (setq t18 (|SIntPrev| t16))
    (when
      (|CharEQ| (|AElt| t20 t18) (the |Char| |CharCode0|))
      (go |Lab4|))
    (setq t16 (|SIntNext| t16))
    (go |Lab3|)
    |Lab4|
    (setq t15 (|ANew| |Char| (|SIntNext| t18)))
    (|SetAElt| t15 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t15 t18 (the |Char| |CharCode0|))
    (setq t17 (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| t17 t18) (go |Lab6|))
    (setq t14 (|FormatSInt| t121 t15 (the |SInt| 2)))
    (setq t13 (|SIntNext| (|SIntNext| t14)))
    (|SetAElt| t15 (|SIntPrev| t13) (the |Char| |CharCode0|))
    (setq t27 t15)
    |Lab10|
    (setq
      t34
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t63
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t61 (|Clos| t63 |C6-runtime-PRINT|))
    (setq
      t62
      (|CCall| t34 (|RElt| |Struct-runtime-11| |domainRep| 1 t120)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t62))
      (go |Lab11|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 3))
      (go |Lab13|))
    (setq
      t36
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 2)))
    (setq t35 (|RElt| |Struct-runtime-54| |p| 1 t62))
    (when t36 (go |Lab15|))
    (setq t154 (|PtrIsNil| t35))
    (when t154 (go |Lab16|))
    (setq t52 (|RElt| |Struct-runtime-56| |first| 0 t35))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t52))
      (go |Lab20|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 3))
      (go |Lab21|))
    (setq
      t71
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 2)))
    (setq t70 (|RElt| |Struct-runtime-54| |p| 1 t52))
    (when t71 (go |Lab22|))
    (setq t155 (|PtrIsNil| t70))
    (when t155 (go |Lab23|))
    (setq t85 (|RElt| |Struct-runtime-56| |first| 0 t70))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t85))
      (go |Lab34|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t85) (the |SInt| 3))
      (go |Lab35|))
    (setq
      t124
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t85) (the |SInt| 2)))
    (setq t123 (|RElt| |Struct-runtime-54| |p| 1 t85))
    (when t124 (go |Lab36|))
    (setq t158 (|PtrIsNil| t123))
    (when t158 (go |Lab37|))
    (setq t138 (|RElt| |Struct-runtime-56| |first| 0 t123))
    (|C8-runtime-printDomain| t61 t138 |e1|)
    (setq t139 (|RElt| |Struct-runtime-56| |rest| 1 t123))
    (setq t123 t139)
    |Lab36|
    (multiple-value-setq (t132 t133 t134) (|CCall| t61))
    (|CCall| t133 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T153-l| t123)
    |Lab38|
    (setq t160 (|PtrIsNil| |T153-l|))
    (when t160 (go |Lab39|))
    (setq t146 (|RElt| |Struct-runtime-56| |rest| 1 |T153-l|))
    (setq t144 (|RElt| |Struct-runtime-56| |first| 0 |T153-l|))
    (|C8-runtime-printDomain| t61 t144 |e1|)
    (setq t145 (|RElt| |Struct-runtime-56| |rest| 1 |T153-l|))
    (when (|PtrIsNil| t145) (go |Lab40|))
    (setq t128 (|MakeLit| ", "))
    (multiple-value-setq (t125 t126 t127) (|CCall| t61))
    (|CCall| t126 t128 (the |SInt| 1) (the |SInt| 0))
    |Lab40|
    (setq |T153-l| t146)
    (go |Lab38|)
    |Lab39|
    (setq t143 (|MakeLit| ")"))
    (multiple-value-setq (t140 t141 t142) (|CCall| t61))
    (|CCall| t141 t143 (the |SInt| 1) (the |SInt| 0))
    |Lab44|
    (setq t86 (|RElt| |Struct-runtime-56| |rest| 1 t70))
    (setq t70 t86)
    |Lab22|
    (multiple-value-setq (t79 t80 t81) (|CCall| t61))
    (|CCall| t80 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T151-l| t70)
    |Lab24|
    (setq t161 (|PtrIsNil| |T151-l|))
    (when t161 (go |Lab25|))
    (setq t93 (|RElt| |Struct-runtime-56| |rest| 1 |T151-l|))
    (setq t91 (|RElt| |Struct-runtime-56| |first| 0 |T151-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t91))
      (go |Lab27|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 3))
      (go |Lab28|))
    (setq
      t97
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 2)))
    (setq t96 (|RElt| |Struct-runtime-54| |p| 1 t91))
    (when t97 (go |Lab29|))
    (setq t157 (|PtrIsNil| t96))
    (when t157 (go |Lab30|))
    (setq t111 (|RElt| |Struct-runtime-56| |first| 0 t96))
    (|C8-runtime-printDomain| t61 t111 |e1|)
    (setq t112 (|RElt| |Struct-runtime-56| |rest| 1 t96))
    (setq t96 t112)
    |Lab29|
    (multiple-value-setq (t105 t106 t107) (|CCall| t61))
    (|CCall| t106 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T152-l| t96)
    |Lab31|
    (setq t162 (|PtrIsNil| |T152-l|))
    (when t162 (go |Lab32|))
    (setq t119 (|RElt| |Struct-runtime-56| |rest| 1 |T152-l|))
    (setq t117 (|RElt| |Struct-runtime-56| |first| 0 |T152-l|))
    (|C8-runtime-printDomain| t61 t117 |e1|)
    (setq t118 (|RElt| |Struct-runtime-56| |rest| 1 |T152-l|))
    (when (|PtrIsNil| t118) (go |Lab33|))
    (setq t101 (|MakeLit| ", "))
    (multiple-value-setq (t98 t99 t100) (|CCall| t61))
    (|CCall| t99 t101 (the |SInt| 1) (the |SInt| 0))
    |Lab33|
    (setq |T152-l| t119)
    (go |Lab31|)
    |Lab32|
    (setq t116 (|MakeLit| ")"))
    (multiple-value-setq (t113 t114 t115) (|CCall| t61))
    (|CCall| t114 t116 (the |SInt| 1) (the |SInt| 0))
    |Lab42|
    (setq t92 (|RElt| |Struct-runtime-56| |rest| 1 |T151-l|))
    (when (|PtrIsNil| t92) (go |Lab26|))
    (setq t75 (|MakeLit| ", "))
    (multiple-value-setq (t72 t73 t74) (|CCall| t61))
    (|CCall| t73 t75 (the |SInt| 1) (the |SInt| 0))
    |Lab26|
    (setq |T151-l| t93)
    (go |Lab24|)
    |Lab30|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab28|
    (multiple-value-setq (t102 t103 t104) (|CCall| t61))
    (|CCall| t103 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab42|)
    |Lab27|
    (multiple-value-setq (t108 t109 t110) (|CCall| t61))
    (|CCall|
      t109
      (|RElt| |Struct-runtime-54| |p| 1 t91)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab42|)
    |Lab25|
    (setq t90 (|MakeLit| ")"))
    (multiple-value-setq (t87 t88 t89) (|CCall| t61))
    (|CCall| t88 t90 (the |SInt| 1) (the |SInt| 0))
    |Lab43|
    (setq t53 (|RElt| |Struct-runtime-56| |rest| 1 t35))
    (setq t35 t53)
    |Lab15|
    (multiple-value-setq (t46 t47 t48) (|CCall| t61))
    (|CCall| t47 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T150-l| t35)
    |Lab17|
    (setq t163 (|PtrIsNil| |T150-l|))
    (when t163 (go |Lab18|))
    (setq t60 (|RElt| |Struct-runtime-56| |rest| 1 |T150-l|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 |T150-l|))
    (|C8-runtime-printDomain| t61 t58 |e1|)
    (setq t59 (|RElt| |Struct-runtime-56| |rest| 1 |T150-l|))
    (when (|PtrIsNil| t59) (go |Lab19|))
    (setq t42 (|MakeLit| ", "))
    (multiple-value-setq (t39 t40 t41) (|CCall| t61))
    (|CCall| t40 t42 (the |SInt| 1) (the |SInt| 0))
    |Lab19|
    (setq |T150-l| t60)
    (go |Lab17|)
    |Lab18|
    (setq t57 (|MakeLit| ")"))
    (multiple-value-setq (t54 t55 t56) (|CCall| t61))
    (|CCall| t55 t57 (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    |Lab14|
    (setq t37 t38)
    |Lab12|
    (multiple-value-setq (t31 t32 t33) (|CCall| t37))
    (|CCall| t32 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t28 t29 t30) (|CCall| t37))
    (|CCall| t29 t27 (the |SInt| 1) (the |SInt| 0))
    (setq t8 (|MakeLit| " with code "))
    (multiple-value-setq (t5 t6 t7) (|CCall| t37))
    (|CCall| t6 t8 (the |SInt| 1) (the |SInt| 0))
    (setq t12 (|formatSInt| t122))
    (multiple-value-setq (t9 t10 t11) (|CCall| t37))
    (|CCall| t10 t12 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t2 t3 t4) (|CCall| t37))
    (|CCall| t2 (the |Char| #\Newline))
    (setq t1 (|MakeLit| "Export not found"))
    (|fiRaiseException| t1)
    (|Halt| (the |SInt| 102))
    |Lab37|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab35|
    (multiple-value-setq (t129 t130 t131) (|CCall| t61))
    (|CCall| t130 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab44|)
    |Lab34|
    (multiple-value-setq (t135 t136 t137) (|CCall| t61))
    (|CCall|
      t136
      (|RElt| |Struct-runtime-54| |p| 1 t85)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab44|)
    |Lab23|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab21|
    (multiple-value-setq (t76 t77 t78) (|CCall| t61))
    (|CCall| t77 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab43|)
    |Lab20|
    (multiple-value-setq (t82 t83 t84) (|CCall| t61))
    (|CCall|
      t83
      (|RElt| |Struct-runtime-54| |p| 1 t52)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab43|)
    |Lab16|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab13|
    (multiple-value-setq (t43 t44 t45) (|CCall| t61))
    (|CCall| t44 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    (go |Lab14|)
    |Lab11|
    (multiple-value-setq (t49 t50 t51) (|CCall| t61))
    (|CCall|
      t50
      (|RElt| |Struct-runtime-54| |p| 1 t62)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t37 t61)
    (go |Lab12|)
    |Lab6|
    (setq t19 (|SIntPrev| t17))
    (|SetAElt| t15 t19 (|AElt| t20 t19))
    (setq t17 (|SIntNext| t17))
    (go |Lab5|)
    |Lab8|
    (setq t25 |T147-l|)
    (go |Lab9|)
    |Lab2|
    (setq t27 t24)
    (go |Lab10|)))

(defprog
  ((|C52-runtime-table| |Word|) ((|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Record|)
    (t2 |Arr|)
    (t3 |SInt|)
    (t4 |SInt|)
    (t5 |Word|)
    (t6 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-36|))
    (|SetRElt| |Struct-runtime-36| |count| 0 t0 (the |SInt| 0))
    (setq t6 (|Lex| |Struct-runtime-51-primes-108| 108 |l1|))
    (setq
      t5
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t6) (the |SInt| 2)))
    (setq t1 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t1 t5)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t1 t5)
    (setq t2 (|ANew| |Word| t5))
    (setq t4 (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| t4 t5) (go |Lab1|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t1 t2)
    (|SetRElt| |Struct-runtime-36| |buckv| 1 t0 t1)
    (block-return |C52-runtime-table| t0)
    |Lab1|
    (setq t3 (|SIntPrev| t4))
    (|SetAElt| t2 t3 nil)
    (setq t4 (|SIntNext| t4))
    (go |Lab0|)))

(defprog
  ((|C53-runtime-domainMake| |Word|) ((|P0-df| |Clos|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Record|)
    (t9 |Record|)
    (t10 |Record|)
    (t11 |Arr|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |Record|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t18 (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (|SetLex| |Struct-runtime-51-serialThis-78| 78 |l1| (|SIntNext| t18))
    (setq t8 (|RNew| |Struct-runtime-13|))
    (|SetRElt| |Struct-runtime-13| |f1| 0 t8 |P0-df|)
    (|SetRElt| |Struct-runtime-13| |f2| 1 t8 nil)
    (|SetRElt| |Struct-runtime-13| |hashcode| 2 t8 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-13| |parents| 3 t8 nil)
    (|SetRElt| |Struct-runtime-13| |extendees| 4 t8 nil)
    (|SetRElt| |Struct-runtime-13| |defaults| 5 t8 nil)
    (|SetRElt| |Struct-runtime-13| |names| 6 t8 nil)
    (|SetRElt| |Struct-runtime-13| |types| 7 t8 nil)
    (|SetRElt| |Struct-runtime-13| |exports| 8 t8 nil)
    (|SetRElt| |Struct-runtime-13| |ngets| 9 t8 (the |SInt| 0))
    (|SetRElt|
      |Struct-runtime-13|
      |serial|
      10
      t8
      (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (setq t9 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t9 (the |SInt| 0))
    (setq t10 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t10 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t10 (the |SInt| 15))
    (setq t11 (|ANew| |Word| (the |SInt| 15)))
    (setq t13 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t13 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t10 t11)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t9 t10)
    (setq t14 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t14 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t14 (the |SInt| 15))
    (setq t15 (|ANew| |Word| (the |SInt| 15)))
    (setq t17 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t17 (the |SInt| 15)) (go |Lab5|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t14 t15)
    (|SetRElt| |Struct-runtime-34| |values| 2 t9 t14)
    (|SetRElt| |Struct-runtime-34| |size| 3 t9 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 t8 t9)
    (|SetRElt|
      |Struct-runtime-13|
      |nameFn|
      12
      t8
      (|Lex| |Struct-runtime-51-domainStdName-77| 77 |l1|))
    (setq t0 (|RNew| |Struct-runtime-11|))
    (setq t2 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t0 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t0 t8)
    (block-return |C53-runtime-domainMake| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-name-74| 74 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-get-76| 76 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hash-75| 75 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritTo-73| 73 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-adv-64| 64 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    (go |Lab1|)
    |Lab5|
    (setq t16 (|SIntPrev| t17))
    (|SetAElt| t15 t16 nil)
    (setq t17 (|SIntNext| t17))
    (go |Lab4|)
    |Lab3|
    (setq t12 (|SIntPrev| t13))
    (|SetAElt| t11 t12 nil)
    (setq t13 (|SIntNext| t13))
    (go |Lab2|)))

(defprog
  ((|C54-runtime-domainMakeDispatch| |Word|)
    ((|P0-dr| |Word|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-11|))
    (setq t2 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t0 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t0 |P0-dr|)
    (block-return |C54-runtime-domainMakeDispatch| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-name-74| 74 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-get-76| 76 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hash-75| 75 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritTo-73| 73 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-adv-64| 64 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-adv-64| 64 |l1|))
    (go |Lab1|)))

(defprog
  ((|C55-runtime-extendMakeDispatch| |Word|)
    ((|P0-dr| |Word|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-11|))
    (setq t2 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t0 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t0 |P0-dr|)
    (block-return |C55-runtime-extendMakeDispatch| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-nameExtend-70| 70 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-getExtend-72| 72 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hashExtend-71| 71 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritToExtend-69| 69 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-edv-63| 63 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    (go |Lab1|)))

(defprog
  ((|C56-runtime-domainAddExports!|)
    ((|P0-d| |Word|)
      (|P1-names| |Word|)
      (|P2-types| |Word|)
      (|P3-exports| |Word|)
      (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-runtime-13| |names| 6 |P0-d| |P1-names|)
  (|SetRElt| |Struct-runtime-13| |types| 7 |P0-d| |P2-types|)
  (|SetRElt| |Struct-runtime-13| |exports| 8 |P0-d| |P3-exports|)
  (block-return |C56-runtime-domainAddExports!| ()))

(defprog
  ((|C57-runtime-domainAddDefaults!|)
    ((|P0-d| |Word|) (|P1-defaults| |Word|) (|P2-d2| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq
    t0
    (|RElt|
      |Struct-runtime-28|
      |builder|
      5
      (|RElt| |Struct-runtime-22| |cdv| 0 |P1-defaults|)))
  (|SetRElt|
    |Struct-runtime-13|
    |defaults|
    5
    |P0-d|
    (|CCall|
      t0
      (|RElt| |Struct-runtime-22| |catRep| 1 |P1-defaults|)
      |P2-d2|))
  (block-return |C57-runtime-domainAddDefaults!| ()))

(defprog
  ((|C58-runtime-domainAddParents!|)
    ((|P0-d| |Word|)
      (|P1-parents| |Word|)
      (|P2-dAsDom| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Clos|)
    (t3 |Word|)
    (t4 |Word|)
    (|T5-a| |SInt|)
    (t6 |SInt|))
  (tagbody
    (setq t4 (|RElt| |Struct-runtime-52| |nvalues| 1 |P1-parents|))
    (setq |T5-a| (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| |T5-a| t4) (go |Lab1|))
    (|SetRElt| |Struct-runtime-13| |parents| 3 |P0-d| |P1-parents|)
    (block-return |C58-runtime-domainAddParents!| ())
    |Lab1|
    (setq t6 (|SIntPrev| |T5-a|))
    (setq
      t3
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |P1-parents|) t6))
    (setq
      t2
      (|RElt|
        |Struct-runtime-20|
        |inheriter|
        5
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t3)))
    (setq
      t1
      (|CCall|
        t2
        (|RElt| |Struct-runtime-11| |domainRep| 1 t3)
        |P2-dAsDom|))
    (setq t0 (|RElt| |Struct-runtime-52| |values| 2 |P1-parents|))
    (|SetAElt| t0 t6 t1)
    (setq |T5-a| (|SIntNext| |T5-a|))
    (go |Lab0|)))

(defprog
  ((|C59-runtime-domainAddHash!|)
    ((|P0-d| |Word|) (|P1-hash| |Word|) (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-runtime-13| |hashcode| 2 |P0-d| |P1-hash|)
  (block-return |C59-runtime-domainAddHash!| ()))

(defprog
  ((|C60-runtime-domainAddNameFn!|)
    ((|P0-d| |Word|) (|P1-namefn| |Clos|) (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-runtime-13| |nameFn| 12 |P0-d| |P1-namefn|)
  (block-return |C60-runtime-domainAddNameFn!| ()))

(defprog
  ((|C61-runtime-domainGetExport!| |Word|)
    ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Arr|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Word|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Arr|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Clos|)
    (t34 |Clos|)
    (t35 |Word|)
    (t36 |Bool|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Clos|)
    (t41 |Clos|)
    (t42 |Arr|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Clos|)
    (t51 |Clos|)
    (t52 |Word|)
    (t53 |Word|)
    (t54 |Clos|)
    (t55 |Clos|)
    (t56 |Clos|)
    (t57 |Arr|)
    (t58 |Word|)
    (t59 |Word|)
    (t60 |Word|)
    (t61 |Clos|)
    (t62 |Word|)
    (t63 |Env|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Clos|)
    (t67 |Clos|)
    (t68 |Arr|)
    (t69 |Env|)
    (t70 |Word|)
    (t71 |Bool|)
    (t72 |Clos|)
    (t73 |Clos|)
    (t74 |Clos|)
    (t75 |Arr|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Clos|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Clos|)
    (t90 |Arr|)
    (t91 |Word|)
    (t92 |Word|)
    (t93 |Word|)
    (t94 |Word|)
    (t95 |Clos|)
    (t96 |Word|)
    (t97 |Bool|)
    (t98 |Clos|)
    (t99 |Clos|)
    (t100 |Clos|)
    (t101 |Arr|)
    (t102 |Clos|)
    (t103 |Clos|)
    (t104 |Clos|)
    (t105 |Clos|)
    (t106 |Clos|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Clos|)
    (t110 |Clos|)
    (t111 |Word|)
    (t112 |Word|)
    (t113 |Clos|)
    (t114 |Clos|)
    (t115 |Clos|)
    (t116 |Arr|)
    (t117 |Word|)
    (t118 |Word|)
    (t119 |Word|)
    (|T120-l| |Word|)
    (t121 |Word|)
    (|T122-l| |Word|)
    (|T123-l| |Word|)
    (|T124-l| |Word|)
    (|T125-l| |Word|)
    (t126 |Bool|)
    (t127 |Bool|)
    (t128 |Bool|)
    (t129 |Bool|)
    (t130 |Bool|)
    (t131 |Bool|)
    (t132 |Bool|)
    (t133 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq
      t95
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
    (setq
      t94
      (|CCall|
        t95
        (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)
        |P0-td|
        |P1-name|
        |P2-type|
        (|Lex| |Struct-runtime-51-box-61| 61 |l1|)
        (the |Bool| nil)))
    (when (|PtrIsNil| t94) (go |Lab33|))
    (setq t0 (|RElt| |Struct-runtime-30| |value| 0 t94))
    (block-return |C61-runtime-domainGetExport!| t0)
    |Lab33|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t69
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t67 (|Clos| t69 |C6-runtime-PRINT|))
    (setq t68 (|MakeLit| "Looking in "))
    (multiple-value-setq (t64 t65 t66) (|CCall| t67))
    (|CCall| t65 t68 (the |SInt| 1) (the |SInt| 0))
    (setq t21 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq |T120-l| t21)
    (setq t22 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq |T122-l| t22)
    (setq t127 (|PtrIsNil| t21))
    (when t127 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t21))
    (setq t121 t26)
    |Lab6|
    (setq t130 (|PtrIsNil| |T122-l|))
    (when t130 (go |Lab0|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 |T122-l|))
    (when (|SIntEQ| t121 |P1-name|) (go |Lab1|))
    (when (|PtrIsNil| |T120-l|) (go |Lab7|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T120-l|))
    |Lab8|
    (setq |T120-l| t25)
    (setq t127 (|PtrIsNil| t25))
    (when t127 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t25))
    (setq t121 t26)
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T122-l|))
    (setq |T122-l| t23)
    (go |Lab6|)
    |Lab0|
    (setq t20 (|MakeLit| "??:             "))
    (setq t16 (the |SInt| 1))
    |Lab2|
    (setq t18 (|SIntPrev| t16))
    (when
      (|CharEQ| (|AElt| t20 t18) (the |Char| |CharCode0|))
      (go |Lab3|))
    (setq t16 (|SIntNext| t16))
    (go |Lab2|)
    |Lab3|
    (setq t15 (|ANew| |Char| (|SIntNext| t18)))
    (|SetAElt| t15 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t15 t18 (the |Char| |CharCode0|))
    (setq t17 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t17 t18) (go |Lab5|))
    (setq t14 (|FormatSInt| |P1-name| t15 (the |SInt| 2)))
    (setq t13 (|SIntNext| (|SIntNext| t14)))
    (|SetAElt| t15 (|SIntPrev| t13) (the |Char| |CharCode0|))
    (setq t27 t15)
    |Lab9|
    (setq
      t34
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t63
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t61 (|Clos| t63 |C6-runtime-PRINT|))
    (setq
      t62
      (|CCall| t34 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t62))
      (go |Lab10|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 3))
      (go |Lab12|))
    (setq
      t36
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 2)))
    (setq t35 (|RElt| |Struct-runtime-54| |p| 1 t62))
    (when t36 (go |Lab14|))
    (setq t126 (|PtrIsNil| t35))
    (when t126 (go |Lab15|))
    (setq t52 (|RElt| |Struct-runtime-56| |first| 0 t35))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t52))
      (go |Lab19|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 3))
      (go |Lab20|))
    (setq
      t71
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 2)))
    (setq t70 (|RElt| |Struct-runtime-54| |p| 1 t52))
    (when t71 (go |Lab21|))
    (setq t129 (|PtrIsNil| t70))
    (when t129 (go |Lab22|))
    (setq t85 (|RElt| |Struct-runtime-56| |first| 0 t70))
    (|C8-runtime-printDomain| t61 t85 |e1|)
    (setq t86 (|RElt| |Struct-runtime-56| |rest| 1 t70))
    (setq t70 t86)
    |Lab21|
    (multiple-value-setq (t79 t80 t81) (|CCall| t61))
    (|CCall| t80 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T124-l| t70)
    |Lab23|
    (setq t131 (|PtrIsNil| |T124-l|))
    (when t131 (go |Lab24|))
    (setq t93 (|RElt| |Struct-runtime-56| |rest| 1 |T124-l|))
    (setq t91 (|RElt| |Struct-runtime-56| |first| 0 |T124-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t91))
      (go |Lab26|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 3))
      (go |Lab27|))
    (setq
      t97
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 2)))
    (setq t96 (|RElt| |Struct-runtime-54| |p| 1 t91))
    (when t97 (go |Lab28|))
    (setq t128 (|PtrIsNil| t96))
    (when t128 (go |Lab29|))
    (setq t111 (|RElt| |Struct-runtime-56| |first| 0 t96))
    (|C8-runtime-printDomain| t61 t111 |e1|)
    (setq t112 (|RElt| |Struct-runtime-56| |rest| 1 t96))
    (setq t96 t112)
    |Lab28|
    (multiple-value-setq (t105 t106 t107) (|CCall| t61))
    (|CCall| t106 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T125-l| t96)
    |Lab30|
    (setq t132 (|PtrIsNil| |T125-l|))
    (when t132 (go |Lab31|))
    (setq t119 (|RElt| |Struct-runtime-56| |rest| 1 |T125-l|))
    (setq t117 (|RElt| |Struct-runtime-56| |first| 0 |T125-l|))
    (|C8-runtime-printDomain| t61 t117 |e1|)
    (setq t118 (|RElt| |Struct-runtime-56| |rest| 1 |T125-l|))
    (when (|PtrIsNil| t118) (go |Lab32|))
    (setq t101 (|MakeLit| ", "))
    (multiple-value-setq (t98 t99 t100) (|CCall| t61))
    (|CCall| t99 t101 (the |SInt| 1) (the |SInt| 0))
    |Lab32|
    (setq |T125-l| t119)
    (go |Lab30|)
    |Lab31|
    (setq t116 (|MakeLit| ")"))
    (multiple-value-setq (t113 t114 t115) (|CCall| t61))
    (|CCall| t114 t116 (the |SInt| 1) (the |SInt| 0))
    |Lab34|
    (setq t92 (|RElt| |Struct-runtime-56| |rest| 1 |T124-l|))
    (when (|PtrIsNil| t92) (go |Lab25|))
    (setq t75 (|MakeLit| ", "))
    (multiple-value-setq (t72 t73 t74) (|CCall| t61))
    (|CCall| t73 t75 (the |SInt| 1) (the |SInt| 0))
    |Lab25|
    (setq |T124-l| t93)
    (go |Lab23|)
    |Lab29|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab27|
    (multiple-value-setq (t102 t103 t104) (|CCall| t61))
    (|CCall| t103 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab34|)
    |Lab26|
    (multiple-value-setq (t108 t109 t110) (|CCall| t61))
    (|CCall|
      t109
      (|RElt| |Struct-runtime-54| |p| 1 t91)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab34|)
    |Lab24|
    (setq t90 (|MakeLit| ")"))
    (multiple-value-setq (t87 t88 t89) (|CCall| t61))
    (|CCall| t88 t90 (the |SInt| 1) (the |SInt| 0))
    |Lab35|
    (setq t53 (|RElt| |Struct-runtime-56| |rest| 1 t35))
    (setq t35 t53)
    |Lab14|
    (multiple-value-setq (t46 t47 t48) (|CCall| t61))
    (|CCall| t47 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T123-l| t35)
    |Lab16|
    (setq t133 (|PtrIsNil| |T123-l|))
    (when t133 (go |Lab17|))
    (setq t60 (|RElt| |Struct-runtime-56| |rest| 1 |T123-l|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 |T123-l|))
    (|C8-runtime-printDomain| t61 t58 |e1|)
    (setq t59 (|RElt| |Struct-runtime-56| |rest| 1 |T123-l|))
    (when (|PtrIsNil| t59) (go |Lab18|))
    (setq t42 (|MakeLit| ", "))
    (multiple-value-setq (t39 t40 t41) (|CCall| t61))
    (|CCall| t40 t42 (the |SInt| 1) (the |SInt| 0))
    |Lab18|
    (setq |T123-l| t60)
    (go |Lab16|)
    |Lab17|
    (setq t57 (|MakeLit| ")"))
    (multiple-value-setq (t54 t55 t56) (|CCall| t61))
    (|CCall| t55 t57 (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    |Lab13|
    (setq t37 t38)
    |Lab11|
    (multiple-value-setq (t31 t32 t33) (|CCall| t37))
    (|CCall| t32 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t28 t29 t30) (|CCall| t37))
    (|CCall| t29 t27 (the |SInt| 1) (the |SInt| 0))
    (setq t8 (|MakeLit| " with code "))
    (multiple-value-setq (t5 t6 t7) (|CCall| t37))
    (|CCall| t6 t8 (the |SInt| 1) (the |SInt| 0))
    (setq t12 (|formatSInt| |P2-type|))
    (multiple-value-setq (t9 t10 t11) (|CCall| t37))
    (|CCall| t10 t12 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t2 t3 t4) (|CCall| t37))
    (|CCall| t2 (the |Char| #\Newline))
    (setq t1 (|MakeLit| "Export not found"))
    (|fiRaiseException| t1)
    (|Halt| (the |SInt| 102))
    |Lab22|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab20|
    (multiple-value-setq (t76 t77 t78) (|CCall| t61))
    (|CCall| t77 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab35|)
    |Lab19|
    (multiple-value-setq (t82 t83 t84) (|CCall| t61))
    (|CCall|
      t83
      (|RElt| |Struct-runtime-54| |p| 1 t52)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab35|)
    |Lab15|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab12|
    (multiple-value-setq (t43 t44 t45) (|CCall| t61))
    (|CCall| t44 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    (go |Lab13|)
    |Lab10|
    (multiple-value-setq (t49 t50 t51) (|CCall| t61))
    (|CCall|
      t50
      (|RElt| |Struct-runtime-54| |p| 1 t62)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t37 t61)
    (go |Lab11|)
    |Lab5|
    (setq t19 (|SIntPrev| t17))
    (|SetAElt| t15 t19 (|AElt| t20 t19))
    (setq t17 (|SIntNext| t17))
    (go |Lab4|)
    |Lab7|
    (setq t25 |T120-l|)
    (go |Lab8|)
    |Lab1|
    (setq t27 t24)
    (go |Lab9|)))

(defprog
  ((|C62-runtime-domainTestExport!| |Word|)
    ((|P0-td| |Word|) (|P1-name| |Word|) (|P2-type| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq
    t1
    (|RElt|
      |Struct-runtime-20|
      |getter|
      3
      (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
  (setq
    t0
    (|CCall|
      t1
      (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|)
      |P0-td|
      |P1-name|
      |P2-type|
      (|Lex| |Struct-runtime-51-box-61| 61 |l1|)
      (the |Bool| nil)))
  (block-return
    |C62-runtime-domainTestExport!|
    (|BoolNot| (|PtrIsNil| t0))))

(defprog
  ((|C63-runtime-domainHash!| |Word|) ((|P0-td| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq
    t0
    (|RElt|
      |Struct-runtime-20|
      |hasher|
      4
      (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
  (block-return
    |C63-runtime-domainHash!|
    (|CCall| t0 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|))))

(defprog
  ((|C64-runtime-domainName| |Word|) ((|P0-td| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq
    t0
    (|RElt|
      |Struct-runtime-20|
      |namer|
      1
      (|RElt| |Struct-runtime-11| |dispatcher| 0 |P0-td|)))
  (block-return
    |C64-runtime-domainName|
    (|CCall| t0 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|))))

(defprog
  ((|C65-runtime-domainMakeDummy| |Word|) ((|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-11|))
    (setq t2 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t0 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t0 nil)
    (block-return |C65-runtime-domainMakeDummy| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-nameDummy-68| 68 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-getDummy-67| 67 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hashDummy-66| 66 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritToDummy-65| 65 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-ddv-62| 62 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (go |Lab1|)))

(defprog
  ((|C66-runtime-domainFill!|)
    ((|P0-d| |Word|) (|P1-v| |Word|) (|e1| |Env|)))
  ()
  (|SetRElt|
    |Struct-runtime-11|
    |dispatcher|
    0
    |P0-d|
    (|RElt| |Struct-runtime-11| |dispatcher| 0 |P1-v|))
  (|SetRElt|
    |Struct-runtime-11|
    |domainRep|
    1
    |P0-d|
    (|RElt| |Struct-runtime-11| |domainRep| 1 |P1-v|))
  (block-return |C66-runtime-domainFill!| ()))

(defprog
  ((|C67-runtime-categoryMake| |Word|)
    ((|P0-fn| |Clos|) (|P1-hfn| |Clos|) (|P2-nameFn| |Clos|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Record|)
    (t11 |Record|)
    (t12 |Record|)
    (t13 |Arr|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |Record|)
    (t17 |Arr|)
    (t18 |SInt|)
    (t19 |SInt|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t10 (|RNew| |Struct-runtime-24|))
    (|SetRElt| |Struct-runtime-24| |buildFn| 0 t10 |P0-fn|)
    (|SetRElt| |Struct-runtime-24| |hashFn| 1 t10 |P1-hfn|)
    (setq t11 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t11 (the |SInt| 0))
    (setq t12 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t12 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t12 (the |SInt| 15))
    (setq t13 (|ANew| |Word| (the |SInt| 15)))
    (setq t15 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t15 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t12 t13)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t11 t12)
    (setq t16 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t16 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t16 (the |SInt| 15))
    (setq t17 (|ANew| |Word| (the |SInt| 15)))
    (setq t19 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t19 (the |SInt| 15)) (go |Lab5|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t16 t17)
    (|SetRElt| |Struct-runtime-34| |values| 2 t11 t16)
    (|SetRElt| |Struct-runtime-34| |size| 3 t11 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-24| |dc| 2 t10 t11)
    (|SetRElt| |Struct-runtime-24| |domain| 3 t10 nil)
    (|SetRElt| |Struct-runtime-24| |parents| 4 t10 nil)
    (|SetRElt| |Struct-runtime-24| |nparents| 5 t10 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-24| |names| 6 t10 nil)
    (|SetRElt| |Struct-runtime-24| |types| 7 t10 nil)
    (|SetRElt| |Struct-runtime-24| |exports| 8 t10 nil)
    (|SetRElt| |Struct-runtime-24| |nameFn| 9 t10 |P2-nameFn|)
    (setq t0 (|RNew| |Struct-runtime-22|))
    (setq t2 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t0 t1)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t0 t10)
    (block-return |C67-runtime-categoryMake| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-name0-97| 97 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-build0-96| 96 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-get0-95| 95 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-hash0-94| 94 |l1|))
    (setq t8 (|Lex| |Struct-runtime-51-parentCount0-93| 93 |l1|))
    (setq t9 (|Lex| |Struct-runtime-51-parentGet-92| 92 |l1|))
    (setq t3 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t3 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t3 t6)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t3 t7)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t3 t5)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t3 t8)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t3 t9)
    (|SetLex| |Struct-runtime-51-dv-85| 85 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-dv-85| 85 |l1|))
    (go |Lab1|)
    |Lab5|
    (setq t18 (|SIntPrev| t19))
    (|SetAElt| t17 t18 nil)
    (setq t19 (|SIntNext| t19))
    (go |Lab4|)
    |Lab3|
    (setq t14 (|SIntPrev| t15))
    (|SetAElt| t13 t14 nil)
    (setq t15 (|SIntNext| t15))
    (go |Lab2|)))

(defprog
  ((|C68-runtime-categoryAddParents!|)
    ((|P0-c| |Word|)
      (|P1-parents| |Word|)
      (|P2-cAsCat| |Word|)
      (|e1| |Env|)))
  ((t0 |SInt|)
    (t1 |Word|)
    (t2 |SInt|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Clos|)
    (t6 |Word|)
    (t7 |SInt|)
    (|T8-a| |SInt|)
    (|T9-high| |Word|))
  (tagbody
    (setq t1 (|RElt| |Struct-runtime-24| |domain| 3 |P0-c|))
    (setq t0 (the |SInt| 0))
    (setq
      |T9-high|
      (|RElt| |Struct-runtime-52| |nvalues| 1 |P1-parents|))
    (setq |T8-a| (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| |T8-a| |T9-high|) (go |Lab2|))
    (|SetRElt| |Struct-runtime-24| |parents| 4 |P0-c| |P1-parents|)
    (|SetRElt| |Struct-runtime-24| |nparents| 5 |P0-c| t0)
    (block-return |C68-runtime-categoryAddParents!| ())
    |Lab2|
    (setq t7 (|SIntPrev| |T8-a|))
    (setq
      t6
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |P1-parents|) t7))
    (when (|PtrIsNil| t6) (go |Lab1|))
    (setq t0 (|SIntNext| t0))
    (setq
      t5
      (|RElt|
        |Struct-runtime-28|
        |builder|
        5
        (|RElt| |Struct-runtime-22| |cdv| 0 t6)))
    (setq t4 (|CCall| t5 (|RElt| |Struct-runtime-22| |catRep| 1 t6) t1))
    (setq t3 (|RElt| |Struct-runtime-52| |values| 2 |P1-parents|))
    (setq t2 (|SIntPrev| t0))
    (|SetAElt| t3 t2 t4)
    |Lab1|
    (setq |T8-a| (|SIntNext| |T8-a|))
    (go |Lab0|)))

(defprog
  ((|C69-runtime-categoryAddExports!|)
    ((|P0-c| |Word|)
      (|P1-names| |Word|)
      (|P2-types| |Word|)
      (|P3-exports| |Word|)
      (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-runtime-24| |names| 6 |P0-c| |P1-names|)
  (|SetRElt| |Struct-runtime-24| |types| 7 |P0-c| |P2-types|)
  (|SetRElt| |Struct-runtime-24| |exports| 8 |P0-c| |P3-exports|)
  (block-return |C69-runtime-categoryAddExports!| ()))

(defprog
  ((|C70-runtime-categoryAddNameFn!|)
    ((|P0-cat| |Word|) (|P1-name| |Clos|) (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-runtime-24| |nameFn| 9 |P0-cat| |P1-name|)
  (block-return |C70-runtime-categoryAddNameFn!| ()))

(defprog
  ((|C71-runtime-categoryBuild| |Word|)
    ((|P0-cat| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq
    t0
    (|RElt|
      |Struct-runtime-28|
      |builder|
      5
      (|RElt| |Struct-runtime-22| |cdv| 0 |P0-cat|)))
  (block-return
    |C71-runtime-categoryBuild|
    (|CCall|
      t0
      (|RElt| |Struct-runtime-22| |catRep| 1 |P0-cat|)
      |P1-dom|)))

(defprog
  ((|C72-runtime-categoryName| |Word|) ((|P0-cat| |Word|) (|e1| |Env|)))
  ((t0 |Clos|))
  (setq
    t0
    (|RElt|
      |Struct-runtime-28|
      |namer|
      1
      (|RElt| |Struct-runtime-22| |cdv| 0 |P0-cat|)))
  (block-return
    |C72-runtime-categoryName|
    (|CCall| t0 (|RElt| |Struct-runtime-22| |catRep| 1 |P0-cat|))))

(defprog
  ((|C73-runtime-categoryMakeDummy| |Word|) ((|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-22|))
    (setq t2 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t0 t1)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t0 nil)
    (block-return |C73-runtime-categoryMakeDummy| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-nameDummy-91| 91 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-buildDummy-90| 90 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-getDummy-89| 89 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-hashDummy-88| 88 |l1|))
    (setq t8 (|Lex| |Struct-runtime-51-parentCountDummy-86| 86 |l1|))
    (setq t9 (|Lex| |Struct-runtime-51-parentGetDummy-87| 87 |l1|))
    (setq t3 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t3 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t3 t6)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t3 t7)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t3 t5)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t3 t8)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t3 t9)
    (|SetLex| |Struct-runtime-51-ddv-84| 84 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (go |Lab1|)))

(defprog
  ((|C74-runtime-categoryFill!|)
    ((|P0-d| |Word|) (|P1-v| |Word|) (|e1| |Env|)))
  ()
  (|SetRElt|
    |Struct-runtime-22|
    |cdv|
    0
    |P0-d|
    (|RElt| |Struct-runtime-22| |cdv| 0 |P1-v|))
  (|SetRElt|
    |Struct-runtime-22|
    |catRep|
    1
    |P0-d|
    (|RElt| |Struct-runtime-22| |catRep| 1 |P1-v|))
  (block-return |C74-runtime-categoryFill!| ()))

(defprog
  ((|C75-runtime-domainPrepare!|) ((|P0-td| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Clos|) (t2 |Clos|) (t3 |Word|))
  (tagbody
    (setq t3 (|RElt| |Struct-runtime-11| |domainRep| 1 |P0-td|))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |f2| 1 t3) nil)
      (go |Lab2|))
    |Lab3|
    (setq t0 (|RElt| |Struct-runtime-13| |hashcode| 2 t3))
    (when
      (|PtrEQ| (|RElt| |Struct-runtime-13| |names| 6 t3) nil)
      (go |Lab0|))
    |Lab1|
    (block-return |C75-runtime-domainPrepare!| ())
    |Lab0|
    (setq t1 (|RElt| |Struct-runtime-13| |f2| 1 t3))
    (|CCall| t1 t3 t0)
    (go |Lab1|)
    |Lab2|
    (setq t2 (|RElt| |Struct-runtime-13| |f1| 0 t3))
    (|SetRElt| |Struct-runtime-13| |f2| 1 t3 (|CCall| t2 t3))
    (go |Lab3|)))

(defprog
  ((|C76-runtime-lazyGetExport!| |Word|)
    ((|P0-dom| |Word|) (|P1-n| |Word|) (|P2-t| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-32|))
  (|SetRElt| |Struct-runtime-32| |got| 0 t0 (the |Bool| nil))
  (|SetRElt| |Struct-runtime-32| |dom| 1 t0 |P0-dom|)
  (|SetRElt| |Struct-runtime-32| |name| 2 t0 |P1-n|)
  (|SetRElt| |Struct-runtime-32| |type| 3 t0 |P2-t|)
  (|SetRElt| |Struct-runtime-32| |value| 4 t0 nil)
  (block-return |C76-runtime-lazyGetExport!| t0))

(defprog
  ((|C77-runtime-lazyForceImport| |Word|)
    ((|P0-li| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Arr|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Word|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Arr|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Clos|)
    (t34 |Clos|)
    (t35 |Word|)
    (t36 |Bool|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Clos|)
    (t41 |Clos|)
    (t42 |Arr|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Clos|)
    (t51 |Clos|)
    (t52 |Word|)
    (t53 |Word|)
    (t54 |Clos|)
    (t55 |Clos|)
    (t56 |Clos|)
    (t57 |Arr|)
    (t58 |Word|)
    (t59 |Word|)
    (t60 |Word|)
    (t61 |Clos|)
    (t62 |Word|)
    (t63 |Env|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Clos|)
    (t67 |Clos|)
    (t68 |Arr|)
    (t69 |Env|)
    (t70 |Word|)
    (t71 |Bool|)
    (t72 |Clos|)
    (t73 |Clos|)
    (t74 |Clos|)
    (t75 |Arr|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Clos|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Clos|)
    (t90 |Arr|)
    (t91 |Word|)
    (t92 |Word|)
    (t93 |Word|)
    (t94 |Word|)
    (t95 |Clos|)
    (t96 |Word|)
    (t97 |Bool|)
    (t98 |Clos|)
    (t99 |Clos|)
    (t100 |Clos|)
    (t101 |Arr|)
    (t102 |Clos|)
    (t103 |Clos|)
    (t104 |Clos|)
    (t105 |Clos|)
    (t106 |Clos|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Clos|)
    (t110 |Clos|)
    (t111 |Word|)
    (t112 |Word|)
    (t113 |Clos|)
    (t114 |Clos|)
    (t115 |Clos|)
    (t116 |Arr|)
    (t117 |Word|)
    (t118 |Word|)
    (t119 |Word|)
    (t120 |Word|)
    (t121 |Word|)
    (t122 |Word|)
    (t123 |Word|)
    (t124 |Bool|)
    (t125 |Clos|)
    (t126 |Clos|)
    (t127 |Clos|)
    (t128 |Arr|)
    (t129 |Clos|)
    (t130 |Clos|)
    (t131 |Clos|)
    (t132 |Clos|)
    (t133 |Clos|)
    (t134 |Clos|)
    (t135 |Clos|)
    (t136 |Clos|)
    (t137 |Clos|)
    (t138 |Word|)
    (t139 |Word|)
    (t140 |Clos|)
    (t141 |Clos|)
    (t142 |Clos|)
    (t143 |Arr|)
    (t144 |Word|)
    (t145 |Word|)
    (t146 |Word|)
    (|T147-l| |Word|)
    (t148 |Word|)
    (|T149-l| |Word|)
    (|T150-l| |Word|)
    (|T151-l| |Word|)
    (|T152-l| |Word|)
    (|T153-l| |Word|)
    (t154 |Bool|)
    (t155 |Bool|)
    (t156 |Bool|)
    (t157 |Bool|)
    (t158 |Bool|)
    (t159 |Bool|)
    (t160 |Bool|)
    (t161 |Bool|)
    (t162 |Bool|)
    (t163 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|RElt| |Struct-runtime-32| |got| 0 |P0-li|) (go |Lab0|))
    (setq t120 (|RElt| |Struct-runtime-32| |dom| 1 |P0-li|))
    (setq t121 (|RElt| |Struct-runtime-32| |name| 2 |P0-li|))
    (setq t122 (|RElt| |Struct-runtime-32| |type| 3 |P0-li|))
    (setq
      t95
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (setq
      t94
      (|CCall|
        t95
        (|RElt| |Struct-runtime-11| |domainRep| 1 t120)
        t120
        t121
        t122
        (|Lex| |Struct-runtime-51-box-61| 61 |l1|)
        (the |Bool| nil)))
    (when (|PtrIsNil| t94) (go |Lab41|))
    (setq t0 (|RElt| |Struct-runtime-30| |value| 0 t94))
    (|SetRElt| |Struct-runtime-32| |value| 4 |P0-li| t0)
    (|SetRElt| |Struct-runtime-32| |got| 0 |P0-li| (the |Bool| t))
    (|SetRElt| |Struct-runtime-32| |dom| 1 |P0-li| nil)
    |Lab0|
    (block-return
      |C77-runtime-lazyForceImport|
      (|RElt| |Struct-runtime-32| |value| 4 |P0-li|))
    |Lab41|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t69
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t67 (|Clos| t69 |C6-runtime-PRINT|))
    (setq t68 (|MakeLit| "Looking in "))
    (multiple-value-setq (t64 t65 t66) (|CCall| t67))
    (|CCall| t65 t68 (the |SInt| 1) (the |SInt| 0))
    (setq t21 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq |T147-l| t21)
    (setq t22 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq |T149-l| t22)
    (setq t156 (|PtrIsNil| t21))
    (when t156 (go |Lab1|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t21))
    (setq t148 t26)
    |Lab7|
    (setq t159 (|PtrIsNil| |T149-l|))
    (when t159 (go |Lab1|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 |T149-l|))
    (when (|SIntEQ| t148 t121) (go |Lab2|))
    (when (|PtrIsNil| |T147-l|) (go |Lab8|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T147-l|))
    |Lab9|
    (setq |T147-l| t25)
    (setq t156 (|PtrIsNil| t25))
    (when t156 (go |Lab1|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t25))
    (setq t148 t26)
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T149-l|))
    (setq |T149-l| t23)
    (go |Lab7|)
    |Lab1|
    (setq t20 (|MakeLit| "??:             "))
    (setq t16 (the |SInt| 1))
    |Lab3|
    (setq t18 (|SIntPrev| t16))
    (when
      (|CharEQ| (|AElt| t20 t18) (the |Char| |CharCode0|))
      (go |Lab4|))
    (setq t16 (|SIntNext| t16))
    (go |Lab3|)
    |Lab4|
    (setq t15 (|ANew| |Char| (|SIntNext| t18)))
    (|SetAElt| t15 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t15 t18 (the |Char| |CharCode0|))
    (setq t17 (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| t17 t18) (go |Lab6|))
    (setq t14 (|FormatSInt| t121 t15 (the |SInt| 2)))
    (setq t13 (|SIntNext| (|SIntNext| t14)))
    (|SetAElt| t15 (|SIntPrev| t13) (the |Char| |CharCode0|))
    (setq t27 t15)
    |Lab10|
    (setq
      t34
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|)))
    (setq
      t63
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l1|))
        nil))
    (setq t61 (|Clos| t63 |C6-runtime-PRINT|))
    (setq
      t62
      (|CCall| t34 (|RElt| |Struct-runtime-11| |domainRep| 1 t120)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t62))
      (go |Lab11|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 3))
      (go |Lab13|))
    (setq
      t36
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 2)))
    (setq t35 (|RElt| |Struct-runtime-54| |p| 1 t62))
    (when t36 (go |Lab15|))
    (setq t154 (|PtrIsNil| t35))
    (when t154 (go |Lab16|))
    (setq t52 (|RElt| |Struct-runtime-56| |first| 0 t35))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t52))
      (go |Lab20|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 3))
      (go |Lab21|))
    (setq
      t71
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 2)))
    (setq t70 (|RElt| |Struct-runtime-54| |p| 1 t52))
    (when t71 (go |Lab22|))
    (setq t155 (|PtrIsNil| t70))
    (when t155 (go |Lab23|))
    (setq t85 (|RElt| |Struct-runtime-56| |first| 0 t70))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t85))
      (go |Lab34|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t85) (the |SInt| 3))
      (go |Lab35|))
    (setq
      t124
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t85) (the |SInt| 2)))
    (setq t123 (|RElt| |Struct-runtime-54| |p| 1 t85))
    (when t124 (go |Lab36|))
    (setq t158 (|PtrIsNil| t123))
    (when t158 (go |Lab37|))
    (setq t138 (|RElt| |Struct-runtime-56| |first| 0 t123))
    (|C8-runtime-printDomain| t61 t138 |e1|)
    (setq t139 (|RElt| |Struct-runtime-56| |rest| 1 t123))
    (setq t123 t139)
    |Lab36|
    (multiple-value-setq (t132 t133 t134) (|CCall| t61))
    (|CCall| t133 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T153-l| t123)
    |Lab38|
    (setq t160 (|PtrIsNil| |T153-l|))
    (when t160 (go |Lab39|))
    (setq t146 (|RElt| |Struct-runtime-56| |rest| 1 |T153-l|))
    (setq t144 (|RElt| |Struct-runtime-56| |first| 0 |T153-l|))
    (|C8-runtime-printDomain| t61 t144 |e1|)
    (setq t145 (|RElt| |Struct-runtime-56| |rest| 1 |T153-l|))
    (when (|PtrIsNil| t145) (go |Lab40|))
    (setq t128 (|MakeLit| ", "))
    (multiple-value-setq (t125 t126 t127) (|CCall| t61))
    (|CCall| t126 t128 (the |SInt| 1) (the |SInt| 0))
    |Lab40|
    (setq |T153-l| t146)
    (go |Lab38|)
    |Lab39|
    (setq t143 (|MakeLit| ")"))
    (multiple-value-setq (t140 t141 t142) (|CCall| t61))
    (|CCall| t141 t143 (the |SInt| 1) (the |SInt| 0))
    |Lab44|
    (setq t86 (|RElt| |Struct-runtime-56| |rest| 1 t70))
    (setq t70 t86)
    |Lab22|
    (multiple-value-setq (t79 t80 t81) (|CCall| t61))
    (|CCall| t80 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T151-l| t70)
    |Lab24|
    (setq t161 (|PtrIsNil| |T151-l|))
    (when t161 (go |Lab25|))
    (setq t93 (|RElt| |Struct-runtime-56| |rest| 1 |T151-l|))
    (setq t91 (|RElt| |Struct-runtime-56| |first| 0 |T151-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t91))
      (go |Lab27|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 3))
      (go |Lab28|))
    (setq
      t97
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 2)))
    (setq t96 (|RElt| |Struct-runtime-54| |p| 1 t91))
    (when t97 (go |Lab29|))
    (setq t157 (|PtrIsNil| t96))
    (when t157 (go |Lab30|))
    (setq t111 (|RElt| |Struct-runtime-56| |first| 0 t96))
    (|C8-runtime-printDomain| t61 t111 |e1|)
    (setq t112 (|RElt| |Struct-runtime-56| |rest| 1 t96))
    (setq t96 t112)
    |Lab29|
    (multiple-value-setq (t105 t106 t107) (|CCall| t61))
    (|CCall| t106 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T152-l| t96)
    |Lab31|
    (setq t162 (|PtrIsNil| |T152-l|))
    (when t162 (go |Lab32|))
    (setq t119 (|RElt| |Struct-runtime-56| |rest| 1 |T152-l|))
    (setq t117 (|RElt| |Struct-runtime-56| |first| 0 |T152-l|))
    (|C8-runtime-printDomain| t61 t117 |e1|)
    (setq t118 (|RElt| |Struct-runtime-56| |rest| 1 |T152-l|))
    (when (|PtrIsNil| t118) (go |Lab33|))
    (setq t101 (|MakeLit| ", "))
    (multiple-value-setq (t98 t99 t100) (|CCall| t61))
    (|CCall| t99 t101 (the |SInt| 1) (the |SInt| 0))
    |Lab33|
    (setq |T152-l| t119)
    (go |Lab31|)
    |Lab32|
    (setq t116 (|MakeLit| ")"))
    (multiple-value-setq (t113 t114 t115) (|CCall| t61))
    (|CCall| t114 t116 (the |SInt| 1) (the |SInt| 0))
    |Lab42|
    (setq t92 (|RElt| |Struct-runtime-56| |rest| 1 |T151-l|))
    (when (|PtrIsNil| t92) (go |Lab26|))
    (setq t75 (|MakeLit| ", "))
    (multiple-value-setq (t72 t73 t74) (|CCall| t61))
    (|CCall| t73 t75 (the |SInt| 1) (the |SInt| 0))
    |Lab26|
    (setq |T151-l| t93)
    (go |Lab24|)
    |Lab30|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab28|
    (multiple-value-setq (t102 t103 t104) (|CCall| t61))
    (|CCall| t103 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab42|)
    |Lab27|
    (multiple-value-setq (t108 t109 t110) (|CCall| t61))
    (|CCall|
      t109
      (|RElt| |Struct-runtime-54| |p| 1 t91)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab42|)
    |Lab25|
    (setq t90 (|MakeLit| ")"))
    (multiple-value-setq (t87 t88 t89) (|CCall| t61))
    (|CCall| t88 t90 (the |SInt| 1) (the |SInt| 0))
    |Lab43|
    (setq t53 (|RElt| |Struct-runtime-56| |rest| 1 t35))
    (setq t35 t53)
    |Lab15|
    (multiple-value-setq (t46 t47 t48) (|CCall| t61))
    (|CCall| t47 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T150-l| t35)
    |Lab17|
    (setq t163 (|PtrIsNil| |T150-l|))
    (when t163 (go |Lab18|))
    (setq t60 (|RElt| |Struct-runtime-56| |rest| 1 |T150-l|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 |T150-l|))
    (|C8-runtime-printDomain| t61 t58 |e1|)
    (setq t59 (|RElt| |Struct-runtime-56| |rest| 1 |T150-l|))
    (when (|PtrIsNil| t59) (go |Lab19|))
    (setq t42 (|MakeLit| ", "))
    (multiple-value-setq (t39 t40 t41) (|CCall| t61))
    (|CCall| t40 t42 (the |SInt| 1) (the |SInt| 0))
    |Lab19|
    (setq |T150-l| t60)
    (go |Lab17|)
    |Lab18|
    (setq t57 (|MakeLit| ")"))
    (multiple-value-setq (t54 t55 t56) (|CCall| t61))
    (|CCall| t55 t57 (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    |Lab14|
    (setq t37 t38)
    |Lab12|
    (multiple-value-setq (t31 t32 t33) (|CCall| t37))
    (|CCall| t32 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t28 t29 t30) (|CCall| t37))
    (|CCall| t29 t27 (the |SInt| 1) (the |SInt| 0))
    (setq t8 (|MakeLit| " with code "))
    (multiple-value-setq (t5 t6 t7) (|CCall| t37))
    (|CCall| t6 t8 (the |SInt| 1) (the |SInt| 0))
    (setq t12 (|formatSInt| t122))
    (multiple-value-setq (t9 t10 t11) (|CCall| t37))
    (|CCall| t10 t12 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t2 t3 t4) (|CCall| t37))
    (|CCall| t2 (the |Char| #\Newline))
    (setq t1 (|MakeLit| "Export not found"))
    (|fiRaiseException| t1)
    (|Halt| (the |SInt| 102))
    |Lab37|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab35|
    (multiple-value-setq (t129 t130 t131) (|CCall| t61))
    (|CCall| t130 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab44|)
    |Lab34|
    (multiple-value-setq (t135 t136 t137) (|CCall| t61))
    (|CCall|
      t136
      (|RElt| |Struct-runtime-54| |p| 1 t85)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab44|)
    |Lab23|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab21|
    (multiple-value-setq (t76 t77 t78) (|CCall| t61))
    (|CCall| t77 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab43|)
    |Lab20|
    (multiple-value-setq (t82 t83 t84) (|CCall| t61))
    (|CCall|
      t83
      (|RElt| |Struct-runtime-54| |p| 1 t52)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab43|)
    |Lab16|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab13|
    (multiple-value-setq (t43 t44 t45) (|CCall| t61))
    (|CCall| t44 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    (go |Lab14|)
    |Lab11|
    (multiple-value-setq (t49 t50 t51) (|CCall| t61))
    (|CCall|
      t50
      (|RElt| |Struct-runtime-54| |p| 1 t62)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t37 t61)
    (go |Lab12|)
    |Lab6|
    (setq t19 (|SIntPrev| t17))
    (|SetAElt| t15 t19 (|AElt| t20 t19))
    (setq t17 (|SIntNext| t17))
    (go |Lab5|)
    |Lab8|
    (setq t25 |T147-l|)
    (go |Lab9|)
    |Lab2|
    (setq t27 t24)
    (go |Lab10|)))

(defprog
  ((|C78-runtime-noOperation|) ((|e1| |Env|)))
  ()
  (block-return |C78-runtime-noOperation| ()))

(defprog
  ((|C79-runtime-extendMake| |Word|) ((|P0-df| |Clos|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Record|)
    (t9 |Record|)
    (t10 |Record|)
    (t11 |Arr|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |Record|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t18 (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (|SetLex| |Struct-runtime-51-serialThis-78| 78 |l1| (|SIntNext| t18))
    (setq t8 (|RNew| |Struct-runtime-13|))
    (|SetRElt| |Struct-runtime-13| |f1| 0 t8 |P0-df|)
    (|SetRElt| |Struct-runtime-13| |f2| 1 t8 nil)
    (|SetRElt| |Struct-runtime-13| |hashcode| 2 t8 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-13| |parents| 3 t8 nil)
    (|SetRElt| |Struct-runtime-13| |extendees| 4 t8 nil)
    (|SetRElt| |Struct-runtime-13| |defaults| 5 t8 nil)
    (|SetRElt| |Struct-runtime-13| |names| 6 t8 nil)
    (|SetRElt| |Struct-runtime-13| |types| 7 t8 nil)
    (|SetRElt| |Struct-runtime-13| |exports| 8 t8 nil)
    (|SetRElt| |Struct-runtime-13| |ngets| 9 t8 (the |SInt| 0))
    (|SetRElt|
      |Struct-runtime-13|
      |serial|
      10
      t8
      (|Lex| |Struct-runtime-51-serialThis-78| 78 |l1|))
    (setq t9 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t9 (the |SInt| 0))
    (setq t10 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t10 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t10 (the |SInt| 15))
    (setq t11 (|ANew| |Word| (the |SInt| 15)))
    (setq t13 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t13 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t10 t11)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t9 t10)
    (setq t14 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t14 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t14 (the |SInt| 15))
    (setq t15 (|ANew| |Word| (the |SInt| 15)))
    (setq t17 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t17 (the |SInt| 15)) (go |Lab5|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t14 t15)
    (|SetRElt| |Struct-runtime-34| |values| 2 t9 t14)
    (|SetRElt| |Struct-runtime-34| |size| 3 t9 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-13| |cache| 11 t8 t9)
    (|SetRElt|
      |Struct-runtime-13|
      |nameFn|
      12
      t8
      (|Lex| |Struct-runtime-51-domainStdName-77| 77 |l1|))
    (setq t0 (|RNew| |Struct-runtime-11|))
    (setq t2 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    |Lab1|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t0 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t0 t8)
    (block-return |C79-runtime-extendMake| t0)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-nameExtend-70| 70 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-getExtend-72| 72 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hashExtend-71| 71 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritToExtend-69| 69 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-edv-63| 63 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-edv-63| 63 |l1|))
    (go |Lab1|)
    |Lab5|
    (setq t16 (|SIntPrev| t17))
    (|SetAElt| t15 t16 nil)
    (setq t17 (|SIntNext| t17))
    (go |Lab4|)
    |Lab3|
    (setq t12 (|SIntPrev| t13))
    (|SetAElt| t11 t12 nil)
    (setq t13 (|SIntNext| t13))
    (go |Lab2|)))

(defprog
  ((|C80-runtime-extendFill!|)
    ((|P0-dom| |Word|) (|P1-pars| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |SInt|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Record|)
    (t5 |Arr|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |Word|)
    (t10 |Word|)
    (|T11-a| |SInt|)
    (t12 |SInt|))
  (tagbody
    (|SetRElt| |Struct-runtime-13| |parents| 3 |P0-dom| |P1-pars|)
    (setq
      t0
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |P1-pars|)
        (the |SInt| 0)))
    (setq t9 (|RElt| |Struct-runtime-11| |domainRep| 1 t0))
    (setq t10 (|RElt| |Struct-runtime-52| |nvalues| 1 |P1-pars|))
    (setq t8 (|SIntPrev| t10))
    (setq t4 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t4 t8)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t4 t8)
    (setq t5 (|ANew| |Word| t8))
    (setq t7 (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| t7 t8) (go |Lab1|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t4 t5)
    (setq |T11-a| (the |SInt| 2))
    |Lab2|
    (when (|SIntLE| |T11-a| t10) (go |Lab3|))
    (|SetRElt| |Struct-runtime-13| |extendees| 4 t9 t4)
    (block-return |C80-runtime-extendFill!| ())
    |Lab3|
    (setq t12 (|SIntPrev| |T11-a|))
    (setq
      t3
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |P1-pars|) t12))
    (setq t2 (|RElt| |Struct-runtime-52| |values| 2 t4))
    (setq t1 (|SIntPrev| t12))
    (|SetAElt| t2 t1 t3)
    (setq |T11-a| (|SIntNext| |T11-a|))
    (go |Lab2|)
    |Lab1|
    (setq t6 (|SIntPrev| t7))
    (|SetAElt| t5 t6 nil)
    (setq t7 (|SIntNext| t7))
    (go |Lab0|)))

(defprog
  ((|C81-runtime-rtConstSIntFn| |Clos|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-42| |Struct-runtime-42|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-42-x-0| 0 |l0| |P0-x|)
  (block-return
    |C81-runtime-rtConstSIntFn|
    (|Clos| |e0| |C82-runtime-rtConstSIntFn|)))

(defprog
  ((|C82-runtime-rtConstSIntFn| |Word|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C82-runtime-rtConstSIntFn|
    (|Lex| |Struct-runtime-42-x-0| 0 |l1|)))

(defprog
  ((|C83-runtime-stringConcat| |Word|) ((|P0-t| |Word|) (|e1| |Env|)))
  ((t0 |SInt|)
    (t1 |SInt|)
    (t2 |Word|)
    (t3 |SInt|)
    (t4 |Arr|)
    (t5 |SInt|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|))
  (tagbody
    (setq t0 (the |SInt| 0))
    (setq t11 (|RElt| |Struct-runtime-53| |size| 0 |P0-t|))
    (setq t6 (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| t6 t11) (go |Lab8|))
    (setq t4 (|ANew| |Char| (|SIntNext| t0)))
    (|SetAElt| t4 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t4 t0 (the |Char| |CharCode0|))
    (setq t9 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t9 t0) (go |Lab3|))
    (setq t0 (the |SInt| 1))
    (setq t10 (|RElt| |Struct-runtime-53| |size| 0 |P0-t|))
    (setq t5 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t5 t10) (go |Lab6|))
    (block-return |C83-runtime-stringConcat| t4)
    |Lab6|
    (setq
      t2
      (|AElt|
        (|RElt| |Struct-runtime-53| |values| 1 |P0-t|)
        (|SIntPrev| t5)))
    (setq t8 (the |SInt| 1))
    (setq t7 t0)
    |Lab1|
    (setq t13 (|SIntPrev| t8))
    (when
      (|CharEQ| (|AElt| t2 t13) (the |Char| |CharCode0|))
      (go |Lab10|))
    (setq t14 (|SIntPrev| t7))
    (when
      (|CharEQ| (|AElt| t4 t14) (the |Char| |CharCode0|))
      (go |Lab11|))
    (|SetAElt| t4 t14 (|AElt| t2 t13))
    (setq t8 (|SIntNext| t8))
    (setq t7 (|SIntNext| t7))
    (go |Lab1|)
    |Lab11|
    (setq t0 t7)
    |Lab5|
    (setq t5 (|SIntNext| t5))
    (go |Lab4|)
    |Lab10|
    (setq t0 t7)
    (go |Lab5|)
    |Lab3|
    (setq t3 (|SIntPrev| t9))
    (|SetAElt| t4 t3 (the |Char| #\Space))
    (setq t9 (|SIntNext| t9))
    (go |Lab2|)
    |Lab8|
    (setq t1 (the |SInt| 1))
    |Lab0|
    (setq t12 (|SIntPrev| t1))
    (when
      (|CharEQ|
        (|AElt|
          (|AElt|
            (|RElt| |Struct-runtime-53| |values| 1 |P0-t|)
            (|SIntPrev| t6))
          t12)
        (the |Char| |CharCode0|))
      (go |Lab9|))
    (setq t1 (|SIntNext| t1))
    (go |Lab0|)
    |Lab9|
    (setq t0 (|SIntPlus| t0 t12))
    (setq t6 (|SIntNext| t6))
    (go |Lab7|)))

(defprog
  ((|C84-runtime-rtAddStrings|)
    ((|P0-a1| |Word|) (|P1-a2| |Word|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Record|)
    (t5 |Word|)
    (t6 |Word|)
    (t7 |Record|)
    (t8 |Word|)
    (t9 |Word|)
    (t10 |SInt|)
    (t11 |Word|)
    (t12 |SInt|)
    (t13 |Word|)
    (|T14-a| |SInt|)
    (|T15-a| |SInt|)
    (|T16-high| |Word|)
    (|T17-high| |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t6 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (when (|PtrIsNil| t6) (go |Lab0|))
    |Lab1|
    (setq |T17-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |P0-a1|))
    (setq |T15-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T17-high|) (go |Lab5|))
    |Lab2|
    (block-return |C84-runtime-rtAddStrings| ())
    |Lab5|
    (setq
      t11
      (|AElt|
        (|RElt| |Struct-runtime-52| |values| 2 |P0-a1|)
        (the |SInt| 0)))
    (setq t13 t11)
    (setq |T16-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |P1-a2|))
    (setq |T14-a| (the |SInt| 1))
    |Lab3|
    (when (|SIntLE| |T14-a| |T16-high|) (go |Lab4|))
    (go |Lab2|)
    |Lab4|
    (setq t10 (|SIntPrev| |T14-a|))
    (setq
      t9
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |P1-a2|) t10))
    (setq t8 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq t7 (|RNew| |Struct-runtime-56|))
    (|SetRElt| |Struct-runtime-56| |first| 0 t7 t13)
    (|SetRElt| |Struct-runtime-56| |rest| 1 t7 t8)
    (|SetLex| |Struct-runtime-51-codes-105| 105 |l1| t7)
    (setq t1 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq t0 (|RNew| |Struct-runtime-56|))
    (|SetRElt| |Struct-runtime-56| |first| 0 t0 t9)
    (|SetRElt| |Struct-runtime-56| |rest| 1 t0 t1)
    (|SetLex| |Struct-runtime-51-names-106| 106 |l1| t0)
    (setq |T15-a| (|SIntNext| |T15-a|))
    (when (|SIntLE| |T15-a| |T17-high|) (go |Lab6|))
    (go |Lab2|)
    |Lab6|
    (setq t12 (|SIntPrev| |T15-a|))
    (setq
      t11
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |P0-a1|) t12))
    (setq t13 t11)
    (setq |T14-a| (|SIntNext| |T14-a|))
    (go |Lab3|)
    |Lab0|
    (setq t5 (|Lex| |Struct-runtime-51-names-106| 106 |l1|))
    (setq t4 (|RNew| |Struct-runtime-56|))
    (|SetRElt| |Struct-runtime-56| |first| 0 t4 (|MakeLit| "%%"))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t4 t5)
    (|SetLex| |Struct-runtime-51-names-106| 106 |l1| t4)
    (setq t3 (|Lex| |Struct-runtime-51-codes-105| 105 |l1|))
    (setq t2 (|RNew| |Struct-runtime-56|))
    (|SetRElt| |Struct-runtime-56| |first| 0 t2 (the |SInt| 51482908))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t2 t3)
    (|SetLex| |Struct-runtime-51-codes-105| 105 |l1| t2)
    (go |Lab1|)))

(defprog
  ((|C85-runtime-rtCacheMake| |Word|) ((|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Record|)
    (t2 |Arr|)
    (t3 |SInt|)
    (t4 |SInt|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |SInt|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t0 (the |SInt| 0))
    (setq t1 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t1 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t1 (the |SInt| 15))
    (setq t2 (|ANew| |Word| (the |SInt| 15)))
    (setq t4 (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| t4 (the |SInt| 15)) (go |Lab1|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t1 t2)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t0 t1)
    (setq t5 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t5 (the |SInt| 15))
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t5 (the |SInt| 15))
    (setq t6 (|ANew| |Word| (the |SInt| 15)))
    (setq t8 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t8 (the |SInt| 15)) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t5 t6)
    (|SetRElt| |Struct-runtime-34| |values| 2 t0 t5)
    (|SetRElt| |Struct-runtime-34| |size| 3 t0 (the |SInt| 15))
    (block-return |C85-runtime-rtCacheMake| t0)
    |Lab3|
    (setq t7 (|SIntPrev| t8))
    (|SetAElt| t6 t7 nil)
    (setq t8 (|SIntNext| t8))
    (go |Lab2|)
    |Lab1|
    (setq t3 (|SIntPrev| t4))
    (|SetAElt| t2 t3 nil)
    (setq t4 (|SIntNext| t4))
    (go |Lab0|)))

(defprog
  ((|C86-runtime-rtCacheExplicitMake| |Word|)
    ((|P0-x| |SInt|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Record|)
    (t2 |Arr|)
    (t3 |SInt|)
    (t4 |SInt|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |SInt|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-34|))
    (|SetRElt| |Struct-runtime-34| |posn| 0 t0 (the |SInt| 0))
    (setq t5 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t5 |P0-x|)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t5 |P0-x|)
    (setq t6 (|ANew| |Word| |P0-x|))
    (setq t8 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t8 |P0-x|) (go |Lab3|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t5 t6)
    (|SetRElt| |Struct-runtime-34| |keys| 1 t0 t5)
    (setq t1 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t1 |P0-x|)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t1 |P0-x|)
    (setq t2 (|ANew| |Word| |P0-x|))
    (setq t4 (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| t4 |P0-x|) (go |Lab1|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t1 t2)
    (|SetRElt| |Struct-runtime-34| |values| 2 t0 t1)
    (|SetRElt| |Struct-runtime-34| |size| 3 t0 |P0-x|)
    (block-return |C86-runtime-rtCacheExplicitMake| t0)
    |Lab1|
    (setq t3 (|SIntPrev| t4))
    (|SetAElt| t2 t3 nil)
    (setq t4 (|SIntNext| t4))
    (go |Lab0|)
    |Lab3|
    (setq t7 (|SIntPrev| t8))
    (|SetAElt| t6 t7 nil)
    (setq t8 (|SIntNext| t8))
    (go |Lab2|)))

(defprog
  ((|C87-runtime-rtCacheCheck| |Word| |Word|)
    ((|P0-cache| |Word|) (|P1-key| |Word|) (|e1| |Env|)))
  ((t0 |SInt|)
    (t1 |SInt|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |SInt|)
    (t5 |Word|)
    (t6 |SInt|)
    (t7 |Word|)
    (t8 |Bool|)
    (|T9-a| |SInt|)
    (t10 |Word|)
    (|T11-v| |Word|)
    (|T12-a| |SInt|)
    (|T13-a| |SInt|)
    (|T14-high| |Word|)
    (|T15-high| |Word|)
    (t16 |SInt|))
  (tagbody
    (setq t2 (|RElt| |Struct-runtime-34| |keys| 1 |P0-cache|))
    (setq |T11-v| (|RElt| |Struct-runtime-34| |values| 2 |P0-cache|))
    (setq |T15-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t2))
    (setq |T12-a| (the |SInt| 1))
    (when (|SIntLE| (the |SInt| 1) |T15-high|) (go |Lab10|))
    |Lab0|
    (setq t7 nil)
    (setq t8 (the |Bool| nil))
    |Lab7|
    (block-return |C87-runtime-rtCacheCheck| (values t7 t8))
    |Lab10|
    (setq
      t5
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t2) (the |SInt| 0)))
    (setq t10 t5)
    (setq |T14-high| (|RElt| |Struct-runtime-52| |nvalues| 1 |T11-v|))
    (setq |T13-a| (the |SInt| 1))
    |Lab5|
    (when (|SIntLE| |T13-a| |T14-high|) (go |Lab8|))
    (go |Lab0|)
    |Lab8|
    (setq t4 (|SIntPrev| |T13-a|))
    (setq
      t3
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 |T11-v|) t4))
    (when (|PtrEQ| t10 nil) (go |Lab6|))
    (setq t1 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (when
      (|SIntNE| (|RElt| |Struct-runtime-53| |size| 0 t10) t1)
      (go |Lab1|))
    (setq t0 (|RElt| |Struct-runtime-53| |size| 0 t10))
    (setq |T9-a| (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| |T9-a| t0) (go |Lab4|))
    (setq t7 t3)
    (setq t8 (the |Bool| t))
    (go |Lab7|)
    |Lab4|
    (setq t16 (|SIntPrev| |T9-a|))
    (when
      (|PtrMagicEQ|
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 t10) t16)
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 |P1-key|) t16))
      (go |Lab3|))
    |Lab6|
    (setq |T12-a| (|SIntNext| |T12-a|))
    (when (|SIntLE| |T12-a| |T15-high|) (go |Lab9|))
    (go |Lab0|)
    |Lab9|
    (setq t6 (|SIntPrev| |T12-a|))
    (setq t5 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t2) t6))
    (setq t10 t5)
    (setq |T13-a| (|SIntNext| |T13-a|))
    (go |Lab5|)
    |Lab3|
    (setq |T9-a| (|SIntNext| |T9-a|))
    (go |Lab2|)
    |Lab1|
    (go |Lab6|)))

(defprog
  ((|C88-runtime-rtCacheAdd| |Word|)
    ((|P0-cache| |Word|)
      (|P1-key| |Word|)
      (|P2-value| |Word|)
      (|e1| |Env|)))
  ((t0 |SInt|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |SInt|)
    (t4 |Word|)
    (t5 |Word|)
    (t6 |SInt|)
    (t7 |Word|)
    (t8 |Word|)
    (t9 |Word|))
  (tagbody
    (setq t7 (|RElt| |Struct-runtime-34| |posn| 0 |P0-cache|))
    (setq t9 (|RElt| |Struct-runtime-34| |keys| 1 |P0-cache|))
    (setq t8 (|RElt| |Struct-runtime-52| |values| 2 t9))
    (|SetAElt| t8 t7 |P1-key|)
    (setq t5 (|RElt| |Struct-runtime-34| |values| 2 |P0-cache|))
    (setq
      t6
      (|SIntNext| (|RElt| |Struct-runtime-34| |posn| 0 |P0-cache|)))
    (setq t4 (|RElt| |Struct-runtime-52| |values| 2 t5))
    (setq t3 (|SIntPrev| t6))
    (|SetAElt| t4 t3 |P2-value|)
    (setq t1 (|RElt| |Struct-runtime-34| |posn| 0 |P0-cache|))
    (setq t2 (|RElt| |Struct-runtime-34| |size| 3 |P0-cache|))
    (setq t1 (|SIntMinus| t1 t2))
    (setq t0 (|SIntNext| t1))
    (when (|SIntIsNeg| t0) (go |Lab0|))
    |Lab1|
    (|SetRElt| |Struct-runtime-34| |posn| 0 |P0-cache| t0)
    (block-return |C88-runtime-rtCacheAdd| |P2-value|)
    |Lab0|
    (setq t0 (|SIntPlus| t0 t2))
    (go |Lab1|)))

(defprog
  ((|C89-runtime-rtCacheDynamicMake| |Word|) ((|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Record|)
    (t2 |Arr|)
    (t3 |SInt|)
    (t4 |SInt|)
    (t5 |Word|)
    (t6 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t0 (|RNew| |Struct-runtime-36|))
    (|SetRElt| |Struct-runtime-36| |count| 0 t0 (the |SInt| 0))
    (setq t6 (|Lex| |Struct-runtime-51-primes-108| 108 |l1|))
    (setq
      t5
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t6) (the |SInt| 2)))
    (setq t1 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t1 t5)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t1 t5)
    (setq t2 (|ANew| |Word| t5))
    (setq t4 (the |SInt| 1))
    |Lab0|
    (when (|SIntLE| t4 t5) (go |Lab1|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t1 t2)
    (|SetRElt| |Struct-runtime-36| |buckv| 1 t0 t1)
    (block-return |C89-runtime-rtCacheDynamicMake| t0)
    |Lab1|
    (setq t3 (|SIntPrev| t4))
    (|SetAElt| t2 t3 nil)
    (setq t4 (|SIntNext| t4))
    (go |Lab0|)))

(defprog
  ((|C90-runtime-rtCacheDynamicCheck| |Word| |Word|)
    ((|P0-cache| |Word|) (|P1-key| |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Bool|)
    (t2 |Word|)
    (t3 |Bool|)
    (t4 |Word|)
    (t5 |SInt|)
    (t6 |Word|)
    (t7 |Word|)
    (t8 |Word|)
    (t9 |Word|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |Word|)
    (t13 |Word|)
    (t14 |Word|)
    (t15 |Word|)
    (t16 |Word|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |Word|)
    (t20 |Word|)
    (t21 |SInt|)
    (t22 |SInt|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |SInt|)
    (t26 |Word|)
    (|T27-a| |SInt|)
    (|T28-a| |SInt|)
    (t29 |Bool|)
    (t30 |SInt|)
    (t31 |Bool|)
    (t32 |SInt|)
    (t33 |Bool|))
  (tagbody
    (setq t21 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq t22 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq |T28-a| (the |SInt| 1))
    |Lab14|
    (when (|SIntLE| |T28-a| t22) (go |Lab15|))
    (setq
      t12
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|)))
    (setq t11 (|SIntRem| t21 t12))
    (when (|SIntIsNeg| t11) (go |Lab8|))
    |Lab9|
    (setq t10 (|SIntNext| t11))
    (setq t32 (|SIntPrev| t10))
    (setq
      t9
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
        t32))
    (setq t8 nil)
    |Lab4|
    (setq t33 (|PtrIsNil| t9))
    (when t33 (go |Lab5|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 t9))
    (when
      (|SIntEQ| t21 (|RElt| |Struct-runtime-37| |hash| 2 t24))
      (go |Lab6|))
    (setq t8 t9)
    |Lab17|
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 t9))
    (setq t9 t23)
    (go |Lab4|)
    |Lab6|
    (setq t19 (|RElt| |Struct-runtime-37| |key| 0 t24))
    (setq t18 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (when
      (|SIntNE| (|RElt| |Struct-runtime-53| |size| 0 t19) t18)
      (go |Lab10|))
    (setq t17 (|RElt| |Struct-runtime-53| |size| 0 t19))
    (setq |T27-a| (the |SInt| 1))
    |Lab11|
    (when (|SIntLE| |T27-a| t17) (go |Lab13|))
    (setq t29 (|PtrIsNil| t8))
    (when t29 (go |Lab7|))
    (setq t16 (|RElt| |Struct-runtime-56| |rest| 1 t9))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t8 t16)
    (setq
      t15
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
        t32))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t9 t15)
    (setq t14 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t13 (|RElt| |Struct-runtime-52| |values| 2 t14))
    (|SetAElt| t13 t32 t9)
    |Lab7|
    (setq t25 t10)
    |Lab16|
    (when (|SIntIsZero| t25) (go |Lab0|))
    (setq t6 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t5 (|SIntPrev| t25))
    (setq t0 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t6) t5))
    (setq t31 (|PtrIsNil| t0))
    (when t31 (go |Lab2|))
    (setq t7 (|RElt| |Struct-runtime-56| |first| 0 t0))
    (setq t26 (|RElt| |Struct-runtime-37| |value| 1 t7))
    (setq t3 (the |Bool| t))
    (setq t4 t26)
    |Lab3|
    (setq t1 t3)
    (setq t2 t4)
    |Lab1|
    (block-return |C90-runtime-rtCacheDynamicCheck| (values t2 t1))
    |Lab2|
    (setq t3 (the |Bool| nil))
    (setq t4 nil)
    (go |Lab3|)
    |Lab0|
    (setq t1 (the |Bool| nil))
    (setq t2 nil)
    (go |Lab1|)
    |Lab13|
    (setq t30 (|SIntPrev| |T27-a|))
    (when
      (|PtrMagicEQ|
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 t19) t30)
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 |P1-key|) t30))
      (go |Lab12|))
    (setq t8 t9)
    (go |Lab17|)
    |Lab12|
    (setq |T27-a| (|SIntNext| |T27-a|))
    (go |Lab11|)
    |Lab10|
    (setq t8 t9)
    (go |Lab17|)
    |Lab5|
    (setq t25 (the |SInt| 0))
    (go |Lab16|)
    |Lab8|
    (setq t11 (|SIntPlus| t11 t12))
    (go |Lab9|)
    |Lab15|
    (setq
      t20
      (|AElt|
        (|RElt| |Struct-runtime-53| |values| 1 |P1-key|)
        (|SIntPrev| |T28-a|)))
    (setq t21 (|SIntXOr| t21 t20))
    (setq |T28-a| (|SIntNext| |T28-a|))
    (go |Lab14|)))

(defprog
  ((|C91-runtime-rtCacheDynamicAdd| |Word|)
    ((|P0-cache| |Word|)
      (|P1-key| |Word|)
      (|P2-value| |Word|)
      (|e1| |Env|)))
  ((t0 |SInt|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Word|)
    (t6 |Record|)
    (t7 |SInt|)
    (t8 |Word|)
    (t9 |SInt|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SFlo|)
    (t15 |Word|)
    (t16 |SFlo|)
    (t17 |SInt|)
    (t18 |Word|)
    (t19 |Word|)
    (t20 |Word|)
    (t21 |Word|)
    (t22 |SInt|)
    (t23 |SInt|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Record|)
    (t27 |Arr|)
    (t28 |SInt|)
    (t29 |SInt|)
    (t30 |SInt|)
    (t31 |Word|)
    (t32 |Word|)
    (t33 |Word|)
    (t34 |Word|)
    (t35 |Word|)
    (t36 |Word|)
    (t37 |SInt|)
    (t38 |SInt|)
    (t39 |SInt|)
    (t40 |Word|)
    (t41 |Word|)
    (t42 |Word|)
    (t43 |Word|)
    (t44 |SInt|)
    (t45 |SInt|)
    (t46 |Word|)
    (t47 |Word|)
    (t48 |Word|)
    (t49 |Word|)
    (t50 |Word|)
    (t51 |SInt|)
    (t52 |SInt|)
    (t53 |Word|)
    (t54 |Word|)
    (t55 |SInt|)
    (t56 |SInt|)
    (t57 |Word|)
    (t58 |Word|)
    (t59 |SInt|)
    (|T60-a| |SInt|)
    (|T61-a| |SInt|)
    (|T62-a| |SInt|)
    (|T63-a| |SInt|)
    (|T64-a| |SInt|)
    (|T65-high| |Word|)
    (t66 |Bool|)
    (t67 |SInt|)
    (t68 |Bool|)
    (t69 |Bool|)
    (t70 |SInt|)
    (t71 |Bool|)
    (t72 |SInt|)
    (t73 |SInt|)
    (t74 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t55 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq t56 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq |T63-a| (the |SInt| 1))
    |Lab26|
    (when (|SIntLE| |T63-a| t56) (go |Lab27|))
    (setq
      t46
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|)))
    (setq t45 (|SIntRem| t55 t46))
    (when (|SIntIsNeg| t45) (go |Lab20|))
    |Lab21|
    (setq t44 (|SIntNext| t45))
    (setq t73 (|SIntPrev| t44))
    (setq
      t43
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
        t73))
    (setq t42 nil)
    |Lab16|
    (setq t74 (|PtrIsNil| t43))
    (when t74 (go |Lab17|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 t43))
    (when
      (|SIntEQ| t55 (|RElt| |Struct-runtime-37| |hash| 2 t58))
      (go |Lab18|))
    (setq t42 t43)
    |Lab29|
    (setq t57 (|RElt| |Struct-runtime-56| |rest| 1 t43))
    (setq t43 t57)
    (go |Lab16|)
    |Lab18|
    (setq t53 (|RElt| |Struct-runtime-37| |key| 0 t58))
    (setq t52 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (when
      (|SIntNE| (|RElt| |Struct-runtime-53| |size| 0 t53) t52)
      (go |Lab22|))
    (setq t51 (|RElt| |Struct-runtime-53| |size| 0 t53))
    (setq |T62-a| (the |SInt| 1))
    |Lab23|
    (when (|SIntLE| |T62-a| t51) (go |Lab25|))
    (setq t69 (|PtrIsNil| t42))
    (when t69 (go |Lab19|))
    (setq t50 (|RElt| |Struct-runtime-56| |rest| 1 t43))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t42 t50)
    (setq
      t49
      (|AElt|
        (|RElt|
          |Struct-runtime-52|
          |values|
          2
          (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
        t73))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t43 t49)
    (setq t48 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t47 (|RElt| |Struct-runtime-52| |values| 2 t48))
    (|SetAElt| t47 t73 t43)
    |Lab19|
    (setq t59 t44)
    |Lab28|
    (when (|SIntIsPos| t59) (go |Lab0|))
    (setq t12 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq t13 (|RElt| |Struct-runtime-53| |size| 0 |P1-key|))
    (setq |T60-a| (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| |T60-a| t13) (go |Lab5|))
    (setq
      t10
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|)))
    (setq t9 (|SIntRem| t12 t10))
    (when (|SIntIsNeg| t9) (go |Lab2|))
    |Lab3|
    (setq t0 (|SIntNext| t9))
    (setq t2 (|RNew| |Struct-runtime-37|))
    (|SetRElt| |Struct-runtime-37| |key| 0 t2 |P1-key|)
    (|SetRElt| |Struct-runtime-37| |value| 1 t2 |P2-value|)
    (|SetRElt| |Struct-runtime-37| |hash| 2 t2 t12)
    (setq t4 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t5 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t67 (|SIntPrev| t0))
    (setq t6 (|RNew| |Struct-runtime-56|))
    (|SetRElt| |Struct-runtime-56| |first| 0 t6 t2)
    (|SetRElt|
      |Struct-runtime-56|
      |rest|
      1
      t6
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t5) t67))
    (setq t3 (|RElt| |Struct-runtime-52| |values| 2 t4))
    (|SetAElt| t3 t67 t6)
    (|SetRElt|
      |Struct-runtime-36|
      |count|
      0
      |P0-cache|
      (|SIntNext| (|RElt| |Struct-runtime-36| |count| 0 |P0-cache|)))
    (setq
      t15
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|)))
    (setq
      t16
      (|SIntToSFlo| (|RElt| |Struct-runtime-36| |count| 0 |P0-cache|)))
    (setq t14 (|SFloDivide| t16 (|SIntToSFlo| t15)))
    (when (|SFloLT| (the |SFlo| 5.00000000000000000s0) t14) (go |Lab6|))
    |Lab1|
    (block-return |C91-runtime-rtCacheDynamicAdd| |P2-value|)
    |Lab6|
    (setq
      t40
      (|RElt|
        |Struct-runtime-52|
        |nvalues|
        1
        (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|)))
    (setq t39 (the |SInt| 1))
    (setq |T61-a| (the |SInt| 0))
    |Lab15|
    (when (|SIntLE| t40 t39) (go |Lab14|))
    (setq t39 (|SIntPlus| t39 t39))
    (setq |T61-a| (|SIntNext| |T61-a|))
    (go |Lab15|)
    |Lab14|
    (setq t38 (|SIntNext| |T61-a|))
    (when (|SIntLT| t38 (the |SInt| 1)) (go |Lab1|))
    (setq t33 (|Lex| |Struct-runtime-51-primes-108| 108 |l1|))
    (setq t25 (|RElt| |Struct-runtime-52| |nvalues| 1 t33))
    (when (|SIntLT| t25 t38) (go |Lab1|))
    (setq t31 (|Lex| |Struct-runtime-51-primes-108| 108 |l1|))
    (setq t30 (|SIntPrev| t38))
    (setq t20 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t31) t30))
    (setq t26 (|RNew| |Struct-runtime-52|))
    (|SetRElt| |Struct-runtime-52| |size| 0 t26 t20)
    (|SetRElt| |Struct-runtime-52| |nvalues| 1 t26 t20)
    (setq t27 (|ANew| |Word| t20))
    (setq t29 (the |SInt| 1))
    |Lab9|
    (when (|SIntLE| t29 t20) (go |Lab10|))
    (|SetRElt| |Struct-runtime-52| |values| 2 t26 t27)
    (setq t32 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq |T65-high| (|RElt| |Struct-runtime-52| |nvalues| 1 t32))
    (setq |T64-a| (the |SInt| 1))
    |Lab12|
    (when (|SIntLE| |T64-a| |T65-high|) (go |Lab31|))
    (setq t24 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (|FoamFree| (|RElt| |Struct-runtime-52| |values| 2 t24))
    (|FoamFree| t24)
    (|SetRElt| |Struct-runtime-36| |buckv| 1 |P0-cache| t26)
    (go |Lab1|)
    |Lab31|
    (setq t37 (|SIntPrev| |T64-a|))
    (setq t36 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t32) t37))
    (setq t19 t36)
    |Lab7|
    (setq t71 (|PtrIsNil| t19))
    (when t71 (go |Lab13|))
    (setq t18 t19)
    (setq t34 (|RElt| |Struct-runtime-56| |rest| 1 t19))
    (setq t19 t34)
    (setq t68 (|PtrIsNil| t18))
    (when t68 (go |Lab11|))
    (setq t35 (|RElt| |Struct-runtime-56| |first| 0 t18))
    (setq t23 (|SIntRem| (|RElt| |Struct-runtime-37| |hash| 2 t35) t20))
    (when (|SIntIsNeg| t23) (go |Lab8|))
    (setq t17 (|SIntNext| t23))
    (setq t72 (|SIntPrev| t17))
    (setq t22 t72)
    |Lab30|
    (|SetRElt|
      |Struct-runtime-56|
      |rest|
      1
      t18
      (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t26) t22))
    (setq t21 (|RElt| |Struct-runtime-52| |values| 2 t26))
    (|SetAElt| t21 t72 t18)
    (go |Lab7|)
    |Lab8|
    (setq t23 (|SIntPlus| t23 t20))
    (setq t17 (|SIntNext| t23))
    (setq t72 (|SIntPrev| t17))
    (setq t22 t72)
    (go |Lab30|)
    |Lab11|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab13|
    (setq |T64-a| (|SIntNext| |T64-a|))
    (go |Lab12|)
    |Lab10|
    (setq t28 (|SIntPrev| t29))
    (|SetAElt| t27 t28 nil)
    (setq t29 (|SIntNext| t29))
    (go |Lab9|)
    |Lab2|
    (setq t9 (|SIntPlus| t9 t10))
    (go |Lab3|)
    |Lab5|
    (setq
      t11
      (|AElt|
        (|RElt| |Struct-runtime-53| |values| 1 |P1-key|)
        (|SIntPrev| |T60-a|)))
    (setq t12 (|SIntXOr| t12 t11))
    (setq |T60-a| (|SIntNext| |T60-a|))
    (go |Lab4|)
    |Lab0|
    (setq t8 (|RElt| |Struct-runtime-36| |buckv| 1 |P0-cache|))
    (setq t7 (|SIntPrev| t59))
    (setq t1 (|AElt| (|RElt| |Struct-runtime-52| |values| 2 t8) t7))
    (setq t66 (|PtrIsNil| t1))
    (when t66 (go |Lab1|))
    (setq t41 (|RElt| |Struct-runtime-56| |first| 0 t1))
    (|SetRElt| |Struct-runtime-37| |value| 1 t41 |P2-value|)
    (go |Lab1|)
    |Lab25|
    (setq t70 (|SIntPrev| |T62-a|))
    (when
      (|PtrMagicEQ|
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 t53) t70)
        (|AElt| (|RElt| |Struct-runtime-53| |values| 1 |P1-key|) t70))
      (go |Lab24|))
    (setq t42 t43)
    (go |Lab29|)
    |Lab24|
    (setq |T62-a| (|SIntNext| |T62-a|))
    (go |Lab23|)
    |Lab22|
    (setq t42 t43)
    (go |Lab29|)
    |Lab17|
    (setq t59 (the |SInt| 0))
    (go |Lab28|)
    |Lab20|
    (setq t45 (|SIntPlus| t45 t46))
    (go |Lab21|)
    |Lab27|
    (setq
      t54
      (|AElt|
        (|RElt| |Struct-runtime-53| |values| 1 |P1-key|)
        (|SIntPrev| |T63-a|)))
    (setq t55 (|SIntXOr| t55 t54))
    (setq |T63-a| (|SIntNext| |T63-a|))
    (go |Lab26|)))

(defprog
  ((|C92-runtime-rtDelayedInit!| |Clos|)
    ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-43| |Struct-runtime-43|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-43-fn-0| 0 |l0| |P0-fn|)
  (|SetLex| |Struct-runtime-43-n-1| 1 |l0| |P1-n|)
  (block-return
    |C92-runtime-rtDelayedInit!|
    (|Clos| |e0| |C93-runtime-rtDelayedInit!|)))

(defprog
  ((|C93-runtime-rtDelayedInit!| |Word|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C93-runtime-rtDelayedInit!|
    (|CCall|
      (|Lex| |Struct-runtime-43-fn-0| 0 |l1|)
      (|Lex| |Struct-runtime-43-n-1| 1 |l1|))))

(defprog
  ((|C94-runtime-rtDelayedGetExport!| |Clos|)
    ((|P0-d| |Word|) (|P1-n1| |Word|) (|P2-n2| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-44| |Struct-runtime-44|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-44-d-0| 0 |l0| |P0-d|)
  (|SetLex| |Struct-runtime-44-n1-1| 1 |l0| |P1-n1|)
  (|SetLex| |Struct-runtime-44-n2-2| 2 |l0| |P2-n2|)
  (block-return
    |C94-runtime-rtDelayedGetExport!|
    (|Clos| |e0| |C95-runtime-rtDelayedGetExport!|)))

(defprog
  ((|C95-runtime-rtDelayedGetExport!| |Word|) ((|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Clos|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Arr|)
    (t9 |Clos|)
    (t10 |Clos|)
    (t11 |Clos|)
    (t12 |Word|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |Arr|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |Arr|)
    (t21 |Word|)
    (t22 |Word|)
    (t23 |Word|)
    (t24 |Word|)
    (t25 |Word|)
    (t26 |Word|)
    (t27 |Word|)
    (t28 |Clos|)
    (t29 |Clos|)
    (t30 |Clos|)
    (t31 |Clos|)
    (t32 |Clos|)
    (t33 |Clos|)
    (t34 |Clos|)
    (t35 |Word|)
    (t36 |Bool|)
    (t37 |Clos|)
    (t38 |Clos|)
    (t39 |Clos|)
    (t40 |Clos|)
    (t41 |Clos|)
    (t42 |Arr|)
    (t43 |Clos|)
    (t44 |Clos|)
    (t45 |Clos|)
    (t46 |Clos|)
    (t47 |Clos|)
    (t48 |Clos|)
    (t49 |Clos|)
    (t50 |Clos|)
    (t51 |Clos|)
    (t52 |Word|)
    (t53 |Word|)
    (t54 |Clos|)
    (t55 |Clos|)
    (t56 |Clos|)
    (t57 |Arr|)
    (t58 |Word|)
    (t59 |Word|)
    (t60 |Word|)
    (t61 |Clos|)
    (t62 |Word|)
    (t63 |Env|)
    (t64 |Clos|)
    (t65 |Clos|)
    (t66 |Clos|)
    (t67 |Clos|)
    (t68 |Arr|)
    (t69 |Env|)
    (t70 |Word|)
    (t71 |Bool|)
    (t72 |Clos|)
    (t73 |Clos|)
    (t74 |Clos|)
    (t75 |Arr|)
    (t76 |Clos|)
    (t77 |Clos|)
    (t78 |Clos|)
    (t79 |Clos|)
    (t80 |Clos|)
    (t81 |Clos|)
    (t82 |Clos|)
    (t83 |Clos|)
    (t84 |Clos|)
    (t85 |Word|)
    (t86 |Word|)
    (t87 |Clos|)
    (t88 |Clos|)
    (t89 |Clos|)
    (t90 |Arr|)
    (t91 |Word|)
    (t92 |Word|)
    (t93 |Word|)
    (t94 |Word|)
    (t95 |Clos|)
    (t96 |Word|)
    (t97 |Bool|)
    (t98 |Clos|)
    (t99 |Clos|)
    (t100 |Clos|)
    (t101 |Arr|)
    (t102 |Clos|)
    (t103 |Clos|)
    (t104 |Clos|)
    (t105 |Clos|)
    (t106 |Clos|)
    (t107 |Clos|)
    (t108 |Clos|)
    (t109 |Clos|)
    (t110 |Clos|)
    (t111 |Word|)
    (t112 |Word|)
    (t113 |Clos|)
    (t114 |Clos|)
    (t115 |Clos|)
    (t116 |Arr|)
    (t117 |Word|)
    (t118 |Word|)
    (t119 |Word|)
    (t120 |Word|)
    (t121 |Word|)
    (t122 |Word|)
    (|T123-l| |Word|)
    (t124 |Word|)
    (|T125-l| |Word|)
    (|T126-l| |Word|)
    (|T127-l| |Word|)
    (|T128-l| |Word|)
    (t129 |Bool|)
    (t130 |Bool|)
    (t131 |Bool|)
    (t132 |Bool|)
    (t133 |Bool|)
    (t134 |Bool|)
    (t135 |Bool|)
    (t136 |Bool|)
    (|l1| |Level|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (tagbody
    (setq t120 (|Lex| |Struct-runtime-44-d-0| 0 |l1|))
    (setq t121 (|Lex| |Struct-runtime-44-n1-1| 1 |l1|))
    (setq t122 (|Lex| |Struct-runtime-44-n2-2| 2 |l1|))
    (setq
      t95
      (|RElt|
        |Struct-runtime-20|
        |getter|
        3
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (setq
      t94
      (|CCall|
        t95
        (|RElt| |Struct-runtime-11| |domainRep| 1 t120)
        t120
        t121
        t122
        (|Lex| |Struct-runtime-51-box-61| 61 |l2|)
        (the |Bool| nil)))
    (when (|PtrIsNil| t94) (go |Lab33|))
    (setq t0 (|RElt| |Struct-runtime-30| |value| 0 t94))
    (block-return |C95-runtime-rtDelayedGetExport!| t0)
    |Lab33|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l2|)))
    (setq
      t69
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l2|))
        nil))
    (setq t67 (|Clos| t69 |C6-runtime-PRINT|))
    (setq t68 (|MakeLit| "Looking in "))
    (multiple-value-setq (t64 t65 t66) (|CCall| t67))
    (|CCall| t65 t68 (the |SInt| 1) (the |SInt| 0))
    (setq t21 (|Lex| |Struct-runtime-51-codes-105| 105 |l2|))
    (setq |T123-l| t21)
    (setq t22 (|Lex| |Struct-runtime-51-names-106| 106 |l2|))
    (setq |T125-l| t22)
    (setq t130 (|PtrIsNil| t21))
    (when t130 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t21))
    (setq t124 t26)
    |Lab6|
    (setq t133 (|PtrIsNil| |T125-l|))
    (when t133 (go |Lab0|))
    (setq t24 (|RElt| |Struct-runtime-56| |first| 0 |T125-l|))
    (when (|SIntEQ| t124 t121) (go |Lab1|))
    (when (|PtrIsNil| |T123-l|) (go |Lab7|))
    (setq t25 (|RElt| |Struct-runtime-56| |rest| 1 |T123-l|))
    |Lab8|
    (setq |T123-l| t25)
    (setq t130 (|PtrIsNil| t25))
    (when t130 (go |Lab0|))
    (setq t26 (|RElt| |Struct-runtime-56| |first| 0 t25))
    (setq t124 t26)
    (setq t23 (|RElt| |Struct-runtime-56| |rest| 1 |T125-l|))
    (setq |T125-l| t23)
    (go |Lab6|)
    |Lab0|
    (setq t20 (|MakeLit| "??:             "))
    (setq t16 (the |SInt| 1))
    |Lab2|
    (setq t18 (|SIntPrev| t16))
    (when
      (|CharEQ| (|AElt| t20 t18) (the |Char| |CharCode0|))
      (go |Lab3|))
    (setq t16 (|SIntNext| t16))
    (go |Lab2|)
    |Lab3|
    (setq t15 (|ANew| |Char| (|SIntNext| t18)))
    (|SetAElt| t15 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t15 t18 (the |Char| |CharCode0|))
    (setq t17 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t17 t18) (go |Lab5|))
    (setq t14 (|FormatSInt| t121 t15 (the |SInt| 2)))
    (setq t13 (|SIntNext| (|SIntNext| t14)))
    (|SetAElt| t15 (|SIntPrev| t13) (the |Char| |CharCode0|))
    (setq t27 t15)
    |Lab9|
    (setq
      t34
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t120)))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l2|)))
    (setq
      t63
      (|MakeEnv|
        (|ClosEnv| (|Lex| |Struct-runtime-51-PRINT-60| 60 |l2|))
        nil))
    (setq t61 (|Clos| t63 |C6-runtime-PRINT|))
    (setq
      t62
      (|CCall| t34 (|RElt| |Struct-runtime-11| |domainRep| 1 t120)))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t62))
      (go |Lab10|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 3))
      (go |Lab12|))
    (setq
      t36
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t62) (the |SInt| 2)))
    (setq t35 (|RElt| |Struct-runtime-54| |p| 1 t62))
    (when t36 (go |Lab14|))
    (setq t129 (|PtrIsNil| t35))
    (when t129 (go |Lab15|))
    (setq t52 (|RElt| |Struct-runtime-56| |first| 0 t35))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t52))
      (go |Lab19|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 3))
      (go |Lab20|))
    (setq
      t71
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t52) (the |SInt| 2)))
    (setq t70 (|RElt| |Struct-runtime-54| |p| 1 t52))
    (when t71 (go |Lab21|))
    (setq t132 (|PtrIsNil| t70))
    (when t132 (go |Lab22|))
    (setq t85 (|RElt| |Struct-runtime-56| |first| 0 t70))
    (|C8-runtime-printDomain| t61 t85 |e2|)
    (setq t86 (|RElt| |Struct-runtime-56| |rest| 1 t70))
    (setq t70 t86)
    |Lab21|
    (multiple-value-setq (t79 t80 t81) (|CCall| t61))
    (|CCall| t80 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T127-l| t70)
    |Lab23|
    (setq t134 (|PtrIsNil| |T127-l|))
    (when t134 (go |Lab24|))
    (setq t93 (|RElt| |Struct-runtime-56| |rest| 1 |T127-l|))
    (setq t91 (|RElt| |Struct-runtime-56| |first| 0 |T127-l|))
    (when
      (|SIntIsZero| (|RElt| |Struct-runtime-54| |tag| 0 t91))
      (go |Lab26|))
    (when
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 3))
      (go |Lab27|))
    (setq
      t97
      (|SIntEQ| (|RElt| |Struct-runtime-54| |tag| 0 t91) (the |SInt| 2)))
    (setq t96 (|RElt| |Struct-runtime-54| |p| 1 t91))
    (when t97 (go |Lab28|))
    (setq t131 (|PtrIsNil| t96))
    (when t131 (go |Lab29|))
    (setq t111 (|RElt| |Struct-runtime-56| |first| 0 t96))
    (|C8-runtime-printDomain| t61 t111 |e2|)
    (setq t112 (|RElt| |Struct-runtime-56| |rest| 1 t96))
    (setq t96 t112)
    |Lab28|
    (multiple-value-setq (t105 t106 t107) (|CCall| t61))
    (|CCall| t106 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T128-l| t96)
    |Lab30|
    (setq t135 (|PtrIsNil| |T128-l|))
    (when t135 (go |Lab31|))
    (setq t119 (|RElt| |Struct-runtime-56| |rest| 1 |T128-l|))
    (setq t117 (|RElt| |Struct-runtime-56| |first| 0 |T128-l|))
    (|C8-runtime-printDomain| t61 t117 |e2|)
    (setq t118 (|RElt| |Struct-runtime-56| |rest| 1 |T128-l|))
    (when (|PtrIsNil| t118) (go |Lab32|))
    (setq t101 (|MakeLit| ", "))
    (multiple-value-setq (t98 t99 t100) (|CCall| t61))
    (|CCall| t99 t101 (the |SInt| 1) (the |SInt| 0))
    |Lab32|
    (setq |T128-l| t119)
    (go |Lab30|)
    |Lab31|
    (setq t116 (|MakeLit| ")"))
    (multiple-value-setq (t113 t114 t115) (|CCall| t61))
    (|CCall| t114 t116 (the |SInt| 1) (the |SInt| 0))
    |Lab34|
    (setq t92 (|RElt| |Struct-runtime-56| |rest| 1 |T127-l|))
    (when (|PtrIsNil| t92) (go |Lab25|))
    (setq t75 (|MakeLit| ", "))
    (multiple-value-setq (t72 t73 t74) (|CCall| t61))
    (|CCall| t73 t75 (the |SInt| 1) (the |SInt| 0))
    |Lab25|
    (setq |T127-l| t93)
    (go |Lab23|)
    |Lab29|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab27|
    (multiple-value-setq (t102 t103 t104) (|CCall| t61))
    (|CCall| t103 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab34|)
    |Lab26|
    (multiple-value-setq (t108 t109 t110) (|CCall| t61))
    (|CCall|
      t109
      (|RElt| |Struct-runtime-54| |p| 1 t91)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab34|)
    |Lab24|
    (setq t90 (|MakeLit| ")"))
    (multiple-value-setq (t87 t88 t89) (|CCall| t61))
    (|CCall| t88 t90 (the |SInt| 1) (the |SInt| 0))
    |Lab35|
    (setq t53 (|RElt| |Struct-runtime-56| |rest| 1 t35))
    (setq t35 t53)
    |Lab14|
    (multiple-value-setq (t46 t47 t48) (|CCall| t61))
    (|CCall| t47 (|MakeLit| "(") (the |SInt| 1) (the |SInt| 0))
    (setq |T126-l| t35)
    |Lab16|
    (setq t136 (|PtrIsNil| |T126-l|))
    (when t136 (go |Lab17|))
    (setq t60 (|RElt| |Struct-runtime-56| |rest| 1 |T126-l|))
    (setq t58 (|RElt| |Struct-runtime-56| |first| 0 |T126-l|))
    (|C8-runtime-printDomain| t61 t58 |e2|)
    (setq t59 (|RElt| |Struct-runtime-56| |rest| 1 |T126-l|))
    (when (|PtrIsNil| t59) (go |Lab18|))
    (setq t42 (|MakeLit| ", "))
    (multiple-value-setq (t39 t40 t41) (|CCall| t61))
    (|CCall| t40 t42 (the |SInt| 1) (the |SInt| 0))
    |Lab18|
    (setq |T126-l| t60)
    (go |Lab16|)
    |Lab17|
    (setq t57 (|MakeLit| ")"))
    (multiple-value-setq (t54 t55 t56) (|CCall| t61))
    (|CCall| t55 t57 (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    |Lab13|
    (setq t37 t38)
    |Lab11|
    (multiple-value-setq (t31 t32 t33) (|CCall| t37))
    (|CCall| t32 (|MakeLit| " for ") (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t28 t29 t30) (|CCall| t37))
    (|CCall| t29 t27 (the |SInt| 1) (the |SInt| 0))
    (setq t8 (|MakeLit| " with code "))
    (multiple-value-setq (t5 t6 t7) (|CCall| t37))
    (|CCall| t6 t8 (the |SInt| 1) (the |SInt| 0))
    (setq t12 (|formatSInt| t122))
    (multiple-value-setq (t9 t10 t11) (|CCall| t37))
    (|CCall| t10 t12 (the |SInt| 1) (the |SInt| 0))
    (multiple-value-setq (t2 t3 t4) (|CCall| t37))
    (|CCall| t2 (the |Char| #\Newline))
    (setq t1 (|MakeLit| "Export not found"))
    (|fiRaiseException| t1)
    (|Halt| (the |SInt| 102))
    |Lab22|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab20|
    (multiple-value-setq (t76 t77 t78) (|CCall| t61))
    (|CCall| t77 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (go |Lab35|)
    |Lab19|
    (multiple-value-setq (t82 t83 t84) (|CCall| t61))
    (|CCall|
      t83
      (|RElt| |Struct-runtime-54| |p| 1 t52)
      (the |SInt| 1)
      (the |SInt| 0))
    (go |Lab35|)
    |Lab15|
    (|fputs|
      (|MakeLit| "Cannot select `first' of empty list.")
      (|stdoutFile|))
    (|fputc| (the |SInt| 10) (|stdoutFile|))
    (|Halt| (the |SInt| 0))
    |Lab12|
    (multiple-value-setq (t43 t44 t45) (|CCall| t61))
    (|CCall| t44 (|MakeLit| "??") (the |SInt| 1) (the |SInt| 0))
    (setq t38 t61)
    (go |Lab13|)
    |Lab10|
    (multiple-value-setq (t49 t50 t51) (|CCall| t61))
    (|CCall|
      t50
      (|RElt| |Struct-runtime-54| |p| 1 t62)
      (the |SInt| 1)
      (the |SInt| 0))
    (setq t37 t61)
    (go |Lab11|)
    |Lab5|
    (setq t19 (|SIntPrev| t17))
    (|SetAElt| t15 t19 (|AElt| t20 t19))
    (setq t17 (|SIntNext| t17))
    (go |Lab4|)
    |Lab7|
    (setq t25 |T123-l|)
    (go |Lab8|)
    |Lab1|
    (setq t27 t24)
    (go |Lab9|)))

(defprog
  ((|C96-runtime-rtLazyCatFrInit| |Word|)
    ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))
  ((|T0-ifn| |Clos|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Clos|)
    (t10 |Record|)
    (t11 |Record|)
    (t12 |Word|)
    (t13 |Word|)
    (t14 |Record|)
    (t15 |Clos|)
    (t16 |Clos|)
    (t17 |Clos|)
    (t18 |Clos|)
    (t19 |Clos|)
    (t20 |Clos|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-45| |Struct-runtime-45|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-runtime-45-fn-0| 0 |l0| |P0-fn|)
    (|SetLex| |Struct-runtime-45-n-1| 1 |l0| |P1-n|)
    (setq |T0-ifn| (|Clos| |e0| |C97-runtime-ifn|))
    (setq t11 (|RNew| |Struct-runtime-22|))
    (setq t13 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (when (|PtrIsNil| t13) (go |Lab2|))
    (setq t12 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    |Lab3|
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t11 t12)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t11 nil)
    (setq t2 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    |Lab1|
    (setq t10 (|RNew| |Struct-runtime-18|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t10 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-18| |value| 1 t10 |T0-ifn|)
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t11 t1)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t11 t10)
    (block-return |C96-runtime-rtLazyCatFrInit| t11)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-name0-103| 103 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-build0-102| 102 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-get0-101| 101 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-hash0-100| 100 |l1|))
    (setq t8 (|Lex| |Struct-runtime-51-parentCount0-99| 99 |l1|))
    (setq t9 (|Lex| |Struct-runtime-51-parentGet-98| 98 |l1|))
    (setq t3 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t3 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t3 t6)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t3 t7)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t3 t5)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t3 t8)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t3 t9)
    (|SetLex| |Struct-runtime-51-pcdv-104| 104 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    (go |Lab1|)
    |Lab2|
    (setq t15 (|Lex| |Struct-runtime-51-nameDummy-91| 91 |l1|))
    (setq t16 (|Lex| |Struct-runtime-51-buildDummy-90| 90 |l1|))
    (setq t17 (|Lex| |Struct-runtime-51-getDummy-89| 89 |l1|))
    (setq t18 (|Lex| |Struct-runtime-51-hashDummy-88| 88 |l1|))
    (setq t19 (|Lex| |Struct-runtime-51-parentCountDummy-86| 86 |l1|))
    (setq t20 (|Lex| |Struct-runtime-51-parentGetDummy-87| 87 |l1|))
    (setq t14 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t14 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t14 t15)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t14 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t14 t17)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t14 t18)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t14 t16)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t14 t19)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t14 t20)
    (|SetLex| |Struct-runtime-51-ddv-84| 84 |l1| t14)
    (setq t12 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (go |Lab3|)))

(defprog
  ((|C97-runtime-ifn| |Word|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C97-runtime-ifn|
    (|CCall|
      (|Lex| |Struct-runtime-45-fn-0| 0 |l1|)
      (|Lex| |Struct-runtime-45-n-1| 1 |l1|))))

(defprog
  ((|C98-runtime-rtLazyCatFrFn| |Word|) ((|P0-fn| |Clos|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Clos|)
    (t9 |Record|)
    (t10 |Record|)
    (t11 |Word|)
    (t12 |Word|)
    (t13 |Record|)
    (t14 |Clos|)
    (t15 |Clos|)
    (t16 |Clos|)
    (t17 |Clos|)
    (t18 |Clos|)
    (t19 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t10 (|RNew| |Struct-runtime-22|))
    (setq t12 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (when (|PtrIsNil| t12) (go |Lab2|))
    (setq t11 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    |Lab3|
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t10 t11)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t10 nil)
    (setq t1 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    (when (|PtrIsNil| t1) (go |Lab0|))
    (setq t0 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    |Lab1|
    (setq t9 (|RNew| |Struct-runtime-18|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t9 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-18| |value| 1 t9 |P0-fn|)
    (|SetRElt| |Struct-runtime-22| |cdv| 0 t10 t0)
    (|SetRElt| |Struct-runtime-22| |catRep| 1 t10 t9)
    (block-return |C98-runtime-rtLazyCatFrFn| t10)
    |Lab0|
    (setq t3 (|Lex| |Struct-runtime-51-name0-103| 103 |l1|))
    (setq t4 (|Lex| |Struct-runtime-51-build0-102| 102 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-get0-101| 101 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-hash0-100| 100 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-parentCount0-99| 99 |l1|))
    (setq t8 (|Lex| |Struct-runtime-51-parentGet-98| 98 |l1|))
    (setq t2 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t2 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t2 t3)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t2 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t2 t5)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t2 t6)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t2 t4)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t2 t7)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t2 t8)
    (|SetLex| |Struct-runtime-51-pcdv-104| 104 |l1| t2)
    (setq t0 (|Lex| |Struct-runtime-51-pcdv-104| 104 |l1|))
    (go |Lab1|)
    |Lab2|
    (setq t14 (|Lex| |Struct-runtime-51-nameDummy-91| 91 |l1|))
    (setq t15 (|Lex| |Struct-runtime-51-buildDummy-90| 90 |l1|))
    (setq t16 (|Lex| |Struct-runtime-51-getDummy-89| 89 |l1|))
    (setq t17 (|Lex| |Struct-runtime-51-hashDummy-88| 88 |l1|))
    (setq t18 (|Lex| |Struct-runtime-51-parentCountDummy-86| 86 |l1|))
    (setq t19 (|Lex| |Struct-runtime-51-parentGetDummy-87| 87 |l1|))
    (setq t13 (|RNew| |Struct-runtime-28|))
    (|SetRElt| |Struct-runtime-28| |tag| 0 t13 (the |SInt| 10))
    (|SetRElt| |Struct-runtime-28| |namer| 1 t13 t14)
    (|SetRElt| |Struct-runtime-28| |noname| 2 t13 nil)
    (|SetRElt| |Struct-runtime-28| |getter| 3 t13 t16)
    (|SetRElt| |Struct-runtime-28| |hasher| 4 t13 t17)
    (|SetRElt| |Struct-runtime-28| |builder| 5 t13 t15)
    (|SetRElt| |Struct-runtime-28| |parentCounter| 6 t13 t18)
    (|SetRElt| |Struct-runtime-28| |parentGetter| 7 t13 t19)
    (|SetLex| |Struct-runtime-51-ddv-84| 84 |l1| t13)
    (setq t11 (|Lex| |Struct-runtime-51-ddv-84| 84 |l1|))
    (go |Lab3|)))

(defprog
  ((|C99-runtime-rtLazyDomFrInit| |Word|)
    ((|P0-fn| |Clos|) (|P1-n| |Word|) (|e1| |Env|)))
  ((|T0-ifn| |Clos|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Record|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Record|)
    (t9 |Record|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |Record|)
    (t13 |Clos|)
    (t14 |Clos|)
    (t15 |Clos|)
    (t16 |Clos|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-46| |Struct-runtime-46|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-runtime-46-fn-0| 0 |l0| |P0-fn|)
    (|SetLex| |Struct-runtime-46-n-1| 1 |l0| |P1-n|)
    (setq |T0-ifn| (|Clos| |e0| |C100-runtime-ifn|))
    (setq t9 (|RNew| |Struct-runtime-11|))
    (setq t11 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (when (|PtrIsNil| t11) (go |Lab2|))
    (setq t10 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    |Lab3|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t9 t10)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t9 nil)
    (setq t2 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    (when (|PtrIsNil| t2) (go |Lab0|))
    (setq t1 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    |Lab1|
    (setq t8 (|RNew| |Struct-runtime-18|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t8 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-18| |value| 1 t8 |T0-ifn|)
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t9 t1)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t9 t8)
    (block-return |C99-runtime-rtLazyDomFrInit| t9)
    |Lab0|
    (setq t4 (|Lex| |Struct-runtime-51-name-82| 82 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-get-80| 80 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-domHash-81| 81 |l1|))
    (setq t7 (|Lex| |Struct-runtime-51-inheritTo-79| 79 |l1|))
    (setq t3 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t3 t4)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t3 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t3 t5)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t3 t6)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t3 t7)
    (|SetLex| |Struct-runtime-51-pdv-83| 83 |l1| t3)
    (setq t1 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    (go |Lab1|)
    |Lab2|
    (setq t13 (|Lex| |Struct-runtime-51-nameDummy-68| 68 |l1|))
    (setq t14 (|Lex| |Struct-runtime-51-getDummy-67| 67 |l1|))
    (setq t15 (|Lex| |Struct-runtime-51-hashDummy-66| 66 |l1|))
    (setq t16 (|Lex| |Struct-runtime-51-inheritToDummy-65| 65 |l1|))
    (setq t12 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t12 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t12 t13)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t12 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t12 t14)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t12 t15)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t12 t16)
    (|SetLex| |Struct-runtime-51-ddv-62| 62 |l1| t12)
    (setq t10 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (go |Lab3|)))

(defprog
  ((|C100-runtime-ifn| |Word|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C100-runtime-ifn|
    (|CCall|
      (|Lex| |Struct-runtime-46-fn-0| 0 |l1|)
      (|Lex| |Struct-runtime-46-n-1| 1 |l1|))))

(defprog
  ((|C101-runtime-rtLazyDomFrFn| |Word|)
    ((|P0-fn| |Clos|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |Clos|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Record|)
    (t8 |Record|)
    (t9 |Word|)
    (t10 |Word|)
    (t11 |Record|)
    (t12 |Clos|)
    (t13 |Clos|)
    (t14 |Clos|)
    (t15 |Clos|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t8 (|RNew| |Struct-runtime-11|))
    (setq t10 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (when (|PtrIsNil| t10) (go |Lab2|))
    (setq t9 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    |Lab3|
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t8 t9)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t8 nil)
    (setq t1 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    (when (|PtrIsNil| t1) (go |Lab0|))
    (setq t0 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    |Lab1|
    (setq t7 (|RNew| |Struct-runtime-18|))
    (|SetRElt| |Struct-runtime-18| |tag| 0 t7 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-18| |value| 1 t7 |P0-fn|)
    (|SetRElt| |Struct-runtime-11| |dispatcher| 0 t8 t0)
    (|SetRElt| |Struct-runtime-11| |domainRep| 1 t8 t7)
    (block-return |C101-runtime-rtLazyDomFrFn| t8)
    |Lab0|
    (setq t3 (|Lex| |Struct-runtime-51-name-82| 82 |l1|))
    (setq t4 (|Lex| |Struct-runtime-51-get-80| 80 |l1|))
    (setq t5 (|Lex| |Struct-runtime-51-domHash-81| 81 |l1|))
    (setq t6 (|Lex| |Struct-runtime-51-inheritTo-79| 79 |l1|))
    (setq t2 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t2 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t2 t3)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t2 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t2 t4)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t2 t5)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t2 t6)
    (|SetLex| |Struct-runtime-51-pdv-83| 83 |l1| t2)
    (setq t0 (|Lex| |Struct-runtime-51-pdv-83| 83 |l1|))
    (go |Lab1|)
    |Lab2|
    (setq t12 (|Lex| |Struct-runtime-51-nameDummy-68| 68 |l1|))
    (setq t13 (|Lex| |Struct-runtime-51-getDummy-67| 67 |l1|))
    (setq t14 (|Lex| |Struct-runtime-51-hashDummy-66| 66 |l1|))
    (setq t15 (|Lex| |Struct-runtime-51-inheritToDummy-65| 65 |l1|))
    (setq t11 (|RNew| |Struct-runtime-20|))
    (|SetRElt| |Struct-runtime-20| |tag| 0 t11 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-20| |namer| 1 t11 t12)
    (|SetRElt| |Struct-runtime-20| |noname| 2 t11 nil)
    (|SetRElt| |Struct-runtime-20| |getter| 3 t11 t13)
    (|SetRElt| |Struct-runtime-20| |hasher| 4 t11 t14)
    (|SetRElt| |Struct-runtime-20| |inheriter| 5 t11 t15)
    (|SetLex| |Struct-runtime-51-ddv-62| 62 |l1| t11)
    (setq t9 (|Lex| |Struct-runtime-51-ddv-62| 62 |l1|))
    (go |Lab3|)))

(defprog
  ((|C102-runtime-namePartConcat| |Word|)
    ((|P0-x| |Word|) (p1-t |Word|) (|e1| |Env|)))
  ((t0 |Record|)
    (t1 |Record|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Record|)
    (t5 |SInt|)
    (t6 |SInt|)
    (t7 |SInt|))
  (tagbody
    (setq t3 nil)
    (setq t6 (|RElt| |Struct-runtime-53| |size| 0 p1-t))
    (setq t5 t6)
    |Lab2|
    (when (|SIntLE| (the |SInt| 1) t5) (go |Lab3|))
    (when |P0-x| (go |Lab0|))
    (setq t1 (|RNew| |Struct-runtime-54|))
    (|SetRElt| |Struct-runtime-54| |tag| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-runtime-54| |p| 1 t1 t3)
    (setq t0 t1)
    |Lab1|
    (block-return |C102-runtime-namePartConcat| t0)
    |Lab0|
    (setq t2 (|RNew| |Struct-runtime-54|))
    (|SetRElt| |Struct-runtime-54| |tag| 0 t2 (the |SInt| 2))
    (|SetRElt| |Struct-runtime-54| |p| 1 t2 t3)
    (setq t0 t2)
    (go |Lab1|)
    |Lab3|
    (setq t4 (|RNew| |Struct-runtime-56|))
    (setq t7 (|SIntPrev| t5))
    (|SetRElt|
      |Struct-runtime-56|
      |first|
      0
      t4
      (|AElt| (|RElt| |Struct-runtime-53| |values| 1 p1-t) t7))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t4 t3)
    (setq t3 t4)
    (setq t5 t7)
    (go |Lab2|)))

(defprog
  ((|C103-runtime-namePartFrString| |Word|)
    ((|P0-s| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 0))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 |P0-s|)
  (block-return |C103-runtime-namePartFrString| t0))

(defprog
  ((|C104-runtime-namePartFrOther| |Word|)
    ((|P0-p| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 3))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 |P0-p|)
  (block-return |C104-runtime-namePartFrOther| t0))

(defprog
  ((|C105-runtime-rtConstNameFn| |Clos|) ((|P0-s| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-47| |Struct-runtime-47|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-47-s-0| 0 |l0| |P0-s|)
  (block-return
    |C105-runtime-rtConstNameFn|
    (|Clos| |e0| |C106-runtime-rtConstNameFn|)))

(defprog
  ((|C106-runtime-rtConstNameFn| |Word|) ((|e1| |Env|)))
  ((t0 |Record|) (t1 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t1 (|Lex| |Struct-runtime-47-s-0| 0 |l1|))
  (setq t0 (|RNew| |Struct-runtime-54|))
  (|SetRElt| |Struct-runtime-54| |tag| 0 t0 (the |SInt| 0))
  (|SetRElt| |Struct-runtime-54| |p| 1 t0 t1)
  (block-return |C106-runtime-rtConstNameFn| t0))

(defprog
  ((|C107-runtime-rtSingleParamNameFn| |Clos|)
    ((|P0-s| |Word|) (|P1-d| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-49| |Struct-runtime-49|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-49-s-0| 0 |l0| |P0-s|)
  (|SetLex| |Struct-runtime-49-d-1| 1 |l0| |P1-d|)
  (block-return
    |C107-runtime-rtSingleParamNameFn|
    (|Clos| |e0| |C108-runtime-rtSingleParamNameFn|)))

(defprog
  ((|C108-runtime-rtSingleParamNameFn| |Word|) ((|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Word|)
    (t2 |Record|)
    (t3 |SInt|)
    (t4 |SInt|)
    (t5 |Record|)
    (t6 |Record|)
    (t7 |Word|)
    (t8 |Clos|)
    (t9 |Word|)
    (t10 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq t7 (|Lex| |Struct-runtime-49-s-0| 0 |l1|))
    (setq t6 (|RNew| |Struct-runtime-54|))
    (|SetRElt| |Struct-runtime-54| |tag| 0 t6 (the |SInt| 0))
    (|SetRElt| |Struct-runtime-54| |p| 1 t6 t7)
    (setq t9 (|Lex| |Struct-runtime-49-d-1| 1 |l1|))
    (setq
      t8
      (|RElt|
        |Struct-runtime-20|
        |namer|
        1
        (|RElt| |Struct-runtime-11| |dispatcher| 0 t9)))
    (setq
      t10
      (|CCall| t8 (|RElt| |Struct-runtime-11| |domainRep| 1 t9)))
    (setq t0 (|ANew| |Word| (the |SInt| 2)))
    (|SetAElt| t0 (the |SInt| 0) t6)
    (|SetAElt| t0 (the |SInt| 1) t10)
    (setq t1 nil)
    (setq t3 (the |SInt| 2))
    |Lab0|
    (when (|SIntLE| (the |SInt| 1) t3) (go |Lab1|))
    (setq t5 (|RNew| |Struct-runtime-54|))
    (|SetRElt| |Struct-runtime-54| |tag| 0 t5 (the |SInt| 1))
    (|SetRElt| |Struct-runtime-54| |p| 1 t5 t1)
    (block-return |C108-runtime-rtSingleParamNameFn| t5)
    |Lab1|
    (setq t2 (|RNew| |Struct-runtime-56|))
    (setq t4 (|SIntPrev| t3))
    (|SetRElt| |Struct-runtime-56| |first| 0 t2 (|AElt| t0 t4))
    (|SetRElt| |Struct-runtime-56| |rest| 1 t2 t1)
    (setq t1 t2)
    (setq t3 t4)
    (go |Lab0|)))

(defprog
  ((|C109-runtime-runtime|)
    ((|P0-a| |Word|)
      (|P1-s| |Word|)
      (|P2-i| |Word|)
      (|P3-v1| |Word|)
      (|P4-v2| |Word|)
      (|P5-v3| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C109-runtime-runtime| ()))

(defprog
  ((|C110-runtime-rtDoDebug|)
    ((|P0-a| |Word|)
      (|P1-s| |Word|)
      (|P2-i| |Word|)
      (|P3-v1| |Word|)
      (|P4-v2| |Word|)
      (|P5-v3| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|))
  (setq t0 (|fiGetDebugVar|))
  (|CCall| t0 |P0-a| |P1-s| |P2-i| |P3-v1| |P4-v2| |P5-v3|)
  (block-return |C110-runtime-rtDoDebug| ()))

(defprog
  ((|C111-runtime-rtDebugPaused?| |Word|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C111-runtime-rtDebugPaused?|
    (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|)))

(defprog
  ((|C112-runtime-rtDebugPaused!| |Word|)
    ((|P0-state| |Word|) (|e1| |Env|)))
  ((|T0-result| |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |T0-result| (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|))
  (block-return |C112-runtime-rtDebugPaused!| |T0-result|))

(defprog
  ((|C113-runtime-rtDebugInit| |Word|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-e| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-c| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|) (t1 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t1 (|fiGetDebugger| (the |SInt| 0)))
    (setq t0 (|CCall| t1 |P0-f| |P1-l| |P2-e| |P3-n| |P4-t| |P5-c|))
    (block-return |C113-runtime-rtDebugInit| t0)
    |Lab0|
    (block-return |C113-runtime-rtDebugInit| nil)))

(defprog
  ((|C114-runtime-rtDebugEnter| |Word|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-e| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-c| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|) (t1 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t1 (|fiGetDebugger| (the |SInt| 1)))
    (setq t0 (|CCall| t1 |P0-f| |P1-l| |P2-e| |P3-n| |P4-t| |P5-c|))
    (block-return |C114-runtime-rtDebugEnter| t0)
    |Lab0|
    (block-return |C114-runtime-rtDebugEnter| nil)))

(defprog
  ((|C115-runtime-rtDebugInside|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 2)))
    (|CCall| t0 |P0-x|)
    (block-return |C115-runtime-rtDebugInside| ())
    |Lab0|
    (block-return |C115-runtime-rtDebugInside| ())))

(defprog
  ((|C116-runtime-rtDebugReturn|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-t| |Word|)
      (|P4-v| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 3)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x| |P3-t| |P4-v|)
    (block-return |C116-runtime-rtDebugReturn| ())
    |Lab0|
    (block-return |C116-runtime-rtDebugReturn| ())))

(defprog
  ((|C117-runtime-rtDebugExit|)
    ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 4)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x|)
    (block-return |C117-runtime-rtDebugExit| ())
    |Lab0|
    (block-return |C117-runtime-rtDebugExit| ())))

(defprog
  ((|C118-runtime-rtDebugAssign|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-v| |Word|)
      (|P6-d| |Word|)
      (|P7-c| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 5)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x| |P3-n| |P4-t| |P5-v| |P6-d| |P7-c|)
    (block-return |C118-runtime-rtDebugAssign| ())
    |Lab0|
    (block-return |C118-runtime-rtDebugAssign| ())))

(defprog
  ((|C119-runtime-rtDebugThrow|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-e| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 6)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x| |P3-e|)
    (block-return |C119-runtime-rtDebugThrow| ())
    |Lab0|
    (block-return |C119-runtime-rtDebugThrow| ())))

(defprog
  ((|C120-runtime-rtDebugCatch|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-e| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 7)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x| |P3-e|)
    (block-return |C120-runtime-rtDebugCatch| ())
    |Lab0|
    (block-return |C120-runtime-rtDebugCatch| ())))

(defprog
  ((|C121-runtime-rtDebugCall|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-n| |Word|)
      (|P4-e| |Word|)
      (|P5-t| |Word|)
      (|P6-c| |Word|)
      (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 9)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x| |P3-n| |P4-e| |P5-t| |P6-c|)
    (block-return |C121-runtime-rtDebugCall| ())
    |Lab0|
    (block-return |C121-runtime-rtDebugCall| ())))

(defprog
  ((|C122-runtime-rtDebugStep|)
    ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-51-dbgPaused?-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|fiGetDebugger| (the |SInt| 8)))
    (|CCall| t0 |P0-f| |P1-l| |P2-x|)
    (block-return |C122-runtime-rtDebugStep| ())
    |Lab0|
    (block-return |C122-runtime-rtDebugStep| ())))

(defprog
  ((|C123-runtime-dInit| |Word|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-e| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-c| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C123-runtime-dInit| nil))

(defprog
  ((|C124-runtime-dEnter| |Word|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-e| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-c| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C124-runtime-dEnter| nil))

(defprog
  ((|C125-runtime-dInside|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C125-runtime-dInside| ()))

(defprog
  ((|C126-runtime-dReturn|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-t| |Word|)
      (|P4-v| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C126-runtime-dReturn| ()))

(defprog
  ((|C127-runtime-dExit|)
    ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C127-runtime-dExit| ()))

(defprog
  ((|C128-runtime-dAssign|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-n| |Word|)
      (|P4-t| |Word|)
      (|P5-v| |Word|)
      (|P6-d| |Word|)
      (|P7-c| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C128-runtime-dAssign| ()))

(defprog
  ((|C129-runtime-dThrow|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-e| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C129-runtime-dThrow| ()))

(defprog
  ((|C130-runtime-dCatch|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-e| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C130-runtime-dCatch| ()))

(defprog
  ((|C131-runtime-dCall|)
    ((|P0-f| |Word|)
      (|P1-l| |Word|)
      (|P2-x| |Word|)
      (|P3-n| |Word|)
      (|P4-e| |Word|)
      (|P5-t| |Word|)
      (|P6-c| |Word|)
      (|e1| |Env|)))
  ()
  (block-return |C131-runtime-dCall| ()))

(defprog
  ((|C132-runtime-dStep|)
    ((|P0-f| |Word|) (|P1-l| |Word|) (|P2-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C132-runtime-dStep| ()))

(defprog
  ((|C133-runtime-stringHash| |Word|) ((|P0-s| |Word|) (|e1| |Env|)))
  ()
  (block-return |C133-runtime-stringHash| (|fiStrHash| |P0-s|)))

(defprog
  ((|C134-runtime-rtAssertMessage|)
    ((|P0-file| |Word|)
      (|P1-line| |Word|)
      (|P2-text| |Word|)
      (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |SInt|)
    (t2 |SInt|)
    (t3 |Word|)
    (t4 |SInt|)
    (t5 |Arr|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|))
  (tagbody
    (setq t0 (|ANew| |Word| (the |SInt| 6)))
    (|SetAElt| t0 (the |SInt| 0) (|MakeLit| "Assert failed in "))
    (|SetAElt| t0 (the |SInt| 1) |P0-file|)
    (|SetAElt| t0 (the |SInt| 2) (|MakeLit| ", at line:"))
    (|SetAElt| t0 (the |SInt| 3) (|formatSInt| |P1-line|))
    (|SetAElt| t0 (the |SInt| 4) (|MakeLit| ": "))
    (|SetAElt| t0 (the |SInt| 5) |P2-text|)
    (setq t1 (the |SInt| 0))
    (setq t7 (the |SInt| 1))
    |Lab7|
    (when (|SIntLE| t7 (the |SInt| 6)) (go |Lab8|))
    (setq t5 (|ANew| |Char| (|SIntNext| t1)))
    (|SetAElt| t5 (the |SInt| 0) (the |Char| |CharCode0|))
    (|SetAElt| t5 t1 (the |Char| |CharCode0|))
    (setq t10 (the |SInt| 1))
    |Lab2|
    (when (|SIntLE| t10 t1) (go |Lab3|))
    (setq t1 (the |SInt| 1))
    (setq t6 (the |SInt| 1))
    |Lab4|
    (when (|SIntLE| t6 (the |SInt| 6)) (go |Lab6|))
    (|fiRaiseException| t5)
    (block-return |C134-runtime-rtAssertMessage| ())
    |Lab6|
    (setq t3 (|AElt| t0 (|SIntPrev| t6)))
    (setq t9 (the |SInt| 1))
    (setq t8 t1)
    |Lab1|
    (setq t12 (|SIntPrev| t9))
    (when
      (|CharEQ| (|AElt| t3 t12) (the |Char| |CharCode0|))
      (go |Lab10|))
    (setq t13 (|SIntPrev| t8))
    (when
      (|CharEQ| (|AElt| t5 t13) (the |Char| |CharCode0|))
      (go |Lab11|))
    (|SetAElt| t5 t13 (|AElt| t3 t12))
    (setq t9 (|SIntNext| t9))
    (setq t8 (|SIntNext| t8))
    (go |Lab1|)
    |Lab11|
    (setq t1 t8)
    |Lab5|
    (setq t6 (|SIntNext| t6))
    (go |Lab4|)
    |Lab10|
    (setq t1 t8)
    (go |Lab5|)
    |Lab3|
    (setq t4 (|SIntPrev| t10))
    (|SetAElt| t5 t4 (the |Char| #\Space))
    (setq t10 (|SIntNext| t10))
    (go |Lab2|)
    |Lab8|
    (setq t2 (the |SInt| 1))
    |Lab0|
    (setq t11 (|SIntPrev| t2))
    (when
      (|CharEQ|
        (|AElt| (|AElt| t0 (|SIntPrev| t7)) t11)
        (the |Char| |CharCode0|))
      (go |Lab9|))
    (setq t2 (|SIntNext| t2))
    (go |Lab0|)
    |Lab9|
    (setq t1 (|SIntPlus| t1 t11))
    (setq t7 (|SIntNext| t7))
    (go |Lab7|)))

(defprog
  ((|C135-runtime-lazyGetter2|) ((|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetEnvInfo| |e1| nil)
    |Lab0|
    (block-return |C135-runtime-lazyGetter2| ())))

(defprog
  ((|C136-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C137-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C136-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C137-runtime-lazyGetter| |Word| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (multiple-value-setq
      (t1 t2)
      (|CCall|
        (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
        |P0-a|
        |P1-b|
        |P2-c|))
    (block-return |C137-runtime-lazyGetter| (values t1 t2))))

(defprog
  ((|C138-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C139-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C138-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C139-runtime-lazyGetter| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C139-runtime-lazyGetter|
      (|CCall|
        (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
        |P0-a|
        |P1-b|
        |P2-c|))))

(defprog
  ((|C140-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C141-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C140-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C141-runtime-lazyGetter|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (|CCall|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      |P0-a|
      |P1-b|
      |P2-c|)
    (block-return |C141-runtime-lazyGetter| ())))

(defprog
  ((|C142-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C143-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C142-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C143-runtime-lazyGetter| |Clos|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|P2-c| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C143-runtime-lazyGetter|
      (|CCall|
        (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
        |P0-a|
        |P1-b|
        |P2-c|))))

(defprog
  ((|C144-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C145-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C144-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C145-runtime-lazyGetter| |Word| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (multiple-value-setq
      (t1 t2)
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a| |P1-b|))
    (block-return |C145-runtime-lazyGetter| (values t1 t2))))

(defprog
  ((|C146-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C147-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C146-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C147-runtime-lazyGetter| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C147-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a| |P1-b|))))

(defprog
  ((|C148-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C149-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C148-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C149-runtime-lazyGetter|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a| |P1-b|)
    (block-return |C149-runtime-lazyGetter| ())))

(defprog
  ((|C150-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C151-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C150-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C151-runtime-lazyGetter| |Clos|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C151-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a| |P1-b|))))

(defprog
  ((|C152-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C153-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C152-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C153-runtime-lazyGetter| |Word| |Word|)
    ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (multiple-value-setq
      (t1 t2)
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))
    (block-return |C153-runtime-lazyGetter| (values t1 t2))))

(defprog
  ((|C154-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C155-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C154-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C155-runtime-lazyGetter| |Word|) ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C155-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))))

(defprog
  ((|C156-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C157-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C156-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C157-runtime-lazyGetter|) ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|)
    (block-return |C157-runtime-lazyGetter| ())))

(defprog
  ((|C158-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C159-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C158-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C159-runtime-lazyGetter| |Clos|) ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C159-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))))

(defprog
  ((|C160-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C161-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C160-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C161-runtime-lazyGetter| |Word| |Word|)
    ((|P0-a| |Clos|) (|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (multiple-value-setq
      (t1 t2)
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))
    (block-return |C161-runtime-lazyGetter| (values t1 t2))))

(defprog
  ((|C162-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C163-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C162-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C163-runtime-lazyGetter| |Word|) ((|P0-a| |Clos|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C163-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))))

(defprog
  ((|C164-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C165-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C164-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C165-runtime-lazyGetter|) ((|P0-a| |Clos|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|)
    (block-return |C165-runtime-lazyGetter| ())))

(defprog
  ((|C166-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C167-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C166-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C167-runtime-lazyGetter| |Clos|) ((|P0-a| |Clos|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C167-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|) |P0-a|))))

(defprog
  ((|C168-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C169-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C168-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C169-runtime-lazyGetter| |Word| |Word|) ((|e1| |Env|)))
  ((t0 |Clos|) (t1 |Word|) (t2 |Word|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (multiple-value-setq
      (t1 t2)
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|)))
    (block-return |C169-runtime-lazyGetter| (values t1 t2))))

(defprog
  ((|C170-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C171-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C170-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C171-runtime-lazyGetter| |Word|) ((|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C171-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|)))))

(defprog
  ((|C172-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C173-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C172-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C173-runtime-lazyGetter|) ((|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|))
    (block-return |C173-runtime-lazyGetter| ())))

(defprog
  ((|C174-runtime-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-runtime-50| |Struct-runtime-50|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-runtime-50-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-runtime-50-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-runtime-50-self-2|
    2
    |l0|
    (|Clos| |e0| |C175-runtime-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C135-runtime-lazyGetter2|))
  (block-return
    |C174-runtime-lazyFnGetter|
    (|Lex| |Struct-runtime-50-self-2| 2 |l0|)))

(defprog
  ((|C175-runtime-lazyGetter| |Clos|) ((|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-runtime-50-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-runtime-50-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-runtime-50-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-runtime-50-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C175-runtime-lazyGetter|
      (|CCall| (|Lex| |Struct-runtime-50-self-2| 2 |l1|)))))

(setq |G-runtime| (|Clos| nil |C0-runtime-runtime|))

(setq |G-stringHash| nil)

(setq |G-dInside| nil)

(setq |G-rtLazyCatFrFn| nil)

(setq |G-stringConcat| nil)

(setq |G-rtLazyDomFrFn| nil)

(setq |G-extendMakeDispatch| nil)

(setq |G-stdGetRetClos0| nil)

(setq |G-stdGetRetNOp0| nil)

(setq |G-stdGetRetWord0| nil)

(setq |G-stdGetRetNOp2| nil)

(setq |G-stdGetClosRetClos0| nil)

(setq |G-stdGetClosRetNOp0| nil)

(setq |G-stdGetClosRetWord0| nil)

(setq |G-stdGetClosRetNOp2| nil)

(setq |G-stdGetWordRetClos0| nil)

(setq |G-stdGetWordRetNOp0| nil)

(setq |G-stdGetWordRetWord0| nil)

(setq |G-stdGetWordRetNOp2| nil)

(setq |G-stdGetWordWordRetClos0| nil)

(setq |G-stdGetWordWordRetNOp0| nil)

(setq |G-stdGetWordWordRetWord0| nil)

(setq |G-stdGetWordWordRetNOp2| nil)

(setq |G-stdGetWordWordWordRetClos0| nil)

(setq |G-stdGetWordWordWordRetNOp0| nil)

(setq |G-stdGetWordWordWordRetWord0| nil)

(setq |G-stdGetWordWordWordRetNOp2| nil)

(setq |G-domainMake| nil)

(setq |G-domainMakeDispatch| nil)

(setq |G-domainAddExports!| nil)

(setq |G-domainAddDefaults!| nil)

(setq |G-domainAddParents!| nil)

(setq |G-domainAddHash!| nil)

(setq |G-domainAddNameFn!| nil)

(setq |G-domainGetExport!| nil)

(setq |G-domainTestExport!| nil)

(setq |G-domainHash!| nil)

(setq |G-domainName| nil)

(setq |G-domainMakeDummy| nil)

(setq |G-domainFill!| nil)

(setq |G-categoryAddParents!| nil)

(setq |G-categoryAddNameFn!| nil)

(setq |G-categoryAddExports!| nil)

(setq |G-categoryMake| nil)

(setq |G-categoryBuild| nil)

(setq |G-categoryName| nil)

(setq |G-categoryMakeDummy| nil)

(setq |G-categoryFill!| nil)

(setq |G-noOperation| nil)

(setq |G-extendMake| nil)

(setq |G-extendFill!| nil)

(setq |G-lazyGetExport!| nil)

(setq |G-lazyForceImport| nil)

(setq |G-rtConstSIntFn| nil)

(setq |G-rtAddStrings| nil)

(setq |G-domainPrepare!| nil)

(setq |G-rtCacheMake| nil)

(setq |G-rtCacheExplicitMake| nil)

(setq |G-rtCacheCheck| nil)

(setq |G-rtCacheAdd| nil)

(setq |G-rtCacheDynamicMake| nil)

(setq |G-rtCacheDynamicCheck| nil)

(setq |G-rtCacheDynamicAdd| nil)

(setq |G-rtDelayedInit!| nil)

(setq |G-rtDelayedGetExport!| nil)

(setq |G-rtLazyCatFrInit| nil)

(setq |G-rtLazyDomFrInit| nil)

(setq |G-namePartConcat| nil)

(setq |G-namePartFrOther| nil)

(setq |G-namePartFrString| nil)

(setq |G-rtConstNameFn| nil)

(setq |G-rtSingleParamNameFn| nil)

(setq |G-rtDoDebug| nil)

(setq |G-rtDebugInit| nil)

(setq |G-rtDebugEnter| nil)

(setq |G-rtDebugInside| nil)

(setq |G-rtDebugReturn| nil)

(setq |G-rtDebugExit| nil)

(setq |G-rtDebugAssign| nil)

(setq |G-rtDebugThrow| nil)

(setq |G-rtDebugCatch| nil)

(setq |G-rtDebugCall| nil)

(setq |G-rtDebugStep| nil)

(setq |G-rtDebugPaused?| nil)

(setq |G-rtDebugPaused!| nil)

(setq |G-rtAssertMessage| nil)

(setq |C176-runtime-Domain| nil)

(setq |C177-runtime-DomainRep| nil)

(setq |C178-runtime-PointerDomain| nil)

(setq |C179-runtime-DispatchVector| nil)

(setq |C180-runtime-CatObj| nil)

(setq |C181-runtime-CatRep| nil)

(setq |C182-runtime-PointerCatObj| nil)

(setq |C183-runtime-CatDispatchVector| nil)

(setq |C184-runtime-Box| nil)

(setq |C185-runtime-LazyImport| nil)

(setq |C186-runtime-StringTable| nil)

(setq |C187-runtime-BasicTuple| nil)

(setq |C188-runtime-PtrCache| nil)

(setq |C189-runtime-CacheTable| nil)

(setq |C190-runtime-VariablePtrCache| nil)

(file-imports '())

(file-exports
  '((|G-rtAssertMessage| "rtAssertMessage" 0 "")
      (|G-rtDebugPaused!| "rtDebugPaused!" 0 "")
      (|G-rtDebugPaused?| "rtDebugPaused?" 0 "")
      (|G-rtDebugStep| "rtDebugStep" 0 "")
      (|G-rtDebugCall| "rtDebugCall" 0 "")
      (|G-rtDebugCatch| "rtDebugCatch" 0 "")
      (|G-rtDebugThrow| "rtDebugThrow" 0 "")
      (|G-rtDebugAssign| "rtDebugAssign" 0 "")
      (|G-rtDebugExit| "rtDebugExit" 0 "")
      (|G-rtDebugReturn| "rtDebugReturn" 0 "")
      (|G-rtDebugInside| "rtDebugInside" 0 "")
      (|G-rtDebugEnter| "rtDebugEnter" 0 "")
      (|G-rtDebugInit| "rtDebugInit" 0 "")
      (|G-rtDoDebug| "rtDoDebug" 0 "")
      (|G-rtSingleParamNameFn| "rtSingleParamNameFn" 0 "")
      (|G-rtConstNameFn| "rtConstNameFn" 0 "")
      (|G-namePartFrString| "namePartFrString" 0 "")
      (|G-namePartFrOther| "namePartFrOther" 0 "")
      (|G-namePartConcat| "namePartConcat" 0 "")
      (|G-rtLazyCatFrInit| "rtLazyCatFrInit" 0 "")
      (|G-rtCacheDynamicAdd| "rtCacheDynamicAdd" 0 "")
      (|G-rtCacheDynamicCheck| "rtCacheDynamicCheck" 0 "")
      (|G-rtCacheDynamicMake| "rtCacheDynamicMake" 0 "")
      (|G-rtCacheAdd| "rtCacheAdd" 0 "")
      (|G-rtCacheCheck| "rtCacheCheck" 0 "")
      (|G-rtCacheExplicitMake| "rtCacheExplicitMake" 0 "")
      (|G-rtCacheMake| "rtCacheMake" 0 "")
      (|G-domainPrepare!| "domainPrepare!" 0 "")
      (|G-rtAddStrings| "rtAddStrings" 0 "")
      (|G-rtConstSIntFn| "rtConstSIntFn" 0 "")
      (|G-extendFill!| "extendFill!" 0 "")
      (|G-extendMake| "extendMake" 0 "")
      (|G-categoryFill!| "categoryFill!" 0 "")
      (|G-categoryMakeDummy| "categoryMakeDummy" 0 "")
      (|G-categoryName| "categoryName" 0 "")
      (|G-categoryBuild| "categoryBuild" 0 "")
      (|G-categoryMake| "categoryMake" 0 "")
      (|G-categoryAddExports!| "categoryAddExports!" 0 "")
      (|G-categoryAddNameFn!| "categoryAddNameFn!" 0 "")
      (|G-categoryAddParents!| "categoryAddParents!" 0 "")
      (|G-domainFill!| "domainFill!" 0 "")
      (|G-domainMakeDummy| "domainMakeDummy" 0 "")
      (|G-domainName| "domainName" 0 "")
      (|G-domainHash!| "domainHash!" 0 "")
      (|G-domainTestExport!| "domainTestExport!" 0 "")
      (|G-domainGetExport!| "domainGetExport!" 0 "")
      (|G-domainAddNameFn!| "domainAddNameFn!" 0 "")
      (|G-domainAddHash!| "domainAddHash!" 0 "")
      (|G-domainAddParents!| "domainAddParents!" 0 "")
      (|G-domainAddDefaults!| "domainAddDefaults!" 0 "")
      (|G-domainAddExports!| "domainAddExports!" 0 "")
      (|G-domainMakeDispatch| "domainMakeDispatch" 0 "")
      (|G-domainMake| "domainMake" 0 "")
      (|G-rtDelayedInit!| "rtDelayedInit!" 0 "")
      (|G-lazyForceImport| "lazyForceImport" 0 "")
      (|G-lazyGetExport!| "lazyGetExport!" 0 "")
      (|G-rtDelayedGetExport!| "rtDelayedGetExport!" 0 "")
      (|G-rtLazyDomFrInit| "rtLazyDomFrInit" 0 "")
      (|G-stdGetWordWordWordRetNOp2| "stdGetWordWordWordRetNOp2" 0 "")
      (|G-stdGetWordWordWordRetWord0| "stdGetWordWordWordRetWord0" 0 "")
      (|G-stdGetWordWordWordRetNOp0| "stdGetWordWordWordRetNOp0" 0 "")
      (|G-stdGetWordWordWordRetClos0| "stdGetWordWordWordRetClos0" 0 "")
      (|G-stdGetWordWordRetNOp2| "stdGetWordWordRetNOp2" 0 "")
      (|G-stdGetWordWordRetWord0| "stdGetWordWordRetWord0" 0 "")
      (|G-stdGetWordWordRetNOp0| "stdGetWordWordRetNOp0" 0 "")
      (|G-stdGetWordWordRetClos0| "stdGetWordWordRetClos0" 0 "")
      (|G-stdGetWordRetNOp2| "stdGetWordRetNOp2" 0 "")
      (|G-stdGetWordRetWord0| "stdGetWordRetWord0" 0 "")
      (|G-stdGetWordRetNOp0| "stdGetWordRetNOp0" 0 "")
      (|G-stdGetWordRetClos0| "stdGetWordRetClos0" 0 "")
      (|G-stdGetClosRetNOp2| "stdGetClosRetNOp2" 0 "")
      (|G-stdGetClosRetWord0| "stdGetClosRetWord0" 0 "")
      (|G-stdGetClosRetNOp0| "stdGetClosRetNOp0" 0 "")
      (|G-stdGetClosRetClos0| "stdGetClosRetClos0" 0 "")
      (|G-stdGetRetNOp2| "stdGetRetNOp2" 0 "")
      (|G-stdGetRetWord0| "stdGetRetWord0" 0 "")
      (|G-stdGetRetNOp0| "stdGetRetNOp0" 0 "")
      (|G-stdGetRetClos0| "stdGetRetClos0" 0 "")
      (|G-extendMakeDispatch| "extendMakeDispatch" 0 "")
      (|G-rtLazyDomFrFn| "rtLazyDomFrFn" 0 "")
      (|G-stringConcat| "stringConcat" 0 "")
      (|G-rtLazyCatFrFn| "rtLazyCatFrFn" 0 "")
      (|G-dInside| "dInside" 0 "")
      (|G-stringHash| "stringHash" 0 "")
      (|G-noOperation| "noOperation" 0 "")
      (|G-runtime| "runtime" |initializer| "")))
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
