#ifndef CPUDETECT_H
#define CPUDETECT_H

#define CPUTYPE_I386	3
#define CPUTYPE_I486	4
#define CPUTYPE_I586	5
#define CPUTYPE_I686    6

typedef struct cpu_caps_s {
	int cpu_type;
	int cpu_stepping;
	int has_MMX;
	int has_MMX2;
	int has_3DNow;
	int has_3DNowExt;
	int has_SSE;
	int has_SSE2;
	int is_x86;
} cpu_caps_t;

void mmxnow_get_cpu_caps(cpu_caps_t *caps);

/* returned value is malloc()'ed so free() it after use */
char *mmxnow_get_cpu_name(unsigned int regs[], unsigned int regs2[]);

#endif /* !CPUDETECT_H */

