MACRO(checkQt4)
	IF (NOT QT4_CHECKED)
		OPTION(QT4 "" ON)

		MESSAGE(STATUS "Checking for Qt 4")
		MESSAGE(STATUS "*****************")

		IF (QT4)
			SET(QT_MIN_VERSION 4.5.0)
			
			FIND_PACKAGE(Qt4)	
			STRING(REGEX REPLACE "[\\]" "/" QT_INCLUDES "${QT_INCLUDES}")	# backslashes aren't taken care of properly on Windows
			PRINT_LIBRARY_INFO("Qt 4" QT4_FOUND "${QT_INCLUDES} ${QT_DEFINITIONS}" "${QT_QTCORE_LIBRARY} ${QT_QTGUI_LIBRARY}")

			MARK_AS_ADVANCED(LRELEASE_EXECUTABLE)
			MARK_AS_ADVANCED(QT_MKSPECS_DIR)
			MARK_AS_ADVANCED(QT_PLUGINS_DIR)
			MARK_AS_ADVANCED(QT_QMAKE_EXECUTABLE)
		ELSE (QT4)
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF (QT4)

		IF (QT4_FOUND)
			SET(ADM_UI_QT4 1)
		ELSE (QT4_FOUND)
			SET(ADM_UI_QT4 0)
		ENDIF (QT4_FOUND)

		SET(QT4_CHECKED 1)

		MESSAGE("")
	ENDIF (NOT QT4_CHECKED)
ENDMACRO(checkQt4)