/*
 *      width.c v1.2  - January 21, 1994
 *
 *      Ascii to Postscript translator
 *      fonts widths extracted from the .afm files
 *
 *      Copyright (C) 1995 Paolo Severini {lendl@dist.dist.unige.it}
 *
 *      Permission to use and modify this software and its
 *      documentation for any purpose other than its incorporation
 *      into a commercial product is hereby granted without fee.
 *      Permission to copy and distribute this software and its
 *      documentation only for non-commercial use is also granted
 *      without fee, provided, however, that the above copyright
 *      notice appear in all copies, that both that copyright notice
 *      and this permission notice appear in supporting documentation.
 *      The author makes no representations about the suitability
 *      of this software for any purpose.  It is provided ``as is'',
 *      without express or implied warranty.
 */

char *font_names[]={    "Helvetica", "Helvetica-Oblique",
                        "Helvetica-Bold", "Helvetica-BoldOblique",
                        "Times-Roman", "Times-Italic",
                        "Times-Bold", "Times-BoldItalic",
                        "Palatino-Roman","Palatino-Italic",
                        "Palatino-Bold","Palatino-BoldItalic",
                        "NewCenturySchlbk-Roman","NewCenturySchlbk-Italic",
                        "NewCenturySchlbk-Bold","NewCenturySchlbk-BoldItalic",
                        "CharterBT-Roman","CharterBT-Italic",
                        "CharterBT-Bold","CharterBT-BoldItalic",
                        "AvantGarde-Demi","AvantGarde-DemiOblique",
                        "AvantGarde-Book","AvantGarde-BookOblique",
                        "Bookman-Light","Bookman-LightItalic",
                        "Bookman-Demi","Bookman-DemiItalic",
                        "Utopia-Regular","Utopia-Italic",
                        "Utopia-Bold","Utopia-BoldItalic",   
                        "Courier", "Courier-Italic",
                        "Courier-Bold", "Courier-BoldItalic",
			"Courier", "Courier-Oblique", 
			"Courier-Bold", "Courier-BoldOblique",
                        ""  };

short font_widths[][256]={
{                                               /*Helvetica*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 278, 355, 556, 556, 889, 667, 222, 333, 333, 389, 584, 278, 584, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556,
1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556,
 222, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556,
 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 333, 737, 333,
 420, 584, 333, 333, 333, 333, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611,
 667, 667, 667, 667, 667, 667,1000, 722, 667, 667, 667, 667, 278, 278, 278, 278,
 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611,
 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 584, 611, 556, 556, 556, 556, 500, 556, 500
},

{                                               /*Helvetica-Oblique*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 278, 355, 556, 556, 889, 667, 222, 333, 333, 389, 584, 278, 584, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556,
1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556,
 222, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556,
 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 333, 737, 333,
 420, 584, 333, 333, 333, 333, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611,
 667, 667, 667, 667, 667, 667,1000, 722, 667, 667, 667, 667, 278, 278, 278, 278,
 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611,
 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 584, 611, 556, 556, 556, 556, 500, 556, 500
},

{                                               /*Helvetica-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 333, 474, 556, 556, 889, 722, 278, 333, 333, 389, 584, 278, 584, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611,
 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556,
 278, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611,
 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 333, 737, 333,
 420, 584, 333, 333, 333, 333, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611,
 722, 722, 722, 722, 722, 722,1000, 722, 667, 667, 667, 667, 278, 278, 278, 278,
 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611,
 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
 611, 611, 611, 611, 611, 611, 611, 584, 611, 611, 611, 611, 611, 556, 611, 556
},

{                                               /*Helvetica-BoldOblique*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 333, 474, 556, 556, 889, 722, 278, 333, 333, 389, 584, 278, 584, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611,
 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556,
 278, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611,
 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 333, 737, 333,
 420, 584, 333, 333, 333, 333, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611,
 722, 722, 722, 722, 722, 722,1000, 722, 667, 667, 667, 667, 278, 278, 278, 278,
 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611,
 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
 611, 611, 611, 611, 611, 611, 611, 584, 611, 611, 611, 611, 611, 556, 611, 556
},

{                                               /*Times-Roman*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 333, 408, 500, 500, 833, 778, 333, 333, 333, 500, 564, 250, 564, 250, 278,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 278, 278, 564, 564, 564, 444,
 921, 722, 667, 667, 722, 611, 556, 722, 722, 333, 389, 722, 611, 889, 722, 722,
 556, 722, 667, 556, 611, 722, 722, 944, 722, 722, 611, 333, 278, 333, 469, 500,
 333, 444, 500, 444, 500, 444, 333, 500, 500, 278, 278, 500, 278, 778, 500, 500,
 500, 500, 333, 389, 278, 500, 500, 722, 500, 500, 444, 480, 200, 480, 541,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 500, 500, 500, 500, 200, 500, 333, 760, 276, 500, 564, 333, 760, 333,
 420, 564, 300, 300, 333, 333, 453, 250, 333, 300, 310, 500, 750, 750, 750, 444,
 722, 722, 722, 722, 722, 722, 889, 667, 611, 611, 611, 611, 333, 333, 333, 333,
 722, 722, 722, 722, 722, 722, 722, 564, 722, 722, 722, 722, 722, 722, 556, 500,
 444, 444, 444, 444, 444, 444, 667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
 500, 500, 500, 500, 500, 500, 500, 564, 500, 500, 500, 500, 500, 500, 500, 500
},

{                                               /*Times-Italic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 333, 420, 500, 500, 833, 778, 333, 333, 333, 500, 675, 250, 675, 250, 278,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 675, 675, 675, 500,
 920, 611, 611, 667, 722, 611, 611, 722, 722, 333, 444, 667, 556, 833, 667, 722,
 611, 722, 611, 500, 556, 722, 611, 833, 611, 556, 556, 389, 278, 389, 422, 500,
 333, 500, 500, 444, 500, 444, 278, 500, 500, 278, 278, 444, 278, 722, 500, 500,
 500, 500, 389, 389, 278, 500, 444, 667, 444, 444, 389, 400, 275, 400, 541,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 389, 500, 500, 500, 500, 275, 500, 333, 760, 276, 500, 675, 333, 760, 333,
 420, 675, 300, 300, 333, 333, 523, 250, 333, 300, 310, 500, 750, 750, 750, 500,
 611, 611, 611, 611, 611, 611, 889, 667, 611, 611, 611, 611, 333, 333, 333, 333,
 722, 667, 722, 722, 722, 722, 722, 675, 722, 722, 722, 722, 722, 556, 611, 500,
 500, 500, 500, 500, 500, 500, 667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
 500, 500, 500, 500, 500, 500, 500, 675, 500, 500, 500, 500, 500, 444, 500, 444
},

{                                               /*Times-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 333, 555, 500, 500,1000, 833, 333, 333, 333, 500, 570, 250, 570, 250, 278,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 570, 570, 570, 500,
 930, 722, 667, 722, 722, 667, 611, 778, 778, 389, 500, 778, 667, 944, 722, 778,
 611, 778, 722, 556, 667, 722, 722,1000, 722, 722, 667, 333, 278, 333, 581, 500,
 333, 500, 556, 444, 556, 444, 333, 500, 556, 278, 333, 556, 278, 833, 556, 500,
 556, 556, 444, 389, 333, 556, 500, 722, 500, 500, 444, 394, 220, 394, 520,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 500, 500, 500, 500, 220, 500, 333, 747, 300, 500, 570, 333, 747, 333,
 420, 570, 300, 300, 333, 333, 540, 250, 333, 300, 330, 500, 750, 750, 750, 500,
 722, 722, 722, 722, 722, 722,1000, 722, 667, 667, 667, 667, 389, 389, 389, 389,
 722, 722, 778, 778, 778, 778, 778, 570, 778, 722, 722, 722, 722, 722, 611, 556,
 500, 500, 500, 500, 500, 500, 722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
 500, 556, 500, 500, 500, 500, 500, 570, 500, 556, 556, 556, 556, 500, 556, 500
},

{                                               /*Times-BoldItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 389, 555, 500, 500, 833, 778, 333, 333, 333, 500, 570, 250, 570, 250, 278,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 570, 570, 570, 500,
 832, 667, 667, 667, 722, 667, 667, 722, 778, 389, 500, 667, 611, 889, 722, 722,
 611, 722, 667, 556, 611, 722, 667, 889, 667, 611, 611, 333, 278, 333, 570, 500,
 333, 500, 500, 444, 500, 444, 333, 500, 556, 278, 278, 500, 278, 778, 556, 500,
 500, 500, 389, 389, 278, 556, 444, 667, 500, 444, 389, 348, 220, 348, 570,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 389, 500, 500, 500, 500, 220, 500, 333, 747, 266, 500, 606, 333, 747, 333,
 420, 570, 300, 300, 333, 333, 500, 250, 333, 300, 300, 500, 750, 750, 750, 500,
 667, 667, 667, 667, 667, 667, 944, 667, 667, 667, 667, 667, 389, 389, 389, 389,
 722, 722, 722, 722, 722, 722, 722, 570, 722, 722, 722, 722, 722, 611, 611, 500,
 500, 500, 500, 500, 500, 500, 722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
 500, 556, 500, 500, 500, 500, 500, 570, 500, 556, 556, 556, 556, 444, 500, 444
},

{                                               /*Palatino-Roman*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 278, 371, 500, 500, 840, 778, 278, 333, 333, 389, 606, 250, 606, 250, 606,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 250, 250, 606, 606, 606, 444,
 747, 778, 611, 709, 774, 611, 556, 763, 832, 337, 333, 726, 611, 946, 831, 786,
 604, 786, 668, 525, 613, 778, 722,1000, 667, 667, 667, 333, 606, 333, 606, 500,
 278, 500, 553, 444, 611, 479, 333, 556, 582, 291, 234, 556, 291, 883, 582, 546,
 601, 560, 395, 424, 326, 603, 565, 834, 516, 556, 500, 333, 606, 333, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 278, 500, 500, 500, 500, 606, 500, 333, 747, 333, 500, 606, 333, 747, 333,
 400, 606, 300, 300, 333, 603, 628, 250, 333, 300, 333, 500, 750, 750, 750, 444,
 778, 778, 778, 778, 778, 778, 944, 709, 611, 611, 611, 611, 337, 337, 337, 337,
 774, 831, 786, 786, 786, 786, 786, 606, 833, 778, 778, 778, 778, 667, 604, 556,
 500, 500, 500, 500, 500, 500, 758, 444, 479, 479, 479, 479, 287, 287, 287, 287,
 546, 582, 546, 546, 546, 546, 546, 606, 556, 603, 603, 603, 603, 556, 601, 556
},

{                                               /*Palatino-Italic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 333, 500, 500, 500, 889, 778, 278, 333, 333, 389, 606, 250, 606, 250, 296,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 250, 250, 606, 606, 606, 500,
 747, 722, 611, 667, 778, 611, 556, 722, 778, 333, 333, 667, 556, 944, 778, 778,
 611, 778, 667, 556, 611, 778, 722, 944, 722, 667, 667, 333, 606, 333, 606, 500,
 278, 444, 463, 407, 500, 389, 278, 500, 500, 278, 278, 444, 278, 778, 556, 444,
 500, 463, 389, 389, 333, 556, 500, 722, 500, 500, 444, 333, 606, 333, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 500, 500, 500, 500, 606, 500, 333, 747, 333, 500, 606, 333, 747, 333,
 400, 606, 300, 300, 333, 556, 500, 250, 333, 300, 333, 500, 750, 750, 750, 500,
 722, 722, 722, 722, 722, 722, 941, 667, 611, 611, 611, 611, 333, 333, 333, 333,
 778, 778, 778, 778, 778, 778, 778, 606, 778, 778, 778, 778, 778, 667, 611, 500,
 444, 444, 444, 444, 444, 444, 638, 407, 389, 389, 389, 389, 278, 278, 278, 278,
 444, 556, 444, 444, 444, 444, 444, 606, 444, 556, 556, 556, 556, 500, 500, 500
},

{                                               /*Palatino-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 278, 402, 500, 500, 889, 833, 278, 333, 333, 444, 606, 250, 606, 250, 296,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 250, 250, 606, 606, 606, 444,
 747, 778, 667, 722, 833, 611, 556, 833, 833, 389, 389, 778, 611,1000, 833, 833,
 611, 833, 722, 611, 667, 778, 778,1000, 667, 667, 667, 333, 606, 333, 606, 500,
 278, 500, 611, 444, 611, 500, 389, 556, 611, 333, 333, 611, 333, 889, 611, 556,
 611, 611, 389, 444, 333, 611, 556, 833, 500, 556, 500, 310, 606, 310, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 278, 500, 500, 500, 500, 606, 500, 333, 747, 438, 500, 606, 333, 747, 333,
 400, 606, 300, 300, 333, 611, 641, 250, 333, 300, 488, 500, 750, 750, 750, 444,
 778, 778, 778, 778, 778, 778,1000, 722, 611, 611, 611, 611, 389, 389, 389, 389,
 833, 833, 833, 833, 833, 833, 833, 606, 833, 778, 778, 778, 778, 667, 611, 611,
 500, 500, 500, 500, 500, 500, 778, 444, 500, 500, 500, 500, 333, 333, 333, 333,
 556, 611, 556, 556, 556, 556, 556, 606, 556, 611, 611, 611, 611, 556, 611, 556
},

{                                               /*Palatino-BoldItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 250, 333, 500, 500, 500, 889, 833, 278, 333, 333, 444, 606, 250, 606, 250, 315,
 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 250, 250, 606, 606, 606, 444,
 833, 722, 667, 685, 778, 611, 556, 778, 778, 389, 389, 722, 611, 944, 778, 833,
 667, 833, 722, 556, 611, 778, 667,1000, 722, 611, 667, 333, 606, 333, 606, 500,
 278, 556, 537, 444, 556, 444, 333, 500, 556, 333, 333, 556, 333, 833, 556, 556,
 556, 537, 389, 444, 389, 556, 556, 833, 500, 556, 500, 333, 606, 333, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 500, 500, 500, 500, 606, 556, 333, 747, 333, 500, 606, 389, 747, 333,
 400, 606, 300, 300, 333, 556, 556, 250, 333, 300, 333, 500, 750, 750, 750, 444,
 722, 722, 722, 722, 722, 722, 944, 685, 611, 611, 611, 611, 389, 389, 389, 389,
 778, 778, 833, 833, 833, 833, 833, 606, 833, 778, 778, 778, 778, 611, 667, 556,
 556, 556, 556, 556, 556, 556, 738, 444, 444, 444, 444, 444, 333, 333, 333, 333,
 556, 556, 556, 556, 556, 556, 556, 606, 556, 556, 556, 556, 556, 556, 556, 556
},

{                                               /*NewCenturySchlbk-Roman*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 296, 389, 556, 556, 833, 815, 204, 333, 333, 500, 606, 278, 606, 278, 278,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 606, 606, 606, 444,
 737, 722, 722, 722, 778, 722, 667, 778, 833, 407, 556, 778, 667, 944, 815, 778,
 667, 778, 722, 630, 667, 815, 722, 981, 704, 704, 611, 333, 606, 333, 606, 500,
 204, 556, 556, 444, 574, 500, 333, 537, 611, 315, 296, 593, 315, 889, 611, 500,
 574, 556, 444, 463, 389, 611, 537, 778, 537, 537, 481, 333, 606, 333, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 296, 556, 556, 556, 556, 606, 500, 333, 737, 334, 426, 606, 333, 737, 333,
 400, 606, 333, 333, 333, 611, 606, 278, 333, 333, 300, 426, 834, 834, 834, 444,
 722, 722, 722, 722, 722, 722,1000, 722, 722, 722, 722, 722, 407, 407, 407, 407,
 778, 815, 778, 778, 778, 778, 778, 606, 778, 815, 815, 815, 815, 704, 667, 574,
 556, 556, 556, 556, 556, 556, 796, 444, 500, 500, 500, 500, 315, 315, 315, 315,
 500, 611, 500, 500, 500, 500, 500, 606, 500, 611, 611, 611, 611, 537, 574, 537
},

{                                               /*NewCenturySchlbk-Italic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 333, 400, 556, 556, 833, 852, 204, 333, 333, 500, 606, 278, 606, 278, 606,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 606, 606, 606, 444,
 747, 704, 722, 722, 778, 722, 667, 778, 833, 407, 611, 741, 667, 944, 815, 778,
 667, 778, 741, 667, 685, 815, 704, 926, 704, 685, 667, 333, 606, 333, 606, 500,
 204, 574, 556, 444, 611, 444, 333, 537, 611, 333, 315, 556, 333, 889, 611, 500,
 574, 556, 444, 444, 352, 611, 519, 778, 500, 500, 463, 333, 606, 333, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 556, 556, 556, 556, 606, 500, 333, 747, 422, 426, 606, 333, 747, 333,
 400, 606, 333, 333, 333, 611, 650, 278, 333, 333, 372, 426, 834, 834, 834, 444,
 704, 704, 704, 704, 704, 704, 870, 722, 722, 722, 722, 722, 407, 407, 407, 407,
 778, 815, 778, 778, 778, 778, 778, 606, 778, 815, 815, 815, 815, 685, 667, 556,
 574, 574, 574, 574, 574, 574, 722, 444, 444, 444, 444, 444, 333, 333, 333, 333,
 500, 611, 500, 500, 500, 500, 500, 606, 500, 611, 611, 611, 611, 500, 574, 500
},

{                                               /*NewCenturySchlbk-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 287, 296, 333, 574, 574, 833, 852, 241, 389, 389, 500, 606, 278, 606, 278, 278,
 574, 574, 574, 574, 574, 574, 574, 574, 574, 574, 278, 278, 606, 606, 606, 500,
 747, 759, 778, 778, 833, 759, 722, 833, 870, 444, 648, 815, 722, 981, 833, 833,
 759, 833, 815, 667, 722, 833, 759, 981, 722, 722, 667, 389, 606, 389, 606, 500,
 241, 611, 648, 556, 667, 574, 389, 611, 685, 370, 352, 667, 352, 963, 685, 611,
 667, 648, 519, 500, 426, 685, 611, 889, 611, 611, 537, 389, 606, 389, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 296, 574, 574, 574, 574, 606, 500, 333, 747, 367, 500, 606, 333, 747, 333,
 400, 606, 344, 344, 333, 685, 747, 278, 333, 344, 367, 500, 861, 861, 861, 500,
 759, 759, 759, 759, 759, 759, 981, 778, 759, 759, 759, 759, 444, 444, 444, 444,
 833, 833, 833, 833, 833, 833, 833, 606, 833, 833, 833, 833, 833, 722, 759, 611,
 611, 611, 611, 611, 611, 611, 870, 556, 574, 574, 574, 574, 370, 370, 370, 370,
 611, 685, 611, 611, 611, 611, 611, 606, 611, 685, 685, 685, 685, 611, 667, 611
},

{                                               /*NewCenturySchlbk-BoldItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 287, 333, 400, 574, 574, 889, 889, 259, 407, 407, 500, 606, 287, 606, 287, 278,
 574, 574, 574, 574, 574, 574, 574, 574, 574, 574, 287, 287, 606, 606, 606, 481,
 747, 741, 759, 759, 833, 741, 704, 815, 870, 444, 667, 778, 704, 944, 852, 833,
 741, 833, 796, 685, 722, 833, 741, 944, 741, 704, 704, 407, 606, 407, 606, 500,
 259, 667, 611, 537, 667, 519, 389, 611, 685, 389, 370, 648, 389, 944, 685, 574,
 648, 630, 519, 481, 407, 685, 556, 833, 574, 519, 519, 407, 606, 407, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 333, 574, 574, 574, 574, 606, 500, 333, 747, 412, 481, 606, 333, 747, 333,
 400, 606, 344, 344, 333, 685, 650, 287, 333, 344, 356, 481, 861, 861, 861, 481,
 741, 741, 741, 741, 741, 741, 889, 759, 741, 741, 741, 741, 444, 444, 444, 444,
 833, 852, 833, 833, 833, 833, 833, 606, 833, 833, 833, 833, 833, 704, 741, 574,
 667, 667, 667, 667, 667, 667, 815, 537, 519, 519, 519, 519, 389, 389, 389, 389,
 574, 685, 574, 574, 574, 574, 574, 606, 574, 685, 685, 685, 685, 519, 648, 519
},

{                                               /*CharterBT-Roman*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 338, 331, 745, 556, 852, 704, 201, 417, 417, 500, 833, 278, 833, 278, 481,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 319, 319, 833, 833, 833, 486,
 942, 639, 604, 632, 693, 576, 537, 694, 738, 324, 444, 611, 520, 866, 713, 731,
 558, 731, 646, 556, 597, 694, 618, 928, 600, 586, 586, 421, 481, 421,1000, 500,
 201, 507, 539, 446, 565, 491, 321, 523, 564, 280, 266, 517, 282, 843, 568, 539,
 551, 531, 382, 400, 334, 569, 494, 771, 503, 495, 468, 486, 500, 486, 833,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 338, 556, 556, 606, 556, 500, 500, 500, 900, 380, 442, 833, 319, 900, 500,
 329, 833, 367, 367, 500, 547, 484, 278, 500, 367, 404, 442, 867, 867, 868, 486,
 639, 639, 639, 639, 639, 639, 866, 632, 576, 576, 576, 576, 324, 324, 324, 324,
 693, 713, 731, 731, 731, 731, 731, 833, 731, 694, 694, 694, 694, 586, 558, 609,
 507, 507, 507, 507, 507, 507, 725, 446, 491, 491, 491, 491, 280, 280, 280, 280,
 528, 568, 539, 539, 539, 539, 539, 833, 539, 569, 569, 569, 569, 495, 551, 495
},

{                                               /*CharterBT-Italic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 278, 338, 331, 745, 556, 852, 704, 201, 419, 419, 500, 833, 278, 833, 278, 481,
 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 319, 319, 833, 833, 833, 486,
 942, 606, 588, 604, 671, 546, 509, 664, 712, 312, 447, 625, 498, 839, 683, 708,
 542, 708, 602, 537, 565, 664, 590, 898, 569, 562, 556, 421, 481, 421,1000, 500,
 201, 525, 507, 394, 523, 424, 292, 481, 551, 287, 269, 514, 275, 815, 556, 502,
 516, 512, 398, 370, 333, 553, 454, 713, 477, 475, 440, 486, 500, 486, 833,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 338, 556, 556, 606, 556, 500, 500, 500, 900, 394, 442, 833, 319, 900, 500,
 329, 833, 367, 367, 500, 547, 484, 278, 500, 367, 377, 442, 867, 867, 868, 486,
 606, 606, 606, 606, 606, 606, 873, 604, 546, 546, 546, 546, 312, 312, 312, 312,
 671, 683, 708, 708, 708, 708, 708, 833, 708, 664, 664, 664, 664, 562, 532, 574,
 525, 525, 525, 525, 525, 525, 671, 394, 424, 424, 424, 424, 287, 287, 287, 287,
 500, 556, 502, 502, 502, 502, 502, 833, 502, 553, 553, 553, 553, 475, 516, 475
},

{                                               /*CharterBT-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 291, 340, 339, 736, 581, 888, 741, 255, 428, 428, 500, 833, 289, 833, 289, 491,
 581, 581, 581, 581, 581, 581, 581, 581, 581, 581, 340, 340, 833, 833, 833, 487,
 917, 651, 628, 638, 716, 596, 552, 710, 760, 354, 465, 650, 543, 883, 727, 752,
 587, 752, 671, 568, 603, 705, 635, 946, 637, 610, 592, 443, 491, 443,1000, 500,
 255, 544, 577, 476, 596, 524, 341, 551, 597, 305, 297, 553, 304, 892, 605, 577,
 591, 575, 421, 447, 358, 600, 513, 799, 531, 515, 495, 493, 500, 493, 833,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 340, 581, 581, 606, 595, 500, 500, 500, 876, 408, 449, 833, 326, 876, 500,
 329, 833, 383, 383, 500, 578, 491, 289, 500, 383, 433, 449, 899, 899, 899, 487,
 651, 651, 651, 651, 651, 651, 890, 638, 596, 596, 596, 596, 354, 354, 354, 354,
 716, 727, 752, 752, 752, 752, 752, 833, 752, 705, 705, 705, 705, 610, 587, 642,
 544, 544, 544, 544, 544, 544, 768, 476, 524, 524, 524, 524, 305, 305, 305, 305,
 569, 605, 577, 577, 577, 577, 577, 833, 577, 600, 600, 600, 600, 515, 591, 515
},

{                                               /*CharterBT-BoldItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 293, 340, 339, 751, 586, 898, 730, 261, 420, 420, 500, 833, 292, 833, 294, 481,
 586, 586, 586, 586, 586, 586, 586, 586, 586, 586, 346, 346, 833, 833, 833, 492,
 936, 634, 628, 625, 702, 581, 539, 693, 747, 353, 474, 653, 529, 894, 712, 729,
 581, 729, 645, 553, 584, 701, 617, 921, 608, 586, 572, 449, 481, 449,1000, 500,
 261, 572, 556, 437, 579, 464, 325, 517, 595, 318, 297, 559, 307, 883, 600, 550,
 565, 562, 449, 403, 366, 599, 492, 768, 510, 494, 465, 487, 500, 487, 833,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 340, 586, 586, 606, 601, 500, 500, 500, 894, 429, 450, 833, 320, 894, 500,
 329, 833, 387, 387, 500, 578, 492, 292, 500, 387, 413, 450, 905, 905, 905, 492,
 634, 634, 634, 634, 634, 634, 894, 625, 581, 581, 581, 581, 353, 353, 353, 353,
 702, 712, 729, 729, 729, 729, 729, 833, 729, 701, 701, 701, 701, 586, 576, 622,
 572, 572, 572, 572, 572, 572, 719, 437, 464, 464, 464, 464, 318, 318, 318, 318,
 561, 600, 550, 550, 550, 550, 550, 833, 550, 599, 599, 599, 599, 494, 565, 494
},

{                                               /*AvantGarde-Demi*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 280, 280, 360, 560, 560, 860, 680, 280, 380, 380, 440, 600, 280, 600, 280, 460,
 560, 560, 560, 560, 560, 560, 560, 560, 560, 560, 280, 280, 600, 600, 600, 560,
 740, 740, 580, 780, 700, 520, 480, 840, 680, 280, 480, 620, 440, 900, 740, 840,
 560, 840, 580, 520, 420, 640, 700, 900, 680, 620, 500, 320, 640, 320, 600, 500,
 280, 660, 660, 640, 660, 640, 280, 660, 600, 240, 260, 580, 240, 940, 600, 640,
 660, 660, 320, 440, 300, 600, 560, 800, 560, 580, 460, 340, 600, 340, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 280, 560, 560, 560, 560, 600, 560, 500, 740, 360, 460, 600, 420, 740, 420,
 400, 600, 336, 336, 420, 576, 600, 280, 340, 336, 360, 460, 840, 840, 840, 560,
 740, 740, 740, 740, 740, 740, 900, 780, 520, 520, 520, 520, 280, 280, 280, 280,
 742, 740, 840, 840, 840, 840, 840, 600, 840, 640, 640, 640, 640, 620, 560, 600,
 660, 660, 660, 660, 660, 660,1080, 640, 640, 640, 640, 640, 240, 240, 240, 240,
 640, 600, 640, 640, 640, 640, 640, 600, 660, 600, 600, 600, 600, 580, 660, 580
},

{                                               /*AvantGarde-DemiOblique*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 280, 280, 360, 560, 560, 860, 680, 280, 380, 380, 440, 600, 280, 600, 280, 460,
 560, 560, 560, 560, 560, 560, 560, 560, 560, 560, 280, 280, 600, 600, 600, 560,
 740, 740, 580, 780, 700, 520, 480, 840, 680, 280, 480, 620, 440, 900, 740, 840,
 560, 840, 580, 520, 420, 640, 700, 900, 680, 620, 500, 320, 640, 320, 600, 500,
 280, 660, 660, 640, 660, 640, 280, 660, 600, 240, 260, 580, 240, 940, 600, 640,
 660, 660, 320, 440, 300, 600, 560, 800, 560, 580, 460, 340, 600, 340, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 280, 560, 560, 560, 560, 600, 560, 500, 740, 360, 460, 600, 420, 740, 420,
 400, 600, 336, 336, 420, 576, 600, 280, 340, 336, 360, 460, 840, 840, 840, 560,
 740, 740, 740, 740, 740, 740, 900, 780, 520, 520, 520, 520, 280, 280, 280, 280,
 742, 740, 840, 840, 840, 840, 840, 600, 840, 640, 640, 640, 640, 620, 560, 600,
 660, 660, 660, 660, 660, 660,1080, 640, 640, 640, 640, 640, 240, 240, 240, 240,
 640, 600, 640, 640, 640, 640, 640, 600, 660, 600, 600, 600, 600, 580, 660, 580
},

{                                               /*AvantGarde-Book*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 277, 295, 309, 554, 554, 775, 757, 351, 369, 369, 425, 606, 277, 606, 277, 437,
 554, 554, 554, 554, 554, 554, 554, 554, 554, 554, 277, 277, 606, 606, 606, 591,
 867, 740, 574, 813, 744, 536, 485, 872, 683, 226, 482, 591, 462, 919, 740, 869,
 592, 871, 607, 498, 426, 655, 702, 960, 609, 592, 480, 351, 605, 351, 606, 500,
 351, 683, 682, 647, 685, 650, 314, 673, 610, 200, 203, 502, 200, 938, 610, 655,
 682, 682, 301, 388, 339, 608, 554, 831, 480, 536, 425, 351, 672, 351, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 295, 554, 554, 554, 554, 672, 615, 369, 747, 369, 425, 606, 332, 747, 485,
 400, 606, 332, 332, 375, 608, 564, 277, 324, 332, 369, 425, 831, 831, 831, 591,
 740, 740, 740, 740, 740, 740, 992, 813, 536, 536, 536, 536, 226, 226, 226, 226,
 790, 740, 869, 869, 869, 869, 869, 606, 868, 655, 655, 655, 655, 592, 592, 554,
 683, 683, 683, 683, 683, 683,1157, 647, 650, 650, 650, 650, 200, 200, 200, 200,
 655, 610, 655, 655, 655, 655, 655, 606, 653, 608, 608, 608, 608, 536, 682, 536
},

{                                               /*AvantGarde-BookOblique*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 277, 295, 309, 554, 554, 775, 757, 351, 369, 369, 425, 606, 277, 606, 277, 437,
 554, 554, 554, 554, 554, 554, 554, 554, 554, 554, 277, 277, 606, 606, 606, 591,
 867, 740, 574, 813, 744, 536, 485, 872, 683, 226, 482, 591, 462, 919, 740, 869,
 592, 871, 607, 498, 426, 655, 702, 960, 609, 592, 480, 351, 605, 351, 606, 500,
 351, 683, 682, 647, 685, 650, 314, 673, 610, 200, 203, 502, 200, 938, 610, 655,
 682, 682, 301, 388, 339, 608, 554, 831, 480, 536, 425, 351, 672, 351, 606,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 295, 554, 554, 554, 554, 672, 615, 369, 747, 369, 425, 606, 332, 747, 485,
 400, 606, 332, 332, 375, 608, 564, 277, 324, 332, 369, 425, 831, 831, 831, 591,
 740, 740, 740, 740, 740, 740, 992, 813, 536, 536, 536, 536, 226, 226, 226, 226,
 790, 740, 869, 869, 869, 869, 869, 606, 868, 655, 655, 655, 655, 592, 592, 554,
 683, 683, 683, 683, 683, 683,1157, 647, 650, 650, 650, 650, 200, 200, 200, 200,
 655, 610, 655, 655, 655, 655, 655, 606, 653, 608, 608, 608, 608, 536, 682, 536
},

{                                               /*Bookman-Light*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 320, 300, 380, 620, 620, 900, 800, 220, 300, 300, 440, 600, 320, 600, 320, 600,
 620, 620, 620, 620, 620, 620, 620, 620, 620, 620, 320, 320, 600, 600, 600, 540,
 820, 680, 740, 740, 800, 720, 640, 800, 800, 340, 600, 720, 600, 920, 740, 800,
 620, 820, 720, 660, 620, 780, 700, 960, 720, 640, 640, 300, 600, 300, 600, 500,
 220, 580, 620, 520, 620, 520, 320, 540, 660, 300, 300, 620, 300, 940, 660, 560,
 620, 580, 440, 520, 380, 680, 520, 780, 560, 540, 480, 280, 600, 280, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 300, 620, 620, 620, 620, 600, 520, 420, 740, 420, 360, 600, 400, 740, 440,
 400, 600, 372, 372, 340, 680, 600, 320, 320, 372, 420, 360, 930, 930, 930, 540,
 680, 680, 680, 680, 680, 680,1260, 740, 720, 720, 720, 720, 340, 340, 340, 340,
 800, 740, 800, 800, 800, 800, 800, 600, 800, 780, 780, 780, 780, 640, 620, 660,
 580, 580, 580, 580, 580, 580, 860, 520, 520, 520, 520, 520, 300, 300, 300, 300,
 560, 660, 560, 560, 560, 560, 560, 600, 560, 680, 680, 680, 680, 540, 620, 540
},

{                                               /*Bookman-LightItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 300, 320, 360, 620, 620, 800, 820, 280, 280, 280, 440, 600, 300, 600, 300, 600,
 620, 620, 620, 620, 620, 620, 620, 620, 620, 620, 300, 300, 600, 600, 600, 540,
 780, 700, 720, 720, 740, 680, 620, 760, 800, 320, 560, 720, 580, 860, 720, 760,
 600, 780, 700, 640, 600, 720, 680, 960, 700, 660, 580, 260, 600, 260, 600, 500,
 280, 620, 600, 480, 640, 540, 340, 560, 620, 280, 280, 600, 280, 880, 620, 540,
 600, 560, 400, 540, 340, 620, 540, 880, 540, 600, 520, 360, 600, 380, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 320, 620, 620, 620, 620, 600, 620, 420, 740, 440, 300, 600, 320, 740, 440,
 400, 600, 372, 372, 320, 620, 620, 300, 320, 372, 400, 300, 930, 930, 930, 540,
 700, 700, 700, 700, 700, 700,1220, 720, 680, 680, 680, 680, 320, 320, 320, 320,
 740, 720, 760, 760, 760, 760, 760, 600, 760, 720, 720, 720, 720, 660, 600, 620,
 620, 620, 620, 620, 620, 620, 880, 480, 540, 540, 540, 540, 280, 280, 280, 280,
 540, 620, 540, 540, 540, 540, 540, 600, 540, 620, 620, 620, 620, 600, 600, 600
},

{                                               /*Bookman-Demi*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 340, 360, 420, 660, 660, 940, 800, 320, 320, 320, 460, 600, 340, 600, 340, 600,
 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 340, 340, 600, 600, 600, 660,
 820, 720, 720, 740, 780, 720, 680, 780, 820, 400, 640, 800, 640, 940, 740, 800,
 660, 800, 780, 660, 700, 740, 720, 940, 780, 700, 640, 300, 600, 300, 600, 500,
 320, 580, 600, 580, 640, 580, 380, 580, 680, 360, 340, 660, 340,1000, 680, 620,
 640, 620, 460, 520, 460, 660, 600, 800, 600, 620, 560, 320, 600, 320, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 360, 660, 660, 660, 660, 600, 600, 500, 740, 400, 400, 600, 360, 740, 460,
 400, 600, 396, 396, 400, 660, 800, 340, 360, 396, 400, 400, 990, 990, 990, 660,
 720, 720, 720, 720, 720, 720,1140, 740, 720, 720, 720, 720, 400, 400, 400, 400,
 780, 740, 800, 800, 800, 800, 800, 600, 800, 740, 740, 740, 740, 700, 660, 660,
 580, 580, 580, 580, 580, 580, 880, 580, 580, 580, 580, 580, 360, 360, 360, 360,
 620, 680, 620, 620, 620, 620, 620, 600, 620, 660, 660, 660, 660, 620, 640, 620
},

{                                               /*Bookman-DemiItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 340, 320, 380, 680, 680, 880, 980, 320, 260, 260, 460, 600, 340, 600, 340, 360,
 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 340, 340, 620, 600, 620, 620,
 780, 720, 720, 700, 760, 720, 660, 760, 800, 380, 620, 780, 640, 860, 740, 760,
 640, 760, 740, 700, 700, 740, 660,1000, 740, 660, 680, 260, 580, 260, 620, 500,
 320, 680, 600, 560, 680, 560, 420, 620, 700, 380, 320, 700, 380, 960, 680, 600,
 660, 620, 500, 540, 440, 680, 540, 860, 620, 600, 560, 300, 620, 300, 620,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 320, 680, 680, 680, 680, 620, 620, 520, 780, 440, 380, 620, 280, 780, 480,
 400, 600, 408, 408, 340, 680, 680, 340, 360, 408, 440, 380,1020,1020,1020, 620,
 720, 720, 720, 720, 720, 720,1140, 700, 720, 720, 720, 720, 380, 380, 380, 380,
 760, 740, 760, 760, 760, 760, 760, 600, 760, 740, 740, 740, 740, 660, 640, 660,
 680, 680, 680, 680, 680, 680, 880, 560, 560, 560, 560, 560, 380, 380, 380, 380,
 600, 680, 600, 600, 600, 600, 600, 600, 600, 680, 680, 680, 680, 600, 660, 600
},

{                                               /*Utopia-Regular*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 225, 242, 458, 530, 530, 838, 706, 278, 350, 350, 412, 570, 265, 570, 265, 460,
 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 265, 265, 570, 570, 570, 389,
 793, 635, 646, 684, 779, 606, 580, 734, 798, 349, 350, 658, 568, 944, 780, 762,
 600, 762, 644, 541, 621, 791, 634, 940, 624, 588, 610, 330, 460, 330, 570, 500,
 278, 523, 598, 496, 598, 514, 319, 520, 607, 291, 280, 524, 279, 923, 619, 577,
 608, 591, 389, 436, 344, 606, 504, 768, 486, 506, 480, 340, 228, 340, 570,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 242, 530, 530, 530, 530, 228, 554, 400, 818, 390, 442, 570, 400, 818, 400,
 350, 570, 380, 380, 400, 606, 555, 265, 400, 380, 398, 442, 860, 860, 860, 389,
 635, 635, 635, 635, 635, 627, 876, 680, 606, 606, 606, 606, 349, 349, 349, 349,
 785, 780, 762, 762, 762, 762, 762, 570, 762, 791, 791, 791, 791, 588, 593, 601,
 523, 523, 523, 523, 523, 523, 797, 496, 514, 514, 514, 514, 291, 291, 291, 291,
 577, 619, 577, 577, 577, 577, 577, 570, 577, 606, 606, 606, 606, 506, 606, 506
},

{                                               /*Utopia-Italic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 225, 240, 402, 530, 530, 826, 725, 216, 350, 350, 412, 570, 265, 570, 265, 270,
 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 265, 265, 570, 570, 570, 425,
 794, 624, 632, 661, 763, 596, 571, 709, 775, 345, 352, 650, 565, 920, 763, 753,
 614, 753, 640, 533, 606, 794, 637, 946, 632, 591, 622, 330, 390, 330, 570, 500,
 216, 561, 559, 441, 587, 453, 315, 499, 607, 317, 309, 545, 306, 912, 618, 537,
 590, 559, 402, 389, 341, 618, 510, 785, 516, 468, 468, 340, 270, 340, 570,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 240, 530, 530, 530, 530, 270, 530, 400, 836, 425, 462, 570, 400, 836, 400,
 400, 570, 370, 370, 400, 618, 560, 265, 400, 370, 389, 462, 890, 890, 890, 425,
 624, 624, 624, 624, 624, 624, 880, 661, 596, 596, 596, 596, 345, 345, 345, 345,
 770, 763, 753, 753, 753, 753, 753, 570, 753, 794, 794, 794, 794, 591, 604, 577,
 561, 561, 561, 561, 561, 561, 779, 441, 453, 453, 453, 453, 317, 317, 317, 317,
 537, 618, 537, 537, 537, 537, 537, 570, 537, 618, 618, 618, 618, 468, 584, 468
},

{                                               /*Utopia-Bold*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 210, 278, 473, 560, 560, 887, 748, 252, 365, 365, 442, 600, 280, 600, 280, 378,
 560, 560, 560, 560, 560, 560, 560, 560, 560, 560, 280, 280, 600, 600, 600, 456,
 833, 644, 683, 689, 777, 629, 593, 726, 807, 384, 386, 707, 585, 918, 739, 768,
 650, 768, 684, 561, 624, 786, 645, 933, 634, 617, 614, 335, 379, 335, 600, 500,
 252, 544, 605, 494, 605, 519, 342, 533, 631, 316, 316, 582, 309, 948, 638, 585,
 615, 597, 440, 446, 370, 629, 520, 774, 522, 524, 483, 365, 284, 365, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 278, 560, 560, 560, 560, 284, 566, 430, 800, 405, 487, 600, 430, 800, 430,
 396, 600, 402, 402, 430, 629, 552, 280, 430, 402, 427, 487, 900, 900, 900, 456,
 644, 644, 644, 644, 644, 644, 879, 689, 629, 629, 629, 629, 384, 384, 384, 384,
 783, 739, 768, 768, 768, 768, 768, 600, 768, 786, 786, 786, 786, 617, 640, 662,
 544, 544, 544, 544, 544, 544, 806, 494, 519, 519, 519, 519, 316, 316, 316, 316,
 585, 638, 585, 585, 585, 585, 585, 600, 585, 629, 629, 629, 629, 524, 609, 524
},

{                                               /*Utopia-BoldItalic*/
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 210, 285, 455, 560, 560, 896, 752, 246, 350, 350, 500, 600, 280, 600, 280, 260,
 560, 560, 560, 560, 560, 560, 560, 560, 560, 560, 280, 280, 600, 600, 600, 454,
 828, 634, 680, 672, 774, 622, 585, 726, 800, 386, 388, 688, 586, 921, 741, 761,
 660, 761, 681, 551, 616, 776, 630, 920, 630, 622, 618, 350, 460, 350, 600, 500,
 246, 596, 586, 456, 609, 476, 348, 522, 629, 339, 333, 570, 327, 914, 635, 562,
 606, 584, 440, 417, 359, 634, 518, 795, 516, 489, 466, 340, 265, 340, 600,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 285, 560, 560, 560, 560, 265, 568, 400, 824, 444, 560, 600, 400, 824, 400,
 375, 600, 402, 402, 400, 634, 580, 280, 400, 402, 412, 560, 940, 940, 940, 454,
 634, 634, 634, 634, 634, 634, 890, 672, 622, 622, 622, 622, 386, 386, 386, 386,
 780, 741, 761, 761, 761, 761, 761, 600, 761, 776, 776, 776, 776, 622, 629, 628,
 596, 596, 596, 596, 596, 596, 789, 456, 476, 476, 476, 476, 339, 339, 339, 339,
 562, 635, 562, 562, 562, 562, 562, 600, 562, 634, 634, 634, 634, 489, 600, 489
}

};
