/* This file is part of the 'atomes' software

'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>

Copyright (C) 2022-2025 by CNRS and University of Strasbourg */

/*!
* @file cp2k_molopt-basis.c
* @short CP2K MOLOPT basis set, as distributed with CP2K 9.1
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'cp2k_molopt-basis.c'
*
* Contains:
*

  - CP2K MOLOPT basis set, as distributed with CP2K 9.1

  This file contains 3 tables:

  molopt_elem -> the list of chemical elements
  molopt_keys -> the list of keywords
  cp2k_molopt -> finally the complete MOLOPT basis set

*/

#include "global.h"

char * molopt_elem[191]={"H",
"H",
"H",
"H",
"H",
"C",
"C",
"C",
"C",
"C",
"N",
"N",
"N",
"N",
"N",
"O",
"O",
"O",
"O",
"O",
"F",
"F",
"F",
"F",
"F",
"Si",
"Si",
"Si",
"Si",
"Si",
"P",
"P",
"P",
"P",
"P",
"S",
"S",
"S",
"S",
"S",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"H",
"H",
"He",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"B",
"C",
"C",
"N",
"N",
"O",
"O",
"F",
"F",
"Ne",
"Ne",
"Na",
"Na",
"Mg",
"Mg",
"Al",
"Al",
"Si",
"Si",
"P",
"P",
"S",
"S",
"Cl",
"Cl",
"Ar",
"Ar",
"K",
"K",
"Ca",
"Ca",
"Sc",
"Sc",
"Ti",
"Ti",
"V",
"V",
"Cr",
"Cr",
"Mn",
"Mn",
"Fe",
"Fe",
"Co",
"Co",
"Ni",
"Ni",
"Cu",
"Cu",
"Zn",
"Zn",
"Ga",
"Ga",
"Ge",
"Ge",
"As",
"As",
"Se",
"Se",
"Br",
"Br",
"Kr",
"Kr",
"Rb",
"Rb",
"Sr",
"Sr",
"Y",
"Y",
"Zr",
"Zr",
"Nb",
"Nb",
"Mo",
"Mo",
"Tc",
"Tc",
"Ru",
"Ru",
"Rh",
"Rh",
"Rh",
"Rh",
"Rh",
"Pd",
"Pd",
"Ag",
"Ag",
"Cd",
"Cd",
"In",
"In",
"Sn",
"Sn",
"Sb",
"Sb",
"Te",
"Te",
"I",
"I",
"Xe",
"Xe",
"Cs",
"Cs",
"Ba",
"Ba",
"Hf",
"Hf",
"Ta",
"Ta",
"W",
"W",
"Re",
"Re",
"Os",
"Os",
"Ir",
"Ir",
"Pt",
"Pt",
"Au",
"Au",
"Hg",
"Hg",
"Tl",
"Tl",
"Pb",
"Pb",
"Bi",
"Bi",
"Po",
"Po",
"At",
"At",
"Rn",
"Rn",
"U"};

char * molopt_keys[191]={"SZV-MOLOPT-GTH-q1",
"DZVP-MOLOPT-GTH-q1",
"TZVP-MOLOPT-GTH-q1",
"TZV2P-MOLOPT-GTH-q1",
"TZV2PX-MOLOPT-GTH-q1",
"SZV-MOLOPT-GTH-q4",
"DZVP-MOLOPT-GTH-q4",
"TZVP-MOLOPT-GTH-q4",
"TZV2P-MOLOPT-GTH-q4",
"TZV2PX-MOLOPT-GTH-q4",
"SZV-MOLOPT-GTH-q5",
"DZVP-MOLOPT-GTH-q5",
"TZVP-MOLOPT-GTH-q5",
"TZV2P-MOLOPT-GTH-q5",
"TZV2PX-MOLOPT-GTH-q5",
"SZV-MOLOPT-GTH-q6",
"DZVP-MOLOPT-GTH-q6",
"TZVP-MOLOPT-GTH-q6",
"TZV2P-MOLOPT-GTH-q6",
"TZV2PX-MOLOPT-GTH-q6",
"SZV-MOLOPT-GTH-q7",
"DZVP-MOLOPT-GTH-q7",
"TZVP-MOLOPT-GTH-q7",
"TZV2P-MOLOPT-GTH-q7",
"TZV2PX-MOLOPT-GTH-q7",
"SZV-MOLOPT-GTH-q4",
"DZVP-MOLOPT-GTH-q4",
"TZVP-MOLOPT-GTH-q4",
"TZV2P-MOLOPT-GTH-q4",
"TZV2PX-MOLOPT-GTH-q4",
"SZV-MOLOPT-GTH-q5",
"DZVP-MOLOPT-GTH-q5",
"TZVP-MOLOPT-GTH-q5",
"TZV2P-MOLOPT-GTH-q5",
"TZV2PX-MOLOPT-GTH-q5",
"SZV-MOLOPT-GTH-q6",
"DZVP-MOLOPT-GTH-q6",
"TZVP-MOLOPT-GTH-q6",
"TZV2P-MOLOPT-GTH-q6",
"TZV2PX-MOLOPT-GTH-q6",
"SZV-MOLOPT-GTH-q7",
"DZVP-MOLOPT-GTH-q7",
"TZVP-MOLOPT-GTH-q7",
"TZV2P-MOLOPT-GTH-q7",
"TZV2PX-MOLOPT-GTH-q7",
"SZV-MOLOPT-SR-GTH-q1",
"DZVP-MOLOPT-SR-GTH-q1",
"SZV-MOLOPT-SR-GTH-q2",
"DZVP-MOLOPT-SR-GTH-q2",
"SZV-MOLOPT-SR-GTH-q3",
"DZVP-MOLOPT-SR-GTH-q3",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q3",
"DZVP-MOLOPT-SR-GTH-q3",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q5",
"DZVP-MOLOPT-SR-GTH-q5",
"SZV-MOLOPT-SR-GTH-q6",
"DZVP-MOLOPT-SR-GTH-q6",
"SZV-MOLOPT-SR-GTH-q7",
"DZVP-MOLOPT-SR-GTH-q7",
"SZV-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-SR-GTH-q8",
"SZV-MOLOPT-SR-GTH-q9",
"DZVP-MOLOPT-SR-GTH-q9",
"SZV-MOLOPT-SR-GTH-q10",
"DZVP-MOLOPT-SR-GTH-q10",
"SZV-MOLOPT-SR-GTH-q3",
"DZVP-MOLOPT-SR-GTH-q3",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q5",
"DZVP-MOLOPT-SR-GTH-q5",
"SZV-MOLOPT-SR-GTH-q6",
"DZVP-MOLOPT-SR-GTH-q6",
"SZV-MOLOPT-SR-GTH-q7",
"DZVP-MOLOPT-SR-GTH-q7",
"SZV-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-SR-GTH-q8",
"SZV-MOLOPT-SR-GTH-q9",
"DZVP-MOLOPT-SR-GTH-q9",
"SZV-MOLOPT-SR-GTH-q10",
"DZVP-MOLOPT-SR-GTH-q10",
"SZV-MOLOPT-SR-GTH-q11",
"DZVP-MOLOPT-SR-GTH-q11",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q14",
"DZVP-MOLOPT-SR-GTH-q14",
"SZV-MOLOPT-SR-GTH-q15",
"DZVP-MOLOPT-SR-GTH-q15",
"SZV-MOLOPT-SR-GTH-q16",
"DZVP-MOLOPT-SR-GTH-q16",
"SZV-MOLOPT-SR-GTH-q17",
"DZVP-MOLOPT-SR-GTH-q17",
"SZV-MOLOPT-SR-GTH-q18",
"DZVP-MOLOPT-SR-GTH-q18",
"SZV-MOLOPT-SR-GTH-q11",
"DZVP-MOLOPT-SR-GTH-q11",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q5",
"DZVP-MOLOPT-SR-GTH-q5",
"SZV-MOLOPT-SR-GTH-q6",
"DZVP-MOLOPT-SR-GTH-q6",
"SZV-MOLOPT-SR-GTH-q7",
"DZVP-MOLOPT-SR-GTH-q7",
"SZV-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-SR-GTH-q8",
"SZV-MOLOPT-SR-GTH-q9",
"DZVP-MOLOPT-SR-GTH-q9",
"SZV-MOLOPT-SR-GTH-q10",
"DZVP-MOLOPT-SR-GTH-q10",
"SZV-MOLOPT-SR-GTH-q11",
"DZVP-MOLOPT-SR-GTH-q11",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q14",
"DZVP-MOLOPT-SR-GTH-q14",
"SZV-MOLOPT-SR-GTH-q15",
"DZVP-MOLOPT-SR-GTH-q15",
"SZV-MOLOPT-SR-GTH-q16",
"DZVP-MOLOPT-SR-GTH-q16",
"SZV-MOLOPT-SR-GTH-q17",
"DZVP-MOLOPT-SR-GTH-q17",
"SZV-MOLOPT-SR-GTH-q9",
"SZVP-MOLOPT-SR-GTH-q9",
"DZVP-MOLOPT-SR-GTH-q9",
"SZV-MOLOPT-SR-GTH-q18",
"DZVP-MOLOPT-SR-GTH-q18",
"SZV-MOLOPT-SR-GTH-q11",
"DZVP-MOLOPT-SR-GTH-q11",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q5",
"DZVP-MOLOPT-SR-GTH-q5",
"SZV-MOLOPT-SR-GTH-q6",
"DZVP-MOLOPT-SR-GTH-q6",
"SZV-MOLOPT-SR-GTH-q7",
"DZVP-MOLOPT-SR-GTH-q7",
"SZV-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-SR-GTH-q8",
"SZV-MOLOPT-SR-GTH-q9",
"DZVP-MOLOPT-SR-GTH-q9",
"SZV-MOLOPT-SR-GTH-q10",
"DZVP-MOLOPT-SR-GTH-q10",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q14",
"DZVP-MOLOPT-SR-GTH-q14",
"SZV-MOLOPT-SR-GTH-q15",
"DZVP-MOLOPT-SR-GTH-q15",
"SZV-MOLOPT-SR-GTH-q16",
"DZVP-MOLOPT-SR-GTH-q16",
"SZV-MOLOPT-SR-GTH-q17",
"DZVP-MOLOPT-SR-GTH-q17",
"SZV-MOLOPT-SR-GTH-q18",
"DZVP-MOLOPT-SR-GTH-q18",
"SZV-MOLOPT-SR-GTH-q11",
"DZVP-MOLOPT-SR-GTH-q11",
"SZV-MOLOPT-SR-GTH-q12",
"DZVP-MOLOPT-SR-GTH-q12",
"SZV-MOLOPT-SR-GTH-q13",
"DZVP-MOLOPT-SR-GTH-q13",
"SZV-MOLOPT-SR-GTH-q4",
"DZVP-MOLOPT-SR-GTH-q4",
"SZV-MOLOPT-SR-GTH-q5",
"DZVP-MOLOPT-SR-GTH-q5",
"SZV-MOLOPT-SR-GTH-q6",
"DZVP-MOLOPT-SR-GTH-q6",
"SZV-MOLOPT-SR-GTH-q7",
"DZVP-MOLOPT-SR-GTH-q7",
"SZV-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-SR-GTH-q8",
"DZVP-MOLOPT-GTH-q14"};

char * cp2k_molopt[191]={"\n"
" H  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q1\n"
" 1\n"
" 2 0 0 7 1\n"
"     11.478000339908  0.024916243200\n"
"      3.700758562763  0.079825490000\n"
"      1.446884268432  0.128862675300\n"
"      0.716814589696  0.379448894600\n"
"      0.247918564176  0.324552432600\n"
"      0.066918004004  0.037148121400\n"
"      0.021708243634 -0.001125195500\n"
"#","\n"
" H  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q1\n"
" 1\n"
" 2 0 1 7 2 1\n"
"     11.478000339908  0.024916243200 -0.012512421400  0.024510918200\n"
"      3.700758562763  0.079825490000 -0.056449071100  0.058140794100\n"
"      1.446884268432  0.128862675300  0.011242684700  0.444709498500\n"
"      0.716814589696  0.379448894600 -0.418587548300  0.646207973100\n"
"      0.247918564176  0.324552432600  0.590363216700  0.803385018200\n"
"      0.066918004004  0.037148121400  0.438703133000  0.892971208700\n"
"      0.021708243634 -0.001125195500 -0.059693171300  0.120101316500\n"
"#","\n"
" H  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q1\n"
" 1\n"
" 2 0 1 7 3 1\n"
"     11.478000339908  0.024916243200 -0.012512421400 -0.013929731000  0.024510918200\n"
"      3.700758562763  0.079825490000 -0.056449071100  0.003035027400  0.058140794100\n"
"      1.446884268432  0.128862675300  0.011242684700 -0.295875900100  0.444709498500\n"
"      0.716814589696  0.379448894600 -0.418587548300  0.688608603400  0.646207973100\n"
"      0.247918564176  0.324552432600  0.590363216700 -0.228296404800  0.803385018200\n"
"      0.066918004004  0.037148121400  0.438703133000 -0.099863944100  0.892971208700\n"
"      0.021708243634 -0.001125195500 -0.059693171300  0.035435150600  0.120101316500\n"
"#","\n"
" H  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q1\n"
" 1\n"
" 2 0 1 7 3 2\n"
"     11.478000339908  0.024916243200 -0.012512421400 -0.013929731000  0.024510918200 -0.016497254600\n"
"      3.700758562763  0.079825490000 -0.056449071100  0.003035027400  0.058140794100 -0.023524900100\n"
"      1.446884268432  0.128862675300  0.011242684700 -0.295875900100  0.444709498500 -0.484890807700\n"
"      0.716814589696  0.379448894600 -0.418587548300  0.688608603400  0.646207973100  0.581651597400\n"
"      0.247918564176  0.324552432600  0.590363216700 -0.228296404800  0.803385018200 -0.302708265200\n"
"      0.066918004004  0.037148121400  0.438703133000 -0.099863944100  0.892971208700  0.037586403600\n"
"      0.021708243634 -0.001125195500 -0.059693171300  0.035435150600  0.120101316500  0.177876988600\n"
"#","\n"
" H  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q1\n"
" 1\n"
" 2 0 2 7 3 2 1\n"
"     11.478000339908  0.024916243200 -0.012512421400 -0.013929731000  0.024510918200 -0.016497254600  0.013783151600\n"
"      3.700758562763  0.079825490000 -0.056449071100  0.003035027400  0.058140794100 -0.023524900100  0.095244888900\n"
"      1.446884268432  0.128862675300  0.011242684700 -0.295875900100  0.444709498500 -0.484890807700  1.000410191300\n"
"      0.716814589696  0.379448894600 -0.418587548300  0.688608603400  0.646207973100  0.581651597400  0.169848598800\n"
"      0.247918564176  0.324552432600  0.590363216700 -0.228296404800  0.803385018200 -0.302708265200  0.073559299500\n"
"      0.066918004004  0.037148121400  0.438703133000 -0.099863944100  0.892971208700  0.037586403600  0.782848013900\n"
"      0.021708243634 -0.001125195500 -0.059693171300  0.035435150600  0.120101316500  0.177876988600 -0.348307160100\n"
"#","\n"
" C  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 1 7 1 1\n"
"      6.132624767898 -0.105576563700  0.035098108400\n"
"      2.625196064782 -0.174866621100  0.114197930900\n"
"      1.045456957247  0.064464981400  0.215908137300\n"
"      0.478316330874  0.830447035300  0.355929151000\n"
"      0.178617414302  0.371911373800  0.271541842000\n"
"      0.075144725465  0.006174464000  0.056256557700\n"
"      0.030286753006  0.008966477300  0.004998059700\n"
"#","\n"
" C  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 7 2 2 1\n"
"      6.132624767898 -0.105576563700  0.024850587600  0.035098108400 -0.056712999000  0.037469425800\n"
"      2.625196064782 -0.174866621100  0.147440856000  0.114197930900 -0.076743951500  0.071047574800\n"
"      1.045456957247  0.064464981400 -0.421418379200  0.215908137300 -0.528056757000  0.619330561200\n"
"      0.478316330874  0.830447035300  0.823051336800  0.355929151000  0.394594045700  0.710730857000\n"
"      0.178617414302  0.371911373800  0.184880712100  0.271541842000  0.721247475800  0.389148235000\n"
"      0.075144725465  0.006174464000 -0.742086051600  0.056256557700  0.733902531700  0.346374124100\n"
"      0.030286753006  0.008966477300  0.083382192000  0.004998059700  0.248172175500 -0.005142430900\n"
"#","\n"
" C  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 7 3 3 1\n"
"      6.132624767898 -0.105576563700  0.024850587600 -0.047388414100  0.035098108400 -0.056712999000 -0.006742034000  0.037469425800\n"
"      2.625196064782 -0.174866621100  0.147440856000 -0.054003851700  0.114197930900 -0.076743951500 -0.031163909400  0.071047574800\n"
"      1.045456957247  0.064464981400 -0.421418379200 -0.056737220700  0.215908137300 -0.528056757000 -0.126324702500  0.619330561200\n"
"      0.478316330874  0.830447035300  0.823051336800  0.450960854100  0.355929151000  0.394594045700  0.629779932600  0.710730857000\n"
"      0.178617414302  0.371911373800  0.184880712100 -0.611198185900  0.271541842000  0.721247475800 -0.487599713200  0.389148235000\n"
"      0.075144725465  0.006174464000 -0.742086051600  0.365424292900  0.056256557700  0.733902531700  0.218697596000  0.346374124100\n"
"      0.030286753006  0.008966477300  0.083382192000 -0.079339373900  0.004998059700  0.248172175500 -0.137064380000 -0.005142430900\n"
"#","\n"
" C  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 7 3 3 2\n"
"      6.132624767898 -0.105576563700  0.024850587600 -0.047388414100  0.035098108400 -0.056712999000 -0.006742034000  0.037469425800  0.029169209100\n"
"      2.625196064782 -0.174866621100  0.147440856000 -0.054003851700  0.114197930900 -0.076743951500 -0.031163909400  0.071047574800  0.026982879200\n"
"      1.045456957247  0.064464981400 -0.421418379200 -0.056737220700  0.215908137300 -0.528056757000 -0.126324702500  0.619330561200  0.547209491100\n"
"      0.478316330874  0.830447035300  0.823051336800  0.450960854100  0.355929151000  0.394594045700  0.629779932600  0.710730857000 -0.776406436300\n"
"      0.178617414302  0.371911373800  0.184880712100 -0.611198185900  0.271541842000  0.721247475800 -0.487599713200  0.389148235000  0.657213953300\n"
"      0.075144725465  0.006174464000 -0.742086051600  0.365424292900  0.056256557700  0.733902531700  0.218697596000  0.346374124100 -0.480025949600\n"
"      0.030286753006  0.008966477300  0.083382192000 -0.079339373900  0.004998059700  0.248172175500 -0.137064380000 -0.005142430900  0.036022564900\n"
"#","\n"
" C  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 3 7 3 3 2 1\n"
"      6.132624767898 -0.105576563700  0.024850587600 -0.047388414100  0.035098108400 -0.056712999000 -0.006742034000  0.037469425800  0.029169209100  0.022304679500\n"
"      2.625196064782 -0.174866621100  0.147440856000 -0.054003851700  0.114197930900 -0.076743951500 -0.031163909400  0.071047574800  0.026982879200  0.026025873000\n"
"      1.045456957247  0.064464981400 -0.421418379200 -0.056737220700  0.215908137300 -0.528056757000 -0.126324702500  0.619330561200  0.547209491100  0.716854675300\n"
"      0.478316330874  0.830447035300  0.823051336800  0.450960854100  0.355929151000  0.394594045700  0.629779932600  0.710730857000 -0.776406436300 -0.024992326800\n"
"      0.178617414302  0.371911373800  0.184880712100 -0.611198185900  0.271541842000  0.721247475800 -0.487599713200  0.389148235000  0.657213953300  0.633014106300\n"
"      0.075144725465  0.006174464000 -0.742086051600  0.365424292900  0.056256557700  0.733902531700  0.218697596000  0.346374124100 -0.480025949600 -0.092802773900\n"
"      0.030286753006  0.008966477300  0.083382192000 -0.079339373900  0.004998059700  0.248172175500 -0.137064380000 -0.005142430900  0.036022564900 -0.094955683900\n"
"#","\n"
" N  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 1 7 1 1\n"
"      9.042730397298 -0.057711157700  0.031469526900\n"
"      3.882224940673 -0.121876730300  0.109126355100\n"
"      1.512880320070  0.094844857800  0.238123330300\n"
"      0.586630738140  0.558583487700  0.376105481500\n"
"      0.222851091943  0.346456981000  0.249727365300\n"
"      0.084582888713  0.031196738600  0.054673928900\n"
"      0.039193834928  0.010393976200 -0.000181794900\n"
"#","\n"
" N  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 7 2 2 1\n"
"      9.042730397298 -0.057711157700  0.055618665600  0.031469526900 -0.012643172000  0.017852718900\n"
"      3.882224940673 -0.121876730300  0.101741751800  0.109126355100 -0.031177059000  0.037932409700\n"
"      1.512880320070  0.094844857800 -0.036013432800  0.238123330300 -0.094228032000  0.324051472500\n"
"      0.586630738140  0.558583487700 -0.547764884700  0.376105481500 -0.192405367500  0.888374055100\n"
"      0.222851091943  0.346456981000  0.606791574500  0.249727365300  0.701455729100  0.188935754200\n"
"      0.084582888713  0.031196738600  0.493556790200  0.054673928900  0.593951368600 -0.049452863800\n"
"      0.039193834928  0.010393976200  0.053452379800 -0.000181794900  0.039720774300 -0.019150455700\n"
"#","\n"
" N  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 7 3 3 1\n"
"      9.042730397298 -0.057711157700  0.055618665600  0.032762883500  0.031469526900 -0.012643172000 -0.028389787500  0.017852718900\n"
"      3.882224940673 -0.121876730300  0.101741751800  0.137929475200  0.109126355100 -0.031177059000  0.039238304500  0.037932409700\n"
"      1.512880320070  0.094844857800 -0.036013432800 -0.215975165900  0.238123330300 -0.094228032000 -0.305920303000  0.324051472500\n"
"      0.586630738140  0.558583487700 -0.547764884700  0.366111863100  0.376105481500 -0.192405367500  0.543553700700  0.888374055100\n"
"      0.222851091943  0.346456981000  0.606791574500  0.307294682700  0.249727365300  0.701455729100  0.145372660300  0.188935754200\n"
"      0.084582888713  0.031196738600  0.493556790200 -0.707766106200  0.054673928900  0.593951368600 -0.742817489000 -0.049452863800\n"
"      0.039193834928  0.010393976200  0.053452379800  0.185238519800 -0.000181794900  0.039720774300  0.455455763000 -0.019150455700\n"
"#","\n"
" N  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 7 3 3 2\n"
"      9.042730397298 -0.057711157700  0.055618665600  0.032762883500  0.031469526900 -0.012643172000 -0.028389787500  0.017852718900 -0.026814870200\n"
"      3.882224940673 -0.121876730300  0.101741751800  0.137929475200  0.109126355100 -0.031177059000  0.039238304500  0.037932409700  0.018900829300\n"
"      1.512880320070  0.094844857800 -0.036013432800 -0.215975165900  0.238123330300 -0.094228032000 -0.305920303000  0.324051472500 -0.406110228200\n"
"      0.586630738140  0.558583487700 -0.547764884700  0.366111863100  0.376105481500 -0.192405367500  0.543553700700  0.888374055100  0.202616067000\n"
"      0.222851091943  0.346456981000  0.606791574500  0.307294682700  0.249727365300  0.701455729100  0.145372660300  0.188935754200  0.641914827500\n"
"      0.084582888713  0.031196738600  0.493556790200 -0.707766106200  0.054673928900  0.593951368600 -0.742817489000 -0.049452863800 -0.754236178400\n"
"      0.039193834928  0.010393976200  0.053452379800  0.185238519800 -0.000181794900  0.039720774300  0.455455763000 -0.019150455700  0.192322748800\n"
"#","\n"
" N  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 3 7 3 3 2 1\n"
"      9.042730397298 -0.057711157700  0.055618665600  0.032762883500  0.031469526900 -0.012643172000 -0.028389787500  0.017852718900 -0.026814870200  0.020975689500\n"
"      3.882224940673 -0.121876730300  0.101741751800  0.137929475200  0.109126355100 -0.031177059000  0.039238304500  0.037932409700  0.018900829300 -0.027501696100\n"
"      1.512880320070  0.094844857800 -0.036013432800 -0.215975165900  0.238123330300 -0.094228032000 -0.305920303000  0.324051472500 -0.406110228200  0.569952079600\n"
"      0.586630738140  0.558583487700 -0.547764884700  0.366111863100  0.376105481500 -0.192405367500  0.543553700700  0.888374055100  0.202616067000  0.862205093600\n"
"      0.222851091943  0.346456981000  0.606791574500  0.307294682700  0.249727365300  0.701455729100  0.145372660300  0.188935754200  0.641914827500 -0.067750230800\n"
"      0.084582888713  0.031196738600  0.493556790200 -0.707766106200  0.054673928900  0.593951368600 -0.742817489000 -0.049452863800 -0.754236178400 -0.185330469600\n"
"      0.039193834928  0.010393976200  0.053452379800  0.185238519800 -0.000181794900  0.039720774300  0.455455763000 -0.019150455700  0.192322748800  0.013120721900\n"
"#","\n"
" O  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 1 7 1 1\n"
"     12.015954705512 -0.060190841200  0.036543638800\n"
"      5.108150287385 -0.129597923300  0.120927648700\n"
"      2.048398039874  0.118175889400  0.251093670300\n"
"      0.832381575582  0.462964485000  0.352639910300\n"
"      0.352316246455  0.450353782600  0.294708645200\n"
"      0.142977330880  0.092715833600  0.173039869300\n"
"      0.046760918300 -0.000255945800  0.009726110600\n"
"#","\n"
" O  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 7 2 2 1\n"
"     12.015954705512 -0.060190841200  0.065738617900  0.036543638800 -0.034210557400  0.014807054400\n"
"      5.108150287385 -0.129597923300  0.110885902200  0.120927648700 -0.120619770900  0.068186159300\n"
"      2.048398039874  0.118175889400 -0.053732406400  0.251093670300 -0.213719464600  0.290576499200\n"
"      0.832381575582  0.462964485000 -0.572670666200  0.352639910300 -0.473674858400  1.063344189500\n"
"      0.352316246455  0.450353782600  0.186760006700  0.294708645200  0.484848376400  0.307656114200\n"
"      0.142977330880  0.092715833600  0.387201458600  0.173039869300  0.717465919700  0.318346834400\n"
"      0.046760918300 -0.000255945800  0.003825849600  0.009726110600  0.032498979400 -0.005771736600\n"
"#","\n"
" O  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 7 3 3 1\n"
"     12.015954705512 -0.060190841200  0.065738617900  0.041006765400  0.036543638800 -0.034210557400 -0.000592640200  0.014807054400\n"
"      5.108150287385 -0.129597923300  0.110885902200  0.080644802300  0.120927648700 -0.120619770900  0.009852349400  0.068186159300\n"
"      2.048398039874  0.118175889400 -0.053732406400 -0.067639801700  0.251093670300 -0.213719464600  0.001286509800  0.290576499200\n"
"      0.832381575582  0.462964485000 -0.572670666200 -0.435078312800  0.352639910300 -0.473674858400 -0.021872639500  1.063344189500\n"
"      0.352316246455  0.450353782600  0.186760006700  0.722792798300  0.294708645200  0.484848376400  0.530504764700  0.307656114200\n"
"      0.142977330880  0.092715833600  0.387201458600 -0.521378340700  0.173039869300  0.717465919700 -0.436184043700  0.318346834400\n"
"      0.046760918300 -0.000255945800  0.003825849600  0.175643142900  0.009726110600  0.032498979400  0.073329259500 -0.005771736600\n"
"#","\n"
" O  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 7 3 3 2\n"
"     12.015954705512 -0.060190841200  0.065738617900  0.041006765400  0.036543638800 -0.034210557400 -0.000592640200  0.014807054400 -0.013843410500\n"
"      5.108150287385 -0.129597923300  0.110885902200  0.080644802300  0.120927648700 -0.120619770900  0.009852349400  0.068186159300  0.016850210400\n"
"      2.048398039874  0.118175889400 -0.053732406400 -0.067639801700  0.251093670300 -0.213719464600  0.001286509800  0.290576499200 -0.186696332600\n"
"      0.832381575582  0.462964485000 -0.572670666200 -0.435078312800  0.352639910300 -0.473674858400 -0.021872639500  1.063344189500  0.068001578700\n"
"      0.352316246455  0.450353782600  0.186760006700  0.722792798300  0.294708645200  0.484848376400  0.530504764700  0.307656114200  0.911407510000\n"
"      0.142977330880  0.092715833600  0.387201458600 -0.521378340700  0.173039869300  0.717465919700 -0.436184043700  0.318346834400 -0.333128530600\n"
"      0.046760918300 -0.000255945800  0.003825849600  0.175643142900  0.009726110600  0.032498979400  0.073329259500 -0.005771736600 -0.405788515900\n"
"#","\n"
" O  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 3 7 3 3 2 1\n"
"     12.015954705512 -0.060190841200  0.065738617900  0.041006765400  0.036543638800 -0.034210557400 -0.000592640200  0.014807054400 -0.013843410500  0.002657486200\n"
"      5.108150287385 -0.129597923300  0.110885902200  0.080644802300  0.120927648700 -0.120619770900  0.009852349400  0.068186159300  0.016850210400 -0.007708463700\n"
"      2.048398039874  0.118175889400 -0.053732406400 -0.067639801700  0.251093670300 -0.213719464600  0.001286509800  0.290576499200 -0.186696332600  0.378459897700\n"
"      0.832381575582  0.462964485000 -0.572670666200 -0.435078312800  0.352639910300 -0.473674858400 -0.021872639500  1.063344189500  0.068001578700  0.819571172100\n"
"      0.352316246455  0.450353782600  0.186760006700  0.722792798300  0.294708645200  0.484848376400  0.530504764700  0.307656114200  0.911407510000 -0.075845376400\n"
"      0.142977330880  0.092715833600  0.387201458600 -0.521378340700  0.173039869300  0.717465919700 -0.436184043700  0.318346834400 -0.333128530600  0.386329438600\n"
"      0.046760918300 -0.000255945800  0.003825849600  0.175643142900  0.009726110600  0.032498979400  0.073329259500 -0.005771736600 -0.405788515900  0.035062554400\n"
"#","\n"
" F  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 1 7 1 1\n"
"     15.025672765127 -0.076135699000  0.043030876500\n"
"      6.156800581515 -0.145492650600  0.138591822100\n"
"      2.411456205564  0.195144281500  0.283251574300\n"
"      0.963986369687  0.553654166300  0.357678749700\n"
"      0.396229721431  0.454888028100  0.300622862100\n"
"      0.157658905678  0.078338198300  0.138839114100\n"
"      0.048130255107  0.002175323600  0.008740274300\n"
"#","\n"
" F  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 7 2 2 1\n"
"     15.025672765127 -0.076135699000  0.060516471000  0.043030876500 -0.027382614400  0.006095862800\n"
"      6.156800581515 -0.145492650600  0.078091919900  0.138591822100 -0.119463647500  0.057880784500\n"
"      2.411456205564  0.195144281500 -0.051537351700  0.283251574300 -0.152089668600  0.143657436500\n"
"      0.963986369687  0.553654166300 -0.448874166200  0.357678749700 -0.460859710900  0.782158193600\n"
"      0.396229721431  0.454888028100  0.143111336600  0.300622862100  0.260540362300  0.349204565600\n"
"      0.157658905678  0.078338198300  0.433345205900  0.138839114100  0.410677921300  0.106634189000\n"
"      0.048130255107  0.002175323600 -0.111759214900  0.008740274300  0.051656760200 -0.008599668300\n"
"#","\n"
" F  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 7 3 3 1\n"
"     15.025672765127 -0.076135699000  0.060516471000  0.236249589200  0.043030876500 -0.027382614400 -0.013131365300  0.006095862800\n"
"      6.156800581515 -0.145492650600  0.078091919900  0.256975207700  0.138591822100 -0.119463647500 -0.061020955700  0.057880784500\n"
"      2.411456205564  0.195144281500 -0.051537351700 -0.299606314200  0.283251574300 -0.152089668600 -0.074530076600  0.143657436500\n"
"      0.963986369687  0.553654166300 -0.448874166200  0.244175306400  0.357678749700 -0.460859710900 -0.333331696200  0.782158193600\n"
"      0.396229721431  0.454888028100  0.143111336600  0.070307660500  0.300622862100  0.260540362300  0.815277681200  0.349204565600\n"
"      0.157658905678  0.078338198300  0.433345205900 -0.391141875700  0.138839114100  0.410677921300 -0.637458747900  0.106634189000\n"
"      0.048130255107  0.002175323600 -0.111759214900  0.275973644000  0.008740274300  0.051656760200  0.225784972300 -0.008599668300\n"
"#","\n"
" F  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 7 3 3 2\n"
"     15.025672765127 -0.076135699000  0.060516471000  0.236249589200  0.043030876500 -0.027382614400 -0.013131365300  0.006095862800 -0.001964191900\n"
"      6.156800581515 -0.145492650600  0.078091919900  0.256975207700  0.138591822100 -0.119463647500 -0.061020955700  0.057880784500 -0.017608747700\n"
"      2.411456205564  0.195144281500 -0.051537351700 -0.299606314200  0.283251574300 -0.152089668600 -0.074530076600  0.143657436500 -0.092704702300\n"
"      0.963986369687  0.553654166300 -0.448874166200  0.244175306400  0.357678749700 -0.460859710900 -0.333331696200  0.782158193600 -0.415809616200\n"
"      0.396229721431  0.454888028100  0.143111336600  0.070307660500  0.300622862100  0.260540362300  0.815277681200  0.349204565600  0.628910907400\n"
"      0.157658905678  0.078338198300  0.433345205900 -0.391141875700  0.138839114100  0.410677921300 -0.637458747900  0.106634189000 -0.412356840700\n"
"      0.048130255107  0.002175323600 -0.111759214900  0.275973644000  0.008740274300  0.051656760200  0.225784972300 -0.008599668300  0.389252314700\n"
"#","\n"
" F  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 3 7 3 3 2 1\n"
"     15.025672765127 -0.076135699000  0.060516471000  0.236249589200  0.043030876500 -0.027382614400 -0.013131365300  0.006095862800 -0.001964191900 -0.008318565400\n"
"      6.156800581515 -0.145492650600  0.078091919900  0.256975207700  0.138591822100 -0.119463647500 -0.061020955700  0.057880784500 -0.017608747700  0.039096268100\n"
"      2.411456205564  0.195144281500 -0.051537351700 -0.299606314200  0.283251574300 -0.152089668600 -0.074530076600  0.143657436500 -0.092704702300  0.354742552600\n"
"      0.963986369687  0.553654166300 -0.448874166200  0.244175306400  0.357678749700 -0.460859710900 -0.333331696200  0.782158193600 -0.415809616200  1.307321527200\n"
"      0.396229721431  0.454888028100  0.143111336600  0.070307660500  0.300622862100  0.260540362300  0.815277681200  0.349204565600  0.628910907400 -0.018428865800\n"
"      0.157658905678  0.078338198300  0.433345205900 -0.391141875700  0.138839114100  0.410677921300 -0.637458747900  0.106634189000 -0.412356840700  0.046645417600\n"
"      0.048130255107  0.002175323600 -0.111759214900  0.275973644000  0.008740274300  0.051656760200  0.225784972300 -0.008599668300  0.389252314700  0.001877717700\n"
"#","\n"
" Si SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 1 6 1 1\n"
"      2.693604434572  0.015333179500 -0.005800105400\n"
"      1.359613855428 -0.283798205000 -0.059172026000\n"
"      0.513245176029 -0.228939692700  0.121487149900\n"
"      0.326563011394  0.728834000900  0.423382421100\n"
"      0.139986977410  0.446205299300  0.474592116300\n"
"      0.068212286977  0.122025292800  0.250129397700\n"
"#","\n"
" Si DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 6 2 2 1\n"
"      2.693604434572  0.015333179500 -0.073325401200 -0.005800105400  0.023996406700  0.043919650100\n"
"      1.359613855428 -0.283798205000  0.484815594600 -0.059172026000  0.055459199900  0.134639409600\n"
"      0.513245176029 -0.228939692700 -0.276015880000  0.121487149900 -0.269559268100  0.517732111300\n"
"      0.326563011394  0.728834000900 -0.228394679700  0.423382421100 -0.259506329000  0.282311245100\n"
"      0.139986977410  0.446205299300 -0.018311553000  0.474592116300  0.310318217600  0.281350794600\n"
"      0.068212286977  0.122025292800  0.365245476200  0.250129397700  0.647414251100  0.139066843800\n"
"#","\n"
" Si TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 6 3 3 1\n"
"      2.693604434572  0.015333179500 -0.073325401200 -0.010190491000 -0.005800105400  0.023996406700  0.014220556800  0.043919650100\n"
"      1.359613855428 -0.283798205000  0.484815594600  0.009707564700 -0.059172026000  0.055459199900 -0.158407152000  0.134639409600\n"
"      0.513245176029 -0.228939692700 -0.276015880000 -0.707360006800  0.121487149900 -0.269559268100  0.854126223400  0.517732111300\n"
"      0.326563011394  0.728834000900 -0.228394679700  0.968240963100  0.423382421100 -0.259506329000 -0.964190479700  0.282311245100\n"
"      0.139986977410  0.446205299300 -0.018311553000 -0.449692717700  0.474592116300  0.310318217600  0.336885865500  0.281350794600\n"
"      0.068212286977  0.122025292800  0.365245476200  0.147937633300  0.250129397700  0.647414251100 -0.063010752700  0.139066843800\n"
"#","\n"
" Si TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 2 6 3 3 2\n"
"      2.693604434572  0.015333179500 -0.073325401200 -0.010190491000 -0.005800105400  0.023996406700  0.014220556800  0.043919650100 -0.021796206700\n"
"      1.359613855428 -0.283798205000  0.484815594600  0.009707564700 -0.059172026000  0.055459199900 -0.158407152000  0.134639409600 -0.065666574500\n"
"      0.513245176029 -0.228939692700 -0.276015880000 -0.707360006800  0.121487149900 -0.269559268100  0.854126223400  0.517732111300 -0.587881439600\n"
"      0.326563011394  0.728834000900 -0.228394679700  0.968240963100  0.423382421100 -0.259506329000 -0.964190479700  0.282311245100  0.799278215300\n"
"      0.139986977410  0.446205299300 -0.018311553000 -0.449692717700  0.474592116300  0.310318217600  0.336885865500  0.281350794600 -0.377563218200\n"
"      0.068212286977  0.122025292800  0.365245476200  0.147937633300  0.250129397700  0.647414251100 -0.063010752700  0.139066843800  0.406207118300\n"
"#","\n"
" Si TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q4\n"
" 1\n"
" 2 0 3 6 3 3 2 1\n"
"      2.693604434572  0.015333179500 -0.073325401200 -0.010190491000 -0.005800105400  0.023996406700  0.014220556800  0.043919650100 -0.021796206700 -0.021648469800\n"
"      1.359613855428 -0.283798205000  0.484815594600  0.009707564700 -0.059172026000  0.055459199900 -0.158407152000  0.134639409600 -0.065666574500  0.421421477600\n"
"      0.513245176029 -0.228939692700 -0.276015880000 -0.707360006800  0.121487149900 -0.269559268100  0.854126223400  0.517732111300 -0.587881439600  0.744190736800\n"
"      0.326563011394  0.728834000900 -0.228394679700  0.968240963100  0.423382421100 -0.259506329000 -0.964190479700  0.282311245100  0.799278215300  0.434937300000\n"
"      0.139986977410  0.446205299300 -0.018311553000 -0.449692717700  0.474592116300  0.310318217600  0.336885865500  0.281350794600 -0.377563218200 -0.722129731000\n"
"      0.068212286977  0.122025292800  0.365245476200  0.147937633300  0.250129397700  0.647414251100 -0.063010752700  0.139066843800  0.406207118300  0.655673293700\n"
"#","\n"
" P  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 1 6 1 1\n"
"      3.338153406523  0.039454247900 -0.012783546700\n"
"      1.833919672496 -0.306814659300 -0.038865450000\n"
"      0.688531765653 -0.113978610700  0.127534067400\n"
"      0.372376701254  0.668025394000  0.401195491100\n"
"      0.166131443191  0.491467475700  0.369849381300\n"
"      0.075778343330  0.087478573600  0.184268604800\n"
"#","\n"
" P  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 6 2 2 1\n"
"      3.338153406523  0.039454247900 -0.055902122900 -0.012783546700  0.005165760600  0.023530272900\n"
"      1.833919672496 -0.306814659300  0.305933443100 -0.038865450000  0.103133751300  0.140233454000\n"
"      0.688531765653 -0.113978610700  0.118785269000  0.127534067400 -0.305520428500  0.507069588900\n"
"      0.372376701254  0.668025394000 -0.716389791200  0.401195491100 -0.245673644600  0.492728339400\n"
"      0.166131443191  0.491467475700  0.271518859600  0.369849381300  0.153640758600  0.310650223400\n"
"      0.075778343330  0.087478573600  0.523136739400  0.184268604800  0.721924297300  0.030421200100\n"
"#","\n"
" P  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 6 3 3 1\n"
"      3.338153406523  0.039454247900 -0.055902122900 -0.036333320500 -0.012783546700  0.005165760600 -0.021032703500  0.023530272900\n"
"      1.833919672496 -0.306814659300  0.305933443100  0.126954601200 -0.038865450000  0.103133751300  0.038242927200  0.140233454000\n"
"      0.688531765653 -0.113978610700  0.118785269000  0.100890359400  0.127534067400 -0.305520428500 -0.256363421800  0.507069588900\n"
"      0.372376701254  0.668025394000 -0.716389791200  0.407065582600  0.401195491100 -0.245673644600  0.548550924800  0.492728339400\n"
"      0.166131443191  0.491467475700  0.271518859600 -0.989778437000  0.369849381300  0.153640758600  0.178359136800  0.310650223400\n"
"      0.075778343330  0.087478573600  0.523136739400  0.538151443400  0.184268604800  0.721924297300 -0.226343952000  0.030421200100\n"
"#","\n"
" P  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 2 6 3 3 2\n"
"      3.338153406523  0.039454247900 -0.055902122900 -0.036333320500 -0.012783546700  0.005165760600 -0.021032703500  0.023530272900 -0.026902801200\n"
"      1.833919672496 -0.306814659300  0.305933443100  0.126954601200 -0.038865450000  0.103133751300  0.038242927200  0.140233454000 -0.024419850900\n"
"      0.688531765653 -0.113978610700  0.118785269000  0.100890359400  0.127534067400 -0.305520428500 -0.256363421800  0.507069588900 -0.592608257200\n"
"      0.372376701254  0.668025394000 -0.716389791200  0.407065582600  0.401195491100 -0.245673644600  0.548550924800  0.492728339400  0.982063898700\n"
"      0.166131443191  0.491467475700  0.271518859600 -0.989778437000  0.369849381300  0.153640758600  0.178359136800  0.310650223400  0.131647772600\n"
"      0.075778343330  0.087478573600  0.523136739400  0.538151443400  0.184268604800  0.721924297300 -0.226343952000  0.030421200100  0.264354685800\n"
"#","\n"
" P  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q5\n"
" 1\n"
" 2 0 3 6 3 3 2 1\n"
"      3.338153406523  0.039454247900 -0.055902122900 -0.036333320500 -0.012783546700  0.005165760600 -0.021032703500  0.023530272900 -0.026902801200  0.005311181800\n"
"      1.833919672496 -0.306814659300  0.305933443100  0.126954601200 -0.038865450000  0.103133751300  0.038242927200  0.140233454000 -0.024419850900  0.138144780500\n"
"      0.688531765653 -0.113978610700  0.118785269000  0.100890359400  0.127534067400 -0.305520428500 -0.256363421800  0.507069588900 -0.592608257200  0.874057452500\n"
"      0.372376701254  0.668025394000 -0.716389791200  0.407065582600  0.401195491100 -0.245673644600  0.548550924800  0.492728339400  0.982063898700  0.436475627300\n"
"      0.166131443191  0.491467475700  0.271518859600 -0.989778437000  0.369849381300  0.153640758600  0.178359136800  0.310650223400  0.131647772600 -0.092923616900\n"
"      0.075778343330  0.087478573600  0.523136739400  0.538151443400  0.184268604800  0.721924297300 -0.226343952000  0.030421200100  0.264354685800  0.017694303700\n"
"#","\n"
" S  SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 1 6 1 1\n"
"      3.817590656735  0.075558928000 -0.019219238100\n"
"      2.362751931093 -0.351216488200 -0.035664835200\n"
"      0.861004180298 -0.099160602500  0.160834397000\n"
"      0.417524512433  0.862753116400  0.507608206800\n"
"      0.181513540673  0.307053614900  0.249563613200\n"
"      0.070570776865  0.001592872500  0.025974500500\n"
"#","\n"
" S  DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 6 2 2 1\n"
"      3.817590656735  0.075558928000 -0.045713227100 -0.019219238100  0.001714015800  0.007498037400\n"
"      2.362751931093 -0.351216488200  0.179094296600 -0.035664835200  0.064608303200  0.104757185100\n"
"      0.861004180298 -0.099160602500  0.206133423700  0.160834397000 -0.170453754100  0.344818199900\n"
"      0.417524512433  0.862753116400 -0.737640763800  0.507608206800 -0.536548069500  0.472319101700\n"
"      0.181513540673  0.307053614900  0.419230078700  0.249563613200  0.786543640200  0.204745694800\n"
"      0.070570776865  0.001592872500  0.359607313200  0.025974500500  0.740434318200 -0.019952573900\n"
"#","\n"
" S  TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 6 3 3 1\n"
"      3.817590656735  0.075558928000 -0.045713227100 -0.334102726000 -0.019219238100  0.001714015800 -0.065081716400  0.007498037400\n"
"      2.362751931093 -0.351216488200  0.179094296600  0.901078536300 -0.035664835200  0.064608303200  0.216735258500  0.104757185100\n"
"      0.861004180298 -0.099160602500  0.206133423700  0.139445328400  0.160834397000 -0.170453754100 -0.656181270900  0.344818199900\n"
"      0.417524512433  0.862753116400 -0.737640763800 -0.236533973000  0.507608206800 -0.536548069500  0.847619826200  0.472319101700\n"
"      0.181513540673  0.307053614900  0.419230078700  0.259546805900  0.249563613200  0.786543640200  0.204233835000  0.204745694800\n"
"      0.070570776865  0.001592872500  0.359607313200 -0.378802711500  0.025974500500  0.740434318200 -0.341040490700 -0.019952573900\n"
"#","\n"
" S  TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 2 6 3 3 2\n"
"      3.817590656735  0.075558928000 -0.045713227100 -0.334102726000 -0.019219238100  0.001714015800 -0.065081716400  0.007498037400 -0.024661974800\n"
"      2.362751931093 -0.351216488200  0.179094296600  0.901078536300 -0.035664835200  0.064608303200  0.216735258500  0.104757185100  0.042689758500\n"
"      0.861004180298 -0.099160602500  0.206133423700  0.139445328400  0.160834397000 -0.170453754100 -0.656181270900  0.344818199900 -0.325440208500\n"
"      0.417524512433  0.862753116400 -0.737640763800 -0.236533973000  0.507608206800 -0.536548069500  0.847619826200  0.472319101700  0.746641212400\n"
"      0.181513540673  0.307053614900  0.419230078700  0.259546805900  0.249563613200  0.786543640200  0.204233835000  0.204745694800 -0.120502819400\n"
"      0.070570776865  0.001592872500  0.359607313200 -0.378802711500  0.025974500500  0.740434318200 -0.341040490700 -0.019952573900 -0.158216979000\n"
"#","\n"
" S  TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q6\n"
" 1\n"
" 2 0 3 6 3 3 2 1\n"
"      3.817590656735  0.075558928000 -0.045713227100 -0.334102726000 -0.019219238100  0.001714015800 -0.065081716400  0.007498037400 -0.024661974800  0.013118322300\n"
"      2.362751931093 -0.351216488200  0.179094296600  0.901078536300 -0.035664835200  0.064608303200  0.216735258500  0.104757185100  0.042689758500  0.057787584100\n"
"      0.861004180298 -0.099160602500  0.206133423700  0.139445328400  0.160834397000 -0.170453754100 -0.656181270900  0.344818199900 -0.325440208500  0.679953632100\n"
"      0.417524512433  0.862753116400 -0.737640763800 -0.236533973000  0.507608206800 -0.536548069500  0.847619826200  0.472319101700  0.746641212400  0.768725285200\n"
"      0.181513540673  0.307053614900  0.419230078700  0.259546805900  0.249563613200  0.786543640200  0.204233835000  0.204745694800 -0.120502819400  0.173138012700\n"
"      0.070570776865  0.001592872500  0.359607313200 -0.378802711500  0.025974500500  0.740434318200 -0.341040490700 -0.019952573900 -0.158216979000  0.060850854200\n"
"#","\n"
" Cl SZV-MOLOPT-GTH SZV-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 1 6 1 1\n"
"      4.577034194110  0.065051807700 -0.018555371400\n"
"      2.685006367322 -0.363216561500 -0.038757218600\n"
"      1.107869270111 -0.013978112200  0.165913669300\n"
"      0.515012065056  0.656897397000  0.409671142600\n"
"      0.225105420962  0.492961793600  0.367216031300\n"
"      0.089684813445  0.053468914400  0.129741292500\n"
"#","\n"
" Cl DZVP-MOLOPT-GTH DZVP-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 6 2 2 1\n"
"      4.577034194110  0.065051807700 -0.056917463100 -0.018555371400  0.004980719100  0.008255008600\n"
"      2.685006367322 -0.363216561500  0.289383593800 -0.038757218600  0.062414668400  0.112659622200\n"
"      1.107869270111 -0.013978112200  0.170470730200  0.165913669300 -0.069602677800  0.303640572700\n"
"      0.515012065056  0.656897397000 -0.631234162900  0.409671142600 -0.435899779400  0.542588312000\n"
"      0.225105420962  0.492961793600  0.132599834000  0.367216031300  0.798386816000  0.275653471800\n"
"      0.089684813445  0.053468914400  0.558743621800  0.129741292500  1.105427347200 -0.001399665300\n"
"#","\n"
" Cl TZVP-MOLOPT-GTH TZVP-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 6 3 3 1\n"
"      4.577034194110  0.065051807700 -0.056917463100 -0.222676105800 -0.018555371400  0.004980719100  0.014188226800  0.008255008600\n"
"      2.685006367322 -0.363216561500  0.289383593800  0.906226330700 -0.038757218600  0.062414668400  0.099373116400  0.112659622200\n"
"      1.107869270111 -0.013978112200  0.170470730200  0.240057556900  0.165913669300 -0.069602677800 -0.139583547500  0.303640572700\n"
"      0.515012065056  0.656897397000 -0.631234162900 -0.584789043400  0.409671142600 -0.435899779400 -0.452556047700  0.542588312000\n"
"      0.225105420962  0.492961793600  0.132599834000  0.113336595400  0.367216031300  0.798386816000  0.872967525000  0.275653471800\n"
"      0.089684813445  0.053468914400  0.558743621800 -0.074517779100  0.129741292500  1.105427347200 -0.464881530900 -0.001399665300\n"
"#","\n"
" Cl TZV2P-MOLOPT-GTH TZV2P-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 2 6 3 3 2\n"
"      4.577034194110  0.065051807700 -0.056917463100 -0.222676105800 -0.018555371400  0.004980719100  0.014188226800  0.008255008600 -0.023981761800\n"
"      2.685006367322 -0.363216561500  0.289383593800  0.906226330700 -0.038757218600  0.062414668400  0.099373116400  0.112659622200  0.022760737200\n"
"      1.107869270111 -0.013978112200  0.170470730200  0.240057556900  0.165913669300 -0.069602677800 -0.139583547500  0.303640572700 -0.255872922500\n"
"      0.515012065056  0.656897397000 -0.631234162900 -0.584789043400  0.409671142600 -0.435899779400 -0.452556047700  0.542588312000  0.152366447500\n"
"      0.225105420962  0.492961793600  0.132599834000  0.113336595400  0.367216031300  0.798386816000  0.872967525000  0.275653471800  0.683411212900\n"
"      0.089684813445  0.053468914400  0.558743621800 -0.074517779100  0.129741292500  1.105427347200 -0.464881530900 -0.001399665300 -0.558926647700\n"
"#","\n"
" Cl TZV2PX-MOLOPT-GTH TZV2PX-MOLOPT-GTH-q7\n"
" 1\n"
" 2 0 3 6 3 3 2 1\n"
"      4.577034194110  0.065051807700 -0.056917463100 -0.222676105800 -0.018555371400  0.004980719100  0.014188226800  0.008255008600 -0.023981761800  0.012967367100\n"
"      2.685006367322 -0.363216561500  0.289383593800  0.906226330700 -0.038757218600  0.062414668400  0.099373116400  0.112659622200  0.022760737200  0.024412096700\n"
"      1.107869270111 -0.013978112200  0.170470730200  0.240057556900  0.165913669300 -0.069602677800 -0.139583547500  0.303640572700 -0.255872922500  0.393536985500\n"
"      0.515012065056  0.656897397000 -0.631234162900 -0.584789043400  0.409671142600 -0.435899779400 -0.452556047700  0.542588312000  0.152366447500  0.715552544800\n"
"      0.225105420962  0.492961793600  0.132599834000  0.113336595400  0.367216031300  0.798386816000  0.872967525000  0.275653471800  0.683411212900  0.342440527400\n"
"      0.089684813445  0.053468914400  0.558743621800 -0.074517779100  0.129741292500  1.105427347200 -0.464881530900 -0.001399665300 -0.558926647700 -0.147002819200\n"
"#","\n"
" H  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q1\n"
" 1\n"
" 2 0 0 5 1\n"
"     10.068468228533 -0.033917444900\n"
"      2.680222868089 -0.122202212100\n"
"      0.791501539122 -0.443818861200\n"
"      0.239116150487 -0.453182186600\n"
"      0.082193184441 -0.131612861500\n"
"#","\n"
" H  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q1\n"
" 1\n"
" 2 0 1 5 2 1\n"
"     10.068468228533 -0.033917444900  0.059193775500  0.009905134400\n"
"      2.680222868089 -0.122202212100  0.843318328900  0.122449566500\n"
"      0.791501539122 -0.443818861200 -1.155707115500  0.477183240900\n"
"      0.239116150487 -0.453182186600  0.049479621200  0.547919678200\n"
"      0.082193184441 -0.131612861500  0.522708738000  0.869031854000\n"
"#","\n"
" He SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q2\n"
" 1\n"
" 2 0 0 4 1\n"
"     11.042785405048 -0.057709039524\n"
"      2.784477928537 -0.186997538114\n"
"      0.777508803064 -0.356165765185\n"
"      0.222222544418 -0.270871722171\n"
"#","\n"
" He DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q2\n"
" 1\n"
" 2 0 1 4 2 1\n"
"     11.042785405048 -0.057709039524 -0.105186433287  0.003655817482\n"
"      2.784477928537 -0.186997538114 -0.390936479220 -0.189395754815\n"
"      0.777508803064 -0.356165765185 -0.838063667638 -1.512867520694\n"
"      0.222222544418 -0.270871722171  1.442874338563  0.670534435463\n"
"#","\n"
" Li SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 0 5 2\n"
"      7.133127574876  0.277443782336  0.081564852833\n"
"      1.999997046722  0.418209986449  0.163120764751\n"
"      0.612030939985  0.305912589369  0.178229873051\n"
"      0.084366737836  0.210640845338 -0.467205177084\n"
"      0.032613166298  0.112523830865 -0.297593804585\n"
"#","\n"
" Li DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 1 5 3 1\n"
"      7.133127574876  0.277443782336  0.081564852833 -0.186441017519 -0.057587889331\n"
"      1.999997046722  0.418209986449  0.163120764751 -0.109333052536 -0.009895878526\n"
"      0.612030939985  0.305912589369  0.178229873051 -0.035923579149 -0.849366496083\n"
"      0.084366737836  0.210640845338 -0.467205177084 -1.930661653919 -2.366974219334\n"
"      0.032613166298  0.112523830865 -0.297593804585  1.884814754037  0.117218879286\n"
"#","\n"
" Be SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 0 6 2\n"
"     14.927410410930 -0.101692281035  0.108892279587\n"
"      6.934611958494 -0.211895541408  0.237670602277\n"
"      2.222208384565 -0.279935231472  0.429698556888\n"
"      0.732913986617 -0.091068265926  0.213557818158\n"
"      0.225007132266 -0.115295308010 -0.652182396204\n"
"      0.074144067364 -0.173251908170 -0.905622978118\n"
"#","\n"
" Be DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 6 3 1\n"
"     14.927410410930 -0.101692281035  0.108892279587 -0.013828511039 -0.043322867269\n"
"      6.934611958494 -0.211895541408  0.237670602277 -0.065062052894 -0.047764533740\n"
"      2.222208384565 -0.279935231472  0.429698556888 -0.515821054187 -0.217923574729\n"
"      0.732913986617 -0.091068265926  0.213557818158 -0.100183446834 -1.091509212634\n"
"      0.225007132266 -0.115295308010 -0.652182396204  2.012025412480 -2.124632001073\n"
"      0.074144067364 -0.173251908170 -0.905622978118 -1.507944883871 -1.344316057412\n"
"#","\n"
" B  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      3.053444073497  0.142389531583 -0.124774394633\n"
"      0.915483968316  0.070304308347 -0.383517801425\n"
"      0.329920053516 -0.657626233726 -0.645201457411\n"
"      0.101655384143 -0.417625483973 -0.369557407831\n"
"#","\n"
" B  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      3.053444073497  0.142389531583 -0.541363625050 -0.124774394633 -0.166005683397 -0.081377656373\n"
"      0.915483968316  0.070304308347 -0.187885904555 -0.383517801425 -0.631934352115 -0.772292138236\n"
"      0.329920053516 -0.657626233726  1.734743314732 -0.645201457411 -0.579629526633 -1.322433881793\n"
"      0.101655384143 -0.417625483973 -1.647357915542 -0.369557407831  1.762122465548 -0.981970482328\n"
"#","\n"
" C  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      5.605330751705  0.111532881900 -0.064868978500\n"
"      2.113016390533  0.153142194100 -0.200470255700\n"
"      0.769911454810 -0.321396879400 -0.413141730100\n"
"      0.348157086385 -0.610926421600 -0.415337139200\n"
"      0.128212254710 -0.133990862800 -0.288527673600\n"
"#","\n"
" C  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      5.605330751705  0.111532881900  0.466507483200 -0.064868978500 -0.055475693400  0.029952774600\n"
"      2.113016390533  0.153142194100  0.144113212800 -0.200470255700 -0.216165175200  0.070784458800\n"
"      0.769911454810 -0.321396879400  0.029364880900 -0.413141730100 -0.436624272300  0.674601058600\n"
"      0.348157086385 -0.610926421600  0.929470388400 -0.415337139200  0.784000698400  0.173652061800\n"
"      0.128212254710 -0.133990862800  1.066914331200 -0.288527673600  0.987908135000  1.036317024700\n"
"#","\n"
" N  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      7.341988051825  0.113789156500 -0.053744330400\n"
"      2.542637110957  0.097294516500 -0.165752516200\n"
"      0.888574967229 -0.445077422600 -0.317365165600\n"
"      0.333802200435 -0.584142233900 -0.312039675200\n"
"      0.112012109029 -0.139562383500 -0.117936008100\n"
"#","\n"
" N  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      7.341988051825  0.113789156500  0.077765588400 -0.053744330400 -0.007627243700  0.033688455200\n"
"      2.542637110957  0.097294516500  0.108655219900 -0.165752516200  0.015163333100  0.109813343200\n"
"      0.888574967229 -0.445077422600 -0.374125427100 -0.317365165600 -0.129388247500  0.856542971300\n"
"      0.333802200435 -0.584142233900  0.024021712400 -0.312039675200  0.554905847400  0.509681657500\n"
"      0.112012109029 -0.139562383500  0.979415132500 -0.117936008100  1.001020469600  0.047030652200\n"
"#","\n"
" O  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 1 5 1 1\n"
"     10.389228018317  0.126240722900 -0.061302037200\n"
"      3.849621072005  0.139933704300 -0.190087511700\n"
"      1.388401188741 -0.434348231700 -0.377726982800\n"
"      0.496955043655 -0.852791790900 -0.454266086000\n"
"      0.162491615040 -0.242351537800 -0.257388983000\n"
"#","\n"
" O  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"     10.389228018317  0.126240722900  0.069215797900 -0.061302037200 -0.026862701100  0.029845227500\n"
"      3.849621072005  0.139933704300  0.115634538900 -0.190087511700 -0.006283021000  0.060939733900\n"
"      1.388401188741 -0.434348231700 -0.322839719400 -0.377726982800 -0.224839187800  0.732321580100\n"
"      0.496955043655 -0.852791790900 -0.095944016600 -0.454266086000  0.380324658600  0.893564918400\n"
"      0.162491615040 -0.242351537800  1.102830348700 -0.257388983000  1.054102919900  0.152954188700\n"
"#","\n"
" F  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 1 5 1 1\n"
"     13.701520668842  0.112227293400 -0.076186490700\n"
"      5.098268930397  0.138913509400 -0.239982004100\n"
"      1.837941323644 -0.418624975600 -0.481912435400\n"
"      0.631758758967 -0.781149500600 -0.576092640600\n"
"      0.202026732748 -0.233361053400 -0.325681090200\n"
"#","\n"
" F  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"     13.701520668842  0.112227293400  0.097208978300 -0.076186490700 -0.065073103800  0.014975910100\n"
"      5.098268930397  0.138913509400  0.102876192000 -0.239982004100 -0.178954386700  0.056540852300\n"
"      1.837941323644 -0.418624975600 -0.261194711300 -0.481912435400 -0.432978808900  0.421555957700\n"
"      0.631758758967 -0.781149500600 -0.613877500700 -0.576092640600 -0.420393726200  1.040368501100\n"
"      0.202026732748 -0.233361053400  0.913930794200 -0.325681090200  1.087532785600 -0.115372011600\n"
"#","\n"
" Ne SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 1 6 1 1\n"
"     19.144669251814  0.069475808579  0.044323480089\n"
"      7.817581633327  0.136833604284  0.141748545980\n"
"      3.076395099204 -0.176240522396  0.286599690536\n"
"      1.225783227767 -0.534790596391  0.369762267197\n"
"      0.469438475964 -0.420816475643  0.313976275678\n"
"      0.165401378033 -0.056199770547  0.129616681048\n"
"#","\n"
" Ne DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 2 6 2 2 1\n"
"     19.144669251814  0.069475808579  0.008074422113  0.044323480089 -0.019633668505 -0.016337449779\n"
"      7.817581633327  0.136833604284  0.088172430797  0.141748545980 -0.051196308389 -0.013519520944\n"
"      3.076395099204 -0.176240522396 -0.218906635760  0.286599690536 -0.171521562166 -0.158627528552\n"
"      1.225783227767 -0.534790596391  0.130013326453  0.369762267197  0.007505219111 -0.028650976608\n"
"      0.469438475964 -0.420816475643 -1.271285832759  0.313976275678 -0.568357530124 -0.982412169970\n"
"      0.165401378033 -0.056199770547  1.727911777889  0.129616681048  1.298147838544  1.273253904774\n"
"#","\n"
" Na SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 1 7 2 1\n"
"     23.518800761960  0.037798268053  0.005040470618 -0.041235150854\n"
"     11.135656103275  0.180415272016  0.031210048356 -0.102704065658\n"
"      4.647813820246 -0.084235489885 -0.021214584887 -0.276507156374\n"
"      1.866708259982 -0.502007239468 -0.088006426680 -0.405087985600\n"
"      0.734683697196 -0.487454712994 -0.241562643580 -0.345669762598\n"
"      0.275672995860 -0.088909855778  0.046069503612 -0.128294724774\n"
"      0.049895108245 -0.000245624853  1.008694292400 -0.002074313963\n"
"#","\n"
" Na DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 1 7 3 2\n"
"     23.518800761960  0.037798268053  0.005040470618  0.037779070657 -0.041235150854 -0.005410838671\n"
"     11.135656103275  0.180415272016  0.031210048356 -0.119614429319 -0.102704065658 -0.017609338317\n"
"      4.647813820246 -0.084235489885 -0.021214584887  0.224302495702 -0.276507156374 -0.043803008653\n"
"      1.866708259982 -0.502007239468 -0.088006426680 -0.183779813212 -0.405087985600 -0.067844235623\n"
"      0.734683697196 -0.487454712994 -0.241562643580  1.641649867502 -0.345669762598 -0.085057974012\n"
"      0.275672995860 -0.088909855778  0.046069503612 -2.281564821968 -0.128294724774  0.159527770719\n"
"      0.049895108245 -0.000245624853  1.008694292400  0.801660990981 -0.002074313963  0.982149424568\n"
"#","\n"
" Mg SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 1 7 2 1\n"
"     30.653047963189  0.054377184080 -0.008503364657  0.041949376018\n"
"     12.924389070531  0.180093043263 -0.033268853396  0.154513485142\n"
"      4.968377097667 -0.183378978769  0.039287763681  0.347080006586\n"
"      1.851827556019 -0.641604001295  0.169148911336  0.456042413582\n"
"      0.673565331978 -0.382610049904  0.233823708921  0.275294822235\n"
"      0.168626419621 -0.012877428759 -0.474103906013  0.029266033687\n"
"      0.059428253135 -0.011565253116 -0.681875195374 -0.006397458869\n"
"#","\n"
" Mg DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 1 7 3 2\n"
"     30.653047963189  0.054377184080 -0.008503364657 -0.017403499711  0.041949376018  0.005685482959\n"
"     12.924389070531  0.180093043263 -0.033268853396  0.019979586563  0.154513485142  0.031145413254\n"
"      4.968377097667 -0.183378978769  0.039287763681 -0.035277033496  0.347080006586  0.054939424515\n"
"      1.851827556019 -0.641604001295  0.169148911336 -0.203352520214  0.456042413582  0.123275320202\n"
"      0.673565331978 -0.382610049904  0.233823708921 -0.348027990301  0.275294822235 -0.070548883335\n"
"      0.168626419621 -0.012877428759 -0.474103906013  2.122888539507  0.029266033687 -0.608144728127\n"
"      0.059428253135 -0.011565253116 -0.681875195374 -1.871583263111 -0.006397458869 -0.561501656268\n"
"#","\n"
" Al SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.212902319099  0.095248915182  0.017523273525\n"
"      0.454181446881  0.238368062117  0.031530615904\n"
"      0.242418503788 -0.551005849330 -0.395233201731\n"
"      0.078268495175 -0.241350820340 -0.270737591969\n"
"#","\n"
" Al DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q3\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.212902319099  0.095248915182 -0.230241641025  0.017523273525 -0.081919506975  0.359233701644\n"
"      0.454181446881  0.238368062117 -0.662191771394  0.031530615904  0.059600622511  0.610925184385\n"
"      0.242418503788 -0.551005849330  1.692156327298 -0.395233201731  1.076271205166  1.758688383246\n"
"      0.078268495175 -0.241350820340 -1.648320060523 -0.270737591969 -1.208390139070  0.735529744423\n"
"#","\n"
" Si SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.256767641387  0.227718466600  0.067776267500\n"
"      0.506394122478 -0.024323599300 -0.213716770200\n"
"      0.238883845662 -0.558639778900 -0.409893726600\n"
"      0.087336883836 -0.207272502200 -0.353922302700\n"
"#","\n"
" Si DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.256767641387  0.227718466600 -1.025748084300  0.067776267500  0.099785628800  0.159026680300\n"
"      0.506394122478 -0.024323599300  0.694283033300 -0.213716770200 -0.411985229800  0.392330436800\n"
"      0.238883845662 -0.558639778900  0.058162561600 -0.409893726600 -0.057183126300  0.393085151800\n"
"      0.087336883836 -0.207272502200 -0.258181009000 -0.353922302700  0.700307869400  0.550337119000\n"
"#","\n"
" P  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.631862170786  0.335074115300  0.123299547600\n"
"      0.708432685319 -0.023088252600 -0.351511376700\n"
"      0.284968483654 -0.973819129700 -0.806870557100\n"
"      0.098011823689 -0.292906884000 -0.517933891800\n"
"#","\n"
" P  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.631862170786  0.335074115300  0.341512748800  0.123299547600  0.134459618400  0.174671506000\n"
"      0.708432685319 -0.023088252600  0.008045537600 -0.351511376700 -0.389557392400  0.503029215100\n"
"      0.284968483654 -0.973819129700 -0.851246931200 -0.806870557100 -0.138884374300  0.699184423900\n"
"      0.098011823689 -0.292906884000  1.328906840600 -0.517933891800  1.062071606300  0.407460906200\n"
"#","\n"
" S  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      2.215854692813  0.170962878400  0.092191824200\n"
"      1.131470525271  0.127069405600 -0.162197093800\n"
"      0.410168143974 -0.733925381700 -0.605594737600\n"
"      0.140587330023 -0.176971633900 -0.213309789800\n"
"#","\n"
" S  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      2.215854692813  0.170962878400 -0.080726543800  0.092191824200  0.057845138800  0.113762894700\n"
"      1.131470525271  0.127069405600 -0.209877313900 -0.162197093800 -0.094737441500  0.350414093700\n"
"      0.410168143974 -0.733925381700  0.683497090800 -0.605594737600 -0.369172638100  0.866785684700\n"
"      0.140587330023 -0.176971633900 -0.625512739500 -0.213309789800  1.155699504700  0.217880463100\n"
"#","\n"
" Cl SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      2.379078117601  0.349064979100  0.116462270400\n"
"      1.470718465013  0.023265903500 -0.193945393700\n"
"      0.461213474057 -1.015492630400 -0.463529682400\n"
"      0.150014717415 -0.402599991500 -0.299834714700\n"
"#","\n"
" Cl DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      2.379078117601  0.349064979100  0.153138206200  0.116462270400  0.160067891900  0.074898027900\n"
"      1.470718465013  0.023265903500  0.170051509900 -0.193945393700 -0.212781225800  0.303856570000\n"
"      0.461213474057 -1.015492630400 -0.702516267300 -0.463529682400 -0.439023237200  0.766878436800\n"
"      0.150014717415 -0.402599991500  0.681437336600 -0.299834714700  1.036634179400  0.154947398700\n"
"#","\n"
" Ar SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      3.936450214256 -0.126876868653  0.081197313256\n"
"      2.888050686108  0.488558851459 -0.050560847288\n"
"      0.925305548464 -0.356808308806 -0.382285987629\n"
"      0.366456608488 -0.745538702598 -0.507927770980\n"
"      0.128035915977 -0.148475482748 -0.248562045384\n"
"#","\n"
" Ar DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      3.936450214256 -0.126876868653 -0.120853949683  0.081197313256  0.115242855583  0.118434272495\n"
"      2.888050686108  0.488558851459  0.030456012450 -0.050560847288 -0.153264749918 -0.157989713634\n"
"      0.925305548464 -0.356808308806 -0.229699408013 -0.382285987629 -0.074149829187 -0.072608763447\n"
"      0.366456608488 -0.745538702598  1.833670881562 -0.507927770980 -0.965020325642 -0.967474418604\n"
"      0.128035915977 -0.148475482748 -1.869800022555 -0.248562045384  1.384189599695  1.358175503076\n"
"#","\n"
" K  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 1 6 2 1\n"
"      2.891270375454 -0.125588343071  0.141760377816  0.586273841257\n"
"      2.714957993897 -0.332679523247  0.045797253838 -0.600247660122\n"
"      0.954062644964  0.579235654863 -0.270917640330 -0.331386642719\n"
"      0.407596260029  0.640286613853 -0.523435976542 -0.345162964052\n"
"      0.163339876080  0.132146903359 -0.040955544362 -0.129654083334\n"
"      0.036854064168  0.136961207358  1.420210199250 -0.002662514210\n"
"#","\n"
" K  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 2 6 3 2 1\n"
"      2.891270375454 -0.125588343071  0.141760377816  0.092583173658  0.586273841257  0.174577931878 -0.022072489962\n"
"      2.714957993897 -0.332679523247  0.045797253838 -0.045825704377 -0.600247660122 -0.189434477232  0.113984804892\n"
"      0.954062644964  0.579235654863 -0.270917640330  0.363168058178 -0.331386642719 -0.078101098846  0.234486045475\n"
"      0.407596260029  0.640286613853 -0.523435976542 -2.539586038548 -0.345162964052 -0.144666151565  0.234673259721\n"
"      0.163339876080  0.132146903359 -0.040955544362  2.654427110393 -0.129654083334  0.092758894460  0.452553356262\n"
"      0.036854064168  0.136961207358  1.420210199250 -0.693763482649 -0.002662514210  0.780744603300  0.480095027043\n"
"#","\n"
" Ca SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 1 6 2 1\n"
"      5.284985596557 -0.416182629697 -0.083912217567  0.064960038145\n"
"      4.091752229122  0.887610504052  0.216895453968  0.014546526081\n"
"      1.429520321762 -0.323549926958 -0.096935550443 -0.466720491908\n"
"      0.614375507986 -0.908395199325 -0.502206578258 -0.634030899528\n"
"      0.242970577562 -0.208971576432 -0.096821746914 -0.251681593814\n"
"      0.055000158016  0.039132482825  1.342563762693 -0.000003936848\n"
"#","\n"
" Ca DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 2 6 3 2 1\n"
"      5.284985596557 -0.416182629697 -0.083912217567 -0.208574685974  0.064960038145  0.026515439739 -0.066630752510\n"
"      4.091752229122  0.887610504052  0.216895453968  0.314510703283  0.014546526081 -0.028997969950  0.197842850864\n"
"      1.429520321762 -0.323549926958 -0.096935550443 -0.601923136001 -0.466720491908 -0.073243851190  0.458365171560\n"
"      0.614375507986 -0.908395199325 -0.502206578258  2.853614975011 -0.634030899528 -0.218228118923  0.372585742208\n"
"      0.242970577562 -0.208971576432 -0.096821746914 -3.043287352030 -0.251681593814  0.144907690867  0.820156666086\n"
"      0.055000158016  0.039132482825  1.342563762693  0.887844469398 -0.000003936848  0.854082269914  0.653032075293\n"
"#","\n"
" Sc SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      7.596358558474 -0.005607824648 -0.000597439424 -0.092377568763  0.045120250343\n"
"      3.531908044322  0.513266691301  0.153537412458  0.071267862889  0.192728189010\n"
"      1.358432991102 -0.619613224500 -0.224168885145  0.468025381136  0.336183526558\n"
"      0.543348479632 -0.729328581203 -0.458469756794  0.444181247677  0.405780027669\n"
"      0.197283658533 -0.063678221084  0.072089942129  0.091871138246  0.446780401537\n"
"      0.054428805670 -0.076152416285  1.048240218482 -0.004061267711  0.155178106722\n"
"#","\n"
" Sc DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      7.596358558474 -0.005607824648 -0.000597439424 -0.002143930265 -0.092377568763  0.020935300558  0.045120250343 -0.026241824143  0.005774084495\n"
"      3.531908044322  0.513266691301  0.153537412458  0.228058090414  0.071267862889 -0.024159604541  0.192728189010 -0.096234745142 -0.021058205466\n"
"      1.358432991102 -0.619613224500 -0.224168885145  0.050489185834  0.468025381136 -0.177053431087  0.336183526558 -0.167689255408 -0.090318610966\n"
"      0.543348479632 -0.729328581203 -0.458469756794  1.714744833607  0.444181247677 -0.236101867977  0.405780027669 -0.337050099684 -0.717025179002\n"
"      0.197283658533 -0.063678221084  0.072089942129 -2.748813311572  0.091871138246  0.624399910851  0.446780401537  0.338357123973 -0.806018996967\n"
"      0.054428805670 -0.076152416285  1.048240218482  1.327173437956 -0.004061267711  0.798174697757  0.155178106722  0.993267553023 -0.034431734574\n"
"#","\n"
" Ti SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      7.884569925997  0.004750577412 -0.002690702837 -0.108736525246  0.052842407451\n"
"      3.894698463070  0.499503858222  0.103956524568  0.100912855636  0.195986532018\n"
"      1.513588828959 -0.664995883766 -0.256641947580  0.527328996047  0.330343722079\n"
"      0.596768079836 -0.726044574739 -0.451591547817  0.468197803110  0.396808432313\n"
"      0.222222125842 -0.029011079755  0.165167622946  0.077640626075  0.347092399871\n"
"      0.077078461321  0.075171747143  0.993127316430 -0.007523238420  0.132320900948\n"
"#","\n"
" Ti DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      7.884569925997  0.004750577412 -0.002690702837  0.075105591562 -0.108736525246  0.023185061556  0.052842407451 -0.038307431199 -0.002442658125\n"
"      3.894698463070  0.499503858222  0.103956524568  0.048602853477  0.100912855636 -0.027189036213  0.195986532018 -0.076880250937  0.013119020987\n"
"      1.513588828959 -0.664995883766 -0.256641947580  0.079732563787  0.527328996047 -0.230044390357  0.330343722079 -0.242486488988 -0.206817889885\n"
"      0.596768079836 -0.726044574739 -0.451591547817  1.660896378972  0.468197803110 -0.126795185046  0.396808432313 -0.118369379707 -0.546596492823\n"
"      0.222222125842 -0.029011079755  0.165167622946 -2.748651632733  0.077640626075  0.343517279356  0.347092399871  0.038099375809 -0.279145975103\n"
"      0.077078461321  0.075171747143  0.993127316430  1.368227638651 -0.007523238420  0.946960702315  0.132320900948  1.046553050597  0.934394052863\n"
"#","\n"
" V  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      7.984623749528  0.020761670278  0.003472483927 -0.127318262252  0.054932269310\n"
"      4.192169946044  0.491008828907  0.116393516673  0.142383719999  0.194803913356\n"
"      1.674403287155 -0.682491382781 -0.215217539970  0.556224679524  0.318207922138\n"
"      0.666664577236 -0.670820374730 -0.436714762412  0.483736882428  0.350513304180\n"
"      0.242419878750 -0.048891386418  0.104274844115  0.086227000831  0.324484835051\n"
"      0.067390273084 -0.000084103227  1.134107947863 -0.004719320688  0.134088585517\n"
"#","\n"
" V  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      7.984623749528  0.020761670278  0.003472483927  0.004588768658 -0.127318262252  0.022347856999  0.054932269310 -0.022459138650 -0.026581274918\n"
"      4.192169946044  0.491008828907  0.116393516673  0.265023422395  0.142383719999 -0.034743188380  0.194803913356 -0.101116586232  0.051515222079\n"
"      1.674403287155 -0.682491382781 -0.215217539970  0.055753124298  0.556224679524 -0.168852773516  0.318207922138 -0.120777522887 -0.165483508295\n"
"      0.666664577236 -0.670820374730 -0.436714762412  1.571857662805  0.483736882428 -0.212388638969  0.350513304180 -0.254635388920 -0.672649310115\n"
"      0.242419878750 -0.048891386418  0.104274844115 -2.575720417590  0.086227000831  0.567082913076  0.324484835051  0.328826511242 -0.518402997758\n"
"      0.067390273084 -0.000084103227  1.134107947863  1.490359925888 -0.004719320688  0.737649031611  0.134088585517  0.919495386218  0.651022121928\n"
"#","\n"
" Cr SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      8.512514788173  0.044157704927  0.005521331885 -0.106538347032  0.081830853262\n"
"      4.473610317347  0.611382080738  0.102717317434  0.123956998990  0.165469927086\n"
"      1.935100804674 -0.806653824181 -0.230184308969  0.572145261792  0.291295712802\n"
"      0.787755660544 -0.813737787488 -0.583672998554  0.518904350249  0.315064211859\n"
"      0.293768118617 -0.097787236037  0.171514456916  0.104097287875  0.298491580418\n"
"      0.096285158065 -0.018725934011  1.121145454028 -0.012851161685  0.091086538491\n"
"#","\n"
" Cr DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      8.512514788173  0.044157704927  0.005521331885  0.051983958707 -0.106538347032  0.019159720527  0.081830853262 -0.086435342501  0.010065113847\n"
"      4.473610317347  0.611382080738  0.102717317434 -0.056754820192  0.123956998990 -0.039826791539  0.165469927086 -0.200410712475 -0.041960450278\n"
"      1.935100804674 -0.806653824181 -0.230184308969  0.286788879281  0.572145261792 -0.183705969647  0.291295712802 -0.303533420852 -0.023503174374\n"
"      0.787755660544 -0.813737787488 -0.583672998554  1.450866672422  0.518904350249 -0.237503427061  0.315064211859 -0.406252982054 -0.642426781332\n"
"      0.293768118617 -0.097787236037  0.171514456916 -2.505465496286  0.104097287875  0.544755601203  0.298491580418  0.671193994691 -1.002149340367\n"
"      0.096285158065 -0.018725934011  1.121145454028  1.333321045479 -0.012851161685  0.728237138423  0.091086538491  1.044472107589 -0.051749578559\n"
"#","\n"
" Mn SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      8.544553301652  0.073093470228  0.007737617141 -0.112356559070  0.128427483264\n"
"      4.848054813373  0.524172731625  0.080999035925  0.147232813006  0.251552231081\n"
"      2.164526529348 -0.728865076153 -0.168390545215  0.595364746984  0.432303419394\n"
"      0.889600577579 -0.719279115513 -0.484910732725  0.547990570294  0.462243734648\n"
"      0.342420014284 -0.107062868546  0.161978409160  0.112195052476  0.410033587493\n"
"      0.101924225526 -0.091391408123  0.922002216513 -0.006599984929  0.104488744702\n"
"#","\n"
" Mn DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      8.544553301652  0.073093470228  0.007737617141  0.072614715676 -0.112356559070 -0.000918247791  0.128427483264 -0.098510232939  0.011600099044\n"
"      4.848054813373  0.524172731625  0.080999035925  0.243235089119  0.147232813006 -0.022563980399  0.251552231081 -0.201137346341 -0.038269110382\n"
"      2.164526529348 -0.728865076153 -0.168390545215 -0.083273051926  0.595364746984 -0.222689774520  0.432303419394 -0.372206024320 -0.006930134936\n"
"      0.889600577579 -0.719279115513 -0.484910732725  1.528518694896  0.547990570294 -0.223281730802  0.462243734648 -0.283875478140 -0.593864975230\n"
"      0.342420014284 -0.107062868546  0.161978409160 -2.382396811600  0.112195052476  0.787892008324  0.410033587493  0.535487181225 -0.731351385550\n"
"      0.101924225526 -0.091391408123  0.922002216513  1.312464873250 -0.006599984929  0.923252070662  0.104488744702  0.884777948907 -0.410551623712\n"
"#","\n"
" Fe SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      8.424366035773 -0.162658565315 -0.035363017559 -0.072847050506  0.110173914394\n"
"      4.825219529323 -0.376899337900 -0.052967122649  0.142729813399  0.188638090829\n"
"      2.198939257455  0.782922261822  0.047770046081  0.463643359935  0.309261422382\n"
"      0.891660670520  0.668791717694 -0.303745487596  0.381142099471  0.329416033612\n"
"      0.316230539846  0.044155272467  0.241839701006  0.065337400672  0.286237082129\n"
"      0.103474049912 -0.109124318184  1.110613962319 -0.008571808472  0.085017978924\n"
"#","\n"
" Fe DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      8.424366035773 -0.162658565315 -0.035363017559 -0.094078593184 -0.072847050506 -0.005733704721  0.110173914394 -0.070157127293 -0.006314368438\n"
"      4.825219529323 -0.376899337900 -0.052967122649 -0.123947729175  0.142729813399 -0.013789178386  0.188638090829 -0.086799612151  0.010113549442\n"
"      2.198939257455  0.782922261822  0.047770046081 -0.097232244128  0.463643359935 -0.102097633738  0.309261422382 -0.268972922540 -0.073675908597\n"
"      0.891660670520  0.668791717694 -0.303745487596 -1.526375946562  0.381142099471 -0.120441338124  0.329416033612 -0.034996470754 -0.417006031951\n"
"      0.316230539846  0.044155272467  0.241839701006  2.582854093079  0.065337400672  0.562339049496  0.286237082129  0.429744227008 -0.588459890648\n"
"      0.103474049912 -0.109124318184  1.110613962319 -1.436336658778 -0.008571808472  0.724515320284  0.085017978924  0.805064206226  0.838504572352\n"
"#","\n"
" Co SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      8.365267848849  0.325640340818  0.100399284242  0.065178086481  0.161970551713\n"
"      4.376457504499  0.052133097592  0.035256534659 -0.270123287267  0.258523958001\n"
"      1.999997730424 -0.771768661844 -0.356022277776 -0.523181103805  0.345535423988\n"
"      0.834299833692 -0.451524705474 -0.484191598528 -0.351988387737  0.343948305407\n"
"      0.307481719486 -0.065898239599  0.316152225672 -0.046316455477  0.268593856293\n"
"      0.095840175724 -0.089785302253  1.048143547929  0.002689603563  0.072458934329\n"
"#","\n"
" Co DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      8.365267848849  0.325640340818  0.100399284242 -0.037272221184  0.065178086481 -0.007853810191  0.161970551713 -0.150374171995 -0.004972248652\n"
"      4.376457504499  0.052133097592  0.035256534659  0.130340578991 -0.270123287267 -0.005278972597  0.258523958001 -0.233094541861 -0.027876689140\n"
"      1.999997730424 -0.771768661844 -0.356022277776  0.090277112993 -0.523181103805 -0.068346693868  0.345535423988 -0.433567358235 -0.105956196731\n"
"      0.834299833692 -0.451524705474 -0.484191598528  1.325070368105 -0.351988387737 -0.063077394461  0.343948305407  0.030145546706 -0.735605287383\n"
"      0.307481719486 -0.065898239599  0.316152225672 -2.625301782430 -0.046316455477  0.759497959451  0.268593856293  0.599205222587 -0.912105772173\n"
"      0.095840175724 -0.089785302253  1.048143547929  1.561113649398  0.002689603563  0.543915652075  0.072458934329  0.957030486546  0.577467491892\n"
"#","\n"
" Ni SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"     10.077427756816 -0.169086929207  0.022677528942 -0.126427871284  0.093966508982\n"
"      5.847735848326 -0.313749841130  0.057292097754  0.241165311699  0.269388431386\n"
"      2.494032826008  0.766489587737 -0.198532965699  0.543849904725  0.374569463127\n"
"      0.988354848429  0.557414017577 -0.427662657827  0.407338672608  0.368089865298\n"
"      0.344978242158  0.031729942841  0.260121348436  0.053320914508  0.281719022542\n"
"      0.099465768726 -0.025637387109  0.887675876654 -0.003779723220  0.071642894272\n"
"#","\n"
" Ni DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"     10.077427756816 -0.169086929207  0.022677528942  0.008641083176 -0.126427871284 -0.005476801255  0.093966508982 -0.033098284050 -0.001956691144\n"
"      5.847735848326 -0.313749841130  0.057292097754 -0.136071800928  0.241165311699 -0.010936526817  0.269388431386 -0.127029492510  0.008799010286\n"
"      2.494032826008  0.766489587737 -0.198532965699  0.002540653375  0.543849904725 -0.096663192733  0.374569463127 -0.196169938991  0.006398276758\n"
"      0.988354848429  0.557414017577 -0.427662657827 -1.418467855641  0.407338672608 -0.097657540866  0.368089865298 -0.053996889860  0.204329631644\n"
"      0.344978242158  0.031729942841  0.260121348436  2.550221093172  0.053320914508  0.508429500180  0.281719022542  0.149590629720  0.039178572608\n"
"      0.099465768726 -0.025637387109  0.887675876654 -1.335540301345 -0.003779723220  0.911795065206  0.071642894272  1.026626831833  1.055662599287\n"
"#","\n"
" Cu SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      5.804051150731  0.020918100390 -0.004381592772  0.275442696345\n"
"      2.947777593081 -0.106208582202  0.017185613995  0.351705110927\n"
"      1.271621207972  0.307397740339 -0.089805629814  0.331635969640\n"
"      0.517173767860  0.240805274553  0.054415126660  0.259386540456\n"
"      0.198006620331 -0.798718095004  0.446326740476  0.151105835782\n"
"      0.061684232135 -0.738671023869  0.468516012555  0.030634833418\n"
"#","\n"
" Cu DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      5.804051150731  0.020918100390  0.045720931893 -0.004381592772 -0.021109803873  0.275442696345 -0.101811263028 -0.016523760157\n"
"      2.947777593081 -0.106208582202 -0.094026024883  0.017185613995  0.020960301873  0.351705110927 -0.207670618594  0.055142365254\n"
"      1.271621207972  0.307397740339 -0.110623536813 -0.089805629814  0.233442747472  0.331635969640 -0.224161904198 -0.286656089760\n"
"      0.517173767860  0.240805274553 -0.742218346329  0.054415126660  0.369266430953  0.259386540456  0.176105738988 -0.502349311598\n"
"      0.198006620331 -0.798718095004  2.208107372713  0.446326740476 -1.405067129701  0.151105835782  0.210534119173 -0.508940020577\n"
"      0.061684232135 -0.738671023869 -1.720016262377  0.468516012555  1.042169799071  0.030634833418  0.902456275117  0.682110135764\n"
"#","\n"
" Zn SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      6.400812724595  0.021801105639  0.002944311709  0.285687212506\n"
"      3.167793332690 -0.095613408620 -0.010450068121  0.358913949434\n"
"      1.341703542578  0.274599856591  0.109519543853  0.326076466590\n"
"      0.545418416941  0.137056274402 -0.060402922899  0.224403593782\n"
"      0.222221794449 -0.625184197271 -0.531920972347  0.097325359555\n"
"      0.079830045424 -0.482184818124 -0.498668813865  0.009048926598\n"
"#","\n"
" Zn DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      6.400812724595  0.021801105639  0.042720631346  0.002944311709  0.015629658082  0.285687212506 -0.088263924683 -0.000548299003\n"
"      3.167793332690 -0.095613408620 -0.109242428655 -0.010450068121 -0.063967389104  0.358913949434 -0.137258994504  0.001063691080\n"
"      1.341703542578  0.274599856591 -0.024734012319  0.109519543853 -0.067544866326  0.326076466590 -0.221544327713  0.030739369071\n"
"      0.545418416941  0.137056274402 -1.003647707301 -0.060402922899 -0.144585524038  0.224403593782  0.258114817153  0.504509433027\n"
"      0.222221794449 -0.625184197271  2.351480103434 -0.531920972347  1.553520638132  0.097325359555  0.333724215761  0.222475088124\n"
"      0.079830045424 -0.482184818124 -1.671373693342 -0.498668813865 -1.253104288811  0.009048926598  0.857995942810  0.894090639367\n"
"#","\n"
" Ga SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      7.066653970373  0.004038828810  0.000167446202 -0.311164169605\n"
"      3.428369180000 -0.049926015210  0.003362568505 -0.386388805667\n"
"      1.430064114378  0.270487560795  0.130532105798 -0.341437057173\n"
"      0.571610928613  0.114461485481 -0.096032824634 -0.204608212390\n"
"      0.232196966975 -0.765662388169 -0.807329497232 -0.056129936831\n"
"      0.076561670688 -0.411890094700 -0.419386452377 -0.001205250841\n"
"#","\n"
" Ga DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      7.066653970373  0.004038828810 -0.031816598052  0.000167446202  0.029367472355 -0.311164169605 -0.152377671375  0.008402101637\n"
"      3.428369180000 -0.049926015210  0.005769897361  0.003362568505 -0.090542574365 -0.386388805667 -0.200456714008 -0.016601774058\n"
"      1.430064114378  0.270487560795  0.375790997895  0.130532105798 -0.084206693559 -0.341437057173 -0.304563164958  0.049257564549\n"
"      0.571610928613  0.114461485481  0.388650732034 -0.096032824634  0.052258004145 -0.204608212390  0.349719373167  0.451920686398\n"
"      0.232196966975 -0.765662388169 -1.779139618248 -0.807329497232  1.288732412987 -0.056129936831  0.455579311293  0.322063208269\n"
"      0.076561670688 -0.411890094700  1.829743730735 -0.419386452377 -1.217068254825 -0.001205250841  0.817649971475  1.018553207480\n"
"#","\n"
" Ge SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      3.751626352194 -0.081330564365  0.009035073443\n"
"      1.419172362656  0.601635148115  0.102040890998\n"
"      0.322428319082 -0.974594550901 -0.762506665117\n"
"      0.110739925211 -0.656437584837 -0.400605035566\n"
"#","\n"
" Ge DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      3.751626352194 -0.081330564365  0.131718200550  0.009035073443 -0.028177828258 -0.016817594331\n"
"      1.419172362656  0.601635148115 -0.833571668129  0.102040890998 -0.184453915085  0.112319200324\n"
"      0.322428319082 -0.974594550901  1.770142218328 -0.762506665117  1.459738649058  1.386642934635\n"
"      0.110739925211 -0.656437584837 -1.762909730970 -0.400605035566 -1.461907495600  0.473933627779\n"
"#","\n"
" As SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.098624139209  0.855667038605  0.312802805211\n"
"      0.889293303816 -0.687764546866 -0.362619654191\n"
"      0.234710973732 -0.705420359459 -0.425177185346\n"
"      0.097981856094 -0.209729326520 -0.182957845017\n"
"#","\n"
" As DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.098624139209  0.855667038605 -0.557301753073  0.312802805211 -0.238167652686 -0.102371891125\n"
"      0.889293303816 -0.687764546866 -0.627315887673 -0.362619654191  0.216505388598  0.223787145639\n"
"      0.234710973732 -0.705420359459 -2.016588485577 -0.425177185346  0.935056716086  0.988597507108\n"
"      0.097981856094 -0.209729326520  1.439205779281 -0.182957845017 -1.485977479107  0.039413462750\n"
"#","\n"
" Se SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.465689267622  0.522315327760  0.302629346132\n"
"      1.029752381010 -0.177617010578 -0.349360567622\n"
"      0.303575471349 -1.057800048233 -0.653355185785\n"
"      0.107173147417 -0.299101385035 -0.381186874482\n"
"#","\n"
" Se DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.465689267622  0.522315327760  0.109434486047  0.302629346132  0.397353185807  0.120897258750\n"
"      1.029752381010 -0.177617010578  0.919860707697 -0.349360567622 -0.410169822544 -0.291516752716\n"
"      0.303575471349 -1.057800048233 -1.719933785859 -0.653355185785 -0.626545135443 -1.069566209605\n"
"      0.107173147417 -0.299101385035  2.073037006457 -0.381186874482  2.208055478040 -0.296658894209\n"
"#","\n"
" Br SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.737392738120  0.698849040883  0.408222406946\n"
"      0.995743043074 -0.178219675950 -0.559269850657\n"
"      0.337588776628 -1.701043348622 -1.220407791913\n"
"      0.115887043391 -0.358131187327 -0.708522727592\n"
"#","\n"
" Br DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.737392738120  0.698849040883 -0.027829541950  0.408222406946  0.104199804352  0.735355883214\n"
"      0.995743043074 -0.178219675950  0.121124053665 -0.559269850657 -0.028681992792 -2.354878683630\n"
"      0.337588776628 -1.701043348622 -2.197717138458 -1.220407791913 -0.996384166266 -2.891234672063\n"
"      0.115887043391 -0.358131187327  1.946344639416 -0.708522727592  3.770311426725 -0.592507107440\n"
"#","\n"
" Kr SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 1 4 1 1\n"
"      1.784435668906  0.810837662050  0.348552421052\n"
"      1.005532891273 -0.533585820331 -0.573408630951\n"
"      0.327795673641 -1.439836500217 -0.909538466141\n"
"      0.108549688447 -0.206171398876 -0.408970770978\n"
"#","\n"
" Kr DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 2 4 2 2 1\n"
"      1.784435668906  0.810837662050 -0.329499714794  0.348552421052 -0.018676893124 -0.577769793404\n"
"      1.005532891273 -0.533585820331  0.849588151788 -0.573408630951 -0.063596257231 -0.379378556605\n"
"      0.327795673641 -1.439836500217 -2.926928041746 -0.909538466141 -0.786542637237 -1.203208979343\n"
"      0.108549688447 -0.206171398876  1.961821687963 -0.408970770978  1.457080125376  1.674577778254\n"
"#","\n"
" Rb SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 1 7 2 1\n"
"      7.107230694150 -0.062218041672 -0.013507092266  0.035700265054\n"
"      2.414406259100  0.488731908603  0.125115402960 -0.161483665734\n"
"      1.134628425827 -0.101894960518 -0.042229797524  0.211536304024\n"
"      0.483816136667 -0.827806256641 -0.296364033354  0.499666987934\n"
"      0.198690371820 -0.304219423335 -0.278176269515  0.306717399916\n"
"      0.078496630593  0.002468186208  0.316847793087  0.039955632038\n"
"      0.029773227781  0.025109167182  0.829792452385 -0.000551065720\n"
"#","\n"
" Rb DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 2 7 3 2 1\n"
"      7.107230694150 -0.062218041672 -0.013507092266  0.027821303246  0.035700265054 -0.009299202459 -0.001936508600\n"
"      2.414406259100  0.488731908603  0.125115402960 -0.230232762986 -0.161483665734  0.041686622213 -0.002780629610\n"
"      1.134628425827 -0.101894960518 -0.042229797524  0.239146438168  0.211536304024 -0.062301116336  0.092739553255\n"
"      0.483816136667 -0.827806256641 -0.296364033354 -0.001364253092  0.499666987934 -0.186160284116  0.347438745009\n"
"      0.198690371820 -0.304219423335 -0.278176269515  1.281826773475  0.306717399916 -0.090677499009  0.636698242337\n"
"      0.078496630593  0.002468186208  0.316847793087 -2.888698734643  0.039955632038  0.258184855427  0.573025473782\n"
"      0.029773227781  0.025109167182  0.829792452385  1.751588992331 -0.000551065720  0.909374383359  0.565570253663\n"
"#","\n"
" Sr SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 1 6 2 1\n"
"      7.290111894735  0.069364270475 -0.016182746349  0.035659445929\n"
"      2.536776771327 -0.571246927373  0.158928639982 -0.195822349727\n"
"      1.283099546928  0.167836311459 -0.041157757852  0.260320252229\n"
"      0.532449841650  0.904733330629 -0.431882417196  0.555386362294\n"
"      0.211628059408  0.250907816117 -0.073959284415  0.267635587013\n"
"      0.050841303698  0.007135721199  0.825600560103  0.001214128781\n"
"#","\n"
" Sr DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 2 6 3 2 1\n"
"      7.290111894735  0.069364270475 -0.016182746349 -0.139466774650  0.035659445929  0.013920724630 -0.000090724547\n"
"      2.536776771327 -0.571246927373  0.158928639982 -0.692403611332 -0.195822349727 -0.076802870831 -0.010109417559\n"
"      1.283099546928  0.167836311459 -0.041157757852 -0.230309165261  0.260320252229  0.101479121539  0.066689821534\n"
"      0.532449841650  0.904733330629 -0.431882417196 -0.069075854659  0.555386362294  0.267329775450  0.181824639879\n"
"      0.211628059408  0.250907816117 -0.073959284415  1.145292027845  0.267635587013  0.052802012061  0.278155352971\n"
"      0.050841303698  0.007135721199  0.825600560103 -2.640301525895  0.001214128781 -0.501686484262  0.157444712589\n"
"#","\n"
" Y  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      7.169829557085  0.064756738089 -0.022627762846 -0.024276685117 -0.000498514326\n"
"      2.700922470615 -0.597719860262  0.235885458901  0.187917721906 -0.031403568872\n"
"      1.376251109084  0.082122642041 -0.087291364288 -0.245232860710  0.127573561162\n"
"      0.656916983532  0.966304799106 -0.405979470239 -0.598857920831  0.336722884287\n"
"      0.281951576337  0.370251411162 -0.369782037034 -0.347360898522  0.474465039649\n"
"      0.114567346626  0.047095993893  0.381463146281 -0.027444250529  0.383269025496\n"
"      0.041587097849  0.121766951290  0.813527659184 -0.000772518245  0.124574151507\n"
"#","\n"
" Y  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      7.169829557085  0.064756738089 -0.022627762846  0.003819575374 -0.024276685117 -0.007895618075 -0.000498514326 -0.004435490551 -0.001782791348\n"
"      2.700922470615 -0.597719860262  0.235885458901 -0.198330198799  0.187917721906  0.069387220484 -0.031403568872  0.054881707361  0.012853512634\n"
"      1.376251109084  0.082122642041 -0.087291364288  0.531158632032 -0.245232860710 -0.134631203363  0.127573561162 -0.129541942957 -0.087471625840\n"
"      0.656916983532  0.966304799106 -0.405979470239  0.108726218382 -0.598857920831 -0.231880747338  0.336722884287 -0.597681869599 -0.650935776283\n"
"      0.281951576337  0.370251411162 -0.369782037034  1.371830612307 -0.347360898522 -0.080179872806  0.474465039649 -0.136727173378 -0.584017959493\n"
"      0.114567346626  0.047095993893  0.381463146281 -3.345342150310 -0.027444250529  0.520590734955  0.383269025496  0.038190788742 -0.696187518367\n"
"      0.041587097849  0.121766951290  0.813527659184  2.147987485965 -0.000772518245  0.741032334112  0.124574151507  1.078804758995  0.524836449052\n"
"#","\n"
" Zr SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      7.568385790028 -0.094978310907 -0.033616559232 -0.020865512366 -0.001689422502\n"
"      2.940870125103  0.694261607918  0.288000788551  0.222352813741 -0.011935551626\n"
"      1.478549725921 -0.214258448962 -0.141902662715 -0.319406707712  0.152103521468\n"
"      0.699652747292 -0.923670545104 -0.452166355085 -0.588541345286  0.296191130217\n"
"      0.314575404780 -0.327047026378 -0.381211768681 -0.309198403218  0.399124869129\n"
"      0.129868596693  0.003239038466  0.526743157382 -0.019801636662  0.242072326904\n"
"      0.046850569449 -0.007129719335  0.810803550660 -0.000524643311  0.048657150043\n"
"#","\n"
" Zr DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      7.568385790028 -0.094978310907 -0.033616559232 -0.013349699986 -0.020865512366 -0.002290591691 -0.001689422502 -0.002354868577  0.003856737689\n"
"      2.940870125103  0.694261607918  0.288000788551 -0.164712644101  0.222352813741  0.053781865205 -0.011935551626  0.026432470933 -0.013583377285\n"
"      1.478549725921 -0.214258448962 -0.141902662715  0.533207302704 -0.319406707712 -0.122494830242  0.152103521468 -0.076453834071 -0.086468568432\n"
"      0.699652747292 -0.923670545104 -0.452166355085  0.109420966738 -0.588541345286 -0.277888241330  0.296191130217 -0.273025800110 -0.563950845131\n"
"      0.314575404780 -0.327047026378 -0.381211768681  1.392697829361 -0.309198403218  0.025966843597  0.399124869129  0.045119618315 -0.622062115242\n"
"      0.129868596693  0.003239038466  0.526743157382 -3.337321484704 -0.019801636662  0.475807819736  0.242072326904  0.180401992175 -0.552753691412\n"
"      0.046850569449 -0.007129719335  0.810803550660  2.074605849369 -0.000524643311  0.625967738574  0.048657150043  1.105393639621  0.165196094208\n"
"#","\n"
" Nb SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      3.445688332127  6.967608357644 -3.377478792599 -0.840846380047  0.388363778921\n"
"      3.361754070289 -7.592191163341  3.690016909917  0.956420493475 -0.389233499416\n"
"      1.402769349742  0.489341601567 -0.310828636726 -0.276255708969 -0.232772054682\n"
"      0.638107530614  0.749244219846 -0.462987145063 -0.340280885378 -0.367470032847\n"
"      0.297916452528  0.168228854756 -0.275959272761 -0.120882245268 -0.373135144785\n"
"      0.134531184887 -0.010188517089  0.576706104059 -0.004779969154 -0.185455779821\n"
"      0.051687918628  0.006294814846  0.631490283017 -0.000211964161 -0.039160568093\n"
"#","\n"
" Nb DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      3.445688332127  6.967608357644 -3.377478792599  8.753281549590 -0.840846380047  0.156868559129  0.388363778921  0.459373932984  0.464314945457\n"
"      3.361754070289 -7.592191163341  3.690016909917 -8.926202800310  0.956420493475 -0.211987417412 -0.389233499416 -0.467868954158 -0.427447517961\n"
"      1.402769349742  0.489341601567 -0.310828636726  0.633972204920 -0.276255708969  0.225373426671 -0.232772054682 -0.169379157593 -0.197717184453\n"
"      0.638107530614  0.749244219846 -0.462987145063 -0.111601241388 -0.340280885378  0.183794395021 -0.367470032847 -0.323135603674 -0.588178917976\n"
"      0.297916452528  0.168228854756 -0.275959272761  1.410604379810 -0.120882245268 -0.165885709655 -0.373135144785  0.023106426168 -0.476010923425\n"
"      0.134531184887 -0.010188517089  0.576706104059 -3.231399119388 -0.004779969154 -0.336057891318 -0.185455779821 -0.086482885111 -0.466998469570\n"
"      0.051687918628  0.006294814846  0.631490283017  2.118393728700 -0.000211964161 -0.786575100596 -0.039160568093  1.131690269915  0.648887813696\n"
"#","\n"
" Mo SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      2.540273246178 -0.578530819221  0.207479779241  0.307100812758 -0.149151531382\n"
"      1.999996221023  0.255133124027 -0.231957971109 -0.375633370985  0.289650418561\n"
"      0.894040376874  0.676100594670  0.285544120446 -0.244205356948  0.207391250228\n"
"      0.439256605865  0.131763425580  0.062954195096 -0.177325998176  0.312615422763\n"
"      0.189497802537  0.085911973535 -0.210930323620 -0.016882413378  0.200727667932\n"
"      0.083802212693 -0.062285567387 -0.868201464922 -0.000916114554  0.047819428716\n"
"      0.052948764137  0.016176877393 -0.574266536022  0.000883614589  0.013662121505\n"
"#","\n"
" Mo DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      2.540273246178 -0.578530819221  0.207479779241 -0.299914438061  0.307100812758 -0.056135943926 -0.149151531382  0.078318936957  0.090482429273\n"
"      1.999996221023  0.255133124027 -0.231957971109 -0.417466028636 -0.375633370985  0.137590516968  0.289650418561 -0.193587305622 -0.158221499177\n"
"      0.894040376874  0.676100594670  0.285544120446  0.515341081590 -0.244205356948  0.160869646404  0.207391250228 -0.376645017726 -0.294586192143\n"
"      0.439256605865  0.131763425580  0.062954195096 -0.748853953260 -0.177325998176 -0.132932627695  0.312615422763 -0.186682023670 -0.705339054554\n"
"      0.189497802537  0.085911973535 -0.210930323620  1.300969236640 -0.016882413378 -0.383867077982  0.200727667932  0.236167100944 -0.270988043507\n"
"      0.083802212693 -0.062285567387 -0.868201464922 -3.373816977234 -0.000916114554 -0.526274675338  0.047819428716  0.096109040144 -0.475221485624\n"
"      0.052948764137  0.016176877393 -0.574266536022  1.973814085745  0.000883614589 -0.535005148259  0.013662121505  1.079607069896  0.639098431599\n"
"#","\n"
" Tc SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      3.164224765901 -4.936025404648  2.690105911399  1.875473204955 -0.315743748171\n"
"      3.111533459421  5.402033503677 -2.906113798449 -1.589412009269  0.248590535878\n"
"      1.923601224823 -0.382432085374  0.205154484199 -0.484599011050  0.277986264842\n"
"      0.887428259225 -0.325518324167  0.411180892172 -0.878565217193  0.337694430891\n"
"      0.387592572799 -0.122553923184  0.110130628461 -0.345096002980  0.419921218350\n"
"      0.151375638104  0.091448243559 -0.679068092339 -0.016891045364  0.202434518908\n"
"      0.052897942898  0.094934643036 -0.799513230137  0.002744375423  0.022350450321\n"
"#","\n"
" Tc DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      3.164224765901 -4.936025404648  2.690105911399  8.299735456543  1.875473204955 -0.389124278660 -0.315743748171  0.453605787389  0.417278606867\n"
"      3.111533459421  5.402033503677 -2.906113798449 -8.422380593905 -1.589412009269  0.310379586569  0.248590535878 -0.430318362917 -0.352874423698\n"
"      1.923601224823 -0.382432085374  0.205154484199  0.605501825023 -0.484599011050  0.219977647323  0.277986264842 -0.192462070398 -0.135620561050\n"
"      0.887428259225 -0.325518324167  0.411180892172 -0.244963673523 -0.878565217193  0.144726968569  0.337694430891 -0.252253826854 -0.492425087615\n"
"      0.387592572799 -0.122553923184  0.110130628461  1.309565408916 -0.345096002980 -0.226102503229  0.419921218350 -0.096741785658 -0.446932223217\n"
"      0.151375638104  0.091448243559 -0.679068092339 -3.154717953969 -0.016891045364 -0.394462618190  0.202434518908 -0.085506487189 -0.445111357421\n"
"      0.052897942898  0.094934643036 -0.799513230137  2.197244299784  0.002744375423 -0.648372090195  0.022350450321  1.149052887456  0.721221763063\n"
"#","\n"
" Ru SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 2 7 2 1 1\n"
"      2.787485846721  0.419245156353  0.847305490262 -2.358144554736  0.788526811934\n"
"      2.671513807197  0.402523023175 -1.207617992281  2.345239865410 -0.863711338604\n"
"      1.595751289168 -0.808149719838  0.513111660606  0.317793572742 -0.053253108229\n"
"      0.821527061530 -0.477224887406  0.129164670091  0.512263090829 -0.202587225418\n"
"      0.376346360068 -0.163265585552  0.268674181220  0.188482905753 -0.146122499622\n"
"      0.192696937194 -0.088262869679 -0.408874960105  0.000829620006 -0.095330219372\n"
"      0.068097557464 -0.260996120571 -0.797339816834  0.001387096163 -0.024995451964\n"
"#","\n"
" Ru DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 3 7 3 2 2 1\n"
"      2.787485846721  0.419245156353  0.847305490262  6.921824287372 -2.358144554736 -0.707900609304  0.788526811934  0.431581913720  0.626906168798\n"
"      2.671513807197  0.402523023175 -1.207617992281 -7.215911406936  2.345239865410  0.713232939519 -0.863711338604 -0.493940272079 -0.640462793210\n"
"      1.595751289168 -0.808149719838  0.513111660606  0.791734614725  0.317793572742  0.156002828255 -0.053253108229 -0.106350839479 -0.104374234384\n"
"      0.821527061530 -0.477224887406  0.129164670091 -0.269179658833  0.512263090829  0.255718656921 -0.202587225418 -0.431181078906 -0.721109469116\n"
"      0.376346360068 -0.163265585552  0.268674181220  1.108319334214  0.188482905753 -0.505228683203 -0.146122499622  0.055386787557 -0.474329276924\n"
"      0.192696937194 -0.088262869679 -0.408874960105 -3.154973580527  0.000829620006 -0.444948207050 -0.095330219372  0.157949246530 -0.620019133396\n"
"      0.068097557464 -0.260996120571 -0.797339816834  1.934939194182  0.001387096163 -0.452796474664 -0.024995451964  1.037559058652  0.466016266685\n"
"#","\n"
" Rh SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.157817444361  0.760084070950  0.239207051701 -0.336193318541 -0.176446839307\n"
"      2.683291075925 -0.255650224037 -0.091067207483  0.373953992584  0.261743358411\n"
"      1.140786095845 -1.025626679377 -0.520689753906  0.300684698668  0.174717739794\n"
"      0.492081007160 -0.234415477939 -0.274976137245  0.141457244144  0.188746290944\n"
"      0.192543904978  0.046321838032  0.534686741279  0.007751787318  0.112894420897\n"
"      0.066486620394  0.135748106274  0.896548625743  0.000117823467  0.021703317232\n"
"#","\n"
" Rh DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.157817444361  0.760084070950  0.239207051701 -0.176908781955 -0.336193318541 -0.088125446787 -0.176446839307 -0.026270559744  0.115615533976\n"
"      2.683291075925 -0.255650224037 -0.091067207483  0.468944646941  0.373953992584  0.061257175816  0.261743358411 -0.026406732314 -0.111111060683\n"
"      1.140786095845 -1.025626679377 -0.520689753906 -0.120831837016  0.300684698668 -0.192303757667  0.174717739794 -0.254749961865 -0.622696187547\n"
"      0.492081007160 -0.234415477939 -0.274976137245  1.313841940318  0.141457244144  0.290786768179  0.188746290944  0.046758963178 -0.157786278903\n"
"      0.192543904978  0.046321838032  0.534686741279 -3.287648327719  0.007751787318  0.580565362723  0.112894420897  0.048917987662 -0.581950444165\n"
"      0.066486620394  0.135748106274  0.896548625743  1.948301386804  0.000117823467  0.790444403671  0.021703317232  0.972191217603  0.993182295696\n"
"#","\n"
" Rh SZV-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      3.902721449032  0.016652865171 -0.008699428728 -0.112417659954\n"
"      1.999830271997 -0.133395648426  0.046572987907  0.348017742874\n"
"      0.879887627395  0.373099930807 -0.153463590375  0.381775351795\n"
"      0.363794442257  0.298777744612 -0.052550610965  0.335875585916\n"
"      0.140096726529 -0.924610879301  0.949493319446  0.146687236468\n"
"      0.042562039477 -0.455102584336  0.423881871378  0.013082339937\n"
"#","\n"
" Rh SZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 2 6 2 1 2\n"
"      3.902721449032  0.016652865171 -0.068138878878 -0.008699428728  -0.112417659954 -0.059777116284\n"
"      1.999830271997 -0.133395648426 -0.004871048934  0.046572987907   0.348017742874  0.202056639971\n"
"      0.879887627395  0.373099930807  0.649713932179 -0.153463590375   0.381775351795  0.110186767731\n"
"      0.363794442257  0.298777744612 -0.021734587290 -0.052550610965   0.335875585916  0.064547743479\n"
"      0.140096726529 -0.924610879301 -1.860437433134  0.949493319446   0.146687236468 -0.989654088355\n"
"      0.042562039477 -0.455102584336  1.740659313641  0.423881871378   0.013082339937 -0.289820583737\n"
"#","\n"
" Rh DZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      3.902721449032  0.016652865171 -0.068138878878 -0.008699428728 -0.059391469214 -0.112417659954 -0.059777116284 -0.003558664914\n"
"      1.999830271997 -0.133395648426 -0.004871048934  0.046572987907  0.041960437254  0.348017742874  0.202056639971 -0.044875919808\n"
"      0.879887627395  0.373099930807  0.649713932179 -0.153463590375  0.518188755943  0.381775351795  0.110186767731  0.283349273890\n"
"      0.363794442257  0.298777744612 -0.021734587290 -0.052550610965 -0.216591015187  0.335875585916  0.064547743479  1.043919000870\n"
"      0.140096726529 -0.924610879301 -1.860437433134  0.949493319446 -0.898213733147  0.146687236468 -0.989654088355 -0.791074751670\n"
"      0.042562039477 -0.455102584336  1.740659313641  0.423881871378  1.173029461392  0.013082339937 -0.289820583737 -0.082082714309\n"
"#","\n"
" Pd SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      3.408675573589 -0.132466784026 -0.567545309589 -0.237012042169\n"
"      3.102531722049 -0.437179496952  0.553597861423  0.281832849168\n"
"      1.644492988513  0.691818466230  0.309106812808  0.110086701020\n"
"      0.791839035568  0.350166504373  0.314239136372  0.167791703969\n"
"      0.316235520337  0.074477347669  0.070008169012  0.139346360820\n"
"      0.109243742847 -0.009869037755 -0.003111197582  0.062460911300\n"
"#","\n"
" Pd DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      3.408675573589 -0.132466784026  0.029290454237 -0.567545309589  0.092784274333 -0.237012042169  0.095368996052 -0.073961706459\n"
"      3.102531722049 -0.437179496952  0.192782667373  0.553597861423 -0.071388535306  0.281832849168 -0.080649769787  0.103257171864\n"
"      1.644492988513  0.691818466230 -0.427625425484  0.309106812808 -0.179050519933  0.110086701020 -0.295200859905 -0.351204999462\n"
"      0.791839035568  0.350166504373 -0.357653431542  0.314239136372 -0.049934153069  0.167791703969  0.018285464999 -0.414552037766\n"
"      0.316235520337  0.074477347669  0.052946309434  0.070008169012  0.231812779555  0.139346360820 -0.027457577038 -0.637088708585\n"
"      0.109243742847 -0.009869037755  1.328390548434 -0.003111197582  0.958384247940  0.062460911300  1.416457521209  1.171833433651\n"
"#","\n"
" Ag SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 2 5 1 1 1\n"
"      2.586709178255  0.043754600978  0.022644943791 -0.228119986020\n"
"      1.295159890890 -0.065091062805 -0.041727270135 -0.411112871153\n"
"      0.553039826122 -0.405167335465 -0.158228872130 -0.391768462286\n"
"      0.211183058137  0.497578418798  0.484453657192 -0.227577654035\n"
"      0.062847168062  0.619659047740  0.747373652696 -0.034845530428\n"
"#","\n"
" Ag DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 3 5 2 2 2 1\n"
"      2.586709178255  0.043754600978  0.016002004018  0.022644943791  0.005366630333 -0.228119986020 -0.065708005966  0.049544247949\n"
"      1.295159890890 -0.065091062805 -0.036550568555 -0.041727270135  0.118122315157 -0.411112871153 -0.164499674965 -0.230239586867\n"
"      0.553039826122 -0.405167335465  1.349533052863 -0.158228872130  0.689957680364 -0.391768462286 -0.083405899269 -0.501645626428\n"
"      0.211183058137  0.497578418798 -2.535842013811  0.484453657192 -1.573396135858 -0.227577654035 -0.038684987758 -0.563865046243\n"
"      0.062847168062  0.619659047740  1.655664881614  0.747373652696  1.108931560435 -0.034845530428  1.073281933345  0.515376673117\n"
"#","\n"
" Cd SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 5 1 1 1\n"
"      2.617301292227  0.056942862843  0.032277317911 -0.270406154064\n"
"      1.315617684053 -0.111910427538 -0.096634842893 -0.407839310946\n"
"      0.573375899853 -0.420173785813 -0.083107933622 -0.363233448773\n"
"      0.222222213763  0.564376116618  0.419549254990 -0.168907403589\n"
"      0.076307136525  0.789967059806  0.795089873672 -0.013172843723\n"
"#","\n"
" Cd DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 5 2 2 2 1\n"
"      2.617301292227  0.056942862843  0.085229465042  0.032277317911  0.051510843904 -0.270406154064 -0.064920306950 -0.038770557595\n"
"      1.315617684053 -0.111910427538 -0.202708060768 -0.096634842893 -0.059783928261 -0.407839310946 -0.152553100915 -0.110107626346\n"
"      0.573375899853 -0.420173785813  1.542506765787 -0.083107933622  0.615455610766 -0.363233448773  0.032121836723 -0.034014284171\n"
"      0.222222213763  0.564376116618 -2.827046600082  0.419549254990 -1.767302700397 -0.168907403589 -0.117391708980 -0.107254575233\n"
"      0.076307136525  0.789967059806  1.744522478935  0.795089873672  1.158998093237 -0.013172843723  1.045519107194  1.059683456620\n"
"#","\n"
" In SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      3.101675464995 -0.014756989563 -0.002337235001  0.245121261683\n"
"      1.829866249849 -0.064345448008  0.031433449222  0.432609058860\n"
"      0.898324196118  0.435246205245 -0.178879364380  0.486649088749\n"
"      0.389454004688 -0.080147974732  0.140416923228  0.288251501897\n"
"      0.162701041351 -0.728191656411  0.548122424076  0.057468890352\n"
"      0.059412871673 -0.313235936982  0.384462238049 -0.000258770565\n"
"#","\n"
" In DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      3.101675464995 -0.014756989563 -0.110029580336 -0.002337235001  0.052839464904  0.245121261683 -0.012257945606  0.018888332958\n"
"      1.829866249849 -0.064345448008  0.153222489077  0.031433449222 -0.110752586447  0.432609058860 -0.110028720800 -0.034470276859\n"
"      0.898324196118  0.435246205245  0.391315648506 -0.178879364380 -0.100516978998  0.486649088749 -0.199975755292  0.113987435924\n"
"      0.389454004688 -0.080147974732  0.337603965479  0.140416923228  0.023776328126  0.288251501897  0.335339132093  0.644348565644\n"
"      0.162701041351 -0.728191656411 -1.893798269373  0.548122424076  1.285364410462  0.057468890352  0.399314422381  0.277069768884\n"
"      0.059412871673 -0.313235936982  1.933683990690  0.384462238049 -1.445573560596 -0.000258770565  0.813978718300  0.799646050773\n"
"#","\n"
" Sn SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      0.666669575074  0.689214482698  0.249601611539\n"
"      0.486831392324 -0.512955759145 -0.282734426066\n"
"      0.172775679838 -0.598032924010 -0.235164953470\n"
"      0.065536149861 -0.215612744096 -0.261775353331\n"
"      0.063643963946  0.056968014830  0.117722874377\n"
"#","\n"
" Sn DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      0.666669575074  0.689214482698  0.597390157534  0.249601611539  0.315252873428  0.457406998777\n"
"      0.486831392324 -0.512955759145 -0.578949723335 -0.282734426066 -0.456284996504 -0.671314814330\n"
"      0.172775679838 -0.598032924010 -0.232486513252 -0.235164953470  0.160480606525 -0.579588972796\n"
"      0.065536149861 -0.215612744096 -1.308667699314 -0.261775353331 -1.088783079841 -1.650667611807\n"
"      0.063643963946  0.056968014830  2.152315008945  0.117722874377  1.400518346191  0.726312420432\n"
"#","\n"
" Sb SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      0.757214368696  0.691593689520  0.756051462053\n"
"      0.576116222147 -0.351217469046 -0.792348307348\n"
"      0.244349272369 -0.615740163850 -0.378296806004\n"
"      0.160329448814 -0.264402217378 -0.611128127466\n"
"      0.073465983327 -0.171357973436 -0.255229944153\n"
"#","\n"
" Sb DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      0.757214368696  0.691593689520  1.088920140322  0.756051462053  0.641112817519  0.801626688859\n"
"      0.576116222147 -0.351217469046 -0.822676611872 -0.792348307348 -0.692298068143 -0.889703632274\n"
"      0.244349272369 -0.615740163850  0.211516912099 -0.378296806004 -0.178293615513 -1.240429938237\n"
"      0.160329448814 -0.264402217378 -1.715750005616 -0.611128127466 -0.751513283235 -2.058418758569\n"
"      0.073465983327 -0.171357973436  2.700437428872 -0.255229944153  1.854777651762  0.223525953909\n"
"#","\n"
" Te SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      0.871170553457 -0.768209530501 -0.201075823729\n"
"      0.666552751461  0.368144626623  0.204460083751\n"
"      0.260565380434  0.833378133558  0.154271149685\n"
"      0.171876990300  0.191335229653  0.113448742480\n"
"      0.082233548720  0.215694921905  0.106354644586\n"
"#","\n"
" Te DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      0.871170553457 -0.768209530501  0.791359979104 -0.201075823729  0.531876807227  0.753248997934\n"
"      0.666552751461  0.368144626623 -0.650859183208  0.204460083751 -0.682761765123 -0.946881734404\n"
"      0.260565380434  0.833378133558  0.702283405156  0.154271149685  0.282705036438 -0.783009060844\n"
"      0.171876990300  0.191335229653 -1.929360042093  0.113448742480 -0.665024191612 -1.602503279568\n"
"      0.082233548720  0.215694921905  2.377910783672  0.106354644586  1.691098378374  0.055752014401\n"
"#","\n"
" I  SZV-MOLOPT-SR-GTH  SZV-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      0.966172693776 -0.472463189351 -0.431253473002\n"
"      0.828885570527 -0.046174838614  0.405448133098\n"
"      0.367159310806  0.674866028669  0.154408288042\n"
"      0.201369106832  0.441846190432  0.307131088797\n"
"      0.083015071126  0.147700751496  0.151452356751\n"
"#","\n"
" I  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      0.966172693776 -0.472463189351  1.555822203873 -0.431253473002  0.437499136144  0.790909981479\n"
"      0.828885570527 -0.046174838614 -0.405245398304  0.405448133098 -0.360836974979 -0.706739130323\n"
"      0.367159310806  0.674866028669  0.837346281042  0.154408288042 -0.426955819328 -1.146102256372\n"
"      0.201369106832  0.441846190432 -2.170714561688  0.307131088797 -0.142879089720 -1.473453298743\n"
"      0.083015071126  0.147700751496  2.099200395478  0.151452356751  1.946428231727 -0.517749701272\n"
"#","\n"
" Xe SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      1.060135338393  0.595086879307 -0.455562867881\n"
"      0.666666004946 -0.333303102706  0.584858919323\n"
"      0.277808854324 -0.853453515069  0.556607088551\n"
"      0.171463992710  0.008584975685  0.284690856924\n"
"      0.096899106515 -0.148160183031  0.213921134179\n"
"#","\n"
" Xe DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      1.060135338393  0.595086879307  1.159498326834 -0.455562867881  0.341641892911  0.461999932788\n"
"      0.666666004946 -0.333303102706 -0.700514321869  0.584858919323 -0.637621905684 -0.861718349639\n"
"      0.277808854324 -0.853453515069  0.843332917012  0.556607088551  0.421389646121 -0.690146245180\n"
"      0.171463992710  0.008584975685 -2.438781702578  0.284690856924 -1.036777647654 -2.060830843444\n"
"      0.096899106515 -0.148160183031  2.027210394018  0.213921134179  2.018039151988  0.570372103567\n"
"#","\n"
" Cs SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 1 6 2 1\n"
"      1.000865707027  0.280322352634  0.098179355219 -0.360207388692\n"
"      0.913482115012  0.358344637273 -0.098255007626 -0.016242892143\n"
"      0.666653730505 -0.489376812003  0.118067108510  0.500190150119\n"
"      0.332485858625 -0.512310150761 -0.480608369395  0.336498234976\n"
"      0.149836705312 -0.141743262814  0.078136295233  0.344475837226\n"
"      0.026691284164  0.280660075501  1.173263741421  0.011885241412\n"
"#","\n"
" Cs DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q9\n"
" 1\n"
" 2 0 2 6 3 2 1\n"
"      1.000865707027  0.280322352634  0.098179355219  0.031141586311 -0.360207388692  0.002335867187  0.147697150754\n"
"      0.913482115012  0.358344637273 -0.098255007626  0.330103917383 -0.016242892143  0.084765416923  0.071945154769\n"
"      0.666653730505 -0.489376812003  0.118067108510 -0.659442112080  0.500190150119 -0.132236014043 -0.240447290500\n"
"      0.332485858625 -0.512310150761 -0.480608369395  3.043138449037  0.336498234976 -0.036101912675 -0.535530906149\n"
"      0.149836705312 -0.141743262814  0.078136295233 -3.444995658743  0.344475837226 -0.076534707873 -0.669534557468\n"
"      0.026691284164  0.280660075501  1.173263741421  1.178266960491  0.011885241412  1.106818006414  0.388389576072\n"
"#","\n"
" Ba SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 1 6 2 1\n"
"      1.099107387393 -0.265977603953  0.133167313532 -0.076120521522\n"
"      1.042415611430 -0.548867124949  0.303553076384  0.581707053986\n"
"      0.923815583300  0.534778251294 -0.187596947384 -0.513377720928\n"
"      0.409515187180  0.587584269233 -0.829784858376 -0.199996660495\n"
"      0.166000524554  0.112796348364  0.080177822791 -0.129413972483\n"
"      0.038868137908 -0.097599163432  1.388751874990  0.001685949311\n"
"#","\n"
" Ba DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q10\n"
" 1\n"
" 2 0 2 6 3 2 1\n"
"      1.099107387393 -0.265977603953  0.133167313532  0.290876128104 -0.076120521522  0.156054210447  0.457091203328\n"
"      1.042415611430 -0.548867124949  0.303553076384 -0.457720153751  0.581707053986  0.034898462239 -0.051884397940\n"
"      0.923815583300  0.534778251294 -0.187596947384  0.955681723101 -0.513377720928 -0.112603657198 -0.325084641003\n"
"      0.409515187180  0.587584269233 -0.829784858376 -3.839746465310 -0.199996660495 -0.398760799348 -1.103831466587\n"
"      0.166000524554  0.112796348364  0.080177822791  3.559104747841 -0.129413972483  0.013035859628 -1.307997155338\n"
"      0.038868137908 -0.097599163432  1.388751874990 -1.406284723707  0.001685949311  0.806788017038 -0.503750948349\n"
"#","\n"
" Hf SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      2.671196497548  0.788939427855  0.166407997203 -0.301974408389 -0.047796823905\n"
"      2.597200237263 -0.135944993309  0.121000538909  0.293385766135  0.040716807355\n"
"      1.091215248046 -0.911502384031 -0.450097538431  0.044171452367  0.281226003531\n"
"      0.482780902120 -0.403765732131 -0.527116158052  0.050912843752  0.563159769901\n"
"      0.184203719686 -0.116982787286  0.367518491637  0.006790589259  0.537885417612\n"
"      0.060257634881 -0.118019349325  0.917540530320 -0.000081217891  0.138650274135\n"
"#","\n"
" Hf DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      2.671196497548  0.788939427855  0.166407997203 -0.808044747643 -0.301974408389  0.200618001886 -0.047796823905 -0.576358120326  0.136965103461\n"
"      2.597200237263 -0.135944993309  0.121000538909  0.502710504170  0.293385766135 -0.131814094303  0.040716807355  0.121047786291 -0.101127257056\n"
"      1.091215248046 -0.911502384031 -0.450097538431 -0.571536407023  0.044171452367 -0.119671510085  0.281226003531 -0.260083157654 -0.239844496668\n"
"      0.482780902120 -0.403765732131 -0.527116158052  1.567869205746  0.050912843752 -0.209054741982  0.563159769901 -0.061407406614 -0.448266650992\n"
"      0.184203719686 -0.116982787286  0.367518491637 -3.196670125867  0.006790589259 -0.050569947887  0.537885417612 -0.642967474054 -0.402343230211\n"
"      0.060257634881 -0.118019349325  0.917540530320  1.895484387467 -0.000081217891 -0.947169815010  0.138650274135  0.976981432228  1.144416860469\n"
"#","\n"
" Ta SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      2.946055777701  0.481243902001 -0.039175358113  0.388448534264 -0.093115240785\n"
"      2.777081321651 -0.000792758352  0.308251777475 -0.366342974440  0.111690390706\n"
"      1.000199049661 -0.863712437729 -0.568363162228 -0.156083711841  0.225370492392\n"
"      0.459026245077 -0.356339626223 -0.406417265286 -0.108217872947  0.293416264804\n"
"      0.201289293145 -0.023090355735  0.248901497428 -0.015667426694  0.298377389246\n"
"      0.065633603795 -0.015350833125  0.839900958846  0.000163546036  0.101787930127\n"
"#","\n"
" Ta DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      2.946055777701  0.481243902001 -0.039175358113 -0.219388739489  0.388448534264 -0.107938517042 -0.093115240785 -0.050799537716  0.071927166904\n"
"      2.777081321651 -0.000792758352  0.308251777475  0.403285867163 -0.366342974440  0.047342767090  0.111690390706  0.051196996245 -0.015240206083\n"
"      1.000199049661 -0.863712437729 -0.568363162228 -0.077743160108 -0.156083711841 -0.041740097950  0.225370492392 -0.295019586907 -0.470524112950\n"
"      0.459026245077 -0.356339626223 -0.406417265286  1.717095624131 -0.108217872947  0.095987055932  0.293416264804 -0.181398283746 -0.645020041639\n"
"      0.201289293145 -0.023090355735  0.248901497428 -3.203010923833 -0.015667426694  0.541275844761  0.298377389246 -0.083413162524 -0.819326850350\n"
"      0.065633603795 -0.015350833125  0.839900958846  2.207786277506  0.000163546036  1.013357766701  0.101787930127  1.239644127245  0.794184603929\n"
"#","\n"
" W  SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.103253876757  0.441154908462 -0.046848871737  0.516608286752 -0.104347730230\n"
"      2.893835485057  0.301691972314  0.288483139662 -0.467840628709  0.135920880880\n"
"      1.106150599362 -1.218290751007 -0.497581763775 -0.270577331119  0.396440765199\n"
"      0.501100356736 -0.518231686854 -0.399441949193 -0.201524408230  0.551980290722\n"
"      0.214446586103 -0.084224251837  0.243845988221 -0.022741809925  0.520355492616\n"
"      0.074662878487 -0.194908755488  0.767604001481  0.002782169859  0.166409595366\n"
"#","\n"
" W  DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q14\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.103253876757  0.441154908462 -0.046848871737  0.061298236069  0.516608286752 -0.857438192378 -0.104347730230  0.147146022027  0.063493654940\n"
"      2.893835485057  0.301691972314  0.288483139662  0.240334881954 -0.467840628709  0.847145939975  0.135920880880 -0.154506508676 -0.017539591740\n"
"      1.106150599362 -1.218290751007 -0.497581763775 -0.484396153573 -0.270577331119 -0.102821415305  0.396440765199 -0.271607294299 -0.299829989865\n"
"      0.501100356736 -0.518231686854 -0.399441949193  1.821350211035 -0.201524408230  0.202413605224  0.551980290722 -0.086061740572 -0.841712144112\n"
"      0.214446586103 -0.084224251837  0.243845988221 -3.376374627548 -0.022741809925  0.726346128053  0.520355492616 -0.074473115136 -0.801669560536\n"
"      0.074662878487 -0.194908755488  0.767604001481  1.871608065172  0.002782169859  1.071006452855  0.166409595366  1.370657399699  0.359000011573\n"
"#","\n"
" Re SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.240620484285  0.518163100285 -0.250238063014  0.468480577212 -0.072782318249\n"
"      2.835126642764  0.195266488444  0.421668475444 -0.390221082301  0.122612230842\n"
"      1.164528911859 -1.218515127381 -0.468452769005 -0.460013931050  0.480667297031\n"
"      0.530722413547 -0.526678086213 -0.480290161831 -0.325605406180  0.649752314300\n"
"      0.234483312957  0.013465891784  0.546638137882 -0.033295571228  0.547928673428\n"
"      0.080543361521  0.073473765653  1.175883886226  0.000112993288  0.124811170239\n"
"#","\n"
" Re DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q15\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.240620484285  0.518163100285 -0.250238063014 -0.143105506392  0.468480577212 -0.321600051025 -0.072782318249  0.025724531725 -0.094952415125\n"
"      2.835126642764  0.195266488444  0.421668475444  0.282261176246 -0.390221082301  0.399779900733  0.122612230842 -0.054892892051  0.167119769419\n"
"      1.164528911859 -1.218515127381 -0.468452769005 -0.091681345615 -0.460013931050 -0.473028481025  0.480667297031 -0.324411259630 -0.392227058286\n"
"      0.530722413547 -0.526678086213 -0.480290161831  1.803552484337 -0.325605406180  0.144355698544  0.649752314300 -0.308280195070 -0.743838252325\n"
"      0.234483312957  0.013465891784  0.546638137882 -3.327790605170 -0.033295571228  0.634911741065  0.547928673428 -0.127571404930 -1.130445599596\n"
"      0.080543361521  0.073473765653  1.175883886226  2.036392104934  0.000112993288  0.654149241066  0.124811170239  1.436351247342  0.187517650202\n"
"#","\n"
" Os SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.254044521240  0.750520917538 -0.143104881416  0.300026803534  0.074118403382\n"
"      2.913080457815 -0.151830818511  0.445036489078 -0.259358262119 -0.115497320573\n"
"      1.267677044450 -0.946576386912 -0.597290651826 -0.221193553941 -0.384061295904\n"
"      0.604328817602 -0.387028536076 -0.626533321263 -0.169922484236 -0.478648993701\n"
"      0.281958732679 -0.114632827845  0.617675737134 -0.022924623249 -0.460410219053\n"
"      0.105080883429 -0.043141212439  0.420830468078  0.003128164174 -0.078890551925\n"
"#","\n"
" Os DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q16\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.254044521240  0.750520917538 -0.143104881416 -0.535872399061  0.300026803534 -0.211083191310  0.074118403382  0.126612739775  0.055180357207\n"
"      2.913080457815 -0.151830818511  0.445036489078  0.515111350010 -0.259358262119  0.229325744297 -0.115497320573 -0.133462796701 -0.050797865115\n"
"      1.267677044450 -0.946576386912 -0.597290651826 -0.260044026215 -0.221193553941 -0.306853849304 -0.384061295904 -0.172895146469 -0.094606319061\n"
"      0.604328817602 -0.387028536076 -0.626533321263  2.036801058213 -0.169922484236 -0.097257714947 -0.478648993701 -0.020295601352 -0.619031243983\n"
"      0.281958732679 -0.114632827845  0.617675737134 -3.120177167686 -0.022924623249  0.777630448466 -0.460410219053  0.083516044344 -0.782263365247\n"
"      0.105080883429 -0.043141212439  0.420830468078  2.188492676789  0.003128164174  0.996792107810 -0.078890551925  1.136520641989 -0.218817489272\n"
"#","\n"
" Ir SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.382588893137  0.763880845384  0.045942912052  0.377410965587 -0.045848645796\n"
"      2.784159868873 -0.292040459450  0.216107018572 -0.332679361082  0.111589415592\n"
"      1.210222778222 -0.909572071077 -0.662794901842 -0.436015494968  0.421660006206\n"
"      0.538964109721 -0.253085528911 -0.351696141574 -0.249715223969  0.494349511683\n"
"      0.221744781815 -0.072390522439  0.495615757119 -0.017455807910  0.370178722395\n"
"      0.076331555777 -0.086622720340  0.741983451061 -0.000390256599  0.086694983507\n"
"#","\n"
" Ir DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q17\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.382588893137  0.763880845384  0.045942912052 -0.263001102796  0.377410965587 -0.244073478822 -0.045848645796  0.080634315236  0.043335746927\n"
"      2.784159868873 -0.292040459450  0.216107018572  0.479096801070 -0.332679361082  0.284264073291  0.111589415592 -0.130581842872 -0.027515178683\n"
"      1.210222778222 -0.909572071077 -0.662794901842 -0.247236645375 -0.436015494968 -0.355790158310  0.421660006206 -0.303249401129 -0.249112788977\n"
"      0.538964109721 -0.253085528911 -0.351696141574  1.693017503277 -0.249715223969  0.296278894300  0.494349511683 -0.146179963439 -0.712777874450\n"
"      0.221744781815 -0.072390522439  0.495615757119 -3.248000084180 -0.017455807910  0.597905270423  0.370178722395 -0.212963343957 -0.608411042049\n"
"      0.076331555777 -0.086622720340  0.741983451061  1.914284024079 -0.000390256599  0.721347075950  0.086694983507  1.131902611500  0.702894953816\n"
"#","\n"
" Pt SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 2 6 2 1 1\n"
"      3.630667770866 -0.159789658749 -0.051717884453  0.538256464339 -0.235370873672\n"
"      3.114659085953  0.706153230701  0.409305333723 -0.272066595039  0.216340904150\n"
"      1.999980602577 -0.571771619750 -0.410633416904 -0.529494089441  0.129334517594\n"
"      0.885339761910 -0.081706194543 -0.389005427246 -0.778436218941  0.364806321954\n"
"      0.330796251617 -0.114509254013  0.079357268588 -0.160188783181  0.322200075207\n"
"      0.105770091411 -0.422769859471  0.768211167014  0.009487463222  0.101113260398\n"
"#","\n"
" Pt DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q18\n"
" 1\n"
" 2 0 3 6 3 2 2 1\n"
"      3.630667770866 -0.159789658749 -0.051717884453  0.306450339788  0.538256464339 -0.065391881766 -0.235370873672  0.116835554957  0.047374313928\n"
"      3.114659085953  0.706153230701  0.409305333723 -0.004265278861 -0.272066595039  0.095535920231  0.216340904150 -0.069230936472 -0.086321928611\n"
"      1.999980602577 -0.571771619750 -0.410633416904 -0.325808096224 -0.529494089441 -0.142896827794  0.129334517594 -0.143174497742 -0.045559578405\n"
"      0.885339761910 -0.081706194543 -0.389005427246  2.249070845144 -0.778436218941 -0.282985948216  0.364806321954 -0.296713078924 -0.269438595683\n"
"      0.330796251617 -0.114509254013  0.079357268588 -3.545365684090 -0.160188783181  0.355152674354  0.322200075207 -0.091262909891 -0.826716259834\n"
"      0.105770091411 -0.422769859471  0.768211167014  1.739828578507  0.009487463222  1.072406293162  0.101113260398  0.921513114926  0.798799196421\n"
"#","\n"
" Au SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 2 5 1 1 1\n"
"      2.950008433436  0.043352289298  0.027243676590 -0.013694544955\n"
"      1.563056721867 -0.007387713167  0.010297865642  0.393434199831\n"
"      0.666663784909 -0.527617143816 -0.144512389068  0.499419616649\n"
"      0.251083343925  0.504357857018  0.133984006194  0.342848487787\n"
"      0.081714167287  0.754614789542  0.955899672482  0.072643323717\n"
"#","\n"
" Au DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q11\n"
" 1\n"
" 2 0 3 5 2 2 2 1\n"
"      2.950008433436  0.043352289298  0.131563039441  0.027243676590  0.028420586704 -0.013694544955 -0.004579045037 -0.004506137994\n"
"      1.563056721867 -0.007387713167 -0.273187489232  0.010297865642 -0.293415713813  0.393434199831 -0.180469448036 -0.160912550000\n"
"      0.666663784909 -0.527617143816  1.676640340285 -0.144512389068  0.816838276799  0.499419616649 -0.108498062902 -0.120663084497\n"
"      0.251083343925  0.504357857018 -2.954078498545  0.133984006194 -1.870657920681  0.342848487787 -0.166963798876 -0.308972159083\n"
"      0.081714167287  0.754614789542  1.757201273778  0.955899672482  1.065823745725  0.072643323717  1.125505465534  1.113838074084\n"
"#","\n"
" Hg SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      3.031517109734 -0.000773276442 -0.035104188311 -0.051519431610\n"
"      1.999949750084 -0.127545432316  0.112459425109  0.245745995267\n"
"      0.968505371291  0.467348942725 -0.270433349168  0.344642941759\n"
"      0.443215909283  0.041435964338  0.012885629971  0.274191104401\n"
"      0.197907885691 -0.613050351354  0.562923305773  0.133463525187\n"
"      0.078429867482 -0.478543703910  0.626349238816  0.016313913539\n"
"#","\n"
" Hg DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q12\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      3.031517109734 -0.000773276442  0.142001377433 -0.035104188311 -0.090931506623 -0.051519431610  0.008323885654  0.001599032324\n"
"      1.999949750084 -0.127545432316 -0.280482979589  0.112459425109  0.162444892253  0.245745995267 -0.053441689967  0.043884187965\n"
"      0.968505371291  0.467348942725  0.098625459472 -0.270433349168  0.029548333852  0.344642941759 -0.165877240510 -0.177253996973\n"
"      0.443215909283  0.041435964338 -1.223462696050  0.012885629971  0.581078127814  0.274191104401  0.080323576326 -0.478266521156\n"
"      0.197907885691 -0.613050351354  3.053372335969  0.562923305773 -2.004214126133  0.133463525187 -0.144762593434 -0.613795411840\n"
"      0.078429867482 -0.478543703910 -2.173525587081  0.626349238816  1.450865733492  0.016313913539  1.183407428870  0.788269658688\n"
"#","\n"
" Tl SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 2 6 1 1 1\n"
"      3.381004006201 -0.012728024519 -0.016321000960 -0.053146025142\n"
"      1.995904628767 -0.125438487741  0.089582033082  0.335647454889\n"
"      0.933877613856  0.654386378507 -0.217643347249  0.449765059425\n"
"      0.399454518437 -0.261927153680  0.120847730197  0.311198161018\n"
"      0.159704350468 -0.832380709805  0.521905432003  0.079298892465\n"
"      0.061648317122 -0.296535560045  0.504618443314  0.000172821470\n"
"#","\n"
" Tl DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q13\n"
" 1\n"
" 2 0 3 6 2 2 2 1\n"
"      3.381004006201 -0.012728024519 -0.061982942976 -0.016321000960  0.062772243005 -0.053146025142  0.033620187298 -0.003552704832\n"
"      1.995904628767 -0.125438487741  0.232903517659  0.089582033082 -0.085940512856  0.335647454889 -0.143867909630 -0.007253615821\n"
"      0.933877613856  0.654386378507  0.293870645694 -0.217643347249 -0.043458296138  0.449765059425 -0.230549240854  0.070845906277\n"
"      0.399454518437 -0.261927153680  0.253865535097  0.120847730197 -0.072921411535  0.311198161018  0.089679875757  0.337468890558\n"
"      0.159704350468 -0.832380709805 -1.750489239268  0.521905432003  1.361409731000  0.079298892465  0.093223456445  0.055414449864\n"
"      0.061648317122 -0.296535560045  1.812842163522  0.504618443314 -1.338528342478  0.000172821470  0.951780949164  1.007671535938\n"
"#","\n"
" Pb SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      1.933597551820 -0.128503343993  0.015280202292\n"
"      0.981424884833  0.574812594694 -0.134233849467\n"
"      0.222223023415 -0.960047108285  0.502933226160\n"
"      0.077758928722 -0.206626081460  0.243024445565\n"
"      0.073967768161 -0.082212261416  0.131891977459\n"
"#","\n"
" Pb DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q4\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      1.933597551820 -0.128503343993 -0.101796893236  0.015280202292  0.005350345202  0.014172606616\n"
"      0.981424884833  0.574812594694  0.383708445593 -0.134233849467  0.075210282932 -0.095091389111\n"
"      0.222223023415 -0.960047108285 -0.673075164196  0.502933226160 -0.366898195819  0.404788663351\n"
"      0.077758928722 -0.206626081460 -0.887877388873  0.243024445565 -1.159690406979 -0.640460683863\n"
"      0.073967768161 -0.082212261416  1.917996276605  0.131891977459  1.651684865211  1.791004946570\n"
"#","\n"
" Bi SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      1.666928293168 -0.433606016760 -0.092396269342\n"
"      1.317941720436  0.723433454454  0.184381669404\n"
"      0.222221383065 -0.715303457579 -0.507231634301\n"
"      0.074524438950 -0.308379410009 -0.421377693158\n"
"      0.066725427306  0.159245921554  0.106621540317\n"
"#","\n"
" Bi DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q5\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      1.666928293168 -0.433606016760 -0.100663867810 -0.092396269342 -0.108190299502 -0.195956091275\n"
"      1.317941720436  0.723433454454  0.259612627134  0.184381669404  0.210739707604  0.351618767590\n"
"      0.222221383065 -0.715303457579 -0.216478402471 -0.507231634301 -0.568218339722 -1.047717462114\n"
"      0.074524438950 -0.308379410009 -1.423645113253 -0.421377693158 -0.757828317889 -1.887710553530\n"
"      0.066725427306  0.159245921554  2.308274018558  0.106621540317  1.788226073856  0.443921215549\n"
"#","\n"
" Po SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      1.757750856683 -0.224044332601 -0.053062093035\n"
"      1.245376491921  0.572355818018  0.195354776138\n"
"      0.251860493510 -0.863597717984 -0.839838825812\n"
"      0.087993894799 -0.286569207007 -0.307002699297\n"
"      0.087955184861  0.098257897619 -0.203109314513\n"
"#","\n"
" Po DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q6\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      1.757750856683 -0.224044332601 -0.135012487173 -0.053062093035 -0.021231103721 -0.096055785490\n"
"      1.245376491921  0.572355818018  0.332752073309  0.195354776138  0.081960076684  0.254315976726\n"
"      0.251860493510 -0.863597717984 -0.473417673148 -0.839838825812 -0.313733392241 -0.969368508973\n"
"      0.087993894799 -0.286569207007 -1.276188389904 -0.307002699297 -0.822258321101 -1.683509583898\n"
"      0.087955184861  0.098257897619  1.876429081086 -0.203109314513  1.692783549882  0.775369779849\n"
"#","\n"
" At SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      1.796641038213 -0.363075778132 -0.119884096868\n"
"      1.378396886358  0.702535890722  0.281487205121\n"
"      0.332155278101 -0.571059806679 -0.483364756316\n"
"      0.150379247357 -0.338513795954 -0.533191703362\n"
"      0.059913588731 -0.008356077866 -0.164154832840\n"
"#","\n"
" At DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q7\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      1.796641038213 -0.363075778132 -1.100370829977 -0.119884096868 -0.250626278132 -0.464474892145\n"
"      1.378396886358  0.702535890722 -1.057174398279  0.281487205121  0.561700422906  0.955620810236\n"
"      0.332155278101 -0.571059806679  0.447996190508 -0.483364756316 -1.242559252539 -1.899306426919\n"
"      0.150379247357 -0.338513795954 -1.273313528437 -0.533191703362  0.441233871549 -1.551331120159\n"
"      0.059913588731 -0.008356077866  0.740426167051 -0.164154832840  0.937688301921 -0.982495907237\n"
"#","\n"
" Rn SZV-MOLOPT-SR-GTH SZV-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 1 5 1 1\n"
"      2.000005663002 -0.442608171766 -0.136991011529\n"
"      1.522474413760  0.852282073224  0.312749617939\n"
"      0.319589540831 -0.907143180970 -0.775828387512\n"
"      0.124013091191 -0.222277238353 -0.204098521582\n"
"      0.113270499507 -0.001928995329 -0.288853228632\n"
"#","\n"
" Rn DZVP-MOLOPT-SR-GTH DZVP-MOLOPT-SR-GTH-q8\n"
" 1\n"
" 2 0 2 5 2 2 1\n"
"      2.000005663002 -0.442608171766 -0.511614938408 -0.136991011529 -0.063901785194 -0.186151960320\n"
"      1.522474413760  0.852282073224 -0.536614916033  0.312749617939  0.154086890384  0.369270825531\n"
"      0.319589540831 -0.907143180970 -0.390801321298 -0.775828387512 -0.485164655715 -1.000515166114\n"
"      0.124013091191 -0.222277238353 -1.541429072147 -0.204098521582 -1.116124046015 -1.713700191874\n"
"      0.113270499507 -0.001928995329  1.908801729636 -0.288853228632  1.721625954410  0.927072017361\n"
"#","\n"
" U DZVP-MOLOPT-GTH-q14\n"
" 1\n"
" 6  0  4  7  3  3  2  2  1       6s              7s              8s              6p              7p              8p              6d              7d              5f              6f              5g\n"
"       2.970404051267 -8.613286991729 -4.847218644580 -0.094448304725  2.089613520508 -1.388690863894 -0.339032038879 -0.517917661294 -0.108712988266  0.630053678940 -0.328083139683  0.193812038517\n"
"       2.837409896206  9.359917338956  5.295013384216  0.080503840695 -2.330831226482  1.591366466533 -0.297639904371  0.575541916820  0.134339314945  0.077256524471 -0.136357555344 -0.096937116722\n"
"       1.029287870466 -0.223393808655 -0.207730929575  0.170499084947  0.118073808224 -0.298526476737 -0.144235936067 -0.007051323571 -0.072924564853  0.798224117501 -0.044975575325  0.942045397086\n"
"       0.447156512122 -1.138927348908 -1.085942892963 -0.128005768148  0.875430068610 -0.558080313712  0.020421937017 -0.328938941888 -0.022899936943  0.416776715909  0.084347995405  1.112468197028\n"
"       0.224386023364 -0.475585548696 -0.147870903958  0.028006926300  0.257221846022 -0.186869197027 -0.068935950988 -0.436497768592  0.047774203203  0.269342903301  0.107901532632  0.049712666496\n"
"       0.082082026090 -0.038412518166  1.206363318489  0.959404540206 -0.004940369038  1.337846156620  1.078056470699 -0.170128075474  1.023142281896  0.095618485831  0.591613653295  0.071150976147\n"
"       0.048989649967 -0.161438730593  0.204614845616  0.064250249847 -0.040926507048  0.070410902066  0.151425801177  0.019870929957  0.031382006308 -0.029027116072  0.159595534158 -0.000586301554\n"
"#"};
