(* AST *)
(* $Id: ast.mli,v 1.3 2004/07/25 20:40:23 berke Exp $ *)
(* AST *)
(* $Id: ast.mli,v 1.3 2004/07/25 20:40:23 berke Exp $ *)

type ident = string

type ('a,'b) boolean =
| And of ('a,'b) boolean * ('a,'b) boolean
| Or of ('a,'b) boolean * ('a,'b) boolean
| Not of ('a,'b) boolean
| True
| False
| Atom of 'a
| Meta of 'b * ('a,'b) boolean
and 'a relational =
| Identity
| Union of 'a relational * 'a relational
| Intersection of 'a relational * 'a relational
| Complement of 'a relational
| Star of 'a relational
| Plus of 'a relational
| Compose of 'a relational * 'a relational
| Reverse of 'a relational
| Relation of 'a

type regexp_option =
| Case_insensitive
| Word_boundary

type statement =
| Assign of ident * int * int * set_query
| Display of set_query
and relation =
| Field_link of field_spec
and atomic_set =
| Matches of field_spec * pattern
| Reference of ident
and pattern =
| Exact of string
| Lexicographic_le of string
| Lexicographic_lt of string
| Lexicographic_ge of string
| Lexicographic_gt of string
| Regular of string * regexp_option list
and field_spec =
| Current_field
| Some_field of pattern
| This_field of string
| Either_field of field_spec * field_spec
and meta =
| With_field of field_spec
| Apply_relation of relation relational
and set_query = (atomic_set, meta) boolean

val dump : Format.formatter -> statement -> unit
