(* Configfile *)
(* $Id$ *)

type t =
| List of t list
| Boolean of bool
| Integer of int
| String of string
| Tuple of t list
| Record of (string * handle) list ref
and handle
and status =
| Dont_change (* don't save to user configuration file *)
| Save (* should be saved when other values are saved *)
| Changed (* was changed, needs saving *)
;;
type context;;

exception Parse_error of int * string
exception Semantic_error of string
exception Key_not_found of string
exception No_default_value of string
exception Is_not_a_record of string
exception Type_error of string * string
exception No_filename;;

val handle : t -> handle
val create_context : ?config:t option -> string option -> context
val get_config : context -> t
val set_config : context -> t -> unit
val load_from_file : string -> t
val load : ?merge_with:t list -> string option -> string list -> context * (string * exn) list
val save : context -> unit
val get : ?set:bool -> ?default:t -> context -> string -> t
val set : context -> string -> t -> unit
val to_int : ?k:string -> t -> int
val to_string : ?k:string -> t -> string
val to_bool : ?k:string -> t -> bool
val to_pair : (t -> 'a) -> (t -> 'b) -> ?k:string -> t -> 'a * 'b
val to_list : (t -> 'a) -> ?k:string -> t -> 'a list
val get_int : ?default:int -> context -> string -> int
val get_string : ?default:string -> context -> string -> string
val get_bool : ?default:bool -> context -> string -> bool
val get_pair : ?default:t -> (t -> 'a) -> (t -> 'b) -> context -> string -> 'a * 'b
val get_list : ?default:t -> (t -> 'a) -> context -> string -> 'a list
val set_int : context -> string -> int -> unit
val set_string : context -> string -> string -> unit
val set_bool : context -> string -> bool -> unit
val set_pair : context -> string -> t * t -> unit
val dump : ?show_status:bool -> Format.formatter -> t -> unit
val duplicate : t -> t
val duplicate_context : context -> context
val set_filename : context -> string option -> unit
