# 8 What role did the state take in the creation of capitalism?

If the "anarcho"-capitalist is to claim with any plausibility that "real"
capitalism is non-statist or that it can exist without a state, it must be
shown that capitalism evolved naturally, in opposition to state intervention.
However, in reality, the opposite is the case. Capitalism was born from state
intervention and, in the words of Kropotkin, _"the State . . . and capitalism
. . . developed side by side, mutually supporting and re-enforcing each
other."_ [ **Kropotkin's Revolutionary Pamphlets** , p. 181]

Numerous writers have made this point. For example, in Karl Polanyi's flawed
masterpiece **The Great Transformation** we read that _"the road to the free
market was opened and kept open by an enormous increase in continuous,
centrally organised and controlled interventionism"_ by the state [p. 140].
This intervention took many forms -- for example, state support during
"mercantilism," which allowed the "manufactures" (i.e. industry) to survive
and develop, enclosures of common land, and so forth. In addition, the slave
trade, the invasion and brutal conquest of the Americas and other "primitive"
nations, and the looting of gold, slaves, and raw materials from abroad also
enriched the European economy, giving the development of capitalism an added
boost. Thus Kropotkin:

> _"The history of the genesis of capital has already been told by socialists
> many times. They have described how it was born of war and pillage, of
> slavery and serfdom, of modern fraud and exploitation. They have shown how
> it is nourished by the blood of the worker, and how little by little it has
> conquered the whole world."_ [ **Op. Cit.** ,p. 207]

Or, if Kropotkin seems too committed to be fair, we have John Stuart Mill's
statement that:

> _"The social arrangements of modern Europe commenced from a distribution of
> property which was the result, not of just partition, or acquisition by
> industry, but of conquest and violence. . . "_ [ **Principles of Political
> Economy** , p. 15]

Therefore, when supporters of "libertarian" capitalism say they are against
the "initiation of force," they mean only **new** initiations of force; for
the system they support was born from numerous initiations of force in the
past. And, as can be seen from the history of the last 100 years, it also
requires state intervention to keep it going (section D.1, ["Why does state
intervention occur?,"](secD1.md) addresses this point in some detail).
Indeed, many thinkers have argued that it was precisely this state support and
coercion (particularly the separation of people from the land) that played the
**key** role in allowing capitalism to develop rather than the theory that
_"previous savings"_ did so. As the noted German thinker Franz Oppenheimer
argued, _"the concept of a 'primitive accumulation,' or an original store of
wealth, in land and in movable property, brought about by means of purely
economic forces"_ while _"seem[ing] quite plausible"_ is in fact _"utterly
mistaken; it is a 'fairly tale,' or it is a class theory used to justify the
privileges of the upper classes."_ [ **The State** , pp. 5-6]

This thesis will be discussed in the following sections. It is, of course,
ironic to hear right-wing libertarians sing the praises of a capitalism that
never existed and urge its adoption by all nations, in spite of the historical
evidence suggesting that only state intervention made capitalist economies
viable -- even in that Mecca of "free enterprise," the United States. As Noam
Chomsky argues, _"who but a lunatic could have opposed the development of a
textile industry in New England in the early nineteenth century, when British
textile production was so much more efficient that half the New England
industrial sector would have gone bankrupt without very high protective
tariffs, thus terminating industrial development in the United States? Or the
high tariffs that radically undermined economic efficiency to allow the United
States to develop steel and other manufacturing capacities? Or the gross
distortions of the market that created modern electronics?"_ [ **World Orders,
Old and New** , p. 168]. To claim, therefore, that "mercantilism" is not
capitalism makes little sense. Without mercantilism, "proper" capitalism would
never have developed, and any attempt to divorce a social system from its
roots is ahistoric and makes a mockery of critical thought.

Similarly, it is somewhat ironic when "anarcho"-capitalists and right
libertarians claim that they support the freedom of individuals to choose how
to live. After all, the working class was not given **that** particular choice
when capitalism was developing. Indeed, their right to choose their own way of
life was constantly violated and denied. So to claim that **now** (after
capitalism has been created) we get the chance to try and live as we like is
insulting in the extreme. The available options we have are not independent of
the society we live in and are decisively shaped by the past. To claim we are
"free" to live as we like (within the laws of capitalism) is basically to
argue that we are able to "buy" the freedom that every individual is due from
those who have stolen it from us in the first place!

Needless to say, some right-libertarians recognise that the state played a
massive role in encouraging industrialisation (more correct to say
"proletarianisation" as it created a working class which did not own the tools
they used, although we stress that this process started on the land and not in
industry). So they contrast "bad" business people (who took state aid) and
"good" ones. Thus Rothbard's comment that Marxists have _"made no particular
distinction between 'bourgeoisie' who made use of the state, and bourgeoisie
who acted on the free market."_ [ **The Ethics of Liberty** , p. 72]

But such an argument is nonsense as it ignores the fact that the "free market"
is a network (and defined by the state by the property rights it enforces).
For example, the owners of the American steel and other companies who grew
rich and their companies big behind protectionist walls are obviously "bad"
bourgeoisie. But are the bourgeoisie who supplied the steel companies with
coal, machinery, food, "defence" and so on not also benefiting from state
action? And the suppliers of the luxury goods to the wealthy steel company
owners, did they not benefit from state action? Or the suppliers of
commodities to the workers that laboured in the steel factories that the
tariffs made possible, did they not benefit? And the suppliers to these
suppliers? And the suppliers to these suppliers? Did not the users of
technology first introduced into industry by companies protected by state
orders also not benefit? Did not the capitalists who had a large and landless
working class to select from benefit from the "land monopoly" even though they
may not have, unlike other capitalists, directly advocated it? It increased
the pool of wage labour for **all** capitalists and increased their bargaining
position/power in the labour market at the expense of the working class. In
other words, such a policy helped maintain capitalist market power,
irrespective of whether individual capitalists encouraged politicians to vote
to create/maintain it. And, similarly, **all** capitalists benefited from the
changes in common law to recognise and protect capitalist private property and
rights that the state enforced during the 19th century (see section
[B.2.5](secB2.md#secb25)).

It appears that, for Rothbard, the collusion between state and business is the
fault, not of capitalism, but of particular capitalists. The system is pure;
only individuals are corrupt. But, for anarchists, the origins of the modern
state-capitalist system lies not in the individual qualities of capitalists as
such but in the dynamic and evolution of capitalism itself -- a complex
interaction of class interest, class struggle, social defence against the
destructive actions of the market, individual qualities and so forth. In other
words, Rothbard's claims are flawed -- they fail to understand capitalism as a
**system** and its dynamic nature.

Indeed, if we look at the role of the state in creating capitalism we could be
tempted to rename "anarcho"-capitalism "marxian-capitalism". This is because,
given the historical evidence, a political theory can be developed by which
the "dictatorship of the bourgeoisie" is created and that this capitalist
state "withers away" into anarchy. That this means rejecting the economic and
social ideas of Marxism and their replacement by their direct opposite should
not mean that we should reject the idea (after all, that is what
"anarcho"-capitalism has done to Individualist Anarchism!). But we doubt that
many "anarcho"-capitalists will accept such a name change (even though this
would reflect their politics far better; after all they do not object to past
initiations of force, just current ones and many do seem to think that the
modern state **will** wither away due to market forces).

But this is beside the point. The fact remains that state action was required
to create and maintain capitalism. Without state support it is doubtful that
capitalism would have developed at all.

So, when the right suggests that "we" be "left alone," what they mean by "we"
comes into clear focus when we consider how capitalism developed. Artisans and
peasants were only "left alone" to starve, and the working classes of
industrial capitalism were only "left alone" outside work and for only as long
as they respected the rules of their "betters." As for the other side of the
class divide, they desire to be "left alone" to exercise their power over
others, as we will see. That modern "capitalism" is, in effect, a kind of
"corporate mercantilism," with states providing the conditions that allow
corporations to flourish (e.g. tax breaks, subsidies, bailouts, anti-labour
laws, etc.) says more about the statist roots of capitalism than the
ideologically correct definition of capitalism used by its supporters.

## 8.1 What social forces lay behind the rise of capitalism?

Capitalist society is a relatively recent development. As Murray Bookchin
points out, for a _"long era, perhaps spanning more than five centuries,"_
capitalism _"coexisted with feudal and simple commodity relationships"_ in
Europe. He argues that this period _"simply cannot be treated as
'transitional' without reading back the present into the past."_ [ **From
Urbanisation to Cities** , p. 179] In other words, capitalism was not a
inevitable outcome of "history" or social evolution.

He goes on to note that capitalism existed _"with growing significance in the
mixed economy of the West from the fourteenth century up to the seventeenth"_
but that it _"literally exploded into being in Europe, particularly England,
during the eighteenth and especially nineteenth centuries."_ [ **Op. Cit.** ,
p. 181] The question arises, what lay behind this _"growing significance"_?
Did capitalism _"explode"_ due to its inherently more efficient nature or
where there other, non-economic, forces at work? As we will show, it was most
definitely the later one -- capitalism was born not from economic forces but
from the political actions of the social elites which its usury enriched.
Unlike artisan (simple commodity) production, wage labour generates
inequalities and wealth for the few and so will be selected, protected and
encouraged by those who control the state in their own economic and social
interests.

The development of capitalism in Europe was favoured by two social elites, the
rising capitalist class within the degenerating medieval cities and the
absolutist state. The medieval city was _"thoroughly changed by the gradual
increase in the power of commercial capital, due primarily to foreign trade. .
. By this the inner unity of the commune was loosened, giving place to a
growing caste system and leading necessarily to a progressive inequality of
social interests. The privileged minorities pressed ever more definitely
towards a centralisation of the political forces of the community. . .
Mercantilism in the perishing city republics led logically to a demand for
larger economic units [i.e. to nationalise the market]; and by this the desire
for stronger political forms was greatly strengthened. . . . Thus the city
gradually became a small state, paving the way for the coming national
state."_ [Rudolf Rocker, **Nationalism and Culture** , p. 94]

The rising economic power of the proto-capitalists conflicted with that of the
feudal lords, which meant that the former required help to consolidate their
position. That aid came in the form of the monarchical state. With the force
of absolutism behind it, capital could start the process of increasing its
power and influence by expanding the "market" through state action.

As far as the absolutist state was concerned, it _"was dependent upon the help
of these new economic forces, and vice versa. . . ." "The absolutist state,"_
Rocker argues, _"whose coffers the expansion of commerce filled . . ., at
first furthered the plans of commercial capital. Its armies and fleets . . .
contributed to the expansion of industrial production because they demanded a
number of things for whose large-scale production the shops of small tradesmen
were no longer adapted. Thus gradually arose the so-called manufactures, the
forerunners of the later large industries."_ [ **Op. Cit.** , p. 117-8]

Some of the most important state actions from the standpoint of early industry
were the so-called Enclosure Acts, by which the "commons" -- the free farmland
shared communally by the peasants in most rural villages -- was "enclosed" or
incorporated into the estates of various landlords as private property (see
section [8.3](append138.md#secf83)). This ensured a pool of landless workers
who had no option but to sell their labour to capitalists. Indeed, the
widespread independence caused by the possession of the majority of households
of land caused the rising class of merchants to complain _"that men who should
work as wage-labourers cling to the soil, and in the naughtiness of their
hearts prefer independence as squatters to employment by a master."_ [R.H
Tawney, cited by Allan Elgar in **The Apostles of Greed** , p. 12]

In addition, other forms of state aid ensured that capitalist firms got a head
start, so ensuring their dominance over other forms of work (such as co-
operatives). A major way of creating a pool of resources that could be used
for investment was the use of mercantilist policies which used protectionist
measures to enrich capitalists and landlords at the expense of consumers and
their workers. For example, one of most common complaints of early capitalists
was that workers could not turn up to work regularly. Once they had worked a
few days, they disappeared as they had earned enough money to live on. With
higher prices for food, caused by protectionist measures, workers had to work
longer and harder and so became accustomed to factory labour. In addition,
mercantilism allowed native industry to develop by barring foreign competition
and so allowed industrialists to reap excess profits which they could then use
to increase their investments. In the words of Marian-socialist economic
historian Maurice Dobbs:

> _"In short, the Mercantile System was a system of State-regulated
> exploitation through trade which played a highly important rule in the
> adolescence of capitalist industry: it was essentially the economic policy
> of an age of primitive accumulation."_ [ **Studies in Capitalism
> Development** , p. 209]

As Rocker summarises, _"when abolutism had victoriously overcome all
opposition to national unification, but its furthering of mercantilism and
economic monopoly it gave the whole social evolution a direction which could
only lead to capitalism."_ [ **Op. Cit.** , pp. 116-7]

This process of state aid in capitalist development was also seen in the
United States of America. As Edward Herman points out, the _"level of
government involvement in business in the United States from the late
eighteenth century to the present has followed a U-shaped pattern: There was
extensive government intervention in the pre-Civil War period (major
subsidies, joint ventures with active government participation and direct
government production), then a quasi-laissez faire period between the Civil
War and the end of the nineteenth century [a period marked by "the aggressive
use of tariff protection" and state supported railway construction, a key
factor in capitalist expansion in the USA], followed by a gradual upswing of
government intervention in the twentieth century, which accelerated after
1930."_ [ **Corporate Control, Corporate Power** , p. 162]

Such intervention ensured that income was transferred from workers to
capitalists. Under state protection, America industrialised by forcing the
consumer to enrich the capitalists and increase their capital stock.
_"According to one study, of the tariff had been removed in the 1830s 'about
half the industrial sector of New England would have been bankrupted' . . .
the tariff became a near-permanent political institution representing
government assistance to manufacturing. It kept price levels from being driven
down by foreign competition and thereby shifted the distribution of income in
favour of owners of industrial property to the disadvantage of workers and
customers."_ [Richard B. Du Boff, **Accumulation and Power** , p. 56]

This protection was essential, for as Du Boff notes, the _"end of the European
wars in 1814 . . . reopened the United States to a flood of British imports
that drove many American competitors out of business. Large portions of the
newly expanded manufacturing base were wiped out, bringing a decade of near-
stagnation."_ Unsurprisingly, the _"era of protectionism began in 1816, with
northern agitation for higher tariffs. . . "_ [ **Op. Cit.** , p. 14, p. 55]

Combined with ready repression of the labour movement and government
"homesteading" acts (see section [8.5](append138.md#secf85)), tariffs were
the American equivalent of mercantilism (which, after all, was above all else
a policy of protectionism, i.e. the use of government to stimulate the growth
of native industry). Only once America was at the top of the economic pile did
it renounce state intervention (just as Britain did, we must note).

This is **not** to suggest that government aid was limited to tariffs. The
state played a key role in the development of industry and manufacturing. As
John Zerzan notes, the _"role of the State is tellingly reflected by the fact
that the 'armoury system' now rivals the older 'American system of
manufactures' term as the more accurate to describe the new system of
production methods"_ developed in the early 1800s. [ **Elements of Refusal** ,
p. 100] Moreover, the _"lead in technological innovation [during the US
Industrial Revolution] came in armaments where assured government orders
justified high fixed-cost investments in special-pursue machinery and
managerial personnel. Indeed, some of the pioneering effects occurred in
government-owned armouries."_ [William Lazonick, **Competitive Advantage on
the Shop Floor** , p. 218] The government also _"actively furthered this
process [of "commercial revolution"] with public works in transportation and
communication."_ [Richard B. Du Boff, **Op. Cit.** , p. 15]

In addition to this "physical" aid, _"state government provided critical help,
with devices like the chartered corporation"_ [ **Ibid.** ] and, as we noted
in section [B.2.5](secB2.md#secb25), changes in the legal system which
favoured capitalist interests over the rest of society.

Interestingly, there was increasing inequality between 1840 and 1860 in the
USA This coincided with the victory of wage labour and industrial capitalism
-- the 1820s _"constituted a watershed in U.S. life. By the end of that decade
. . .industrialism assured its decisive American victory, by the end of the
1830s all of its cardinal features were definitely present."_ [John Zerzan,
**Op. Cit.** , p. 99] This is unsurprising, for as we have argued many times,
the capitalist market tends to increase, not reduce, inequalities between
individuals and classes. Little wonder the Individualist Anarchists at the
time denounced the way that property had been transformed into _"a power [with
which] to accumulate an income"_ (to use the words of J.K. Ingalls).

Over all, as Paul Ormerod puts it, the _"advice to follow pure free-market
polices seems . . . to be contrary to the lessons of virtually the whole of
economic history since the Industrial Revolution . . . every country which has
moved into . . . strong sustained growth . . . has done so in outright
violation of pure, free-market principles." "The model of entrepreneurial
activity in the product market, with judicious state support plus repression
in the labour market, seems to be a good model of economic development."_ [
**The Death of Economics** , p. 63]

Thus the social forces at work creating capitalism was a combination of
capitalist activity and state action. But without the support of the state, it
is doubtful that capitalist activity would have been enough to generate the
initial accumulation required to start the economic ball rolling. Hence the
necessity of Mercantilism in Europe and its modified cousin of state aid,
tariffs and "homestead acts" in America.

## 8.2 What was the social context of the statement "laissez-faire?"

The honeymoon of interests between the early capitalists and autocratic kings
did not last long. _"This selfsame monarchy, which for weighty reasons sought
to further the aims of commercial capital and was. . . itself aided in its
development by capital, grew at last into a crippling obstacle to any further
development of European industry."_ [Rudolf Rocker, **Nationalism and
Culture** , p. 117]

This is the social context of the expression _"laissez-faire"_ \-- a system
which has outgrown the supports that protected it in its early stages of
growth. Just as children eventually rebel against the protection and rules of
their parents, so the capitalists rebelled against the over-bearing support of
the absolutist state. Mercantilist policies favoured some industries and
harmed the growth of industrial capitalism in others. The rules and
regulations imposed upon those it did favour reduced the flexibility of
capitalists to changing environments. As Rocker argues, _"no matter how the
abolutist state strove, in its own interest, to meety the demands of commerce,
it still put on industry countless fetters which became gradually more and
more oppressive . . . [it] became an unbearable burden . . . which paralysed
all economic and social life."_ [ _Op. Cit._ , p. 119] All in all,
mercantilism became more of a hindrance than a help and so had to be replaced.
With the growth of economic and social power by the capitalist class, this
replacement was made easier.

Errico Malatesta notes, _"[t]he development of production, the vast expansion
of commerce, the immeasurable power assumed by money . . . have guaranteed
this supremacy [of economic power over the political power] to the capitalist
class which, no longer content with enjoying the support of the government,
demanded that government arise from its own ranks. A government which owed its
origin to the right of conquest . . . though subject by existing circumstances
to the capitalist class, went on maintaining a proud and contemptuous attitude
towards its now wealthy former slaves, and had pretensions to independence of
domination. That government was indeed the defender, the property owners'
gendarme, but the kind of gendarmes who think they are somebody, and behave in
an arrogant manner towards the people they have to escort and defend, when
they don't rob or kill them at the next street corner; and the capitalist
class got rid of it . . . [and replaced it] by a government [and state] . . .
at all times under its control and specifically organised to defend that class
against any possible demands by the disinherited."_ [ **Anarchy** , pp. 19-20]

Malatesta here indicates the true meaning of _"leave us alone,"_ or _"laissez-
faire."_ The **absolutist** state (not "the state" per se) began to interfere
with capitalists' profit-making activities and authority, so they determined
that it had to go -- as happened, for example, in the English, French and
American revolutions. However, in other ways, state intervention in society
was encouraged and applauded by capitalists. _"It is ironic that the main
protagonists of the State, in its political and administrative authority, were
the middle-class Utilitarians, on the other side of whose Statist banner were
inscribed the doctrines of economic Laissez Faire"_ [E.P. Thompson, **The
Making of the English Working Class** , p. 90]. Capitalists simply wanted
**capitalist** states to replace monarchical states, so that heads of
government would follow state economic policies regarded by capitalists as
beneficial to their class as a whole. And as development economist Lance
Taylor argues:

> _"In the long run, there are no laissez-faire transitions to modern economic
> growth. The state has always intervened to create a capitalist class, and
> then it has to regulate the capitalist class, and then the state has to
> worry about being taken over by the capitalist class, but the state has
> always been there."_ [quoted by Noam Chomsky, **Year 501** , p. 104]

In order to attack mercantilism, the early capitalists had to ignore the
successful impact of its policies in developing industry and a "store of
wealth" for future economic activity. As William Lazonick points out, _"the
political purpose of [Adam Smith's] the **Wealth of Nations** was to attack
the mercantilist institutions that the British economy had built up over the
previous two hundred years. . . In his attack on these institutions, Smith
might have asked why the extent of the world market available to Britain in
the late eighteenth century was **so uniquely under British control.** If
Smith had asked this 'big question,' he might have been forced to grant credit
for [it] . . . to the very mercantilist institutions he was attacking . . ."_
Moreover, he _"might have recognised the integral relation between economic
and political power in the rise of Britain to international dominance."_
Overall, _"[w]hat the British advocates of laissez-faire neglected to talk
about was the role that a system of national power had played in creating
conditions for Britain to embark on its dynamic development path . . . They
did not bother to ask how Britain had attained th[e] position [of 'workshop of
the world'], while they conveniently ignored the on going system of national
power - the British Empire -- that . . . continued to support Britain's
position."_ [ **Business Organisation and the Myth of the Market Economy** ,
p. 2, p. 3, p.5]

Similar comments are applicable to American supporters of laissez faire who
fail to notice that the "traditional" American support for world-wide free
trade is quite a recent phenomenon. It started only at the end of the Second
World War (although, of course, **within** America military Keynesian policies
were utilised). While American industry was developing, the country had no
time for laissez-faire. After it had grown strong, the United States began
preaching laissez-faire to the rest of the world -- and began to kid itself
about its own history, believing its slogans about laissez-faire as the secret
of its success. In addition to the tariff, nineteenth-century America went in
heavily for industrial planning--occasionally under that name but more often
in the name of national defence. The military was the excuse for what is today
termed rebuilding infrastructure, picking winners, promoting research, and co-
ordinating industrial growth (as it still is, we should add).

As Richard B. Du Boff points out, the "anti-state" backlash of the 1840s
onwards in America was highly selective, as the general opinion was that
_"[h]enceforth, if governments wished to subsidise private business
operations, there would be no objection. But if public power were to be used
to control business actions or if the public sector were to undertake economic
initiatives on its own, it would run up against the determined opposition of
private capital."_ [ **Accumulation and Power** , p. 26] In other words, the
state could aid capitalists indirectly (via tariffs, land policy, repression
of the labour movement, infrastructure subsidy and so on) and it would "leave
them alone" to oppress and exploit workers, exploit consumers, build their
industrial empires and so forth.

So, the expression "laissez-faire" dates from the period when capitalists were
objecting to the restrictions that helped create them in the first place. It
has little to do with freedom as such and far more to do with the needs of
capitalist power and profits (as Murray Bookchin argues, it is an error to
depict this _"revolutionary era and its democratic aspirations as 'bourgeois,'
an imagery that makes capitalism a system more committed to freedom, or even
ordinary civil liberties, than it was historically"_ [ **From Urbanisation to
Cities** , p. 180f]). Takis Fotopoules, in his essay _"The Nation-state and
the Market"_ , indicates that the social forces at work in "freeing" the
market did not represent a "natural" evolution towards freedom:

> _"Contrary to what liberals and Marxists assert, marketisation of the
> economy was not just an evolutionary process, following the expansion of
> trade under mercantilism . . . modern [i.e. capitalist] markets did not
> evolve out of local markets and/or markets for foreign goods . . . the
> nation-state, which was just emerging at the end of the Middle Ages, played
> a crucial role creating the conditions for the 'nationalisation' of the
> market . . . and . . . by freeing the market [i.e. the rich and proto-
> capitalists] from effective social control."_ [ **Society and Nature** ,
> Vol. 3, pp. 44-45]

The "freeing" of the market thus means freeing those who "own" most of the
market (i.e. the wealthy elite) from _"effective social control,"_ but the
rest of society was not as lucky. Peter Kropotkin makes a similar point in
**Modern Science and Anarchism** , _"[w]hile giving the capitalist any degree
of free scope to amass his wealth at the expense of the helpless labourers,
the government has **nowhere** and **never**. . .afforded the labourers the
opportunity 'to do as they pleased'."_ [ **Kropotkin's Revolutionary
Pamphlets** , p. 182]

The one essential form of support the "Libertarian" right wants the state (or
"defence" firms) to provide capitalism is the enforcement of property rights
-- the right of property owners to "do as they like" on their own property,
which can have obvious and extensive social impacts. What "libertarian"
capitalists object to is attempts by others -- workers, society as a whole,
the state, etc. -- to interfere with the authority of bosses. That this is
just the defence of privilege and power (and **not** freedom) has been
discussed in [section B](secBcon.md) and elsewhere in [ section
F](append13con.md), so we will not repeat ourselves here.

Samuel Johnson once observed that _"we hear the loudest **yelps** for liberty
among the drivers of Negroes."_ Our modern "libertarian" capitalist drivers of
wage-slaves are yelping for exactly the same kind of "liberty." [Johnson
quoted in Noam Chomsky, **Year 501** , p. 141]

## 8.3 What other forms did state intervention in creating capitalism take?

Beyond being a paymaster for new forms of production and social relations and
defending the owners' power, the state intervened economically in other ways
as well. As we noted in section [B.2.5](secB2.md#secb25), the state played a
key role in transforming the law codes of society in a capitalistic fashion,
ignoring custom and common law to do so. Similarly, the use of tariffs and the
granting of monopolies to companies played an important role in accumulating
capital at the expense of working people, as did the breaking of unions and
strikes by force.

However, one of the most blatant of these acts was the enclosure of common
land. In Britain, by means of the Enclosure Acts, land that had been freely
used by poor peasants for farming their small family plots was claimed by
large landlords as private property. As E.P. Thompson notes, _"Parliament and
law imposed capitalist definitions to exclusive property in land"_ [ **Customs
in Common** , p. 163]. Property rights, which exclusively favoured the rich,
replaced the use rights and free agreement that had governed peasant's use of
the commons. Unlike use rights, which rest in the individual, property rights
require state intervention to create and maintain.

This stealing of the land should not be under estimated. Without land, you
cannot live and have to sell your liberty to others. This places those with
capital at an advantage, which will tend to increase, rather than decrease,
the inequalities in society (and so place the landless workers at an
increasing disadvantage over time). This process can be seen from early stages
of capitalism. With the enclosure of the land, an agricultural workforce was
created which had to travel where the work was. This influx of landless ex-
peasants into the towns ensured that the traditional guild system crumbled and
was transformed into capitalistic industry with bosses and wage slaves rather
than master craftsmen and their journeymen. Hence the enclosure of land played
a key role, for _"it is clear that economic inequalities are unlikely to
create a division of society into an employing master class and a subject
wage-earning class, unless access to the mans of production, including land,
is by some means or another barred to a substantial section of the
community."_ [Maurice Dobbs, **Studies in Capitalist Development** , p. 253]

The importance of access to land is summarised by this limerick by the
followers of Henry George (a 19th century writer who argued for a _"single
tax"_ and the nationalisation of land). The Georgites got their basic argument
on the importance of land down these few, excellent lines:

_A college economist planned  
To live without access to land  
He would have succeeded  
But found that he needed  
Food, shelter and somewhere to stand. _

Thus the Individualist (and other) anarchists' concern over the _"land
monopoly"_ of which the Enclosure Acts were but one part. The land monopoly,
to use Tucker's words, _"consists in the enforcement by government of land
titles which do not rest upon personal occupancy and cultivation."_ [ **The
Anarchist Reader** , p. 150] It is important to remember that wage labour
first developed on the land and it was the protection of land titles of
landlords and nobility, combined with enclosure, that meant people could not
just work their own land.

In other words, the circumstances so created by enclosing the land and
enforcing property rights to large estates ensured that capitalists did not
have to point a gun at workers head to get them to work long hours in
authoritarian, dehumanising conditions. In such circumstances, when the
majority are dispossessed and face the threat of starvation, poverty,
homelessness and so on, "initiation of force" is **not required.** But guns
**were** required to enforce the system of private property that created the
labour market in the first place, to enforce the enclosure of common land and
protect the estates of the nobility and wealthy.

In addition to increasing the availability of land on the market, the
enclosures also had the effect of destroying working-class independence.
Through these Acts, innumerable peasants were excluded from access to their
former means of livelihood, forcing them to migrate to the cities to seek work
in the newly emerging factories of the budding capitalist class, who were thus
provided with a ready source of cheap labour. The capitalists, of course, did
not describe the results this way, but attempted to obfuscate the issue with
their usual rhetoric about civilisation and progress. Thus John Bellers, a
17th-century supporter of enclosures, claimed that commons were _"a hindrance
to Industry, and . . . Nurseries of Idleness and Insolence."_ The _"forests
and great Commons make the Poor that are upon them too much like the
**indians.** "_ [quoted by Thompson, **Op. Cit.** , p. 163] Elsewhere Thompson
argues that the commons _"were now seen as a dangerous centre of indiscipline
. . . Ideology was added to self-interest. It became a matter of public-
spirited policy for gentlemen to remove cottagers from the commons, reduce his
labourers to dependence . . ."_ [ **The Making of the English Working Class**
, pp. 242-3]

The commons gave working-class people a degree of independence which allowed
them to be "insolent" to their betters. This had to be stopped, as it
undermined to the very roots of authority relationships within society. The
commons **increased** freedom for ordinary people and made them less willing
to follow orders and accept wage labour. The reference to "Indians" is
important, as the independence and freedom of Native Americans is well
documented. The common feature of both cultures was communal ownership of the
means of production and free access to it (usufruct). This is discussed
further in section I.7 ([Won't Libertarian Socialism destroy
individuality?](secI7.md))

As the early American economist Edward Wakefield noted in 1833, _"where land
is cheap and all are free, where every one who so pleases can easily obtain a
piece of land for himself, not only is labour dear, as respects the labourer's
share of the product, but the difficulty is to obtain combined labour at any
price."_ [ **England and America** , quoted by Jeremy Brecher and Tim
Costello, **Commonsense for Hard Times** , p. 24]

The enclosure of the commons (in whatever form it took -- see section
[8.5](append138.md#secf85) for the US equivalent) solved both problems --
the high cost of labour, and the freedom and dignity of the worker. The
enclosures perfectly illustrate the principle that capitalism requires a state
to ensure that the majority of people do not have free access to any means of
livelihood and so must sell themselves to capitalists in order to survive.
There is no doubt that if the state had "left alone" the European peasantry,
allowing them to continue their collective farming practices ("collective
farming" because, as Kropotkin shows in **Mutual Aid** , the peasants not only
shared the land but much of the farm labour as well), capitalism could not
have taken hold (see **Mutual Aid** , pp. 184-189, for more on the European
enclosures). As Kropotkin notes, _"[i]nstances of commoners themselves
dividing their lands were rare, everywhere the State coerced them to enforce
the division, or simply favoured the private appropriation of their lands"_ by
the nobles and wealthy. [ **Mutual Aid** , p. 188]

Thus Kropotkin's statement that _"to speak of the natural death of the village
community [or the commons] in virtue of economical law is as grim a joke as to
speak of the natural death of soldiers slaughtered on a battlefield."_ [ **Op.
Cit.** , p. 189]

Like the more recent case of fascist Chile, "free market" capitalism was
imposed on the majority of society by an elite using the authoritarian state.
This was recognised by Adam Smith when he opposed state intervention in **The
Wealth of Nations**. In Smith's day, the government was openly and unashamedly
an instrument of wealth owners. Less than 10 per cent of British men (and no
women) had the right to vote. When Smith opposed state interference, he was
opposing the imposition of wealth owners' interests on everybody else (and, of
course, how "liberal", nevermind "libertarian", is a political system in which
the many follow the rules and laws set-down in the so-called interests of all
by the few? As history shows, any minority given, or who take, such power
**will** abuse it in their own interests). Today, the situation is reversed,
with neo-liberals and right libertarians opposing state interference in the
economy (e.g. regulation of Big Business) so as to prevent the public from
having even a minor impact on the power or interests of the elite.

The fact that "free market" capitalism always requires introduction by an
authoritarian state should make all honest "Libertarians" ask: How "free" is
the "free market"? And why, when it is introduced, do the rich get richer and
the poor poorer? This was the case in Chile (see [Section C.11](secC11.md)).
For the poverty associated with the rise of capitalism in England 200 years
ago, E.P. Thompson's **The Making of the English Working Class** provides a
detailed discussion. Howard Zinn's **A People's History of the United States**
describes the poverty associated with 19th-century US capitalism.

## 8.4 Aren't the enclosures a socialist myth?

The short answer is no, they are not. While a lot of historical analysis has
been spent in trying to deny the extent and impact of the enclosures, the
simple fact is (in the words of noted historian E.P. Thompson) enclosure _"was
a plain enough case of class robbery, played according to the fair rules of
property and law laid down by a parliament of property-owners and lawyers."_ [
**The Making of the English Working Class** , pp. 237-8]

The enclosures were one of the ways that the _"land monopoly"_ was created.
The land monopoly was used to refer to capitalist property rights and
ownership of land by (among others) the Individualist Anarchists. Instead of
an _"occupancy and use"_ regime advocated by anarchists, the land monopoly
allowed a few to bar the many from the land -- so creating a class of people
with nothing to sell but their labour. While this monopoly is less important
these days in developed nations (few people know how to farm) it was essential
as a means of consolidating capitalism. Given the choice, most people
preferred to become independent farmers rather than wage workers (see [next
section](append138.md#secf85)).

However, the importance of the enclosure movement is downplayed by supporters
of capitalism. Little wonder, for it is something of an embarrassment for them
to acknowledge that the creation of capitalism was somewhat less than
"immaculate" -- after all, capitalism is portrayed as an almost ideal society
of freedom. To find out that an idol has feet of clay and that we are still
living with the impact of its origins is something pro-capitalists must deny.
So **is** the enclosures a socialist myth? Most claims that it is flow from
the work of the historian J.D. Chambers' famous essay _"Enclosures and the
Labour Supply in the Industrial Revolution."_ [ **Economic History Review** ,
2nd series, no. 5, August 1953] In this essay, Chambers attempts to refute
Karl Marx's account of the enclosures and the role it played in what Marx
called _"primitive accumulation."_

We cannot be expected to provide an extensive account of the debate that has
raged over this issue. All we can do is provide a summary of the work of
William Lazonick who presented an excellent reply to those who claim that the
enclosures were an unimportant historical event. We are drawing upon his
summary of his excellent essay _"Karl Marx and Enclosures in England"_ [
**Review of Radical Political Economy** , no. 6, Summer, 1974] which can be
found in his books **Competitive Advantage on the Shop Floor** and **Business
Organisation and the Myth of the Market Economy**. There are three main claims
against the socialist account of the enclosures. We will cover each in turn.

Firstly, it is often claimed that the enclosures drove the uprooted cottager
and small peasant into industry. However, this was never claimed. It is
correct that the agricultural revolution associated with the enclosures
**increased** the demand for farm labour as claimed by Chambers and others.
And this is the whole point - enclosures created a pool of dispossessed
labourers who had to sell their time/liberty to survive. The _"critical
transformation was not the level of agricultural employment before and after
enclosure but the changes in employment relations caused by the reorganisation
of landholdings and the reallocation of access to land."_ [ **Competitive
Advantage on the Shop Floor** , p. 30] Thus the key feature of the enclosures
was that it created a supply for farm labour, a supply that had no choice but
to work for another. This would drive down wages and increase demand.
Moreover, freed from the land, these workers could later move to the towns in
search for better work.

Secondly, it is argued that the number of small farm owners increased, or at
least did not greatly decline, and so the enclosure movement was unimportant.
Again, this misses the point. Small farm owners can still employ wage workers
(i.e. become capitalist farmers as opposed to "yeomen" -- independent peasant
proprietor). As Lazonick notes, _"[i]t is true that after 1750 some petty
proprietors continued to occupy and work their own land. But in a world of
capitalist agriculture, the yeomanry no longer played an important role in
determining the course of capitalist agriculture. As a social class that could
influence the evolution of British economy society, the yeomanry had
disappeared."_ [ **Op. Cit.** , p. 32]

Thirdly, it is often claimed that it was population growth, rather than
enclosures, that caused the supply of wage workers. So was population growth
more important that enclosures? Maurice Dobbs argues that _"the centuries in
which a proletariat was most rapidly recruited were apt to be those of slow
rather than of rapid natural increase of population, and the paucity or
plenitude of a labour reserve in different countries was not correlated with
comparable difference in their rates of population-growth."_ [ **Studies in
Capitalist Development** , p. 223] Moreover, the population argument ignores
the question of whether the changes in society caused by enclosures and the
rise of capitalism have an impact on the observed trends towards earlier
marriage and larger families after 1750. Lazonick argues that _"[t]here is
reason to believe that they did."_ [ **Op. Cit.** , p. 33] Also, of course,
the use of child labour in the factories created an economic incentive to have
more children, an incentive created by the developing capitalist system.
Overall, Lazonick notes that _"[t]o argue that population growth created the
industrial labour supply is to ignore these momentous social transformations"_
associated with the rise of capitalism [ **Business Organisation and the Myth
of the Market Economy** , p. 273].

In other words, there is good reason to think that the enclosures, far from
being some kind of socialist myth, in fact played a key role in the
development of capitalism. As Lazonick himself notes, _"Chambers
misunderstood" "the argument concerning the 'institutional creation' of a
proletarianised (i.e. landless) workforce. Indeed, Chamber's own evidence and
logic tend to support the Marxian [and anarchist!] argument, when it is
properly understood."_ [ **Op. Cit.** , p. 273]

## 8.5 What about the lack of enclosures in the Americas?

The enclosure movement was but one way of creating the _"land monopoly"_ which
ensured the creation of a working class. The circumstances facing the ruling
class in the Americas were distinctly different than in the Old World and so
the "land monopoly" took a different form there. In the Americas, enclosures
were unimportant as customary land rights did not really exist. Here the
problem was that (after the original users of the land were eliminated, of
course) there were vast tracts of land available for people to use.

Unsurprisingly, there was a movement towards independent farming and this
pushed up the price of labour, by reducing the supply. Capitalists found it
difficult to find workers willing to work for them at wages low enough to
provide them with sufficient profits. It was due the difficulty in finding
cheap enough labour that capitalists in America turned to slavery. All things
being equal, wage labour **is** more productive than slavery. But in early
America all things were **not** equal. Having access to cheap (indeed, free)
land meant that working people had a choice, and few desired to become wage
slaves. Because of this, capitalists turned to slavery in the South and the
"land monopoly" in the North and West.

This was because, in the words of Maurice Dobbs, it _"became clear to those
who wished to reproduce capitalist relations of production in the new country
that the foundation-stone of their endeavour must be the restriction of land-
ownership to a minority and the exclusion of the majority from any share in
[productive] property."_ [ **Studies in Capitalist Development** , pp. 221-2]
As one radical historian puts it, _"[w]hen land is 'free' or 'cheap'. as it
was in different regions of the United States before the 1830s, there was no
compulsion for farmers to introduce labour-saving technology. As a result,
'independent household production' . . . hindered the development of
capitalism . . . [by] allowing large portions of the population to escape wage
labour."_ [Charlie Post, _"The 'Agricultural Revolution' in the United
States"_ , pp. 216-228, **Science and Society** , vol. 61, no. 2, p. 221]

It was precisely this option (i.e. of independent production) that had to be
destroyed in order for capitalist industry to develop. The state had to
violate the holy laws of "supply and demand" by controlling the access to land
in order to ensure the normal workings of "supply and demand" in the labour
market (i.e. that the bargaining position on the labour market favoured
employer over employee). Once this situation became the typical one (i.e. when
the option of self-employment was effectively eliminated) a (protectionist
based) "laissez-faire" approach could be adopted and state action used only to
protect private property from the actions of the dispossessed.

So how was this transformation of land ownership achieved?

Instead of allowing settlers to appropriate their own farms as was the case
before the 1830s, the state stepped in once the army had cleared out the
original users. Its first major role was to enforce legal rights of property
on unused land. Land stolen from the Native Americans was sold at auction to
the highest bidders, namely speculators, who then sold it on to farmers. This
process started right _"after the revolution, [when] huge sections of land
were bought up by rich speculators"_ and their claims supported by the law
[Howard Zinn, **A People's History of the United States** , p. 125] Thus land
which should have been free was sold to land-hungry farmers and the few
enriched themselves at the expense of the many. Not only did this increase
inequality within society, it also encouraged the development of wage labour
-- having to pay for land would have ensured that many immigrants remained on
the East Coast until they had enough money. Thus a pool of people with little
option but to sell their labour was increased due to state protection of
unoccupied land. That the land usually ended up in the hands of farmers did
not (could not) countermand the shift in class forces that this policy
created.

This was also the essential role of the various "Homesteading Acts" and, in
general, the _"Federal land law in the 19th century provided for the sale of
most of the public domain at public auction to the higher bidder . . . Actual
settlers were forced to buy land from speculators, at prices considerably
above the federal minimal price"_ (which few people could afford anyway)
[Charlie Post, **Op. Cit.** , p. 222]. Little wonder the Individualist
Anarchists supported an _"occupancy and use"_ system of land ownership as a
key way of stopping capitalist and landlord usury as well as the development
of capitalism itself.

This change in the appropriation of land had significant effects on
agriculture and the desirability of taking up farming for immigrants. As Post
notes, _"[w]hen the social conditions for obtaining and maintaining possession
of land change, as they did in the midwest between 1830 and 1840, pursuing the
goal of preserving [family ownership and control] . . . produced very
different results. In order to pay growing mortgages, debts and taxes, family
farmers were compelled to specialise production toward cash crops and to
market more and more of their output."_ [ **Op. Cit.** , p. 221-2]

So, in order to pay for land which was formerly free, farmers got themselves
into debt and increasingly turned to the market to pay it off. Thus, the
_"Federal land system, by transforming land into a commodity and stimulating
land speculation, made the midwestern farmers dependent upon markets for the
continual possession of their farms."_ [Charlie Post, **Op. Cit.** , p. 223]
Once on the market, farmers had to invest in new machinery and this also got
them into debt. In the face of a bad harvest or market glut, they could not
repay their loans and their farms had to be sold to so do so. By 1880, 25% of
all farms were rented by tenants, and the numbers kept rising.

This means that Murray Rothbard's comment that _"once the land was purchased
by the settler, the injustice disappeared"_ is nonsense -- the injustice was
transmitted to other parts of society and this, along with the legacy of the
original injustice, lived on and helped transform society towards capitalism [
**The Ethics of Liberty** , p. 73]. In addition, his comments about _"the
establishment in North America of a truly libertarian land system"_ would be
one the Individualist Anarchists would have seriously disagreed with! [
**Ibid.** ]

Thus state action, in restricting free access to the land, ensured that
workers were dependent on wage labour. In addition, the _"transformation of
social property relations in northern agriculture set the stage for the
'agricultural revolution' of the 1840s and 1850s . . . [R]ising debts and
taxes forced midwestern family farmers to compete as commodity producers in
order to maintain their land-holding . . . The transformation . . . was the
central precondition for the development of industrial capitalism in the
United States."_ [Charlie Post, **Ibid.** , p. 226]

In addition to seizing the land and distributing it in such a way as to
benefit capitalist industry, the _"government played its part in helping the
bankers and hurting the farmers; it kept the amount of money - based in the
gold supply - steady while the population rose, so there was less and less
money in circulation. The farmer had to pay off his debts in dollars that were
harder to get. The bankers, getting loans back, were getting dollars worth
more than when they loaned them out - a kind of interest on top of interest.
That was why . . . farmers' movements [like the Individualist Anarchists, we
must add] . . . [talked about] putting more money in circulation."_ [Howard
Zinn, **Op. Cit.** , p. 278]

Overall, therefore, state action ensured the transformation of America from a
society of independent workers to a capitalist one. By creating and enforcing
the "land monopoly" (of which state ownership of unoccupied land and its
enforcement of landlord rights were the most important) the state ensured that
the balance of class forces tipped in favour of the capitalist class. By
removing the option of farming your own land, the US government created its
own form of enclosure and the creation of a landless workforce with little
option but to sell its liberty on the "free market". This, combined with
protectionism, ensured the transformation of American society from a pre-
capitalist one into a capitalist one. They was nothing "natural" about it.

Little wonder the Individualist Anarchist J.K. Ingalls attacked the "land
monopoly" in the following words:

> _"The earth, with its vast resources of mineral wealth, its spontaneous
> productions and its fertile soil, the free gift of God and the common
> patrimony of mankind, has for long centuries been held in the grasp of one
> set of oppressors by right of conquest or right of discovery; and it is now
> held by another, through the right of purchase from them. All of man's
> natural possessions . . . have been claimed as property; nor has man himself
> escaped the insatiate jaws of greed. The invasion of his rights and
> possessions has resulted . . . in clothing property with a power to
> accumulate an income."_ [quoted by James Martin, **Men Against the State** ,
> p. 142]

## 8.6 How did working people view the rise of capitalism?

The best example of how hated capitalism was can be seen by the rise and
spread of the socialist movement, in all its many forms, across the world. It
is no coincidence that the development of capitalism also saw the rise of
socialist theories. However, in order to fully understand how different
capitalism was from previous economic systems, we will consider early
capitalism in the US, which for many "Libertarians" is **the** example of the
"capitalism-equals-freedom" argument.

Early America was pervaded by artisan production -- individual ownership of
the means of production. Unlike capitalism, this system is **not** marked by
the separation of the worker from the means of life. Most people did not have
to work for another, and so did not. As Jeremy Brecher notes, in 1831 the
_"great majority of Americans were farmers working their own land, primarily
for their own needs. Most of the rest were self-employed artisans, merchants,
traders, and professionals. Other classes - employees and industrialists in
the North, slaves and planters in the South - were relatively small. The great
majority of Americans were independent and free from anybody's command."_ [
**Strike!** , p. xxi] These conditions created the high cost of combined
(wage) labour which ensured the practice of slavery existed.

However, toward the middle of the 19th century the economy began to change.
Capitalism began to be imported into American society as the infrastructure
was improved, which allowed markets for manufactured goods to grow. Soon, due
to (state-supported) capitalist competition, artisan production was replaced
by wage labour. Thus "evolved" modern capitalism. Many workers understood,
resented, and opposed their increasing subjugation to their employers ( _"the
masters"_ , to use Adam Smith's expression), which could not be reconciled
with the principles of freedom and economic independence that had marked
American life and sunk deeply into mass consciousness during the days of the
early economy. In 1854, for example, a group of skilled piano makers wrote
that _"the day is far distant when they [wage earners] will so far forget what
is due to manhood as to glory in a system forced upon them by their necessity
and in opposition to their feelings of independence and self-respect. May the
piano trade be spared such exhibitions of the degrading power of the day
[wage] system."_ [quoted by Brecher and Costello, **Common Sense for Hard
Times** , p. 26]

Clearly the working class did not consider working for a daily wage, in
contrast to working for themselves and selling their own product, to be a step
forward for liberty or individual dignity. The difference between selling the
product of one's labour and selling one's labour (i.e. oneself) was seen and
condemned ( _"[w]hen the producer . . . sold his product, he retained himself.
But when he came to sell his labour, he sold himself . . . the extension [of
wage labour] to the skilled worker was regarded by him as a symbol of a deeper
change"_ [Norman Ware, **The Industrial Worker, 1840-1860** , p. xiv]).
Indeed, one group of workers argued that they were _"slaves in the strictest
sense of the word"_ as they had _"to toil from the rising of the sun to the
going down of the same for our masters - aye, masters, and for our daily
bread"_ [Quoted by Ware, **Op. Cit.** , p. 42] and another argued that _"the
factory system contains in itself the elements of slavery, we think no sound
reasoning can deny, and everyday continues to add power to its incorporate
sovereignty, while the sovereignty of the working people decreases in the same
degree."_ [quoted by Brecher and Costello, **Op. Cit.** , p. 29]

Almost as soon as there were wage workers, there were strikes, machine
breaking, riots, unions and many other forms of resistance. John Zerzan's
argument that there was a _"relentless assault on the worker's historical
rights to free time, self-education, craftsmanship, and play was at the heart
of the rise of the factory system"_ is extremely accurate [ **Elements of
Refusal** , p. 105]. And it was an assault that workers resisted with all
their might. In response to being subjected to the "law of value," workers
rebelled and tried to organise themselves to fight the powers that be and to
replace the system with a co-operative one. As the printer's union argued,
_"[we] regard such an organisation [a union] not only as an agent of immediate
relief, but also as an essential to the ultimate destruction of those
unnatural relations at present subsisting between the interests of the
employing and the employed classes. . . .[W]hen labour determines to sell
itself no longer to speculators, but to become its own employer, to own and
enjoy itself and the fruit thereof, the necessity for scales of prices will
have passed away and labour will be forever rescued from the control of the
capitalist."_ [quoted by Brecher and Costello, **Op. Cit.** , pp. 27-28]

Little wonder, then, why wage labourers considered capitalism as a form of
_"slavery"_ and why the term _"wage slavery"_ became so popular in the
anarchist movement. It was just reflecting the feelings of those who
experienced the wages system at first hand and joined the socialist and
anarchist movements. As labour historian Norman Ware notes, the _"term 'wage
slave' had a much better standing in the forties [of the 19th century] than it
has today. It was not then regarded as an empty shibboleth of the soap-box
orator. This would suggest that it has suffered only the normal degradation of
language, has become a **cliche** , not that it is a grossly misleading
characterisation."_ [ **Op. Cit.** , p. xvf]

These responses of workers to the experience of wage labour is important to
show that capitalism is by no means "natural." The fact is the first
generation of workers tried to avoid wage labour is at all possible as they
hated the restrictions of freedom it imposed upon them. They were perfectly
aware that wage labour was wage slavery -- that they were decidedly **unfree**
during working hours and subjected to the will of another. While many working
people now are accustomed to wage labour (while often hating their job) the
actual process of resistance to the development of capitalism indicates well
its inherently authoritarian nature. Only once other options were closed off
and capitalists given an edge in the "free" market by state action did people
accept and become accustomed to wage labour.

Opposition to wage labour and factory fascism was/is widespread and seems to
occur wherever it is encountered. _"Research has shown"_ , summarises William
Lazonick, _"that the 'free-born Englishman' of the eighteenth century - even
those who, by force of circumstance, had to submit to agricultural wage labour
- tenaciously resisted entry into the capitalist workshop."_ [ **Business
Organisation and the Myth of the Market Economy** , p. 37] British workers
shared the dislike of wage labour of their American cousins. A _"Member of the
Builders' Union"_ in the 1830s argued that the trade unions _"will not only
strike for less work, and more wages, but will ultimately **abolish wages** ,
become their own masters and work for each other; labour and capital will no
longer be separate but will be indissolubly joined together in the hands of
workmen and work-women."_ [quoted by Geoffrey Ostergaard, **The Tradition of
Workers' Control** , p. 133] This is unsurprising, for as Ostergaard notes,
_"the workers then, who had not been swallowed up whole by the industrial
revolution, could make critical comparisons between the factory system and
what preceded it."_ [ **Op. Cit.** , p. 134] While wage slavery may seem
"natural" today, the first generation of wage labourers saw the transformation
of the social relationships they experienced in work, from a situation in
which they controlled their own work (and so themselves) to one in which
**others** controlled them, and they did not like it. However, while many
modern workers instinctively hate wage labour and having bosses, without the
awareness of some other method of working, many put up with it as
"inevitable." The first generation of wage labourers had the awareness of
something else (although, of course, a flawed something else) and this gave
then a deep insight into the nature of capitalism and produced a deeply
radical response to it and its authoritarian structures.

Far from being a "natural" development, then, capitalism was imposed on a
society of free and independent people by state action. Those workers alive at
the time viewed it as _"unnatural relations"_ and organised to overcome it.
These feelings and hopes still exist, and will continue to exist until such
time as we organise and _"abolish the wage system"_ (to quote the IWW
preamble) and the state that supports it.

## 8.7 Why is the history of capitalism important?

Simply because it provides us with an understanding of whether that system is
"natural" and whether it can be considered as just and free. If the system was
created by violence, state action and other unjust means then the apparent
"freedom" which we currently face within it is a fraud, a fraud masking
unnecessary and harmful relations of domination, oppression and exploitation.
Moreover, by seeing how capitalist relationships were viewed by the first
generation of wage slaves reminds us that just because many people have
adjusted to this regime and consider it as normal (or even natural) it is
nothing of the kind.

Murray Rothbard is well aware of the importance of history. He considered the
_"moral indignation"_ of socialism arises from the argument _"that the
capitalists have stolen the rightful property of the workers, and therefore
that existing titles to accumulated capital are unjust."_ He argues that given
_"this hypothesis, the remainder of the impetus for both Marxism and
anarchosyndicalism follow quote logically."_ [ **The Ethics of Liberty** , p.
52]

So some right-libertarians are aware that the current property owners have
benefited extensively from violence and state action in the past. Murray
Rothbard argues (in **The Ethics of Liberty** , p. 57) that if the just owners
cannot be found for a property, then the property simply becomes again unowned
and will belong to the first person to appropriate and utilise it. If the
current owners are not the actual criminals then there is no reason at all to
dispossess them of their property; if the just owners cannot be found then
they may keep the property as the first people to use it (of course, those who
own capital and those who use it are usually different people, but we will
ignore this obvious point).

Thus, since all original owners and the originally dispossessed are long dead
nearly all current title owners are in just possession of their property
except for recently stolen property. The principle is simple, dispossess the
criminals, restore property to the dispossessed if they can be found otherwise
leave titles where they are (as Native American tribes owned the land
**collectively** this could have an interesting effect on such a policy in the
USA. Obviously tribes that were wiped out need not apply, but would such
right-libertarian policy recognise such collective, non-capitalist ownership
claims? We doubt it, but we could be wrong -- the Libertarian Party Manifesto
states that their "just" property rights will be restored. And who defines
"just"? And given that unclaimed federal land will be given to Native
Americans, its seems pretty likely that the **original** land will be left
alone).

Of course, that this instantly gives an advantage to the wealthy on the new
"pure" market is not mentioned. The large corporations that, via state
protection and support, built their empires and industrial base will still be
in an excellent position to continue to dominate the market. Wealthy land
owners, benefiting from the effects of state taxation and rents caused by the
"land monopoly" on farmstead failures, will keep their property. The rich will
have a great initial advantage and this may be more than enough to maintain
them in there place. After all, exchanges between worker and owner tend to
reinforce existing inequalities, **not** reduce them (and as the owners can
move their capital elsewhere or import new, lower waged, workers from across
the world, its likely to stay that way).

So Rothbard's "solution" to the problem of past force seems to be
(essentially) a justification of existing property titles and not a serious
attempt to understand or correct past initiations of force that have shaped
society into a capitalist one and still shape it today. The end result of his
theory is to leave things pretty much as they are, for the past criminals are
dead and so are their victims.

However, what Rothbard fails to note is that the **results** of this state
action and coercion are still with us. He totally fails to consider that the
theft of productive wealth has a greater impact on society than the theft
itself. The theft of **productive** wealth shapes society in so many ways that
**all** suffer from it (including current generations). This (the
externalities generated by theft) cannot be easily undone by individualistic
"solutions".

Let us take an example somewhat more useful that the one Rothbard uses
(namely, a stolen watch). A watch cannot really be used to generate wealth
(although if I steal a watch, sell it and buy a winning lottery ticket, does
that mean I can keep the prize after returning the money value of your watch
to you? Without the initial theft, I would not have won the prize but
obviously the prize money far exceeds the amount stolen. Is the prize money
mine?). Let us take a tool of production rather than a watch.

Let assume a ship sinks and 50 people get washed ashore on an island. One
woman has foresight to take a knife from the ship and falls unconscious on the
beach. A man comes along and steals her knife. When the woman awakes she
cannot remember if she had managed to bring the knife ashore with her or not.
The man maintains that he brought it with him and no one else saw anything.
The survivors decide to split the island equally between them and work it
separately, exchanging goods via barter.

However, the man with the knife has the advantage and soon carves himself a
house and fields from the wilderness. Seeing that they need the knife and the
tools created by the knife to go beyond mere existing, some of the other
survivors hire themselves to the knife owner. Soon he is running a surplus of
goods, including houses and equipment which he decides to hire out to others.
This surplus is then used to tempt more and more of the other islanders to
work for him, exchanging their land in return for the goods he provides. Soon
he owns the whole island and never has to work again. His hut is well stocked
and extremely luxurious. His workers face the option of following his orders
or being fired (i.e. expelled from the island and so back into the water and
certain death). Later, he dies and leaves his knife to his son. The woman
whose knife it originally was had died long before, childless.

Note that the theft did not involve taking any land. All had equal access to
it. It was the initial theft of the knife which provided the man with market
power, an edge which allowed him to offer the others a choice between working
by themselves or working for him. By working for him they did "benefit" in
terms of increased material wealth (and also made the thief better off) but
the accumulate impact of unequal exchanges turned them into the effective
slaves of the thief.

Now, would it **really** be enough to turn the knife over to the whoever
happened to be using it once the theft was discovered (perhaps the thief made
a death-bed confession). Even if the woman who had originally taken it from
the ship been alive, would the return of the knife **really** make up for the
years of work the survivors had put in enriching the the thief or the
"voluntary exchanges" which had resulted in the thief owning all the island?
The equipment people use, the houses they life in and the food they eat are
all the product of many hours of collective work. Does this mean that the
transformation of nature which the knife allowed remain in the hands of the
descendants of the thief or become the collective property of all? Would
dividing it equally between all be fair? Not everyone worked equally hard to
produce it. So we have a problem -- the result of the initial theft is far
greater than the theft considered in isolation due to the productive nature of
what was stolen.

In other words, what Rothbard ignores in his attempt to undermine anarchist
use of history is that when the property stolen is of a productive nature, the
accumulative effect of its use is such as to affect all of society. Productive
assets produce **new** property, **new** values, create a **new** balance of
class forces, **new** income and wealth inequalities and so on. This is
because of the **dynamic** nature of production and human life. When the theft
is such that it creates accumulative effects after the initial act, it is
hardly enough to say that it does not really matter any more. If a nobleman
invests in a capitalist firm with the tribute he extracted from his peasants,
then (once the firm starts doing well) sells the land to the peasants and uses
that money to expand his capitalist holdings, does that **really** make
everything all right? Does not the crime transmit with the cash? After all,
the factory would not exist without the prior exploitation of the peasants.

In the case of actually existing capitalism, born as it was of extensive
coercive acts, the resultant of these acts have come to shape the **whole**
society. For example, the theft of common land (plus the enforcement of
property rights -- the land monopoly -- to vast estates owned by the
aristocracy) ensured that working people had no option to sell their labour to
the capitalists (rural or urban). The terms of these contracts reflected the
weak position of the workers and so capitalists extracted surplus value from
workers and used it to consolidate their market position and economic power.
Similarly, the effect of mercantilist policies (and protectionism) was to
enrich the capitalists at the expense of workers and allow them to build
industrial empires.

The accumulative effect of these acts of violation of a "free" market was to
create a class society wherein most people "consent" to be wage slaves and
enrich the few. While those who suffered the impositions are long gone and the
results of the specific acts have multiplied and magnified well beyond their
initial form. And we are still living with them. In other words, the initial
acts of coercion have been transmitted and transformed by collective activity
(wage labour) into society-wide affects.

Rothbard argues in the situation where the descendants (or others) of those
who initially tilled the soil and their aggressors ( _"or those who purchased
their claims"_ ) still extract _"tribute from the modern tillers"_ that this
is a case of _" **continuing** aggression against the true owners"_. This
means that _"the land titles should be transferred to the peasants, without
compensation to the monopoly landlords."_ [ **Op. Cit.** , p. 65] But what he
fails to note is that the extracted "tribute" could have been used to invest
in industry and transform society. Why ignore what the "tribute" has been used
for? Does stolen property not remain stolen property after it has been
transferred to another? And if the stolen property is used to create a society
in which one class has to sell their liberty to another, then surely any
surplus coming from those exchanges are also stolen (as it was generated
directly and indirectly by the theft).

Yes, anarchist agree with Rothbard -- peasants should take the land they use
but which is owned by another. But this logic can equally be applied to
capitalism. Workers are still living with the effects of past initiations of
force and capitalists still extract "tribute" from workers due to the unequal
bargaining powers within the labour market that this has created. The labour
market, after all, was created by state action (directly or indirectly) and is
maintained by state action (to protect property rights and new initiations of
force by working people). The accumulative effects of stealing productive
resources as been to increase the economic power of one class compared to
another. As the victims of these past abuses are long gone and attempts to
find their descendants meaningless (because of the generalised effects the
thefts in question), anarchists feel we are justified in demanding the
**_"expropriation of the expropriators"_**.

Due to Rothbard's failure to understand the dynamic and generalising effects
that result from the theft of productive resources (i.e. externalities that
occur from coercion of one person against a specific set of others) and the
creation of a labour market, his attempt to refute anarchist analysis of the
history of "actually existing capitalism" also fails. Society is the product
of collective activity and should belong to us all (although whether and how
we divide it up is another question).

[‹ 7 How does the history of "anarcho"-capitalism show that it is not
anarchist?](append137.md "Go to previous page") [up](append13.md "Go to
parent page") [9 Is Medieval Iceland an example of "anarcho"-capitalism
working in practice? ›](append139.md "Go to next page")

