/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#include "gcs-types.h"
#include <iostream>
#include <iomanip>

namespace gcs
{

    tColorHsv::tColorHsv(const int h, const int s, const int v)
        : hue(h), saturation(s), value(v)
    { }


    tColorHsv::tColorHsv(const tColorHsv& hsv)
        : hue(hsv.hue), saturation(hsv.saturation), value(hsv.value)
    { }


    tColorRgb::tColorRgb(const int r, const int g, const int b)
        : red(r), green(g), blue(b)
    { }


    tColorRgb::tColorRgb(const tColorRgb& rgb)
        : red(rgb.red), green(rgb.green), blue(rgb.blue)
    { }


    std::ostream& operator<<(std::ostream& out, tColorRgb color)
    {
        return out << std::endl << "RGB:" << std::endl \
            << std::setw(12) << "Red: " << std::setw(3) << color.red << std::endl \
            << std::setw(12) << "Green: " << std::setw(3) << color.green << std::endl \
            << std::setw(12) << "Blue: " << std::setw(3) << color.blue << std::endl;
    }


    std::ostream& operator<<(std::ostream& out, const tColorHsv color)
    {
        return out << std::endl << "HSV:" << std::endl \
            << std::setw(12) << "Hue: " << std::setw(3) << color.hue << std::endl \
            << std::setw(12) << "Saturation: " << std::setw(3) << color.saturation << std::endl \
            << std::setw(12) << "Value: " << std::setw(3) << color.value << std::endl;
    }


    bool operator==(tColorRgb first, tColorRgb last)
    {
        if (first.red == last.red &&
                first.green == last.green && 
                first.blue == last.blue)
        {
            return true;
        }
        else
        {
            return false;
        }
    }


    bool operator==(tColorHsv first, tColorHsv last)
    {
        if ((first.hue == last.hue &&
                    first.saturation == last.saturation &&
                    first.value == last.value) ||
                (first.value == 0 && last.value == 0))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
} // namespace gcs
