!{\src2tex{textfont=tt}}
!!****f* ABINIT/modx
!! NAME
!! modx
!!
!! FUNCTION
!! Calculate a function similar to mod:
!! modx(i,j)=mod(i,j)             i>=0
!!          =mod(mod(i,j)+j,j)    i<0
!! e.g. modx(3,2)=1; modx(-1,2)=1
!!      mod(3,2)=1;  mod(-1,2)=-1
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  i= integer, see function description
!!  j= integer, see function description
!!
!! OUTPUT
!!  function modx=see function description
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

integer function modx(i,j)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: i,j

!Local variables-------------------------------

! *************************************************************************

 modx=mod(mod(i,j)+((1-sign(1,i))/2)*j,j)

 return
 end function modx
!!***
