/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.Initializer;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import org.apache.ws.security.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static List<String> javaPrimitives = Arrays.asList("double", "char", "byte", "short", "int", "long", "float", "boolean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadParameters(Object request, Map<String, String> parameters) {
        try {
            Trie parameterTrie = ReflectionUtil.ParseParameterTrie(parameters);
            ReflectionUtil.loadParameters(request, parameterTrie);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Locale.setDefault(Initializer.DEFAULT_LOCALE);
            throw throwable;
        }
        Locale.setDefault(Initializer.DEFAULT_LOCALE);
    }

    public static void loadParameters(Object parameter, Trie node) {
        if (ReflectionUtil.containsListMethod(parameter)) {
            Collection<Trie> children = node.getChildren();
            if (children.size() != 1) {
                String info = "";
                for (Trie c : children) {
                    info = info + String.format("{key=%s, value=%s}", c.getKey(), c.getValue());
                }
                throw new ConfigurationErrorException(String.format("List parameter type contains more than 1 member. parameter=%s . %s", parameter == null ? null : parameter.getClass().getCanonicalName(), info));
            }
            String type = ReflectionUtil.getMemberItemTypeFromParameterizedTypeOfMemberList(parameter);
            for (Trie child : children) {
                Trie[] grandchildren = child.getChildren().toArray(new Trie[child.getChildren().size()]);
                Arrays.sort(grandchildren, new TrieComparator());
                for (Trie gc : grandchildren) {
                    Object memberItem = ReflectionUtil.constructObject(type, gc.getValue());
                    ReflectionUtil.loadParameters(memberItem, gc);
                    ReflectionUtil.addMemberItemToMemberListOfParameter(parameter, memberItem);
                }
            }
        } else {
            for (Trie c : node.getChildren()) {
                if (c.isLeaf() && ReflectionUtil.isListMember(parameter, c.getKey())) {
                    Object emptyListMember = ReflectionUtil.constructAndSetMemberOfObject(parameter, c.getKey());
                    ReflectionUtil.initializeEmptyList(emptyListMember);
                    continue;
                }
                Object childParam = ReflectionUtil.constructAndSetMemberOfObject(parameter, c.getKey(), c.getValue());
                ReflectionUtil.loadParameters(childParam, c);
            }
        }
    }

    public static Trie ParseParameterTrie(Map<String, String> parameters) {
        Trie root = new Trie(null);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String[] params = StringUtil.split((String)entry.getKey(), (char)'.');
            Trie node = root;
            for (String param : params) {
                if (node.trie.containsKey(param)) {
                    node = node.trie.get(param);
                    continue;
                }
                Trie nextNode = new Trie(param);
                node.trie.put(param, nextNode);
                node = nextNode;
            }
            node.value = entry.getValue();
        }
        return root;
    }

    public static void toMethodName(StringBuilder sb) {
        if (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        } else {
            int i;
            for (i = 2; i < sb.length() && Character.isUpperCase(sb.charAt(i)); ++i) {
            }
            if (i < sb.length() && Character.isLowerCase(sb.charAt(i))) {
                --i;
            }
            sb.replace(0, i, sb.substring(0, i).toLowerCase());
        }
    }

    private static Object constructAndSetMemberOfObject(Object object, String memberName) {
        return ReflectionUtil.constructAndSetMemberOfObject(object, memberName, null);
    }

    public static boolean isListMember(Object object, String memberName) {
        Field memberField = ReflectionUtil.getFieldForParameter(object, memberName);
        return ReflectionUtil.containsListMethod(memberField.getType());
    }

    private static Object constructAndSetMemberOfObject(Object object, String memberName, String memberConstructorString) {
        Field memberField = ReflectionUtil.getFieldForParameter(object, memberName);
        String type = memberField.getType().getName();
        Object newMemberObject = ReflectionUtil.constructObject(type, memberConstructorString);
        try {
            memberField.setAccessible(true);
            memberField.set(object, newMemberObject);
        }
        catch (Exception e) {
            throw new ConfigurationErrorException("Failed to get constructor(String): " + e.getLocalizedMessage(), e);
        }
        return newMemberObject;
    }

    private static void initializeEmptyList(Object parameter) {
        Object member = null;
        try {
            Method getMember = ReflectionUtil.getListMethod(parameter);
            member = getMember.invoke(parameter, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationErrorException(String.format("Unable to call <parameter>.member.add(<memberValue>). parameterType:%s memberItemType:%s memberType:%s getMessage:%s\n\n", parameter == null ? null : parameter.getClass().getCanonicalName(), member == null ? null : member.getClass().getCanonicalName(), e.getMessage()), e);
        }
    }

    private static void addMemberItemToMemberListOfParameter(Object parameter, Object memberItem) {
        Object member = null;
        try {
            Method getMember = ReflectionUtil.getListMethod(parameter);
            member = getMember.invoke(parameter, new Object[0]);
            Method addMethod = ReflectionUtil.getAddMethod(member);
            addMethod.invoke(member, memberItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationErrorException(String.format("Unable to call <parameter>.member.add(<memberValue>). parameterType:%s memberItemType:%s memberType:%s getMessage:%s\n\n", parameter == null ? null : parameter.getClass().getCanonicalName(), memberItem == null ? null : memberItem.getClass().getCanonicalName(), member == null ? null : member.getClass().getCanonicalName(), e.getMessage()), e);
        }
    }

    private static Object constructObject(String type) {
        return ReflectionUtil.constructObject(type, null);
    }

    private static Object constructObject(String type, String constructorArg) {
        Object newMemberObject = null;
        Constructor<?> constructor = null;
        if (javaPrimitives.contains(type)) {
            if (constructorArg == null) {
                throw new ConfigurationErrorException("No constructor argument for primitive type " + type);
            }
            newMemberObject = ReflectionUtil.parsePrimitive(type, constructorArg);
        } else {
            try {
                Class<?> objClass = Class.forName(type);
                if (type.equals("javax.xml.datatype.XMLGregorianCalendar") && constructorArg != null) {
                    newMemberObject = DatatypeFactory.newInstance().newXMLGregorianCalendar(constructorArg);
                } else if (constructorArg != null) {
                    if (objClass.isEnum()) {
                        Method fromValue = objClass.getMethod("fromValue", String.class);
                        newMemberObject = fromValue.invoke(null, constructorArg);
                    } else {
                        constructor = objClass.getConstructor(String.class);
                        newMemberObject = constructor.newInstance(constructorArg);
                    }
                } else {
                    constructor = objClass.getConstructor(new Class[0]);
                    newMemberObject = constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new ConfigurationErrorException("Failed to get constructor() for type {" + type + "} : " + e.getLocalizedMessage() + ":" + constructor, e);
            }
        }
        return newMemberObject;
    }

    private static Object parsePrimitive(String type, String primitiveArgument) {
        if (!javaPrimitives.contains(type)) {
            throw new ConfigurationErrorException("Invalid primitive type: " + type);
        }
        try {
            if (type.equals("double")) {
                return Double.parseDouble(primitiveArgument);
            }
            if (type.equals("char")) {
                if (primitiveArgument.length() != 1) {
                    throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, "char", primitiveArgument);
                }
                return Character.valueOf(primitiveArgument.charAt(0));
            }
            if (type.equals("byte")) {
                return Byte.parseByte(primitiveArgument);
            }
            if (type.equals("short")) {
                return Short.parseShort(primitiveArgument);
            }
            if (type.equals("int")) {
                return Integer.parseInt(primitiveArgument);
            }
            if (type.equals("long")) {
                return Long.parseLong(primitiveArgument);
            }
            if (type.equals("float")) {
                return Float.valueOf(Float.parseFloat(primitiveArgument));
            }
            if (type.equals("boolean")) {
                if (!primitiveArgument.equalsIgnoreCase("false") && !primitiveArgument.equalsIgnoreCase("true")) {
                    throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, "boolean", primitiveArgument);
                }
                return Boolean.parseBoolean(primitiveArgument);
            }
        }
        catch (NumberFormatException e) {
            throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, type, primitiveArgument);
        }
        return null;
    }

    private static String getMemberItemTypeFromParameterizedTypeOfMemberList(Object object) {
        Field memberField = null;
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.getType().equals(List.class)) continue;
            if (memberField != null) {
                throw new ConfigurationErrorException("Type " + object.getClass().getCanonicalName() + " has more than one list field.");
            }
            memberField = field;
        }
        if (memberField == null) {
            throw new ConfigurationErrorException("Type " + object.getClass().getCanonicalName() + " does not have a list field.");
        }
        ParameterizedType ptype = (ParameterizedType)memberField.getGenericType();
        if (ptype.getActualTypeArguments().length != 1) {
            throw new ConfigurationErrorException(String.format("Member '%s' expected to have type List<?>, but instead of 1 has %d parameterized types", memberField.getName(), ptype.getActualTypeArguments().length));
        }
        return ((Class)ptype.getActualTypeArguments()[0]).getName();
    }

    private static Method getListMethod(Object object) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            if (!m.getReturnType().equals(List.class)) continue;
            return m;
        }
        throw new ConfigurationErrorException("Cannot find list getter method in " + object.getClass().getCanonicalName());
    }

    private static boolean containsListMethod(Object object) {
        return ReflectionUtil.containsListMethod(object.getClass());
    }

    private static boolean containsListMethod(Class objClass) {
        Method[] methods;
        for (Method m : methods = objClass.getDeclaredMethods()) {
            if (!m.getReturnType().equals(List.class)) continue;
            return true;
        }
        return false;
    }

    private static Method getAddMethod(Object object) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("add") || m.getParameterTypes().length != 1) continue;
            return m;
        }
        throw new ConfigurationErrorException("Cannot find method 'add' in " + object.getClass().getCanonicalName());
    }

    private static Field getFieldForParameter(Object request, String parameter) {
        Field field;
        String fieldName = ReflectionUtil.toFieldName(parameter);
        try {
            field = request.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationErrorException("Field not found: " + fieldName + "in: " + request.getClass().getCanonicalName(), e);
        }
        return field;
    }

    private static String toFieldName(String parameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(parameter);
        ReflectionUtil.toMethodName(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrieComparator
    implements Comparator<Trie> {
        private TrieComparator() {
        }

        @Override
        public int compare(Trie o1, Trie o2) {
            if (o1.key == null && o2.key == null) {
                return 0;
            }
            if (o1.key == null) {
                return -1;
            }
            if (o2.key == null) {
                return 1;
            }
            Integer int1 = Integer.parseInt(o1.key);
            Integer int2 = Integer.parseInt(o2.key);
            return int1.compareTo(int2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Trie {
        String key;
        String value;
        Map<String, Trie> trie;

        private Trie(String key) {
            this.key = key;
            this.value = null;
            this.trie = new HashMap<String, Trie>();
        }

        public Collection<Trie> getChildren() {
            if (this.trie.values() == null) {
                return new ArrayList<Trie>();
            }
            return this.trie.values();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            if (!this.isLeaf() && this.value != null) {
                throw new ConfigurationErrorException("getValue() impossible to be non-null for non-leaf case in Reflection IR. key=" + this.key + " value=" + this.value);
            }
            return this.value;
        }

        public boolean isLeaf() {
            return this.trie.size() == 0;
        }
    }
}

