#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# Yesterday
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220905.1

GAME_ID='yesterday'
GAME_NAME='Yesterday'

ARCHIVE_BASE_0='setup_yesterday_1.0.1_(34047).exe'
ARCHIVE_BASE_0_MD5='638c9882333cd55dabf7a136c25a5158'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_yesterday_1.0.1_(34047)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='40aa040bcb99a2038d24266d9807aac4'
ARCHIVE_BASE_0_SIZE='4400000'
ARCHIVE_BASE_0_VERSION='1.0.1-gog34047'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/yesterday'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
binkw32.dll
config.lang
psconfig.exe
psengine.dll
pthreadvc2.dll
yesterday.exe'
ARCHIVE_GAME_DATA_FILES='
dataa
datav
resource'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='yesterday.exe'
APP_MAIN_ICON='yesterday.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
gamedata:ProgramData/Pendulo Studios/Yesterday'
USER_PERSISTENT_DIRECTORIES='
gamedata'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary directories

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
