#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Thomas Was Alone
# build native packages from the original installers
# send your bug reports to contatct@dotslashplay.it
###

script_version=20220701.2

GAME_ID='thomas-was-alone'
GAME_NAME='Thomas Was Alone'

# This DRM-free archive is no longer available for sale from Humble Bundle
ARCHIVE_BASE_0='thomaswasalone-linux-1369349552.tar'
ARCHIVE_BASE_0_MD5='e7f8e766188718e16880b1137c430f35'
ARCHIVE_BASE_0_SIZE='250000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'

UNITY3D_NAME='thomasWasAlone'

CONTENT_PATH_DEFAULT='thomasLinuxStandalone'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

APP_MAIN_TYPE='native'
APP_MAIN_EXE="$UNITY3D_NAME"
APP_MAIN_ICON="${UNITY3D_NAME}_Data/Resources/UnityPlayer.png"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libGLU.so.1 xcursor"

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
set_standard_permissions "$PLAYIT_WORKDIR/gamedata"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
