#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Strange Horticulture
# send your bug reports to contact@dotslashplay.it
###

script_version=20240307.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='strange-horticulture'
GAME_NAME='Strange Horticulture'

ARCHIVE_BASE_3_NAME='setup_strange_horticulture_1.1.26_(64bit)_(59461).exe'
ARCHIVE_BASE_3_MD5='f73097c90b89c86b55f164fe42744b0b'
ARCHIVE_BASE_3_TYPE='innosetup'
ARCHIVE_BASE_3_SIZE='695749'
ARCHIVE_BASE_3_VERSION='1.1.26-gog59461'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/strange_horticulture'

ARCHIVE_BASE_2_NAME='setup_strange_horticulture_1.1.9.1_(64bit)_(54071).exe'
ARCHIVE_BASE_2_MD5='3f4294de0f17a31ea936052e8e820059'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='920000'
ARCHIVE_BASE_2_VERSION='1.1.9.1-gog54071'

ARCHIVE_BASE_1_NAME='setup_strange_horticulture_1.0.4_(64bit)_(53097).exe'
ARCHIVE_BASE_1_MD5='6217dd2e77993a5af36954bc19e453c3'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='850000'
ARCHIVE_BASE_1_VERSION='1.0.4-gog53097'

ARCHIVE_BASE_0_NAME='setup_strange_horticulture_1.0.3_(64bit)_(53030).exe'
ARCHIVE_BASE_0_MD5='56551c39d923f593b161a5b56d28c904'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='850000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog53030'

UNITY3D_NAME='strange horticulture'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/BadVikingLtd/Strange Horticulture'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
