#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sam and Max Hit the Road
# send your bug reports to contact@dotslashplay.it
###

script_version=20230331.2

GAME_ID='sam-and-max-hit-the-road'
GAME_NAME='Sam & Max Hit the Road'

ARCHIVE_BASE_EN_1='sam_and_max_hit_the_road_en_gog_2_20100.sh'
ARCHIVE_BASE_EN_1_MD5='0771889c051c7e1cc6e6c8e8ca8fbe1f'
ARCHIVE_BASE_EN_1_TYPE='mojosetup'
ARCHIVE_BASE_EN_1_SIZE='390000'
ARCHIVE_BASE_EN_1_VERSION='1.0-gog20100'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/sam_max_hit_the_road'

ARCHIVE_BASE_EN_0='gog_sam_max_hit_the_road_2.0.0.8.sh'
ARCHIVE_BASE_EN_0_MD5='00e6de62115b581f01f49354212ce545'
ARCHIVE_BASE_EN_0_TYPE='mojosetup'
ARCHIVE_BASE_EN_0_SIZE='270000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog2.0.0.1'

ARCHIVE_BASE_FR_1='sam_and_max_hit_the_road_fr_gog_2_20100.sh'
ARCHIVE_BASE_FR_1_MD5='52b35282832b477c7f1bb06688ba3b95'
ARCHIVE_BASE_FR_1_TYPE='mojosetup'
ARCHIVE_BASE_FR_1_SIZE='280000'
ARCHIVE_BASE_FR_1_VERSION='1.0-gog20100'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/sam_max_hit_the_road'

ARCHIVE_BASE_FR_0='gog_sam_max_hit_the_road_french_2.0.0.8.sh'
ARCHIVE_BASE_FR_0_MD5='127be643ebaa9af24ddd9f2618e4433e'
ARCHIVE_BASE_FR_0_TYPE='mojosetup'
ARCHIVE_BASE_FR_0_SIZE='160000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog2.0.0.1'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
samnmax.000
samnmax.001
monster.so[u3gf]'
CONTENT_DOC_MAIN_PATH_EN='data/noarch/docs/english'
CONTENT_DOC_MAIN_PATH_FR='data/noarch/docs/french'
CONTENT_DOC_MAIN_FILES='
*.pdf'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='scumm:samnmax'
APP_MAIN_ICON='../support/icon.png'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_EN="${PKG_MAIN_ID}-en"
PKG_MAIN_ID_FR="${PKG_MAIN_ID}-fr"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"
PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert all file names to lower case
	tolower .
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
