#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Liar Liar series:
# - Liar Liar 1
# - Liar Liar 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240428.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_EPISODE1='liar-liar-1'
GAME_NAME_EPISODE1='Liar Liar'

GAME_ID_EPISODE2='liar-liar-2'
GAME_NAME_EPISODE2='Liar Liar 2: Pants on Fire'

# Archives

## Liar Liar (episode 1)

ARCHIVE_BASE_EPISODE1_0_NAME='liarliar1.0-all.zip'
ARCHIVE_BASE_EPISODE1_0_MD5='192d7cef446bb6d9ce01e3678889bbbd'
ARCHIVE_BASE_EPISODE1_0_SIZE='96000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-itch'
ARCHIVE_BASE_EPISODE1_0_URL='https://tokimekiwaku.itch.io/liar-liar'

## Liar Liar 2

ARCHIVE_BASE_EPISODE2_0_NAME='liarliar2-all.zip'
ARCHIVE_BASE_EPISODE2_0_MD5='6450f265d59ece46331070a2e0a14121'
ARCHIVE_BASE_EPISODE2_0_SIZE='110000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-itch'
ARCHIVE_BASE_EPISODE2_0_URL='https://tokimekiwaku.itch.io/liar-liar-2'


CONTENT_PATH_DEFAULT_EPISODE1='liarliar1.0-all/game'
CONTENT_PATH_DEFAULT_EPISODE2='liarliar2-all/game'
CONTENT_GAME_MAIN_FILES='
scenes
*.mp3
*.png
*.rpy
*.rpyb
*.rpyc
*.sai
*.wav'
CONTENT_DOC_MAIN_PATH_EPISODE2="${CONTENT_PATH_DEFAULT_EPISODE2}/.."
CONTENT_DOC_MAIN_FILES='
README.html'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON_EPISODE1='../liar liar.exe'
APP_MAIN_ICON_EPISODE2='../liar liar 2.exe'

## Ensure easy upgrades from packages generated with pre-20240428.1 game scripts.
PKG_MAIN_PROVIDES_EPISODE1="${PKG_MAIN_PROVIDES_EPISODE1:-}
liar-liar
liar-liar-data"
PKG_MAIN_PROVIDES_EPISODE2="${PKG_MAIN_PROVIDES_EPISODE2:-}
liar-liar-2-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
