#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gorogoa
# send your bug reports to contact@dotslashplay.it
###

script_version=20230309.1

GAME_ID='gorogoa'
GAME_NAME='Gorogoa'

ARCHIVE_BASE_0='setup_gorogoa_1.1.0_(20406).exe'
ARCHIVE_BASE_0_MD5='8238721619553923c75dafbcaec11018'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='550000'
ARCHIVE_BASE_0_VERSION='1.1.0-gog20406'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/gorogoa'

UNITY3D_NAME='gorogoa'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
unityplayer.dll
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}_data/mono"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_WINE_LINK_DIRS='
galaxydata:users/${USER}/AppData/Local/GOG.com/Galaxy/Applications/50686913489464392/Storage'
USER_PERSISTENT_DIRECTORIES='
galaxydata'

APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
