#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Botanicula
# send your bug reports to contact@dotslashplay.it
###

script_version=20231114.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='botanicula'
GAME_NAME='Botanicula'

ARCHIVE_BASE_LINUX_0_NAME='gog_botanicula_2.0.0.2.sh'
ARCHIVE_BASE_LINUX_0_MD5='7b92a379f8d2749e2f97c43ecc540c3c'
ARCHIVE_BASE_LINUX_0_SIZE='760000'
ARCHIVE_BASE_LINUX_0_VERSION='1.0.1-gog2.0.0.2'
ARCHIVE_BASE_LINUX_0_URL='https://www.gog.com/game/botanicula'

## Support for the Windows build is provided as a fallback for Wayland users that can not start the Linux build.
## cf. https://forge.dotslashplay.it/play.it/games/-/issues/372
ARCHIVE_BASE_WINDOWS_0_NAME='setup_botanicula_1.2.0_(30036).exe'
ARCHIVE_BASE_WINDOWS_0_MD5='e35fc9d7577766841943eac4c0f7e84e'
ARCHIVE_BASE_WINDOWS_0_TYPE='innosetup'
ARCHIVE_BASE_WINDOWS_0_SIZE='856400'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.2.0-gog30036'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.gog.com/game/botanicula'

CONTENT_PATH_DEFAULT_LINUX='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_LIBS_BIN_PATH}/runtimes/air/linux/Adobe AIR/Versions/1.0"
CONTENT_LIBS_BIN_FILES='
libCore.so'
CONTENT_LIBS0_BIN_PATH="${CONTENT_LIBS_BIN_PATH}/runtimes/air/linux/Adobe AIR/Versions/1.0/Resources"
CONTENT_LIBS0_BIN_FILES='
libaddkey.so
libadobecertstore.so
libadobecp15.so
libadobecp.so
libcurl.so
libeggtray.so
libflashplayer.so
libpacparser.so
libWebKit.so'
CONTENT_GAME_BIN_FILES_LINUX='
bin/adl
runtimes'
CONTENT_GAME_DATA_FILES_LINUX='
bin/*.xml
bin/*.swf
bin/data'

CONTENT_PATH_DEFAULT_WINDOWS='.'
CONTENT_GAME_BIN_FILES_WINDOWS='
adobe air
botanicula.exe'
CONTENT_GAME_DATA_FILES_WINDOWS='
data
meta-inf
mimetype
botaniculal.swf
botaniculalaunch.swf'

APP_MAIN_EXE_LINUX='bin/adl'
APP_MAIN_OPTIONS_LINUX='bin/BotaniculaLinux-app.xml -nodebug'
APP_MAIN_ICONS_LIST_LINUX='APP_MAIN_ICON_16 APP_MAIN_ICON_32 APP_MAIN_ICON_36 APP_MAIN_ICON_48 APP_MAIN_ICON_57 APP_MAIN_ICON_72 APP_MAIN_ICON_114 APP_MAIN_ICON_128 APP_MAIN_ICON_256 APP_MAIN_ICON_512'
APP_MAIN_ICON_16='bin/data/icons/b16.png'
APP_MAIN_ICON_32='bin/data/icons/b32.png'
APP_MAIN_ICON_36='bin/data/icons/b36.png'
APP_MAIN_ICON_48='bin/data/icons/b48.png'
APP_MAIN_ICON_57='bin/data/icons/b57.png'
APP_MAIN_ICON_72='bin/data/icons/b72.png'
APP_MAIN_ICON_114='bin/data/icons/b114.png'
APP_MAIN_ICON_128='bin/data/icons/b128.png'
APP_MAIN_ICON_256='bin/data/icons/b256.png'
APP_MAIN_ICON_512='bin/data/icons/b512.png'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/BotaniculaSaves'

APP_MAIN_EXE_WINDOWS='botanicula.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_LINUX="${PKG_DATA_ID}-linux"
PKG_DATA_ID_WINDOWS="${PKG_DATA_ID}-windows"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS_LINUX="$PKG_DATA_ID_LINUX"
PKG_BIN_DEPS_WINDOWS="$PKG_DATA_ID_WINDOWS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libglib-2.0.so.0
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgthread-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libnspr4.so
libnss3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpthread.so.0
librt.so.1
libsmime3.so
libssl3.so
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libxml2.so.2
libXrender.so.1
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
