#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Night at the Watermill
# send your bug reports to contact@dotslashplay.it
###

script_version=20240427.4

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='a-night-at-the-watermill'
GAME_NAME='A Night at the Watermill'

ARCHIVE_BASE_0_NAME='a_night_at_the_watermill_1_0_794_70569.sh'
ARCHIVE_BASE_0_MD5='4e5c4f9b03e2ea0198742a4ca20f2aa1'
ARCHIVE_BASE_0_SIZE='624275'
ARCHIVE_BASE_0_VERSION='1.0.794-gog70569'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_night_at_the_watermill'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/py3-linux-x86_64"
CONTENT_LIBS_BIN_FILES='
librenpython.so'
CONTENT_GAME_BIN_FILES='
lib/py3-linux-x86_64/NightAtTheWatermill
lib/py3-linux-x86_64/python
lib/py3-linux-x86_64/pythonw
lib/py3-linux-x86_64/zsync
lib/py3-linux-x86_64/zsyncmake'
CONTENT_GAME_DATA_FILES='
game
renpy
lib/python3.9
NightAtTheWatermill.py'

APP_MAIN_EXE='lib/py3-linux-x86_64/NightAtTheWatermill'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libutil.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

## Generate standard size icons from the shipped 125×125 one
APP_MAIN_ICON_64="$(dirname "$APP_MAIN_ICON")/icon_64.png"
APP_MAIN_ICON_128="$(dirname "$APP_MAIN_ICON")/icon_128.png"
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_64 APP_MAIN_ICON_128'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	convert "$APP_MAIN_ICON" -resize 64x64 "$APP_MAIN_ICON_64"
	convert "$APP_MAIN_ICON" -resize 128x128 "$APP_MAIN_ICON_128"
)
content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Prevent the game from escaping the user prefix.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Prevent the game from escaping the user prefix
game_script="NightAtTheWatermill.py"
if [ -h "$game_script" ]; then
	game_script_source=$(realpath "$game_script")
	cp --remove-destination "$game_script_source" "$game_script"
fi
'
launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
