/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_POWERMANAGEMENTCAPABILITIES_H_
#define OPENDRIM_POWERMANAGEMENTCAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_PowerManagementCapabilities_classnames[] = {"OpenDRIM_PowerManagementCapabilities"};
static string OpenDRIM_PowerManagementCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_PowerManagementCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	vector<unsigned short> PowerCapabilities;
	bool PowerCapabilities_isNULL;
	
	vector<string> OtherPowerCapabilitiesDescriptions;
	bool OtherPowerCapabilitiesDescriptions_isNULL;
	
	vector<unsigned short> PowerStatesSupported;
	bool PowerStatesSupported_isNULL;
	
	vector<unsigned short> PowerChangeCapabilities;
	bool PowerChangeCapabilities_isNULL;
	
	string OtherPowerChangeCapabilities;
	bool OtherPowerChangeCapabilities_isNULL;
	
	vector<unsigned short> RequestedPowerStatesSupported;
	bool RequestedPowerStatesSupported_isNULL;
	
	OpenDRIM_PowerManagementCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		PowerCapabilities_isNULL = true;
		OtherPowerCapabilitiesDescriptions_isNULL = true;
		PowerStatesSupported_isNULL = true;
		PowerChangeCapabilities_isNULL = true;
		OtherPowerChangeCapabilities_isNULL = true;
		RequestedPowerStatesSupported_isNULL = true;
	}
	
	~OpenDRIM_PowerManagementCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getPowerCapabilities(vector<unsigned short>& value) const {
		if (PowerCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerCapabilities;
		return OK;
	}
	
	int setPowerCapabilities(const vector<unsigned short>& newValue) {
		PowerCapabilities = newValue;
		PowerCapabilities_isNULL = false;
		return OK;
	}

	int getOtherPowerCapabilitiesDescriptions(vector<string>& value) const {
		if (OtherPowerCapabilitiesDescriptions_isNULL==true)
			return NOT_FOUND;
		value = OtherPowerCapabilitiesDescriptions;
		return OK;
	}
	
	int setOtherPowerCapabilitiesDescriptions(const vector<string>& newValue) {
		OtherPowerCapabilitiesDescriptions = newValue;
		OtherPowerCapabilitiesDescriptions_isNULL = false;
		return OK;
	}

	int getPowerStatesSupported(vector<unsigned short>& value) const {
		if (PowerStatesSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerStatesSupported;
		return OK;
	}
	
	int setPowerStatesSupported(const vector<unsigned short>& newValue) {
		PowerStatesSupported = newValue;
		PowerStatesSupported_isNULL = false;
		return OK;
	}

	int getPowerChangeCapabilities(vector<unsigned short>& value) const {
		if (PowerChangeCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerChangeCapabilities;
		return OK;
	}
	
	int setPowerChangeCapabilities(const vector<unsigned short>& newValue) {
		PowerChangeCapabilities = newValue;
		PowerChangeCapabilities_isNULL = false;
		return OK;
	}

	int getOtherPowerChangeCapabilities(string& value) const {
		if (OtherPowerChangeCapabilities_isNULL==true)
			return NOT_FOUND;
		value = OtherPowerChangeCapabilities;
		return OK;
	}
	
	int setOtherPowerChangeCapabilities(const string& newValue) {
		OtherPowerChangeCapabilities = newValue;
		OtherPowerChangeCapabilities_isNULL = false;
		return OK;
	}

	int getRequestedPowerStatesSupported(vector<unsigned short>& value) const {
		if (RequestedPowerStatesSupported_isNULL==true)
			return NOT_FOUND;
		value = RequestedPowerStatesSupported;
		return OK;
	}
	
	int setRequestedPowerStatesSupported(const vector<unsigned short>& newValue) {
		RequestedPowerStatesSupported = newValue;
		RequestedPowerStatesSupported_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_POWERMANAGEMENTCAPABILITIES_H_*/
