/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ComponentMapBox
extends JP2Box {
    public ComponentMapBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        Object object;
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof CodestreamHeaderBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        int n2 = n / 4;
        Property[] propertyArray = new Property[n2];
        App app = this._module.getApp();
        for (int i = 0; i < n2; ++i) {
            object = new Property[3];
            int n3 = this._module.readUnsignedShort(this._dstrm);
            object[0] = new Property("ComponentIndex", PropertyType.INTEGER, new Integer(n3));
            int n4 = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            object[1] = this._module.addIntegerProperty("MTyp", n4, JP2Strings.mtypStr);
            int n5 = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            object[2] = new Property("PaletteComponent", PropertyType.INTEGER, new Integer(n5));
            propertyArray[i] = new Property("Component", PropertyType.PROPERTY, PropertyArity.ARRAY, object);
        }
        Property property = new Property("ComponentMapping", PropertyType.PROPERTY, PropertyArity.ARRAY, propertyArray);
        if (this._parentBox instanceof CodestreamHeaderBox) {
            object = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            ((Codestream)object).setCompMapProperty(property);
        } else {
            this._module.addProperty(property);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Component Mapping Box";
    }
}

