/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import edu.harvard.hul.ois.jhove.handler.audit.AuditCount;
import edu.harvard.hul.ois.jhove.handler.audit.AuditState;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class AuditHandler
extends XmlHandler {
    private static final String NAME = "Audit";
    private static final String RELEASE = "1.1";
    private static final int[] DATE = new int[]{2005, 4, 22};
    private static final String NOTE = "This output handler is derived from the standard JHOVE XML output handler.  It is intended to be used as the parent class for other, more interesting handlers.";
    private static final String RIGHTS = "Copyright 2004-2005 by the President and Fellows of Harvard College. Released under the GNU LGPL license";
    protected String _home;
    protected Map _mimeType;
    protected Map _stateMap;
    protected Stack _stateStack;
    protected long _t0;
    protected int _nAudit;

    public AuditHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._name = NAME;
        this._release = RELEASE;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(DATE[0], DATE[1] - 1, DATE[2]);
        this._date = gregorianCalendar.getTime();
        this._note = NOTE;
        this._rights = RIGHTS;
        this._mimeType = new TreeMap();
        this._stateMap = new TreeMap();
        this._stateStack = new Stack();
        this._nAudit = 0;
    }

    @Override
    public final void endDirectory() {
        AuditState auditState = (AuditState)this._stateStack.pop();
        this._stateMap.put(auditState.getDirectory(), auditState);
        this.endDirectoryImpl(auditState);
    }

    public void endDirectoryImpl(AuditState auditState) {
    }

    @Override
    public final boolean okToProcess(String string) {
        AuditState auditState = (AuditState)this._stateStack.peek();
        boolean bl = this.okToProcessImpl(string, auditState);
        if (!bl) {
            auditState.setNotProcessed(auditState.getNotProcessed() + 1);
        }
        return bl;
    }

    public boolean okToProcessImpl(String string, AuditState auditState) {
        return true;
    }

    @Override
    public void show(RepInfo repInfo) {
        AuditState auditState = (AuditState)this._stateStack.peek();
        if (repInfo.getModule() == null) {
            auditState.setNotFound(auditState.getNotFound() + 1);
            this._writer.println("<!-- file not found or not readable: " + repInfo.getUri() + " -->");
        } else {
            int n;
            String string = repInfo.getMimeType();
            AuditCount auditCount = (AuditCount)this._mimeType.get(string);
            if (auditCount == null) {
                auditCount = new AuditCount();
            }
            if ((n = repInfo.getValid()) == 1) {
                auditState.setValid(auditState.getValid() + 1);
                auditCount.setValid(auditCount.getValid() + 1);
            } else {
                auditState.setWellFormed(auditState.getWellFormed() + 1);
                auditCount.setWellFormed(auditCount.getWellFormed() + 1);
            }
            this._mimeType.put(string, auditCount);
        }
        this.showImpl(repInfo, auditState);
    }

    public void showImpl(RepInfo repInfo, AuditState auditState) {
        Object object;
        String string = null;
        String string2 = repInfo.getMimeType();
        string = string2 != null ? (repInfo.getWellFormed() == 1 ? (repInfo.getValid() == 1 ? "valid" : "well-formed") : "not well-formed") : "not found";
        String string3 = null;
        List list = repInfo.getChecksum();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            object = (Checksum)list.get(i);
            if (!object.getType().equals(ChecksumType.MD5)) continue;
            string3 = object.getValue();
            break;
        }
        if (this._nAudit == 0) {
            String string4 = AuditHandler.getIndent(++this._level);
            object = new String[][]{{"home", this._home}};
            this._writer.println(string4 + AuditHandler.elementStart("audit", object));
        }
        String string5 = AuditHandler.getIndent(this._level) + " ";
        object = repInfo.getUri();
        int n2 = object.indexOf(this._home);
        if (n2 == 0) {
            object = object.substring(this._home.length() + 1);
        }
        String[][] stringArray = new String[][]{{"mime", string2}, {"status", string}, {"md5", string3}};
        this._writer.println(string5 + AuditHandler.element("file", stringArray, (String)object));
        ++this._nAudit;
    }

    @Override
    public void showFooter() {
        int n;
        int n2;
        AuditState auditState = (AuditState)this._stateStack.pop();
        if (auditState.getTotal() > 0 || auditState.getNotFound() > 0) {
            this._stateMap.put(auditState.getDirectory(), auditState);
        }
        this.showFooterImpl(auditState);
        this._writer.println("<!-- Summary by MIME type:");
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Set set = this._mimeType.keySet();
        for (String string : set) {
            AuditCount auditCount = (AuditCount)this._mimeType.get(string);
            int n6 = auditCount.getTotal();
            n2 = auditCount.getValid();
            n = auditCount.getWellFormed();
            this._writer.println(string + ": " + n6 + " (" + n2 + "," + n + ")");
            n3 += n6;
            n4 += n2;
            n5 += n;
        }
        this._writer.println("Total: " + n3 + " (" + n4 + "," + n5 + ")");
        this._writer.println("-->");
        this._writer.println("<!-- Summary by directory:");
        n3 = 0;
        n4 = 0;
        n5 = 0;
        int n7 = 0;
        int n8 = 0;
        set = this._stateMap.keySet();
        for (String string : set) {
            auditState = (AuditState)this._stateMap.get(string);
            n2 = auditState.getTotal();
            n = auditState.getValid();
            int n9 = auditState.getWellFormed();
            int n10 = auditState.getNotFound();
            int n11 = auditState.getNotProcessed();
            this._writer.println(string + ": " + n2 + " (" + n + "," + n9 + ") + " + n11 + "," + n10);
            n3 += n2;
            n4 += n;
            n5 += n9;
            n7 += n10;
            n8 += n11;
        }
        this._writer.println("Total: " + n3 + " (" + n4 + "," + n5 + ") + " + n8 + "," + n7);
        this._writer.println("-->");
        long l = (System.currentTimeMillis() - this._t0 + 999L) / 1000L;
        long l2 = l % 60L;
        long l3 = l / 60L;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L;
        this._writer.println("<!-- Elapsed time: " + l5 + ":" + (l4 > 9L ? "" : "0") + l4 + ":" + (l2 > 9L ? "" : "0") + l2 + " -->");
        this._writer.flush();
    }

    public void showFooterImpl(AuditState auditState) {
        if (this._nAudit > 0) {
            String string = AuditHandler.getIndent(this._level--);
            this._writer.println(string + AuditHandler.elementEnd("audit"));
        }
        super.showFooter();
    }

    @Override
    public void showHeader() {
        this._mimeType = new TreeMap();
        this._stateMap = new TreeMap();
        this._stateStack = new Stack();
        this._nAudit = 0;
        this._t0 = System.currentTimeMillis();
        AuditState auditState = this.showHeaderImpl(".");
        this._stateStack.push(auditState);
        this._home = auditState.getDirectory();
    }

    public AuditState showHeaderImpl(String string) {
        super.showHeader();
        return new AuditState(string);
    }

    @Override
    public void startDirectory(String string) {
        try {
            AuditState auditState = (AuditState)((AuditState)this._stateStack.peek()).clone(string);
            this.startDirectoryImpl(auditState);
            this._stateStack.push(auditState);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public void startDirectoryImpl(AuditState auditState) {
    }
}

