/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.Collection;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentException;

class InvalidArgumentValueException
extends ArgumentException {
    public InvalidArgumentValueException(Collection<Pair<ArgumentDefinition, String>> invalidArgumentValues) {
        super(InvalidArgumentValueException.formatArguments(invalidArgumentValues));
    }

    private static String formatArguments(Collection<Pair<ArgumentDefinition, String>> invalidArgumentValues) {
        StringBuilder sb = new StringBuilder();
        for (Pair<ArgumentDefinition, String> invalidValue : invalidArgumentValues) {
            if (invalidValue.getSecond() == null) {
                sb.append(String.format("%nArgument '--%s' requires a value but none was provided", ((ArgumentDefinition)invalidValue.first).fullName));
                continue;
            }
            sb.append(String.format("%nArgument '--%s' has value of incorrect format: %s (should match %s)", ((ArgumentDefinition)invalidValue.first).fullName, invalidValue.second, ((ArgumentDefinition)invalidValue.first).validation));
        }
        return sb.toString();
    }
}

