/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.lang.annotation.Annotation;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.Input;
import org.broadinstitute.gatk.utils.commandline.Output;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public enum ArgumentIOType {
    INPUT(Input.class),
    OUTPUT(Output.class),
    ARGUMENT(Argument.class);

    public final Class<? extends Annotation> annotationClass;

    private ArgumentIOType(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public static ArgumentIOType getIOType(Annotation annotation) {
        for (ArgumentIOType ioType : ArgumentIOType.values()) {
            if (!ioType.annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return ioType;
        }
        throw new ReviewedGATKException("Unknown annotation type: " + annotation);
    }
}

