/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.table;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.broadinstitute.gatk.engine.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.codecs.table.TableFeature;
import org.broadinstitute.gatk.utils.exceptions.UserException;

public class TableCodec
extends AsciiFeatureCodec<TableFeature>
implements ReferenceDependentFeatureCodec {
    protected static final String delimiterRegex = "\\s+";
    protected static final String headerDelimiter = "HEADER";
    protected static final String igvHeaderDelimiter = "track";
    protected static final String commentDelimiter = "#";
    protected ArrayList<String> header = new ArrayList();
    protected GenomeLocParser genomeLocParser;

    public TableCodec() {
        super(TableFeature.class);
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    public TableFeature decode(String line) {
        if (line.startsWith(headerDelimiter) || line.startsWith(commentDelimiter) || line.startsWith(igvHeaderDelimiter)) {
            return null;
        }
        String[] split = line.split(delimiterRegex);
        if (split.length < 1) {
            throw new IllegalArgumentException("TableCodec line = " + line + " doesn't appear to be a valid table format");
        }
        return new TableFeature(this.genomeLocParser.parseGenomeLoc(split[0]), Arrays.asList(split), this.header);
    }

    public Object readActualHeader(LineIterator reader) {
        boolean isFirst = true;
        while (reader.hasNext()) {
            String line = reader.peek();
            if (isFirst && !line.startsWith(headerDelimiter) && !line.startsWith(commentDelimiter)) {
                throw new UserException.MalformedFile("TableCodec file does not have a header");
            }
            isFirst &= line.startsWith(commentDelimiter);
            if (line.startsWith(headerDelimiter)) {
                reader.next();
                if (this.header.size() > 0) {
                    throw new IllegalStateException("Input table file seems to have two header lines.  The second is = " + line);
                }
                String[] spl = line.split(delimiterRegex);
                Collections.addAll(this.header, spl);
                return this.header;
            }
            if (!line.startsWith(commentDelimiter)) break;
            reader.next();
        }
        return this.header;
    }
}

