/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.PeekIterator;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.TempStreamFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class SortingCollection<T>
implements Iterable<T> {
    private final File[] tmpDirs;
    private final long TMP_SPACE_FREE = 0x140000000L;
    private final Codec<T> codec;
    private final Comparator<T> comparator;
    private final int maxRecordsInRam;
    private int numRecordsInRam = 0;
    private T[] ramRecords;
    private boolean iterationStarted = false;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();
    private boolean destructiveIteration = true;
    private TempStreamFactory tempStreamFactory = new TempStreamFactory();

    private SortingCollection(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRam, File ... tmpDir) {
        if (maxRecordsInRam <= 0) {
            throw new IllegalArgumentException("maxRecordsInRam must be > 0");
        }
        if (tmpDir == null || tmpDir.length == 0) {
            throw new IllegalArgumentException("At least one temp directory must be provided.");
        }
        this.tmpDirs = tmpDir;
        this.codec = codec;
        this.comparator = comparator;
        this.maxRecordsInRam = maxRecordsInRam;
        this.ramRecords = (Object[])Array.newInstance(componentType, maxRecordsInRam);
    }

    public void add(T rec) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAdding()");
        }
        if (this.iterationStarted) {
            throw new IllegalStateException("Cannot add after calling iterator()");
        }
        if (this.numRecordsInRam == this.maxRecordsInRam) {
            this.spillToDisk();
        }
        this.ramRecords[this.numRecordsInRam++] = rec;
    }

    public void doneAdding() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call doneAdding() after cleanup() was called.");
        }
        if (this.doneAdding) {
            return;
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            return;
        }
        if (this.numRecordsInRam > 0) {
            this.spillToDisk();
        }
        this.ramRecords = null;
    }

    public boolean isDestructiveIteration() {
        return this.destructiveIteration;
    }

    public void setDestructiveIteration(boolean destructiveIteration) {
        this.destructiveIteration = destructiveIteration;
    }

    private void spillToDisk() {
        try {
            Arrays.sort(this.ramRecords, 0, this.numRecordsInRam, this.comparator);
            File f = this.newTempFile();
            OutputStream os = null;
            try {
                os = this.tempStreamFactory.wrapTempOutputStream(new FileOutputStream(f), Defaults.BUFFER_SIZE);
                this.codec.setOutputStream(os);
                for (int i = 0; i < this.numRecordsInRam; ++i) {
                    this.codec.encode(this.ramRecords[i]);
                    this.ramRecords[i] = null;
                }
                os.flush();
            }
            catch (RuntimeIOException ex) {
                throw new RuntimeIOException("Problem writing temporary file " + f.getAbsolutePath() + ".  Try setting TMP_DIR to a file system with lots of space.", ex);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
            this.numRecordsInRam = 0;
            this.files.add(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private File newTempFile() throws IOException {
        return IOUtil.newTempFile("sortingcollection.", ".tmp", this.tmpDirs, 0x140000000L);
    }

    @Override
    public CloseableIterator<T> iterator() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call iterator() after cleanup() was called.");
        }
        this.doneAdding();
        this.iterationStarted = true;
        if (this.files.isEmpty()) {
            return new InMemoryIterator();
        }
        return new MergingIterator();
    }

    public void cleanup() {
        this.iterationStarted = true;
        this.cleanedUp = true;
        IOUtil.deleteFiles(this.files);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, File ... tmpDir) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, tmpDir);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, Collection<File> tmpDirs) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, tmpDirs.toArray(new File[tmpDirs.size()]));
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, tmpDir);
    }

    static class PollableTreeSet<T>
    extends TreeSet<T> {
        PollableTreeSet(Comparator<? super T> comparator) {
            super(comparator);
        }

        public T poll() {
            if (this.isEmpty()) {
                return null;
            }
            Object t = this.first();
            this.remove(t);
            return (T)t;
        }
    }

    class PeekFileRecordIteratorComparator
    implements Comparator<PeekFileRecordIterator> {
        PeekFileRecordIteratorComparator() {
        }

        @Override
        public int compare(PeekFileRecordIterator lhs, PeekFileRecordIterator rhs) {
            int result = SortingCollection.this.comparator.compare(lhs.peek(), rhs.peek());
            if (result == 0) {
                return lhs.n - rhs.n;
            }
            return result;
        }
    }

    class PeekFileRecordIterator
    extends PeekIterator<T> {
        final int n;

        PeekFileRecordIterator(Iterator<T> underlyingIterator, int n) {
            super(underlyingIterator);
            this.n = n;
        }
    }

    class FileRecordIterator
    implements CloseableIterator<T> {
        private final File file;
        private final FileInputStream is;
        private final Codec<T> codec;
        private T currentRecord = null;

        FileRecordIterator(File file) {
            this.file = file;
            try {
                this.is = new FileInputStream(file);
                this.codec = SortingCollection.this.codec.clone();
                this.codec.setInputStream(SortingCollection.this.tempStreamFactory.wrapTempInputStream(this.is, Defaults.BUFFER_SIZE));
                this.advance();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentRecord;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.currentRecord = this.codec.decode();
        }

        @Override
        public void close() {
            CloserUtil.close(this.is);
        }
    }

    class MergingIterator
    implements CloseableIterator<T> {
        private final PollableTreeSet<PeekFileRecordIterator> queue;

        MergingIterator() {
            this.queue = new PollableTreeSet<PeekFileRecordIterator>(new PeekFileRecordIteratorComparator());
            int n = 0;
            for (File f : SortingCollection.this.files) {
                FileRecordIterator it = new FileRecordIterator(f);
                if (it.hasNext()) {
                    this.queue.add(new PeekFileRecordIterator(it, n++));
                    continue;
                }
                it.close();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PeekFileRecordIterator fileIterator = this.queue.poll();
            Object ret = fileIterator.next();
            if (fileIterator.hasNext()) {
                this.queue.add(fileIterator);
            } else {
                ((CloseableIterator)fileIterator.getUnderlyingIterator()).close();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                PeekFileRecordIterator it = this.queue.poll();
                ((CloseableIterator)it.getUnderlyingIterator()).close();
            }
        }
    }

    class InMemoryIterator
    implements CloseableIterator<T> {
        private int iterationIndex = 0;

        InMemoryIterator() {
            Arrays.sort(SortingCollection.this.ramRecords, 0, SortingCollection.this.numRecordsInRam, SortingCollection.this.comparator);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterationIndex < SortingCollection.this.numRecordsInRam;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = SortingCollection.this.ramRecords[this.iterationIndex];
            if (SortingCollection.this.destructiveIteration) {
                ((SortingCollection)SortingCollection.this).ramRecords[this.iterationIndex] = null;
            }
            ++this.iterationIndex;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Codec<T>
    extends Cloneable {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(T var1);

        public T decode();

        public Codec<T> clone();
    }
}

