/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

public class FastqRecord {
    private final String seqHeaderPrefix;
    private final String seqLine;
    private final String qualHeaderPrefix;
    private final String qualLine;

    public FastqRecord(String seqHeaderPrefix, String seqLine, String qualHeaderPrefix, String qualLine) {
        this.seqHeaderPrefix = seqHeaderPrefix != null && seqHeaderPrefix.length() > 0 ? seqHeaderPrefix : null;
        this.qualHeaderPrefix = qualHeaderPrefix != null && qualHeaderPrefix.length() > 0 ? qualHeaderPrefix : null;
        this.seqLine = seqLine;
        this.qualLine = qualLine;
    }

    public String getReadHeader() {
        return this.seqHeaderPrefix;
    }

    public String getReadString() {
        return this.seqLine;
    }

    public String getBaseQualityHeader() {
        return this.qualHeaderPrefix;
    }

    public String getBaseQualityString() {
        return this.qualLine;
    }

    public int length() {
        return this.seqLine == null ? 0 : this.seqLine.length();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qualHeaderPrefix == null ? 0 : this.qualHeaderPrefix.hashCode());
        result = 31 * result + (this.qualLine == null ? 0 : this.qualLine.hashCode());
        result = 31 * result + (this.seqHeaderPrefix == null ? 0 : this.seqHeaderPrefix.hashCode());
        result = 31 * result + (this.seqLine == null ? 0 : this.seqLine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastqRecord other = (FastqRecord)obj;
        if (this.seqLine == null ? other.seqLine != null : !this.seqLine.equals(other.seqLine)) {
            return false;
        }
        if (this.qualHeaderPrefix == null ? other.qualHeaderPrefix != null : !this.qualHeaderPrefix.equals(other.qualHeaderPrefix)) {
            return false;
        }
        if (this.qualLine == null ? other.qualLine != null : !this.qualLine.equals(other.qualLine)) {
            return false;
        }
        return !(this.seqHeaderPrefix == null ? other.seqHeaderPrefix != null : !this.seqHeaderPrefix.equals(other.seqHeaderPrefix));
    }

    public String toString() {
        return "@" + (this.seqHeaderPrefix == null ? "" : this.seqHeaderPrefix) + '\n' + (this.seqLine == null ? "" : this.seqLine) + '\n' + "+" + (this.qualHeaderPrefix == null ? "" : this.qualHeaderPrefix) + '\n' + (this.qualLine == null ? "" : this.qualLine);
    }
}

