/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffman.codec.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class HuffmanIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private int[] values;
    private final ByteBuffer buf = ByteBuffer.allocate(10240);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        ITF8.writeUnsignedITF8(this.values.length, this.buf);
        for (int value : this.values) {
            ITF8.writeUnsignedITF8(value, this.buf);
        }
        ITF8.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int value : this.bitLengths) {
            ITF8.writeUnsignedITF8(value, this.buf);
        }
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        int i;
        ByteBuffer buf = ByteBuffer.wrap(data);
        int size = ITF8.readUnsignedITF8(buf);
        this.values = new int[size];
        for (i = 0; i < size; ++i) {
            this.values[i] = ITF8.readUnsignedITF8(buf);
        }
        size = ITF8.readUnsignedITF8(buf);
        this.bitLengths = new int[size];
        for (i = 0; i < size; ++i) {
            this.bitLengths[i] = ITF8.readUnsignedITF8(buf);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new CanonicalHuffmanIntegerCodec(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] bfValues, int[] bfBitLens) {
        HuffmanIntegerEncoding e = new HuffmanIntegerEncoding();
        e.values = bfValues;
        e.bitLengths = bfBitLens;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HuffmanIntegerEncoding) {
            HuffmanIntegerEncoding foe = (HuffmanIntegerEncoding)obj;
            return Arrays.equals(this.bitLengths, foe.bitLengths) && Arrays.equals(this.values, foe.values);
        }
        return false;
    }
}

