/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalLongCodec
extends AbstractBitCodec<Long> {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    public ExternalLongCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public Long read(BitInputStream bitInputStream) throws IOException {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)this.inputStream.read();
        }
        return result;
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Long value) throws IOException {
        for (int i = 0; i < 8; ++i) {
            this.outputStream.write((int)(value & 0xFFL));
            value = value >>> 8;
        }
        return 64L;
    }

    @Override
    public long numberOfBits(Long object) {
        return 8L;
    }

    @Override
    public Long read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

