/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

public class IntHashMap<T> {
    private transient Entry<T>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<T>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<Object> e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        Entry<T>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<Object> entry = tab[index];
        while (entry != null) {
            if (entry.hash == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(int key) {
        Entry<T>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<Object> e = tab[index];
        while (e != null) {
            if (e.hash == key) {
                return (T)e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<T>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<Object> old = oldMap[i];
            while (old != null) {
                Entry<T> entry = old;
                old = old.next;
                int index = (entry.hash & Integer.MAX_VALUE) % newCapacity;
                entry.next = newMap[index];
                newMap[index] = entry;
            }
        }
    }

    public Object put(int key, T value) {
        Entry<T>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<Object> entry = tab[index];
        while (entry != null) {
            if (entry.hash == key) {
                Object old = entry.value;
                entry.value = value;
                return old;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = entry = new Entry<T>(key, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        Entry<T>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<Object> entry = tab[index];
        Entry<T> prev = null;
        while (entry != null) {
            if (entry.hash == key) {
                if (prev != null) {
                    prev.next = entry.next;
                } else {
                    tab[index] = entry.next;
                }
                --this.count;
                Object oldValue = entry.value;
                entry.value = null;
                return oldValue;
            }
            prev = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<T>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    private static class Entry<E> {
        final int hash;
        final int key;
        E value;
        Entry<E> next;

        protected Entry(int hash, int key, E value, Entry<E> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

