/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Collections;

public class DuplicateSetIterator
implements CloseableIterator<DuplicateSet> {
    private final CloseableIterator<SAMRecord> wrappedIterator;
    private DuplicateSet duplicateSet = null;
    private final SAMRecordDuplicateComparator comparator;

    public DuplicateSetIterator(CloseableIterator<SAMRecord> iterator, SAMFileHeader header) {
        this(iterator, header, false);
    }

    public DuplicateSetIterator(CloseableIterator<SAMRecord> iterator, SAMFileHeader header, boolean preSorted) {
        this.comparator = new SAMRecordDuplicateComparator(Collections.singletonList(header));
        if (preSorted) {
            this.wrappedIterator = iterator;
        } else {
            int maxRecordsInRam = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            SortingCollection<SAMRecord> alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), this.comparator, maxRecordsInRam, tmpDir);
            while (iterator.hasNext()) {
                SAMRecord record = (SAMRecord)iterator.next();
                alignmentSorter.add(record);
            }
            iterator.close();
            this.wrappedIterator = alignmentSorter.iterator();
        }
        this.duplicateSet = new DuplicateSet(this.comparator);
        if (this.hasNext()) {
            this.duplicateSet.add((SAMRecord)this.wrappedIterator.next());
        }
    }

    public void setScoringStrategy(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        this.comparator.setScoringStrategy(scoringStrategy);
    }

    @Override
    public DuplicateSet next() {
        DuplicateSet duplicateSet = null;
        int cmp = 0;
        while (0 == cmp) {
            if (!this.wrappedIterator.hasNext()) {
                duplicateSet = this.duplicateSet;
                this.duplicateSet = new DuplicateSet(this.comparator);
                break;
            }
            SAMRecord record = (SAMRecord)this.wrappedIterator.next();
            SAMRecord representative = this.duplicateSet.getRepresentative();
            if (representative.getReadUnmappedFlag() || representative.isSecondaryOrSupplementary()) {
                duplicateSet = this.duplicateSet;
                this.duplicateSet = new DuplicateSet(this.comparator);
                this.duplicateSet.add(record);
                break;
            }
            cmp = this.duplicateSet.add(record);
            if (0 < cmp) {
                throw new SAMException("The input records were not sorted in duplicate order:\n" + representative.getSAMString() + record.getSAMString());
            }
            if (cmp >= 0) continue;
            duplicateSet = this.duplicateSet;
            this.duplicateSet = new DuplicateSet(this.comparator);
            this.duplicateSet.add(record);
        }
        return duplicateSet;
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public boolean hasNext() {
        return !this.duplicateSet.isEmpty() || this.wrappedIterator.hasNext();
    }

    @Override
    public void remove() {
    }
}

