/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;

public class DuplicateScoringStrategy {
    private static short getSumOfBaseQualities(SAMRecord rec) {
        short score = 0;
        for (byte b : rec.getBaseQualities()) {
            if (b < 15) continue;
            score = (short)(score + b);
        }
        return score;
    }

    public static short computeDuplicateScore(SAMRecord record, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.computeDuplicateScore(record, scoringStrategy, false);
    }

    public static short computeDuplicateScore(SAMRecord record, ScoringStrategy scoringStrategy, boolean assumeMateCigar) {
        short score = 0;
        switch (scoringStrategy) {
            case SUM_OF_BASE_QUALITIES: {
                score = (short)(score + DuplicateScoringStrategy.getSumOfBaseQualities(record));
                break;
            }
            case TOTAL_MAPPED_REFERENCE_LENGTH: {
                if (!record.getReadUnmappedFlag()) {
                    score = (short)(score + record.getCigar().getReferenceLength());
                }
                if (!assumeMateCigar || !record.getReadPairedFlag() || record.getMateUnmappedFlag()) break;
                score = (short)(score + SAMUtils.getMateCigar(record).getReferenceLength());
            }
        }
        return score;
    }

    public static int compare(SAMRecord rec1, SAMRecord rec2, ScoringStrategy scoringStrategy, boolean assumeMateCigar) {
        if (rec1.getReadPairedFlag() != rec2.getReadPairedFlag()) {
            return rec1.getReadPairedFlag() ? 1 : -1;
        }
        int cmp = DuplicateScoringStrategy.computeDuplicateScore(rec2, scoringStrategy, assumeMateCigar) - DuplicateScoringStrategy.computeDuplicateScore(rec1, scoringStrategy, assumeMateCigar);
        if (0 == cmp) {
            cmp = SAMUtils.getCanonicalRecordName(rec1).compareTo(SAMUtils.getCanonicalRecordName(rec2));
        }
        return cmp;
    }

    public static int compare(SAMRecord rec1, SAMRecord rec2, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.compare(rec1, rec2, scoringStrategy, false);
    }

    public static enum ScoringStrategy {
        SUM_OF_BASE_QUALITIES,
        TOTAL_MAPPED_REFERENCE_LENGTH;

    }
}

