/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

class CancelLock {
    private State state = State.IDLE;

    CancelLock() {
    }

    boolean isIdle() {
        return this.state == State.IDLE;
    }

    synchronized void enterExecuting() {
        assert (this.state == State.IDLE);
        this.state = State.EXECUTING;
    }

    synchronized void exitExecuting() {
        while (this.state != State.EXECUTING) {
            assert (this.state == State.CANCELING);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.state = State.IDLE;
    }

    synchronized boolean enterCanceling() {
        if (this.state == State.EXECUTING) {
            this.state = State.CANCELING;
            return true;
        }
        return false;
    }

    synchronized void exitCanceling() {
        assert (this.state == State.CANCELING);
        this.state = State.EXECUTING;
        this.notify();
    }

    private static enum State {
        IDLE,
        EXECUTING,
        CANCELING;

    }
}

