/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.Log;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpticalDuplicateFinder {
    public static final String DEFAULT_READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*".intern();
    public static final int DEFAULT_OPTICAL_DUPLICATE_DISTANCE = 100;
    public String readNameRegex;
    public int opticalDuplicatePixelDistance;
    private Pattern readNamePattern;
    private boolean warnedAboutRegexNotMatching = false;
    private final Log log;
    private final int[] tmpLocationFields = new int[10];

    public OpticalDuplicateFinder() {
        this(DEFAULT_READ_NAME_REGEX, 100);
    }

    public OpticalDuplicateFinder(int opticalDuplicatePixelDistance) {
        this(DEFAULT_READ_NAME_REGEX, opticalDuplicatePixelDistance);
    }

    public OpticalDuplicateFinder(String readNameRegex) {
        this(readNameRegex, 100);
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance) {
        this(readNameRegex, opticalDuplicatePixelDistance, null);
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance, Log log) {
        this.readNameRegex = readNameRegex;
        this.opticalDuplicatePixelDistance = opticalDuplicatePixelDistance;
        this.log = log;
    }

    public boolean addLocationInformation(String readName, PhysicalLocation loc) {
        Matcher m;
        if (this.readNameRegex == DEFAULT_READ_NAME_REGEX) {
            int fields = this.getRapidDefaultReadNameRegexSplit(readName, ':', this.tmpLocationFields);
            if (fields != 5 && fields != 7) {
                if (null != this.log && !this.warnedAboutRegexNotMatching) {
                    this.log.warn(new Object[]{String.format("Default READ_NAME_REGEX '%s' did not match read name '%s'.  You may need to specify a READ_NAME_REGEX in order to correctly identify optical duplicates.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, readName)});
                    this.warnedAboutRegexNotMatching = true;
                }
                return false;
            }
            int offset = fields == 7 ? 2 : 0;
            loc.setTile((short)this.tmpLocationFields[offset + 2]);
            loc.setX((short)this.tmpLocationFields[offset + 3]);
            loc.setY((short)this.tmpLocationFields[offset + 4]);
            return true;
        }
        if (this.readNameRegex == null) {
            return false;
        }
        if (this.readNamePattern == null) {
            this.readNamePattern = Pattern.compile(this.readNameRegex);
        }
        if ((m = this.readNamePattern.matcher(readName)).matches()) {
            loc.setTile((short)Integer.parseInt(m.group(1)));
            loc.setX((short)Integer.parseInt(m.group(2)));
            loc.setY((short)Integer.parseInt(m.group(3)));
            return true;
        }
        if (null != this.log && !this.warnedAboutRegexNotMatching) {
            this.log.warn(new Object[]{String.format("READ_NAME_REGEX '%s' did not match read name '%s'.  Your regex may not be correct.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, readName)});
            this.warnedAboutRegexNotMatching = true;
        }
        return false;
    }

    protected int getRapidDefaultReadNameRegexSplit(String readName, char delim, int[] tokens) {
        int tokensIdx = 0;
        int prevIdx = 0;
        for (int i = 0; i < readName.length(); ++i) {
            if (readName.charAt(i) != delim) continue;
            if (1 < tokensIdx && tokensIdx < 5) {
                tokens[tokensIdx] = this.rapidParseInt(readName.substring(prevIdx, i));
            }
            if (4 < ++tokensIdx) {
                return tokensIdx;
            }
            prevIdx = i + 1;
        }
        if (prevIdx < readName.length()) {
            if (1 < tokensIdx && tokensIdx < 5) {
                tokens[tokensIdx] = this.rapidParseInt(readName.substring(prevIdx, readName.length()));
            }
            ++tokensIdx;
        }
        return tokensIdx;
    }

    protected final int rapidParseInt(String input) {
        char ch;
        int len = input.length();
        int val = 0;
        int i = 0;
        boolean isNegative = false;
        if (0 < len && '-' == input.charAt(0)) {
            i = 1;
            isNegative = true;
        }
        while (i < len && Character.isDigit(ch = input.charAt(i))) {
            val = val * 10 + (ch - 48);
            ++i;
        }
        if (isNegative) {
            val = -val;
        }
        return val;
    }

    public boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list) {
        int length = list.size();
        boolean[] opticalDuplicateFlags = new boolean[length];
        Collections.sort(list, new Comparator<PhysicalLocation>(){

            @Override
            public int compare(PhysicalLocation lhs, PhysicalLocation rhs) {
                int retval = lhs.getReadGroup() - rhs.getReadGroup();
                if (retval == 0) {
                    retval = lhs.getTile() - rhs.getTile();
                }
                if (retval == 0) {
                    retval = lhs.getX() - rhs.getX();
                }
                if (retval == 0) {
                    retval = lhs.getY() - rhs.getY();
                }
                return retval;
            }
        });
        block0: for (int i = 0; i < length; ++i) {
            PhysicalLocation lhs = list.get(i);
            if (lhs.getTile() < 0) continue;
            for (int j = i + 1; j < length; ++j) {
                PhysicalLocation rhs = list.get(j);
                if (opticalDuplicateFlags[j]) continue;
                if (lhs.getReadGroup() != rhs.getReadGroup() || lhs.getTile() != rhs.getTile() || rhs.getX() > lhs.getX() + this.opticalDuplicatePixelDistance) continue block0;
                if (Math.abs(lhs.getY() - rhs.getY()) > this.opticalDuplicatePixelDistance) continue;
                opticalDuplicateFlags[j] = true;
            }
        }
        return opticalDuplicateFlags;
    }

    public static interface PhysicalLocation {
        public short getReadGroup();

        public void setReadGroup(short var1);

        public short getTile();

        public void setTile(short var1);

        public short getX();

        public void setX(short var1);

        public short getY();

        public void setY(short var1);

        public short getLibraryId();

        public void setLibraryId(short var1);
    }
}

