/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Fasta;

@CommandLineProgramProperties(usage="Read fasta or fasta.gz containing reference sequences, and write as a SAM or BAM file with only sequence dictionary.\n", usageShort="Creates a SAM or BAM file from reference sequence in fasta format", programGroup=Fasta.class)
public class CreateSequenceDictionary
extends CommandLineProgram {
    @Option(doc="Input reference fasta or fasta.gz", shortName="R")
    public File REFERENCE;
    @Option(doc="Output SAM or BAM file containing only the sequence dictionary", shortName="O")
    public File OUTPUT;
    @Option(doc="Put into AS field of sequence dictionary entry if supplied", optional=true)
    public String GENOME_ASSEMBLY;
    @Option(doc="Put into UR field of sequence dictionary entry.  If not supplied, input reference file is used", optional=true)
    public String URI;
    @Option(doc="Put into SP field of sequence dictionary entry", optional=true)
    public String SPECIES;
    @Option(doc="Make sequence name the first word from the > line in the fasta file.  By default the entire contents of the > line is used, excluding leading and trailing whitespace.")
    public boolean TRUNCATE_NAMES_AT_WHITESPACE = true;
    @Option(doc="Stop after writing this many sequences.  For testing.")
    public int NUM_SEQUENCES = Integer.MAX_VALUE;
    private final MessageDigest md5;

    public CreateSequenceDictionary() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PicardException("MD5 algorithm not found", e);
        }
    }

    public static void main(String[] argv) {
        System.exit(new CreateSequenceDictionary().instanceMain(argv));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.URI == null) {
            this.URI = "file:" + this.REFERENCE.getAbsolutePath();
        }
        return null;
    }

    @Override
    protected int doWork() {
        if (this.OUTPUT.exists()) {
            throw new PicardException(this.OUTPUT.getAbsolutePath() + " already exists.  Delete this file and try again, or specify a different output file.");
        }
        SAMSequenceDictionary sequences = this.makeSequenceDictionary(this.REFERENCE);
        SAMFileHeader samHeader = new SAMFileHeader();
        samHeader.setSequenceDictionary(sequences);
        SAMFileWriter samWriter = new SAMFileWriterFactory().makeSAMWriter(samHeader, false, this.OUTPUT);
        samWriter.close();
        return 0;
    }

    SAMSequenceDictionary makeSequenceDictionary(File referenceFile) {
        ReferenceSequence refSeq;
        ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)referenceFile, (boolean)this.TRUNCATE_NAMES_AT_WHITESPACE);
        ArrayList<SAMSequenceRecord> ret = new ArrayList<SAMSequenceRecord>();
        HashSet<String> sequenceNames = new HashSet<String>();
        for (int numSequences = 0; numSequences < this.NUM_SEQUENCES && (refSeq = refSeqFile.nextSequence()) != null; ++numSequences) {
            if (sequenceNames.contains(refSeq.getName())) {
                throw new PicardException("Sequence name appears more than once in reference: " + refSeq.getName());
            }
            sequenceNames.add(refSeq.getName());
            ret.add(this.makeSequenceRecord(refSeq));
        }
        return new SAMSequenceDictionary(ret);
    }

    private SAMSequenceRecord makeSequenceRecord(ReferenceSequence refSeq) {
        SAMSequenceRecord ret = new SAMSequenceRecord(refSeq.getName(), refSeq.length());
        byte[] bases = refSeq.getBases();
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase((byte)bases[i]);
        }
        ret.setAttribute("M5", this.md5Hash(bases));
        if (this.GENOME_ASSEMBLY != null) {
            ret.setAttribute("AS", this.GENOME_ASSEMBLY);
        }
        ret.setAttribute("UR", this.URI);
        if (this.SPECIES != null) {
            ret.setAttribute("SP", this.SPECIES);
        }
        return ret;
    }

    private String md5Hash(byte[] bytes) {
        this.md5.reset();
        this.md5.update(bytes);
        String s = new BigInteger(1, this.md5.digest()).toString(16);
        if (s.length() != 32) {
            String zeros = "00000000000000000000000000000000";
            s = "00000000000000000000000000000000".substring(0, 32 - s.length()) + s;
        }
        return s;
    }
}

