/*
 *	for new GOGO-no-coda ( 2000/4/1 )
 *	Copyright (C)2000 shigeo
 */
/*
 * How to add the language you want
 *
 * 1. make ???.msg
 *    make the function is???() in its file.
 * 2. add #include "???.msg"
 * 3. add tLANG_??? in t_lang
 * 4. add how to detective location in checkLang()
 * 5. setup msg in setLang()
 * 6  add the option in the top of main() in musui.c
 */

#include "message.h"
#include "japanese.msg"
#include "english.msg"
#include "german.msg"
#include "spanish.msg"

#ifdef WIN32
#include <windows.h>
#endif

static t_lang lang = tLANG_ENGLISH; /* Iꂽ */
static char (*msg)[MSG_LEN_MAX] = msg_ENGLISH;

static t_lang checkLang( void ){
#if defined( WIN32 )
	t_lang tmp = DFLT_LANG;
	char type;
	LCID ID = GetUserDefaultLCID();
	if( !ID ){
		ID = GetSystemDefaultLCID();
	}
	type = ID;
	if( type == (char)LANG_JAPANESE ){
		tmp = tLANG_JAPANESE_SJIS;
	}else
	if( type == (char)LANG_GERMAN ){
		tmp = tLANG_GERMAN;
	}
	else
	if( type == (char)LANG_ENGLISH ){
		tmp = tLANG_ENGLISH;
	}
	else
	if( type == (char)LANG_SPANISH ){
		tmp = tLANG_SPANISH;
	}
#elif defined( BeOS )
	/* Noisyu񏑂Ă(^^; */
	t_lang tmp = DFLT_LANG;
#elif (defined( __os2__ ) && 0)
	t_lang tmp = DFLT_LANG;
#else
	static char env[][12] = { "LC_MESSAGES", "LC_ALL", "LANG" };
	int i;
	t_lang tmp = DFLT_LANG;
	char *LANG;
	for( i = 0; i < sizeof(env)/sizeof(env[0]); i++ ){
		LANG = getenv( env[i] );
		if( !LANG ) continue;
		if( isENGLISH( LANG ) ){
			tmp = tLANG_ENGLISH;
			break;
		}else
		if( isGERMAN( LANG ) ){
			tmp = tLANG_GERMAN;
			break;
		}else
		if( isSPANISH( LANG ) ){
			tmp = tLANG_SPANISH;
			break;
		}else
		if( isJAPANESE_SJIS( LANG ) ){
			tmp = tLANG_JAPANESE_SJIS;
			break;
		}else
		if( isJAPANESE_EUC( LANG ) ){
			tmp = tLANG_JAPANESE_EUC;
			break;
		}
#if 0 /* if you want */
		/* for JAPANESE */
		if( tmp == tLANG_JAPANESE_EUC || tmp == tLANG_JAPANESE_SJIS ){
			char *TERM;
			TERM = getenv("TERM");
			if( TERM && strcmp( TERM, "kterm" ) && strcmp( TERM, "kon" ) && strcmp( TERM, "rxvt" ) ){
				tmp = tLANG_ENGLISH;
			}
		}
#endif
	}
#endif
	return tmp;
}

static short euc2sjis( short a ){
	unsigned char H, L;
	H = ( a >> 8 ) & 0x7F;
	L = a & 0x7F;
	H += 0x1F;
	if( !( L & 1 ) ){
		L -= 2;
		H += 0x5E;
	}
	L >>= 1;
	if( H >= 0x7F ) H++;
	L += ( L <= 0x2E ) ? 0x71 : 0xB1;
	return ( H << 8 ) + L;
}

static short sjis2euc( short a ){
	unsigned char H, L;
	L = a >> 8;
	H = a;
	if( L > 0x7F ) L--;
	H -= ( H <= 0x9F ) ? 0x70 : 0xB0;
	H <<= 1;
	if( L >= 0x9E ){
		L -= 0x5E + 0x1F;
	}else{
		L -= 0x1F;
		H--;
	}
	L |= 0x80;
	H |= 0x80;
	return ( L << 8 ) + H;
}

/* ɏ㏑ */
static void str_euc2sjis( char *s ){
	while( *s ){
		if( *s & 0x80 ){
			short a;
			a = *( short *)s;
			*( short *)s = euc2sjis( a );
			s += 2;
		}else{
			s++;
		}
	}
}

#define isKANJI1(x) ((unsigned char)((x^0x20)-0xA1)<=0x3B)
static void str_sjis2euc( char *s ){
	while( *s ){
		if( isKANJI1(*s) ){
			short a;
			a = *( short *)s;
			*( short *)s = sjis2euc( a );
			s += 2;
		}else{
			s++;
		}
	}
}

t_lang getLangType( void ){
	return lang;
}

/* setup `msg' here */
t_lang setLang( t_lang n ){
	if( n == tLANG_UNKNOWN ){
		n = checkLang();
	}
	lang = n;
	if( lang == tLANG_ENGLISH ){
		msg = msg_ENGLISH;
	}else
	if( lang == tLANG_GERMAN ){
		msg = msg_GERMAN;
	}else
	if( lang == tLANG_SPANISH ){
		msg = msg_SPANISH;
	}else
	if( lang == tLANG_JAPANESE_EUC || lang == tLANG_JAPANESE_SJIS ){
		t_lang data;
		void (*func)(char *) = (void (*)(char *) )NULL;
		if( (unsigned char)(*msg_JAPANESE[MSG_GOGO]) == 0xB8UL ){ /* `'EUCł1byte */
			data = tLANG_JAPANESE_EUC;
	        }else{
			data = tLANG_JAPANESE_SJIS;
		}
		if( data == tLANG_JAPANESE_SJIS && lang == tLANG_JAPANESE_EUC ){
			func = str_sjis2euc;
		}else
		if( data == tLANG_JAPANESE_EUC && lang == tLANG_JAPANESE_SJIS ){
			func = str_euc2sjis;
		}
		if( func ){
			int i;
			for( i = 0; i < sizeof(msg_JAPANESE)/sizeof(msg_JAPANESE[0]); i++){
				func(msg_JAPANESE[i]);
			}
		}
		msg = msg_JAPANESE;
	}
	return n;
}

char *getMsg( int n ){
	return (char *)msg[n];
}

#if 0
int main( int argc, char *argv[] ){
 /* ߌ SJIS 8C:DF, 8C:E3 */
 /*      EUC  B8:E1, B8:E5 */

  setLang( tLANG_UNKNOWN );
  printf( "msg=%s\n", getMsg(MSG_GOGO) );
}
#endif
