/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProcFactory {
    public static ServiceScaffold getScaffold(String procClass, Map<String, String> config) throws CliCommandoException {
        ServiceScaffold scaffold = null;
        try {
            Object c = Class.forName(procClass).newInstance();
            if (c instanceof ServiceScaffold) {
                scaffold = (ServiceScaffold)c;
            }
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to load " + procClass + ": \n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to load " + procClass + ": \n" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException("Failed to load '" + procClass + "' - probably can't find it. Full msg:\n" + e.getMessage());
        }
        if (scaffold == null) {
            throw new InternalErrorException("Failed to load scaffold: " + procClass);
        }
        scaffold.configureScaffold(config);
        return scaffold;
    }
}

