/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Ted Gould <ted.gould@canonical.com>
 */

#include <glib.h>
#include <gio/gio.h>

#ifndef WHOOPSIE_RECOVERABLE_PROBLEM__
#define WHOOPSIE_RECOVERABLE_PROBLEM__ 1

G_BEGIN_DECLS

/**
 * whoopsie_report_recoverable_problem:
 * @signature: The signature bucket for this problem
 * @report_pid: PID to report the error on or zero for this process
 * @wait: Wait until the problem is reported (important if this
 *        and there's a chance we'd exit
 * @additional_properties: Other properties that should be included
 *        in the report. Should have a multiple of 2 number of entries.
 *
 * Reports a recoverable problem so that it can be tracked on
 * daisy. Generally these are issues that can be dealt with, but having
 * tracking of them would be helpful.
 */
void    whoopsie_report_recoverable_problem    (const gchar *   signature,
                                                GPid            report_pid,
                                                gboolean        wait,
                                                const gchar *   additional_properties[]);

G_END_DECLS

#endif /* WHOOPSIE_RECOVERABLE_PROBLEM__ */
