# miniz_oxide
Rust replacement for the [miniz](https://github.com/richgel999/miniz) deflate/zlib encoder/decoder

This project is organized into a C API shell and a rust crate.
The Rust crate is found in the [miniz_oxide subdirectory](https://github.com/Frommi/miniz_oxide/tree/master/miniz_oxide).

## miniz_oxide_C_API
The C API is intented to replicate the api exported from miniz.

### API documentation

TODO

### Testing

```bash
$ cargo test
$ ./test.sh
```

### Benches
```bash
$ cargo bench --features=benching
```
or to compare to miniz
```bash
$ ./travis-after-success.sh
```

### Including in C/C++ projects

Link against the `libminiz_oxide_c_api.a` generated by `build.sh`

### Cargo-fuzz testing

Install fuzzer:
```bash
$ cargo install cargo-fuzz
```

Run fuzzer:
```bash
$ ./run_fuzz.sh
```

### License
This library (excluding the miniz C code used for tests) is licensed under the MIT license. The library is based on the miniz C library, of which the parts used are dual-licensed under the [MIT license](https://github.com/Frommi/miniz_oxide/blob/master/miniz/miniz.c#L1) and also the [unlicense](https://github.com/Frommi/miniz_oxide/blob/master/miniz/miniz.c#L577). 
The parts of miniz that are not covered by the unlicense is [some Zip64 code](https://github.com/richgel999/miniz/commit/224d207ce8fffb908e156d27478be3afb5d83e6a#diff-edc0e9ccfae3b5324b85b3ec0a53dc74) which is only MIT licensed. This and other Zip functionality in miniz is not part of the miniz_oxidde and miniz_oxide_c_api rust libraries.
