/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;

public class SendToBackAction
extends AbstractSelectedAction {
    public static String ID = "edit.sendToBack";

    public SendToBackAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
        SendToBackAction.sendToBack(drawingView, linkedList);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return SendToBackAction.this.labels.getTextProperty(ID);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                SendToBackAction.sendToBack(drawingView, linkedList);
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BringToFrontAction.bringToFront(drawingView, linkedList);
            }
        });
    }

    public static void sendToBack(DrawingView drawingView, Collection collection) {
        Iterator iterator = collection.iterator();
        Drawing drawing = drawingView.getDrawing();
        while (iterator.hasNext()) {
            Figure figure = (Figure)iterator.next();
            drawing.sendToBack(figure);
        }
    }
}

