/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.util.ResourceBundleUtil;

public class DeleteAction
extends TextAction {
    public static final String ID = "edit.delete";

    public DeleteAction() {
        super(ID);
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        resourceBundleUtil.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component != null && component instanceof EditableComponent) {
            ((EditableComponent)((Object)component)).delete();
        } else {
            this.deleteNextChar(actionEvent);
        }
    }

    public void deleteNextChar(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        boolean bl = true;
        if (jTextComponent != null && jTextComponent.isEditable()) {
            try {
                Document document = jTextComponent.getDocument();
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                int n2 = caret.getMark();
                if (n != n2) {
                    document.remove(Math.min(n, n2), Math.abs(n - n2));
                    bl = false;
                } else if (n < document.getLength()) {
                    document.remove(n, 1);
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (bl) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

