/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.IncreaseHandleDetailLevelAction;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveConstrainedAction;

public class DefaultDrawingEditor
extends AbstractBean
implements DrawingEditor,
ToolListener {
    private HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private HashMap<AttributeKey, Object> handleAttributes = new HashMap();
    private Tool tool;
    private HashSet<DrawingView> views;
    private DrawingView activeView;
    private boolean isEnabled = true;
    private InputMap inputMap;
    private ActionMap actionMap;
    private FocusListener focusHandler = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            DefaultDrawingEditor.this.setActiveView(DefaultDrawingEditor.this.findView((Container)focusEvent.getSource()));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    };

    public DefaultDrawingEditor() {
        this.setDefaultAttribute((AttributeKey)AttributeKeys.FILL_COLOR, Color.white);
        this.setDefaultAttribute((AttributeKey)AttributeKeys.STROKE_COLOR, Color.black);
        this.setDefaultAttribute((AttributeKey)AttributeKeys.TEXT_COLOR, Color.black);
        this.views = new HashSet();
        this.inputMap = this.createInputMap();
        this.actionMap = this.createActionMap();
    }

    @Override
    public void setTool(Tool tool) {
        Tool tool2 = this.tool;
        if (tool == this.tool) {
            return;
        }
        if (this.tool != null) {
            for (DrawingView drawingView : this.views) {
                drawingView.removeMouseListener(this.tool);
                drawingView.removeMouseMotionListener(this.tool);
                drawingView.removeKeyListener(this.tool);
            }
            this.tool.deactivate(this);
            this.tool.removeToolListener(this);
        }
        this.tool = tool;
        if (this.tool != null) {
            this.tool.activate(this);
            for (DrawingView drawingView : this.views) {
                drawingView.addMouseListener(this.tool);
                drawingView.addMouseMotionListener(this.tool);
                drawingView.addKeyListener(this.tool);
            }
            this.tool.addToolListener(this);
        }
        this.firePropertyChange("tool", tool2, tool);
    }

    @Override
    public void areaInvalidated(ToolEvent toolEvent) {
        Rectangle rectangle = toolEvent.getInvalidatedArea();
        toolEvent.getView().getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void toolStarted(ToolEvent toolEvent) {
        this.setActiveView(toolEvent.getView());
    }

    @Override
    public void setActiveView(DrawingView drawingView) {
        DrawingView drawingView2 = this.activeView;
        this.activeView = drawingView;
        this.firePropertyChange("activeView", drawingView2, drawingView);
    }

    @Override
    public void toolDone(ToolEvent toolEvent) {
        DrawingView drawingView = this.getActiveView();
        if (drawingView != null) {
            JComponent jComponent = drawingView.getComponent();
            jComponent.revalidate();
        }
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public DrawingView getActiveView() {
        return this.activeView;
    }

    private void updateActiveView() {
        DrawingView drawingView = null;
        for (DrawingView drawingView2 : this.views) {
            if (drawingView2.getComponent().isFocusOwner()) {
                this.setActiveView(drawingView2);
                return;
            }
            drawingView = drawingView2;
        }
        this.setActiveView(drawingView);
    }

    @Override
    public void applyDefaultAttributesTo(Figure figure) {
        for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
            figure.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> T getDefaultAttribute(AttributeKey<T> attributeKey) {
        if (this.defaultAttributes.containsKey(attributeKey)) {
            return attributeKey.get(this.defaultAttributes);
        }
        return attributeKey.getDefaultValue();
    }

    public void setDefaultAttribute(AttributeKey attributeKey, Object object) {
        Object object2 = this.defaultAttributes.put(attributeKey, object);
        this.firePropertyChange(attributeKey.getKey(), object2, object);
    }

    @Override
    public void remove(DrawingView drawingView) {
        drawingView.getComponent().removeFocusListener(this.focusHandler);
        this.views.remove(drawingView);
        if (this.tool != null) {
            drawingView.removeMouseListener(this.tool);
            drawingView.removeMouseMotionListener(this.tool);
            drawingView.removeKeyListener(this.tool);
        }
        drawingView.removeNotify(this);
        if (this.activeView == drawingView) {
            drawingView = this.views.size() > 0 ? this.views.iterator().next() : null;
        }
        this.updateActiveView();
    }

    @Override
    public void add(DrawingView drawingView) {
        this.views.add(drawingView);
        drawingView.addNotify(this);
        drawingView.getComponent().addFocusListener(this.focusHandler);
        if (this.tool != null) {
            drawingView.addMouseListener(this.tool);
            drawingView.addMouseMotionListener(this.tool);
            drawingView.addKeyListener(this.tool);
        }
        this.updateActiveView();
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public Collection<DrawingView> getDrawingViews() {
        return Collections.unmodifiableCollection(this.views);
    }

    @Override
    public DrawingView findView(Container container) {
        for (DrawingView drawingView : this.views) {
            if (drawingView.getComponent() != container) continue;
            return drawingView;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled) {
            boolean bl2 = this.isEnabled;
            this.isEnabled = bl;
            this.firePropertyChange("enabled", bl2, bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Map<AttributeKey, Object> getDefaultAttributes() {
        return Collections.unmodifiableMap(this.defaultAttributes);
    }

    public void setHandleAttribute(AttributeKey attributeKey, Object object) {
        this.handleAttributes.put(attributeKey, object);
    }

    @Override
    public <T> T getHandleAttribute(AttributeKey<T> attributeKey) {
        if (this.handleAttributes.containsKey(attributeKey)) {
            return attributeKey.get(this.handleAttributes);
        }
        return attributeKey.getDefaultValue();
    }

    @Override
    public void setInputMap(InputMap inputMap) {
        InputMap inputMap2 = this.inputMap;
        this.inputMap = inputMap;
        this.firePropertyChange("inputMap", inputMap2, inputMap);
    }

    @Override
    public InputMap getInputMap() {
        return this.inputMap;
    }

    @Override
    public void setActionMap(ActionMap actionMap) {
        ActionMap actionMap2 = this.actionMap;
        this.actionMap = actionMap;
        this.firePropertyChange("actionMap", actionMap2, actionMap);
    }

    @Override
    public ActionMap getActionMap() {
        return this.actionMap;
    }

    protected InputMap createInputMap() {
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "edit.delete");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "edit.delete");
        inputMap.put(KeyStroke.getKeyStroke(65, 0), "edit.selectAll");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "edit.selectAll");
        inputMap.put(KeyStroke.getKeyStroke(65, 256), "edit.selectAll");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "view.increaseHandleDetailLevel");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "edit.moveConstrainedWest");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "edit.moveConstrainedEast");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "edit.moveConstrainedNorth");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "edit.moveConstrainedSouth");
        inputMap.put(KeyStroke.getKeyStroke(37, 512), "edit.moveWest");
        inputMap.put(KeyStroke.getKeyStroke(39, 512), "edit.moveEast");
        inputMap.put(KeyStroke.getKeyStroke(38, 512), "edit.moveNorth");
        inputMap.put(KeyStroke.getKeyStroke(40, 512), "edit.moveSouth");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "edit.moveWest");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "edit.moveEast");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "edit.moveNorth");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "edit.moveSouth");
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "edit.moveWest");
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "edit.moveEast");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "edit.moveNorth");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "edit.moveSouth");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "edit.copy");
        inputMap.put(KeyStroke.getKeyStroke(67, 256), "edit.copy");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "edit.paste");
        inputMap.put(KeyStroke.getKeyStroke(86, 256), "edit.paste");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "edit.cut");
        inputMap.put(KeyStroke.getKeyStroke(88, 256), "edit.cut");
        return inputMap;
    }

    protected ActionMap createActionMap() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("edit.delete", new DeleteAction());
        actionMap.put("edit.selectAll", new SelectAllAction());
        actionMap.put("view.increaseHandleDetailLevel", new IncreaseHandleDetailLevelAction(this));
        actionMap.put("edit.moveEast", new MoveAction.East(this));
        actionMap.put("edit.moveWest", new MoveAction.West(this));
        actionMap.put("edit.moveNorth", new MoveAction.North(this));
        actionMap.put("edit.moveSouth", new MoveAction.South(this));
        actionMap.put("edit.moveConstrainedEast", new MoveConstrainedAction.East(this));
        actionMap.put("edit.moveConstrainedWest", new MoveConstrainedAction.West(this));
        actionMap.put("edit.moveConstrainedNorth", new MoveConstrainedAction.North(this));
        actionMap.put("edit.moveConstrainedSouth", new MoveConstrainedAction.South(this));
        actionMap.put("edit.cut", new CutAction());
        actionMap.put("edit.copy", new CopyAction());
        actionMap.put("edit.paste", new PasteAction());
        return actionMap;
    }
}

