/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.jhotdraw.util.CollectionsFactory;

public class CustomToolBar
extends JToolBar {
    private List standardTools = CollectionsFactory.current().createList();
    private List editTools = CollectionsFactory.current().createList();
    private List currentTools = this.standardTools;
    private boolean needsUpdate = false;

    public void switchToolBar() {
        if (this.currentTools == this.standardTools) {
            this.switchToEditTools();
        } else {
            this.switchToStandardTools();
        }
    }

    public void switchToEditTools() {
        if (this.currentTools != this.editTools) {
            this.currentTools = this.editTools;
            this.needsUpdate = true;
        }
    }

    public void switchToStandardTools() {
        if (this.currentTools != this.standardTools) {
            this.currentTools = this.standardTools;
            this.needsUpdate = true;
        }
    }

    public void activateTools() {
        if (!this.needsUpdate) {
            return;
        }
        this.removeAll();
        JComponent jComponent = null;
        Iterator iterator = this.currentTools.iterator();
        while (iterator.hasNext()) {
            jComponent = (JComponent)iterator.next();
            super.add(jComponent);
        }
        this.validate();
        this.needsUpdate = false;
        this.updateUI();
    }

    public Component add(Component component) {
        if (this.currentTools == this.editTools) {
            this.editTools.add(component);
        } else {
            this.standardTools.add(component);
        }
        this.needsUpdate = true;
        return super.add(component);
    }
}

