# Lexicon for german.
# Copyright © 2004 Björn Beutel.

# Pronouns. ===================================================================

[surf: "ich", POS: pronoun, case: sg1];
[surf: "meiner", POS: pronoun, case: gen_sg];
[surf: "mir", POS: pronoun, case: dat_sg];
[surf: "mich", POS: pronoun, case: acc_sg];

[surf: "du", POS: pronoun, case: sg2];
[surf: "deiner", POS: pronoun, case: gen_sg];
[surf: "dir", POS: pronoun, case: dat_sg];
[surf: "dich", POS: pronoun, case: acc_sg];

[surf: "er", POS: pronoun, case: sg3, gender: masc];
[surf: "sie", POS: pronoun, case: sg3|pl3|acc, gender: fem];
[surf: "es", POS: pronoun, case: sg3|acc_sg, gender: neut];
[surf: "seiner", POS: pronoun, case: gen_sg, gender: masc|neut];
[surf: "ihrer", POS: pronoun, case: gen_sg, gender: fem];
[surf: "ihm", POS: pronoun, case: dat_sg, gender: masc|neut];
[surf: "ihr", POS: pronoun, case: pl2|dat_sg, gender: fem];
[surf: "ihn", POS: pronoun, case: acc_sg, gender: masc];

[surf: "wir", POS: pronoun, case: pl1];
[surf: "unser", POS: pronoun, case: gen_pl];
[surf: "uns", POS: pronoun, case: dat_pl|acc_pl];

[surf: "euer", POS: pronoun, case: gen_pl];
[surf: "euch", POS: pronoun, case: dat_pl|acc_pl];

[surf: "ihnen", POS: pronoun, case: dat_pl];

# Relative pronouns. ==========================================================

[surf: "der", POS: rel_pronoun, case: sg3, gender: masc];
[surf: "dessen", POS: rel_pronoun, case: gen_sg, gender: masc|neut];
[surf: "dem", POS: rel_pronoun, case: dat_sg, gender: masc|neut];
[surf: "den", POS: rel_pronoun, case: acc_sg, gender: masc];
[surf: "das", POS: rel_pronoun, case: sg3|acc_sg, gender: neut];
[surf: "dem", POS: rel_pronoun, case: dat_sg, gender: neut];
[surf: "die", POS: rel_pronoun, case: sg3|acc_sg, gender: fem];
[surf: "der", POS: rel_pronoun, case: gen_sg|dat_sg, gender: fem];
[surf: "die", POS: rel_pronoun, case: nom_pl|acc_pl];
[surf: "deren", POS: rel_pronoun, case: gen_pl];
[surf: "denen", POS: rel_pronoun, case: dat_pl];

# Determiners. ================================================================

[surf: "der", POS: determiner, case: sg3, gender: masc, adj_ending: e];
[surf: "dem", POS: determiner, case: dat_sg, gender: masc|neut,
 adj_ending: en];
[surf: "den", POS: determiner, case: acc_sg, gender: masc, adj_ending: en];
[surf: "das", POS: determiner, case: sg3|acc_sg, gender: neut, adj_ending: e];
[surf: "des", POS: determiner, case: gen_sg, gender: masc|neut,
 adj_ending: en];
[surf: "die", POS: determiner, case: sg3|acc_sg, gender: fem, adj_ending: e];
[surf: "der", POS: determiner, case: gen_sg|dat_sg, gender: fem,
 adj_ending: en];
[surf: "die", POS: determiner, case: nom_pl|acc_pl, adj_ending: en];
[surf: "der", POS: determiner, case: gen_pl, adj_ending: en];
[surf: "den", POS: determiner, case: dat_pl, adj_ending: en];

[surf: "ein", POS: determiner, case: sg3, gender: masc, adj_ending: er];
[surf: "eines", POS: determiner, case: gen_sg, gender: masc|neut,
 adj_ending: en]; 
[surf: "einem", POS: determiner, case: dat_sg, gender: masc|neut,
 adj_ending: en];
[surf: "einen", POS: determiner, case: acc_sg, gender: masc, adj_ending: en];
[surf: "ein", POS: determiner, case: sg3|acc_sg, gender: neut, adj_ending: es];
[surf: "eine", POS: determiner, case: sg3|acc_sg, gender: fem, adj_ending: e];
[surf: "einer", POS: determiner, case: gen_sg|dat_sg, gender: fem,
 adj_ending: en];

# Prepositions. ===============================================================

[surf: "auf", POS: preposition, subtype: local, case: dat];
[surf: "auf", POS: preposition, subtype: directional, case: acc];
[surf: "durch", POS: preposition, subtype: directional, case: acc];
[surf: "hinter", POS: preposition, subtype: local, case: dat];
[surf: "hinter", POS: preposition, subtype: directional, case: acc];
[surf: "in", POS: preposition, subtype: local, case: dat];
[surf: "in", POS: preposition, subtype: directional, case: acc];
[surf: "mittels", POS: preposition, subtype: modal, case: gen];
[surf: "nach", POS: preposition, subtype: temporal, case: dat];
[surf: "neben", POS: preposition, subtype: local, case: dat];
[surf: "neben", POS: preposition, subtype: directional, case: acc];
[surf: "unter", POS: preposition, subtype: local, case: dat];
[surf: "unter", POS: preposition, subtype: directional, case: acc];
[surf: "über", POS: preposition, subtype: local, case: dat];
[surf: "über", POS: preposition, subtype: directional, case: acc];
[surf: "vor", POS: preposition, subtype: local, case: dat];
[surf: "vor", POS: preposition, subtype: directional, case: acc];
[surf: "vor", POS: preposition, subtype: temporal, case: dat];

# Punctuation marks. ==========================================================

[surf: ".", POS: punctuation];
[surf: ",", POS: punctuation];
[surf: "?", POS: punctuation];

# Adverbs. ====================================================================

[surf: "dort", POS: adverb, subtype: local];
[surf: "dorthin", POS: adverb, subtype: directional];
[surf: "gestern", POS: adverb, subtype: temporal];
[surf: "heute", POS: adverb, subtype: temporal];
[surf: "hier", POS: adverb, subtype: local];
[surf: "hierher", POS: adverb, subtype: directional];

# Prefixes. ===================================================================

[surf: "ab", POS: prefix];
[surf: "an", POS: prefix];
[surf: "auf", POS: prefix];
[surf: "aus", POS: prefix];
[surf: "daneben", POS: prefix];
[surf: "durch", POS: prefix];
[surf: "entzwei", POS: prefix];
[surf: "heraus", POS: prefix];
[surf: "herunter", POS: prefix];
[surf: "hin", POS: prefix];
[surf: "los", POS: prefix];
[surf: "nach", POS: prefix];
[surf: "nieder", POS: prefix];
[surf: "um", POS: prefix];
[surf: "unter", POS: prefix];
[surf: "vor", POS: prefix];
[surf: "weg", POS: prefix];
[surf: "zu", POS: prefix];
[surf: "zusammen", POS: prefix];

# Subordinating conjunctions. =================================================

[surf: "weil", POS: sub_conjunction, subtype: causal];

[surf: "wohin", POS: sub_conjunction, subtype: directional,
 constituent: directional];

[surf: "wo", POS: sub_conjunction, subtype: local, constituent: local];

[surf: "wo", POS: sub_conjunction, subtype: local];

[surf: "als", POS: sub_conjunction, subtype: temporal];

[surf: "bevor", POS: sub_conjunction, subtype: temporal];

[surf: "nachdem", POS: sub_conjunction, subtype: temporal];

[surf: "während", POS: sub_conjunction, subtype: temporal];

[base: "dass", POS: sub_conjunction, subtype: acc,
 forms: <[surf: "dass"], [surf: "daß"]>];

[surf: "was", POS: sub_conjunction, subtype: sg3|acc_sg,
 constituent: sg3|acc_sg];

[surf: "wer", POS: sub_conjunction, subtype: sg3, constituent: sg3];

[surf: "wenn", POS: sub_conjunction, subtype: temporal];

# Adjectives. =================================================================

[base: "alt", POS: adjective,
 forms: <[surf: "alte", adj_ending: e],
	 [surf: "altem", adj_ending: em],
	 [surf: "alten", adj_ending: en],
	 [surf: "alter", adj_ending: er],
	 [surf: "altes", adj_ending: es]>];

[base: "jung", POS: adjective,
 forms: <[surf: "junge", adj_ending: e],
	 [surf: "jungem", adj_ending: em],
	 [surf: "jungen", adj_ending: en],
	 [surf: "junger", adj_ending: er],
	 [surf: "junges", adj_ending: es]>];

[base: "groß", POS: adjective,
 forms: <[surf: "große", adj_ending: e],
	 [surf: "großem", adj_ending: em],
	 [surf: "großen", adj_ending: en],
	 [surf: "großer", adj_ending: er],
	 [surf: "großes", adj_ending: es]>];

[base: "klein", POS: adjective,
 forms: <[surf: "kleine", adj_ending: e],
	 [surf: "kleinem", adj_ending: em],
	 [surf: "kleinen", adj_ending: en],
	 [surf: "kleiner", adj_ending: er],
	 [surf: "kleines", adj_ending: es]>];

[base: "schön", POS: adjective,
 forms: <[surf: "schöne", adj_ending: e],
	 [surf: "schönem", adj_ending: em],
	 [surf: "schönen", adj_ending: en],
	 [surf: "schöner", adj_ending: er],
	 [surf: "schönes", adj_ending: es]>];

[base: "hässlich", POS: adjective,
 forms: <[surf: "häßliche", adj_ending: e],
	 [surf: "hässliche", adj_ending: e],
	 [surf: "häßlichem", adj_ending: em],
	 [surf: "hässlichem", adj_ending: em],
	 [surf: "häßlichen", adj_ending: en],
	 [surf: "hässlichen", adj_ending: en],
	 [surf: "häßlicher", adj_ending: er],
	 [surf: "hässlicher", adj_ending: er],
	 [surf: "häßliches", adj_ending: es],
	 [surf: "hässliches", adj_ending: es]>];

[base: "schlau", POS: adjective,
 forms: <[surf: "schlaue", adj_ending: e],
	 [surf: "schlauem", adj_ending: em],
	 [surf: "schlauen", adj_ending: en],
	 [surf: "schlauer", adj_ending: er],
	 [surf: "schlaues", adj_ending: es]>];

[base: "dumm", POS: adjective,
 forms: <[surf: "dumme", adj_ending: e],
	 [surf: "dummem", adj_ending: em],
	 [surf: "dummen", adj_ending: en],
	 [surf: "dummer", adj_ending: er],
	 [surf: "dummes", adj_ending: es]>];

# Verbs. ======================================================================

[base: "geben", POS: verb,
 valencies: <<acc, dat>, <acc>>,
 prefixes: <[surf: "an", valencies: <<acc>>],
	    [surf: "ab", valencies: <<dat>>]>,
 forms: <[surf: "gebe", subtype: finite, subject: sg1, tense: present],
	 [surf: "gibst", subtype: finite, subject: sg2, tense: present],
	 [surf: "gibt", subtype: finite, subject: sg3, tense: present],
	 [surf: "geben", subtype: finite, subject: pl13, tense: present],
	 [surf: "gebt", subtype: finite, subject: pl2, tense: present],
	 [surf: "gab", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "gabst", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "gaben", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "gabt", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "geben", subtype: infinitive],
	 [surf: "gegeben", subtype: participle_2_haben]>];

[base: "haben", POS: verb,
 valencies: <<acc>, <participle_2_haben>>,
 forms: <[surf: "habe", subtype: finite, subject: sg1, tense: present],
	 [surf: "hast", subtype: finite, subject: sg2, tense: present],
	 [surf: "hat", subtype: finite, subject: sg3, tense: present],
	 [surf: "haben", subtype: finite, subject: pl13, tense: present],
	 [surf: "habt", subtype: finite, subject: pl2, tense: present],
	 [surf: "hatte", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "hattest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "hatten", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "hattet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "haben", subtype: infinitive],
	 [surf: "gehabt", subtype: participle_2_haben]>];

[base: "lieben", POS: verb,
 valencies: <<acc>>,
 forms: <[surf: "liebe", subtype: finite, subject: sg1, tense: present],
	 [surf: "liebst", subtype: finite, subject: sg2, tense: present],
	 [surf: "liebt", subtype: finite, subject: sg3|pl2, tense: present],
	 [surf: "lieben", subtype: finite, subject: pl13, tense: present],
	 [surf: "liebte", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "liebtest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "liebten", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "liebtet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "lieben", subtype: infinitive],
	 [surf: "geliebt", subtype: participle_2_haben]>];

[base: "sein", POS: verb,
 valencies: <<nom>, <participle_2_sein>, <local>>,
 forms: <[surf: "bin", subtype: finite, subject: sg1, tense: present],
	 [surf: "bist", subtype: finite, subject: sg2, tense: present],
	 [surf: "ist", subtype: finite, subject: sg3, tense: present],
	 [surf: "sind", subtype: finite, subject: pl13, tense: present],
	 [surf: "seid", subtype: finite, subject: pl2, tense: present],
	 [surf: "war", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "warst", subtype: finite, subject: sg1, tense: preterite],
	 [surf: "waren", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "wart", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "sein", subtype: infinitive],
	 [surf: "gewesen", subtype: participle_2_sein]>];

[base: "spielen", POS: verb,
 valencies: <<acc>>,
 forms: <[surf: "spiele", subtype: finite, subject: sg1, tense: present],
	 [surf: "spielst", subtype: finite, subject: sg2, tense: present],
	 [surf: "spielt", subtype: finite, subject: sg3|pl2, tense: present],
	 [surf: "spielen", subtype: finite, subject: pl13, tense: present],
	 [surf: "spielte", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "spieltest", subtype: finite, subject: sg2,
	  tense: preterite],
	 [surf: "spielten", subtype: finite, subject: pl13,
	  tense: preterite],
	 [surf: "spieltet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "spielen", subtype: infinitive],
	 [surf: "gespielt", subtype: participle_2_haben]>];

[base: "schreiben", POS: verb,
 valencies: <<acc, dat>, <acc>>,
 forms: <[surf: "schreibe", subtype: finite, subject: sg1, tense: present],
	 [surf: "schreibst", subtype: finite, subject: sg2, tense: present],
	 [surf: "schreibt", subtype: finite, subject: sg3|pl2,
	  tense: present],
	 [surf: "schreiben", subtype: finite, subject: pl13, tense: present],
	 [surf: "schrieb", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "schriebst", subtype: finite, subject: sg2,
	  tense: preterite],
	 [surf: "schrieben", subtype: finite, subject: pl13,
	  tense: preterite],
	 [surf: "schriebt", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "schreiben", subtype: infinitive],
	 [surf: "geschrieben", subtype: participle_2_haben]>];

[base: "schlafen", POS: verb,
 valencies: <<>>,
 forms: <[surf: "schlafe", subtype: finite, subject: sg1, tense: present],
	 [surf: "schläfst", subtype: finite, subject: sg2, tense: present],
	 [surf: "schläft", subtype: finite, subject: sg3, tense: present],
	 [surf: "schlafen", subtype: finite, subject: pl13, tense: present],
	 [surf: "schlaft", subtype: finite, subject: pl2, tense: present],
	 [surf: "schlief", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "schliefst", subtype: finite, subject: sg2,
	  tense: preterite],
	 [surf: "schliefen", subtype: finite, subject: pl13,
	  tense: preterite],
	 [surf: "schlieft", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "schlafen", subtype: infinitive],
	 [surf: "geschlafen", subtype: participle_2_haben]>];

[base: "bedürfen", POS: verb,
 valencies: <<gen>>,
 forms: <[surf: "bedarf", subtype: finite, subject: sg13, tense: present],
	 [surf: "bedarfst", subtype: finite, subject: sg2, tense: present],
	 [surf: "bedürfen", subtype: finite, subject: pl13, tense: present],
	 [surf: "bedürft", subtype: finite, subject: pl2, tense: present],
	 [surf: "bedürft", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "bedurfte", subtype: finite, subject: sg13,
	  tense: preterite],
	 [surf: "bedurftest", subtype: finite, subject: sg2,
	  tense: preterite],
	 [surf: "bedurften", subtype: finite, subject: pl13,
	  tense: preterite],
	 [surf: "bedurftet", subtype: finite, subject: pl2,
	  tense: preterite],
	 [surf: "bedürfen", subtype: infinitive],
	 [surf: "bedurft", subtype: participle_2_haben]>];

[base: "lesen", POS: verb,
 valencies: <<acc>>,
 forms: <[surf: "lese", subtype: finite, subject: sg1, tense: present],
	 [surf: "liest", subtype: finite, subject: sg23, tense: present],
	 [surf: "lesen", subtype: finite, subject: pl13, tense: present],
	 [surf: "lest", subtype: finite, subject: pl2, tense: present],
	 [surf: "las", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "last", subtype: finite, subject: sg2|pl2, tense: preterite],
	 [surf: "lasen", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "lesen", subtype: infinitive],
	 [surf: "gelesen", subtype: participle_2_haben]>];

[base: "beißen", POS: verb,
 valencies: <<acc>>,
 forms: <[surf: "beiße", subtype: finite, subject: sg1, tense: present],
	 [surf: "beißt", subtype: finite, subject: sg23|pl2, tense: present],
	 [surf: "beißen", subtype: finite, subject: pl13, tense: present],
	 [surf: "biß", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "biss", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "bissest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "bissen", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "bisset", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "beißen", subtype: infinitive],
	 [surf: "gebissen", subtype: participle_2_haben]>];

[base: "sehen", POS: verb,
 valencies: <<acc>>,
 forms: <[surf: "sehe", subtype: finite, subject: sg1, tense: present],
	 [surf: "siehst", subtype: finite, subject: sg2, tense: present],
	 [surf: "sieht", subtype: finite, subject: sg3, tense: present],
	 [surf: "sehen", subtype: finite, subject: pl13, tense: present],
	 [surf: "seht", subtype: finite, subject: pl2, tense: present],
	 [surf: "sah", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "sahst", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "sahen", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "saht", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "sehen", subtype: infinitive],
	 [surf: "gesehen", subtype: participle_2_haben]>];

[base: "zeigen", POS: verb,
 valencies: <<acc, dat>, <acc>>,
 forms: <[surf: "zeige", subtype: finite, subject: sg1, tense: present],
	 [surf: "zeigst", subtype: finite, subject: sg2, tense: present],
	 [surf: "zeigt", subtype: finite, subject: sg3|pl2, tense: present],
	 [surf: "zeigen", subtype: finite, subject: pl13, tense: present],
	 [surf: "zeigte", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "zeigtest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "zeigten", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "zeigtet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "zeigen", subtype: infinitive],
	 [surf: "gezeigt", subtype: participle_2_haben]>];

[base: "gehen", POS: verb,
 valencies: <<>, <directional>, <acc>, <infinitive>>,
 prefixes: <[surf: "vor", valencies: <<>>],
	    [surf: "nach", valencies: <<dat>, <>>],
	    [surf: "unter", valencies: <<>>]>, 
 forms: <[surf: "gehe", subtype: finite, subject: sg1, tense: present],
	 [surf: "gehst", subtype: finite, subject: sg2, tense: present],
	 [surf: "geht", subtype: finite, subject: sg3|pl2, tense: present],
	 [surf: "gehen", subtype: finite, subject: pl13, tense: present],
	 [surf: "ging", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "gingst", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "gingen", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "gingt", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "gehen", subtype: infinitive],
	 [surf: "gegangen", subtype: participle_2_sein]>];

[base: "wollen", POS: verb,
 valencies: <<infinitive>, <directional>, <acc>>,
 forms: <[surf: "will", subtype: finite, subject: sg13, tense: present],
	 [surf: "willst", subtype: finite, subject: sg2, tense: present],
	 [surf: "wollen", subtype: finite, subject: pl13, tense: present],
	 [surf: "wollt", subtype: finite, subject: pl2, tense: present],
	 [surf: "wollte", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "wolltest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "wollten", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "wolltet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "wollen", subtype: infinitive],
	 [surf: "gewollt", subtype: participle_2_haben]>];

[base: "hauen", POS: verb, valencies: <<acc>>,
 prefixes: <[surf: "an", valencies: <<acc, dat>>],
	    [surf: "aus", valencies: <<acc, dat>>],
	    [surf: "entzwei", valencies: <<acc, dat>>],
	    [surf: "herunter", valencies: <<acc, dat>>],
	    [surf: "ab", valencies: <<acc, dat>>],
	    [surf: "auf", valencies: <<acc>>],
	    [surf: "heraus", valencies: <<acc>>],
	    [surf: "hin", valencies: <<acc>>],
	    [surf: "los", valencies: <<acc>>],
	    [surf: "nieder", valencies: <<acc>>],
	    [surf: "um", valencies: <<acc>>],
	    [surf: "weg", valencies: <<acc>>],
	    [surf: "zusammen", valencies: <<acc>>],
	    [surf: "zu", valencies: <<acc>>],
	    [surf: "durch", valencies: <<dat, acc>>],
	    [surf: "daneben", valencies: <<>>]>,
 forms: <[surf: "haue", subtype: finite, subject: sg1, tense: present],
	 [surf: "haust", subtype: finite, subject: sg2, tense: present],
	 [surf: "haut", subtype: finite, subject: sg3|pl2, tense: present],
	 [surf: "hauen", subtype: finite, subject: pl13, tense: present],
	 [surf: "haute", subtype: finite, subject: sg13, tense: preterite],
	 [surf: "hautest", subtype: finite, subject: sg2, tense: preterite],
	 [surf: "hauten", subtype: finite, subject: pl13, tense: preterite],
	 [surf: "hautet", subtype: finite, subject: pl2, tense: preterite],
	 [surf: "hauen", subtype: infinitive],
	 [surf: "gehauen", subtype: participle_2_haben]>];

# Substantives. ===============================================================

[base: "Bahnhof", POS: substantive, gender: masc,
 forms: <[surf: "Bahnhof", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Bahnhofe", case: dat_sg],
	 [surf: "Bahnhofs", case: gen_sg],
	 [surf: "Bahnhofes", case: gen_sg],
	 [surf: "Bahnhöfe", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Bahnhöfen", case: dat_pl]>];

[base: "Brief", POS: substantive, gender: masc,
 forms: <[surf: "Brief", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Briefs", case: gen_sg],
	 [surf: "Briefes", case: gen_sg],
	 [surf: "Briefe", case: dat_sg|nom_pl|gen_pl|acc_pl],
	 [surf: "Briefen", case: dat_pl]>];

[base: "Buch", POS: substantive, gender: neut,
 forms: <[surf: "Buch", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Buchs", case: gen_sg],
	 [surf: "Buche", case: dat_sg],
	 [surf: "Buches", case: gen_sg],
	 [surf: "Bücher", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Büchern", case: dat_pl]>];

[base: "Fenster", POS: substantive, gender: neut,
 forms: <[surf: "Fenster", case: nom_sg|dat_sg|acc_sg|nom_pl|gen_pl|acc_pl],
	 [surf: "Fenstern", case: dat_pl],
	 [surf: "Fensters", case: gen_sg]>];

[base: "Flasche", POS: substantive, gender: fem,
 forms: <[surf: "Flasche", case: singular],
	 [surf: "Flaschen", case: plural]>];

[base: "Fluss", POS: substantive, gender: masc,
 forms: <[surf: "Fluss", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Fluß", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Flusse", case: dat_sg],
	 [surf: "Flusses", case: gen_sg],
	 [surf: "Flüsse", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Flüssen", case: dat_pl]>];

[base: "Frau", POS: substantive, gender: fem,
 forms: <[surf: "Frau", case: singular],
	 [surf: "Frauen", case: plural]>];

[base: "Garten", POS: substantive, gender: masc,
 forms: <[surf: "Garten", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Gartens", case: gen_sg],
	 [surf: "Gärten", case: plural]>];

[base: "Gleis", POS: substantive, gender: neut,
 forms: <[surf: "Gleis", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Gleise", case: dat_sg|nom_pl|gen_pl|acc_pl],
	 [surf: "Gleisen", case: dat_pl],
	 [surf: "Gleises", case: gen_sg]>];

[base: "Haus", POS: substantive, gender: neut,
 forms: <[surf: "Haus", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Hauses", case: gen_sg],
	 [surf: "Hause", case: dat_sg],
	 [surf: "Häuser", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Häusern", case: dat_pl]>];

[base: "Kind", POS: substantive, gender: neut,
 forms: <[surf: "Kind", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Kinde", case: dat_sg],
	 [surf: "Kinds", case: gen_sg],
	 [surf: "Kindes", case: gen_sg],
	 [surf: "Kinder", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Kindern", case: dat_pl]>];

[base: "Kuchen", POS: substantive, gender: masc,
 forms: <[surf: "Kuchen", case: nom_sg|dat_sg|acc_sg|plural],
	 [surf: "Kuchens", case: gen_sg]>];

[base: "Küche", POS: substantive, gender: fem,
 forms: <[surf: "Küche", case: singular],
	 [surf: "Küchen", case: plural]>];

[base: "Kuss", POS: substantive, gender: masc,
 forms: <[surf: "Kuss", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Kusses", case: gen_sg],
	 [surf: "Küsse", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Küssen", case: dat_pl]>];

[base: "Liebe", POS: substantive, gender: fem,
 forms: <[surf: "Liebe", case: singular],
	 [surf: "Lieben", case: plural]>];

[base: "Mann", POS: substantive, gender: masc,
 forms: <[surf: "Mann", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Manne", case: dat_sg],
	 [surf: "Manns", case: gen_sg],
	 [surf: "Mannes", case: gen_sg],
	 [surf: "Männer", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Männern", case: dat_pl]>];

[base: "Mädchen", POS: substantive, gender: neut,
 forms: <[surf: "Mädchen", case: nom_sg|dat_sg|acc_sg|plural],
	 [surf: "Mädchens", case: gen_sg]>];

[base: "Stadt", POS: substantive, gender: fem,
 forms: <[surf: "Stadt", case: singular],
	 [surf: "Städte", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Städten", case: dat_pl]>];

[base: "Stuhl", POS: substantive, gender: masc,
 forms: <[surf: "Stuhl", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Stuhle", case: dat_sg],
	 [surf: "Stuhls", case: gen_sg],
	 [surf: "Stuhles", case: gen_sg],
	 [surf: "Stühle", case: nom_pl|gen_pl|acc_pl],
	 [surf: "Stühlen", case: dat_pl]>];

[base: "Tisch", POS: substantive, gender: masc,
 forms: <[surf: "Tisch", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Tische", case: dat_sg|nom_pl|gen_pl|acc_pl],
	 [surf: "Tischs", case: gen_sg],
	 [surf: "Tisches", case: gen_sg],
	 [surf: "Tischen", case: dat_pl]>];

[base: "Weg", POS: substantive, gender: masc,
 forms: <[surf: "Weg", case: nom_sg|dat_sg|acc_sg],
	 [surf: "Wege", case: dat_sg|nom_pl|gen_pl|acc_pl],
	 [surf: "Wegs", case: gen_sg],
	 [surf: "Wegen", case: dat_pl]>];

# Names. ======================================================================

[base: "Andrea", POS: name, gender: fem,
 forms: <[surf: "Andrea", case: sg3|dat_sg|acc_sg],
	 [surf: "Andreas", case: gen_sg]>];

[base: "Andreas", POS: name, gender: masc,
 forms: <[surf: "Andreas", case: sg3|dat_sg|acc_sg],
	 [surf: "Andreas'", case: gen_sg]>];

[base: "Björn", POS: name, gender: masc,
 forms: <[surf: "Björn", case: sg3|dat_sg|acc_sg],
	 [surf: "Björns", case: gen_sg]>];

[base: "Chomsky", POS: name, gender: masc,
 forms: <[surf: "Chomsky", case: sg3|dat_sg|acc_sg],
	 [surf: "Chomskys", case: gen_sg]>];

[base: "Fido", POS: name, gender: masc,
 forms: <[surf: "Fido", case: sg3|dat_sg|acc_sg],
	 [surf: "Fidos", case: gen_sg]>];

[base: "Gerald", POS: name, gender: masc,
 forms: <[surf: "Gerald", case: sg3|dat_sg|acc_sg],
	 [surf: "Geralds", case: gen_sg]>];

[base: "Gero", POS: name, gender: masc,
 forms: <[surf: "Gero", case: sg3|dat_sg|acc_sg],
	 [surf: "Geros", case: gen_sg]>];

[base: "Hausser", POS: name, gender: masc,
 forms: <[surf: "Hausser", case: sg3|dat_sg|acc_sg],
	 [surf: "Haussers", case: gen_sg]>];

[base: "Jörg", POS: name, gender: masc,
 forms: <[surf: "Jörg", case: sg3|dat_sg|acc_sg],
	 [surf: "Jörgs", case: gen_sg]>];

[base: "Julia", POS: name, gender: fem,
 forms: <[surf: "Julia", case: sg3|dat_sg|acc_sg],
	 [surf: "Julias", case: gen_sg]>];

[base: "Katz und Maus", POS: name,
 forms: <[surf: "Katz und Maus", case: pl3|dat_pl|acc_pl]>];

[base: "Kind und Kegel", POS: name,
 forms: <[surf: "Kind und Kegel", case: pl3|dat_pl|acc_pl]>];

[base: "Marco", POS: name, gender: masc,
 forms: <[surf: "Marco", case: sg3|dat_sg|acc_sg],
	 [surf: "Marcos", case: gen_sg]>];

[base: "Max", POS: name, gender: masc,
 forms: <[surf: "Max", case: sg3|dat_sg|acc_sg],
	 [surf: "Max'", case: gen_sg]>];

[base: "Michael", POS: name, gender: masc,
 forms: <[surf: "Michael", case: sg3|dat_sg|acc_sg],
	 [surf: "Michaels", case: gen_sg]>];

[base: "Oliver", POS: name, gender: masc,
 forms: <[surf: "Oliver", case: sg3|dat_sg|acc_sg],
	 [surf: "Olivers", case: gen_sg]>];

# End of file. ================================================================
