/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Color
implements OdfDataType {
    private static final Pattern sixHexRGBPattern = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private static final Pattern threeHexRGBPattern = Pattern.compile("^#[0-9a-fA-F]{3}$");
    private static final Map<String, String> labeledColors = new HashMap<String, String>();
    private static final String COLOR_PREFIX = "#";
    private final String mColorAsSixHexRGB;
    public static final Color AQUA;
    public static final Color BLACK;
    public static final Color BLUE;
    public static final Color FUCHSIA;
    public static final Color GRAY;
    public static final Color GREEN;
    public static final Color LIME;
    public static final Color MAROON;
    public static final Color NAVY;
    public static final Color OLIVE;
    public static final Color ORANGE;
    public static final Color PURPLE;
    public static final Color RED;
    public static final Color SILVER;
    public static final Color TEAL;
    public static final Color WHITE;
    public static final Color YELLOW;

    public Color(String color) {
        if (!Color.isValid(color)) {
            throw new IllegalArgumentException("parameter is invalid for datatype Color");
        }
        this.mColorAsSixHexRGB = color.length() == 4 ? Color.mapColorFromThreeToSixHex(color) : color;
    }

    public Color(int red, int green, int blue) {
        this(Color.mapColorIntegerToString(red, green, blue));
    }

    public Color(float red, float green, float blue) {
        this((int)((double)(red * 255.0f) + 0.5), (int)((double)(green * 255.0f) + 0.5), (int)((double)(blue * 255.0f) + 0.5));
    }

    public Color(java.awt.Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public String toString() {
        return this.mColorAsSixHexRGB;
    }

    public static Color valueOf(String colorValue) {
        return new Color(colorValue);
    }

    public static boolean isValid(String colorValue) {
        return colorValue != null && (threeHexRGBPattern.matcher(colorValue).matches() || sixHexRGBPattern.matcher(colorValue).matches());
    }

    public static String toSixDigitHexRGB(String colorValue) {
        if (colorValue == null) {
            throw new IllegalArgumentException("parameter should not be null.");
        }
        if (sixHexRGBPattern.matcher(colorValue = colorValue.toLowerCase().trim()).matches()) {
            return colorValue;
        }
        if (threeHexRGBPattern.matcher(colorValue).matches()) {
            return Color.mapColorFromThreeToSixHex(colorValue);
        }
        if (colorValue.startsWith("rgb")) {
            colorValue = colorValue.substring(3);
            String[] rgbValues = (colorValue = colorValue.substring(colorValue.indexOf("(") + 1, colorValue.indexOf(")"))).split(",");
            if (rgbValues.length == 3) {
                int r = Color.mapColorValueToInteger(rgbValues[0].trim());
                int g = Color.mapColorValueToInteger(rgbValues[1].trim());
                int b = Color.mapColorValueToInteger(rgbValues[2].trim());
                String rs = Integer.toHexString(r);
                String gs = Integer.toHexString(g);
                String bs = Integer.toHexString(b);
                String hexColor = COLOR_PREFIX;
                if (r < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + rs;
                if (g < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + gs;
                if (b < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + bs;
                return hexColor;
            }
            throw new IllegalArgumentException("parameter: " + colorValue + " can't be converted six-digit hex RGB.");
        }
        String hexColor = labeledColors.get(colorValue);
        if (hexColor != null) {
            return hexColor;
        }
        throw new IllegalArgumentException("parameter: " + colorValue + " can't be converted six-digit hex RGB.");
    }

    public java.awt.Color getAWTColor() {
        return Color.mapColorToAWTColor(this);
    }

    public static java.awt.Color mapColorToAWTColor(Color color) {
        int rgb = Integer.decode("0x" + color.mColorAsSixHexRGB.substring(1));
        return new java.awt.Color(rgb);
    }

    private static String mapColorIntegerToString(int red, int green, int blue) {
        String rs = Integer.toHexString(red);
        String gs = Integer.toHexString(green);
        String bs = Integer.toHexString(blue);
        String hexColor = COLOR_PREFIX;
        if (red < 16) {
            hexColor = hexColor + "0";
        }
        hexColor = hexColor + rs;
        if (green < 16) {
            hexColor = hexColor + "0";
        }
        hexColor = hexColor + gs;
        if (blue < 16) {
            hexColor = hexColor + "0";
        }
        hexColor = hexColor + bs;
        return hexColor;
    }

    private static String mapColorFromThreeToSixHex(String threeDigitcColor) {
        char[] colorData = threeDigitcColor.toCharArray();
        char[] sixDigitColor = new char[7];
        for (int i = 0; i < 7; ++i) {
            sixDigitColor[i] = colorData[(i + 1) / 2];
        }
        return new String(sixDigitColor);
    }

    private static int mapColorValueToInteger(String colorValue) {
        if (colorValue.endsWith("%")) {
            int value = Integer.parseInt(colorValue = colorValue.substring(0, colorValue.indexOf("%")));
            if (value < 0) {
                value = 0;
            }
            if (value > 100) {
                value = 100;
            }
            return 255 * value / 100;
        }
        int value = Integer.parseInt(colorValue);
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        return !(this.mColorAsSixHexRGB == null ? other.mColorAsSixHexRGB != null : !this.mColorAsSixHexRGB.equals(other.mColorAsSixHexRGB));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.mColorAsSixHexRGB != null ? this.mColorAsSixHexRGB.hashCode() : 0);
        return hash;
    }

    static {
        labeledColors.put("aqua", "#00ffff");
        labeledColors.put("black", "#000000");
        labeledColors.put("blue", "#0000ff");
        labeledColors.put("fuchsia", "#ff00ff");
        labeledColors.put("gray", "#808080");
        labeledColors.put("green", "#008000");
        labeledColors.put("lime", "#00ff00");
        labeledColors.put("maroon", "#800000");
        labeledColors.put("navy", "#000080");
        labeledColors.put("olive", "#808000");
        labeledColors.put("orange", "#ffA500");
        labeledColors.put("purple", "#800080");
        labeledColors.put("red", "#ff0000");
        labeledColors.put("silver", "#c0c0c0");
        labeledColors.put("teal", "#008080");
        labeledColors.put("white", "#ffffff");
        labeledColors.put("yellow", "#ffff00");
        AQUA = new Color("#00ffff");
        BLACK = new Color("#000000");
        BLUE = new Color("#0000ff");
        FUCHSIA = new Color("#ff00ff");
        GRAY = new Color("#808080");
        GREEN = new Color("#008000");
        LIME = new Color("#00ff00");
        MAROON = new Color("#800000");
        NAVY = new Color("#000080");
        OLIVE = new Color("#808000");
        ORANGE = new Color("#ffA500");
        PURPLE = new Color("#800080");
        RED = new Color("#ff0000");
        SILVER = new Color("#c0c0c0");
        TEAL = new Color("#008080");
        WHITE = new Color("#ffffff");
        YELLOW = new Color("#ffff00");
    }
}

