/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static Logger log = LoggerFactory.getLogger(Metadata.class);
    List<String> resources = new ArrayList<String>();
    Properties properties = new Properties();

    public Metadata() {
    }

    public Metadata(String resourceName) {
        this();
        this.addMetadata(resourceName);
    }

    public void addMetadata(String resourceName) {
        this.resources.add(resourceName);
        Metadata.read(this.properties, resourceName);
    }

    private static void read(Properties properties, String resource) {
        ClassLoader classLoader = SystemUtils.chooseClassLoader();
        if (classLoader == null) {
            classLoader = Metadata.class.getClassLoader();
        }
        if (classLoader == null) {
            log.error("No classloader");
            return;
        }
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null) {
            return;
        }
        try {
            properties.loadFromXML(in);
        }
        catch (InvalidPropertiesFormatException ex) {
            throw new JenaException("Invalid properties file", ex);
        }
        catch (IOException ex) {
            throw new JenaException("Metadata ==> IOException", ex);
        }
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        if (this.properties == null) {
            return defaultValue;
        }
        return this.properties.getProperty(name, defaultValue);
    }
}

