/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Max
extends BaseBuiltin {
    @Override
    public String getName() {
        return "max";
    }

    @Override
    public int getArgLength() {
        return 3;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        BindingEnvironment env = context.getEnv();
        Node n1 = this.getArg(0, args, context);
        Node n2 = this.getArg(1, args, context);
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            Node res = null;
            if (v1 instanceof Number && v2 instanceof Number) {
                Number nv1 = (Number)v1;
                Number nv2 = (Number)v2;
                res = v1 instanceof Float || v1 instanceof Double || v2 instanceof Float || v2 instanceof Double ? (nv1.doubleValue() > nv2.doubleValue() ? n1 : n2) : (nv1.longValue() > nv2.longValue() ? n1 : n2);
                return env.bind(args[2], res);
            }
        }
        return false;
    }
}

