/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner;

import java.util.Iterator;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.StandardValidityReport;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;
    protected boolean recordDerivations;
    private volatile boolean isPrepared = false;
    protected volatile int version = 0;

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.getRawGraph().getPrefixMapping();
    }

    public BaseInfGraph(Graph data, Reasoner reasoner) {
        this.fdata = new FGraph(data);
        this.reasoner = reasoner;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            return this.getReasoner().getGraphCapabilities();
        }
        return this.capabilities;
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        this.getRawGraph().remove(s, p, o);
        this.discardState();
        this.rebind();
        this.getEventManager().notifyEvent(this, GraphEvents.remove(s, p, o));
    }

    @Override
    public void clear() {
        this.getRawGraph().clear();
        this.discardState();
        this.rebind();
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new InfTransactionHandler(this);
    }

    protected void discardState() {
    }

    @Override
    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    @Override
    public Reasoner getReasoner() {
        return this.reasoner;
    }

    @Override
    public synchronized void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.isPrepared = false;
    }

    @Override
    public synchronized void rebind() {
        ++this.version;
        this.isPrepared = false;
    }

    @Override
    public void reset() {
        ++this.version;
    }

    @Override
    public synchronized void prepare() {
        this.isPrepared = true;
    }

    @Override
    public Graph getDeductionsGraph() {
        return null;
    }

    @Override
    public Node getGlobalProperty(Node property) {
        throw new ReasonerException("Global property not implemented: " + property);
    }

    @Override
    public boolean testGlobalProperty(Node property) {
        Object result;
        Node resultNode = this.getGlobalProperty(property);
        if (resultNode.isLiteral() && (result = resultNode.getLiteralValue()) instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + property + "\nResult was: " + resultNode);
    }

    @Override
    public ValidityReport validate() {
        this.checkOpen();
        return new StandardValidityReport();
    }

    @Override
    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        return this.cloneWithPremises(param).find(subject, property, object);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple triple) {
        return this.graphBaseFind(triple.getMatchSubject(), triple.getMatchPredicate(), triple.getMatchObject());
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    public abstract ExtendedIterator<Triple> findWithContinuation(TriplePattern var1, Finder var2);

    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        this.checkOpen();
        return this.findWithContinuation(pattern, this.fdata);
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple triple) {
        return null;
    }

    @Override
    public int graphBaseSize() {
        this.checkOpen();
        return this.fdata.getGraph().size();
    }

    @Override
    public boolean isEmpty() {
        return this.fdata.getGraph().isEmpty();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.fdata.getGraph().close();
            this.fdata = null;
            super.close();
        }
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.requirePrepared();
        this.fdata.getGraph().add(t);
    }

    @Override
    public void performDelete(Triple t) {
        ++this.version;
        this.requirePrepared();
        this.fdata.getGraph().delete(t);
    }

    public abstract Graph getSchemaGraph();

    public InfGraph cloneWithPremises(Graph premises) {
        MultiUnion union = new MultiUnion();
        Graph raw = this.getRawGraph();
        union.addGraph(raw);
        union.setBaseGraph(raw);
        union.addGraph(premises);
        Graph schema = this.getSchemaGraph();
        if (schema != null && schema instanceof BaseInfGraph) {
            Graph rschema;
            BaseInfGraph ischema = (BaseInfGraph)schema;
            Graph sschema = ischema.getSchemaGraph();
            if (sschema != null) {
                union.addGraph(sschema);
            }
            if ((rschema = ischema.getRawGraph()) != null) {
                union.addGraph(rschema);
            }
        }
        return this.getReasoner().bind(union);
    }

    public synchronized boolean isPrepared() {
        return this.isPrepared;
    }

    protected synchronized void setPreparedState(boolean state) {
        this.isPrepared = state;
    }

    protected synchronized void requirePrepared() {
        if (!this.isPrepared) {
            this.prepare();
        }
    }

    public static class InfTransactionHandler
    extends TransactionHandlerBase
    implements TransactionHandler {
        protected final BaseInfGraph base;

        public InfTransactionHandler(BaseInfGraph base) {
            this.base = base;
        }

        @Override
        public boolean transactionsSupported() {
            return this.getBaseHandler().transactionsSupported();
        }

        protected TransactionHandler getBaseHandler() {
            return this.base.getRawGraph().getTransactionHandler();
        }

        @Override
        public void begin() {
            this.getBaseHandler().begin();
        }

        @Override
        public void abort() {
            this.getBaseHandler().abort();
            this.base.rebind();
        }

        @Override
        public void commit() {
            this.getBaseHandler().commit();
        }
    }

    public static class InfFindSafeCapabilities
    extends InfCapabilities {
        @Override
        public boolean findContractSafe() {
            return true;
        }
    }

    public static class InfCapabilities
    extends AllCapabilities {
        @Override
        public boolean sizeAccurate() {
            return false;
        }

        @Override
        public boolean deleteAllowed(boolean every) {
            return !every;
        }

        @Override
        public boolean iteratorRemoveAllowed() {
            return false;
        }

        @Override
        public boolean findContractSafe() {
            return false;
        }
    }
}

