/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.BaseGraphMaker;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.shared.AlreadyExistsException;
import org.apache.jena.shared.DoesNotExistException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SimpleGraphMaker
extends BaseGraphMaker {
    private Map<String, Graph> graphs = new HashMap<String, Graph>();

    public Graph create() {
        return Factory.createGraphMem();
    }

    @Override
    public Graph createGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            Graph result = Factory.createGraphMem();
            this.graphs.put(name, result);
            return result;
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    @Override
    public Graph openGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            if (strict) {
                throw new DoesNotExistException(name);
            }
            return this.createGraph(name, true);
        }
        return already.openAgain();
    }

    @Override
    public Graph openGraph() {
        return this.getGraph();
    }

    @Override
    public void removeGraph(String name) {
        if (!this.graphs.containsKey(name)) {
            throw new DoesNotExistException(name);
        }
        this.graphs.remove(name);
    }

    @Override
    public boolean hasGraph(String name) {
        return this.graphs.containsKey(name);
    }

    @Override
    public void close() {
    }

    @Override
    public ExtendedIterator<String> listGraphs() {
        return WrappedIterator.create(this.graphs.keySet().iterator());
    }
}

